// ARSDK_NO_ENUM_PREPROCESS //
/**
 * @file libARCommands/ARCOMMANDS_Types.h
 * @brief libARCommands types header.
 * This file contains all types declarations needed to use commands
 * @note Autogenerated file
 **/
#ifndef _LIBARCOMMANDS_ARCOMMANDS_TYPES_H_
#define _LIBARCOMMANDS_ARCOMMANDS_TYPES_H_
#include <inttypes.h>

/**
 * @brief Size of the ARCommands header.
 * This is the minimum size of a zero-arg command.
 * The size of a command is equal to this, plus the size
 * of its arguments.
 */
#define ARCOMMANDS_HEADER_SIZE (4)

/**
 * Defined only if the library includes debug commands
 */
#define ARCOMMANDS_HAS_DEBUG_COMMANDS (1)

// Feature generic

/**
 * @brief Flags use by maps and lists
 */
typedef enum
{
    ARCOMMANDS_GENERIC_LIST_FLAGS_FIRST = 0,    ///< indicate it's the first element of the list.
    ARCOMMANDS_GENERIC_LIST_FLAGS_LAST,    ///< indicate it's the last element of the list.
    ARCOMMANDS_GENERIC_LIST_FLAGS_EMPTY,    ///< indicate the list is empty (implies First/Last). All other arguments should be ignored.
    ARCOMMANDS_GENERIC_LIST_FLAGS_REMOVE,    ///< This value should be removed from the existing list.
    ARCOMMANDS_GENERIC_LIST_FLAGS_MAX
} eARCOMMANDS_GENERIC_LIST_FLAGS;

#define ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_FIRST (1 << ARCOMMANDS_GENERIC_LIST_FLAGS_FIRST)    ///< indicate it's the first element of the list.
#define ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_LAST (1 << ARCOMMANDS_GENERIC_LIST_FLAGS_LAST)    ///< indicate it's the last element of the list.
#define ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_EMPTY (1 << ARCOMMANDS_GENERIC_LIST_FLAGS_EMPTY)    ///< indicate the list is empty (implies First/Last). All other arguments should be ignored.
#define ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_REMOVE (1 << ARCOMMANDS_GENERIC_LIST_FLAGS_REMOVE)    ///< This value should be removed from the existing list.

// Feature ARDrone3

/**
 * @brief The circling direction
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_CW = 0,    ///< Circling ClockWise
    ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_CCW,    ///< Circling Counter ClockWise
    ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_DEFAULT,    ///< Use drone default Circling direction set by CirclingDirection cmd
    ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_MAX
} eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION;


/**
 * @brief Direction for the flip
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_FRONT = 0,    ///< Flip direction front
    ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_BACK,    ///< Flip direction back
    ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_RIGHT,    ///< Flip direction right
    ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_LEFT,    ///< Flip direction left
    ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_MAX
} eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION;


/**
 * @brief Command to record video
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_STOP = 0,    ///< Stop the video recording
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_START,    ///< Start the video recording
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD;


/**
 * @brief Command to record video
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_STOP = 0,    ///< Stop the video recording
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_START,    ///< Start the video recording
    ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD;


/**
 * @brief State of video
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_STOPPED = 0,    ///< Video was stopped
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_STARTED,    ///< Video was started
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_FAILED,    ///< Video was failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_AUTOSTOPPED,    ///< Video was auto stopped
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE;


/**
 * @brief State of device picture recording
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_READY = 0,    ///< The picture recording is ready
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_BUSY,    ///< The picture recording is busy
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_NOTAVAILABLE,    ///< The picture recording is not available
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_CAMERA_KO,    ///< Picture camera is out of order
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MEMORYFULL,    ///< Memory full ; cannot save one additional picture
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_LOWBATTERY,    ///< Battery is too low to start/keep recording.
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR;


/**
 * @brief State of device video recording
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_STOPPED = 0,    ///< Video is stopped
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_STARTED,    ///< Video is started
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_NOTAVAILABLE,    ///< The video recording is not available
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_CAMERA_KO,    ///< Video camera is out of order
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_MEMORYFULL,    ///< Memory full ; cannot save one additional video
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_LOWBATTERY,    ///< Battery is too low to start/keep recording.
    ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR;


/**
 * @brief Last event of picture recording
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_TAKEN = 0,    ///< Picture taken and saved
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_FAILED,    ///< Picture failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_UNKNOWN,    ///< Unknown generic error ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_BUSY,    ///< Picture recording is busy ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_NOTAVAILABLE,    ///< Picture recording not available ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MEMORYFULL,    ///< Memory full ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_LOWBATTERY,    ///< Battery is too low to record.
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR;


/**
 * @brief Event of video recording
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_START = 0,    ///< Video start
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_STOP,    ///< Video stop and saved
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_FAILED,    ///< Video failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_UNKNOWN,    ///< Unknown generic error ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_BUSY,    ///< Video recording is busy ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_NOTAVAILABLE,    ///< Video recording not available ; only when state is failed
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_MEMORYFULL,    ///< Memory full
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_LOWBATTERY,    ///< Battery is too low to record.
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_AUTOSTOPPED,    ///< Video was auto stopped
    ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_MAX
} eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR;


/**
 * @brief Drone flying state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_LANDED = 0,    ///< Landed state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_TAKINGOFF,    ///< Taking off state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_HOVERING,    ///< Hovering / Circling (for fixed wings) state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_FLYING,    ///< Flying state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_LANDING,    ///< Landing state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_EMERGENCY,    ///< Emergency state
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_USERTAKEOFF,    ///< User take off state. Waiting for user action to take off.
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE;


/**
 * @brief Drone alert state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_NONE = 0,    ///< No alert
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_USER,    ///< User emergency alert
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_CUT_OUT,    ///< Cut out alert
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_CRITICAL_BATTERY,    ///< Critical battery alert
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_LOW_BATTERY,    ///< Low battery alert
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_TOO_MUCH_ANGLE,    ///< The angle of the drone is too high
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE;


/**
 * @brief State of navigate home
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_AVAILABLE = 0,    ///< Navigate home is available
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_INPROGRESS,    ///< Navigate home is in progress
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_UNAVAILABLE,    ///< Navigate home is not available
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_PENDING,    ///< Navigate home has been received, but its process is pending
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE;


/**
 * @brief Reason of the state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_USERREQUEST = 0,    ///< User requested a navigate home (available->inProgress)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_CONNECTIONLOST,    ///< Connection between controller and product lost (available->inProgress)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_LOWBATTERY,    ///< Low battery occurred (available->inProgress)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_FINISHED,    ///< Navigate home is finished (inProgress->available)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_STOPPED,    ///< Navigate home has been stopped (inProgress->available)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_DISABLED,    ///< Navigate home disabled by product (inProgress->unavailable or available->unavailable)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_ENABLED,    ///< Navigate home enabled by product (unavailable->available)
    ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_OK = 0,    ///< No Error ; The relative displacement
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_BUSY,    ///< The Device is busy ; command moveBy ignored
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_NOTAVAILABLE,    ///< Command moveBy is not available ; command moveBy ignored
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_INTERRUPTED,    ///< Command moveBy interrupted
    ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR;


/**
 * @brief The band(s) : 2.4 Ghz, 5 Ghz, or both
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_MAX
} eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND;


/**
 * @brief The band : 2.4 GHz or 5 GHz
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND;


/**
 * @brief The band of this channel : 2.4 GHz or 5 GHz
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND;


/**
 * @brief The circling direction
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_CW = 0,    ///< Circling ClockWise
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_CCW,    ///< Circling Counter ClockWise
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE;


/**
 * @brief The Pitch mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_NORMAL = 0,    ///< Positive pitch values will make the drone lower its nose.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_INVERTED,    ///< Pitch commands are inverted.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE;


/**
 * @brief The Landing mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_LINEAR = 0,    ///< Linear landing.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_SPIRALE,    ///< Spirale landing.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE;


/**
 * @brief The circling direction
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_CW = 0,    ///< Circling ClockWise
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_CCW,    ///< Circling Counter ClockWise
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE;


/**
 * @brief The Pitch mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_NORMAL = 0,    ///< Positive pitch values will make the drone lower its nose.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_INVERTED,    ///< Pitch commands are inverted.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE;


/**
 * @brief The Landing mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_LINEAR = 0,    ///< Linear landing.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_SPIRALE,    ///< Spirale landing.
    ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_MAX
} eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE;


/**
 * @brief The type of wifi selection (auto, manual)
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_AUTO = 0,    ///< Auto selection
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_MANUAL,    ///< Manual selection
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE;


/**
 * @brief The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND;


/**
 * @brief The type of wifi security (open, wpa2)
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_OPEN = 0,    ///< Wifi is not protected by any security (default)
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_WPA2,    ///< Wifi is protected by wpa2
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE;


/**
 * @brief Type of the key
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_PLAIN = 0,    ///< Key is plain text, not encrypted
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE;


/**
 * @brief The type of wifi selection settings
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_ALL = 0,    ///< Auto selection
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_2_4GHZ,    ///< Auto selection 2.4ghz
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_5GHZ,    ///< Auto selection 5 ghz
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MANUAL,    ///< Manual selection
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE;


/**
 * @brief The actual  wifi band state
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND;


/**
 * @brief The type of wifi security (open, wpa2)
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_OPEN = 0,    ///< Wifi is not protected by any security (default)
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_WPA2,    ///< Wifi is protected by wpa2
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE;


/**
 * @brief The type of wifi security (open, wpa2)
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_OPEN = 0,    ///< Wifi is not protected by any security (default)
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_WPA2,    ///< Wifi is protected by wpa2
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE;


/**
 * @brief Type of the key
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_PLAIN = 0,    ///< Key is plain text, not encrypted
    ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_MAX
} eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE;


/**
 * @brief Enumeration of the motor error
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_NOERROR = 0,    ///< No error detected
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERROREEPROM,    ///< EEPROM access failure
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORMOTORSTALLED,    ///< Motor stalled
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORPROPELLERSECURITY,    ///< Propeller cutout security triggered
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORCOMMLOST,    ///< Communication with motor failed by timeout
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORRCEMERGENCYSTOP,    ///< RC emergency stop
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORREALTIME,    ///< Motor controler scheduler real-time out of bounds
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORMOTORSETTING,    ///< One or several incorrect values in motor settings
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORTEMPERATURE,    ///< Too hot or too cold Cypress temperature
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORBATTERYVOLTAGE,    ///< Battery voltage out of bounds
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORLIPOCELLS,    ///< Incorrect number of LIPO cells
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORMOSFET,    ///< Defectuous MOSFET or broken motor phases
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORBOOTLOADER,    ///< Not use for BLDC but useful for HAL
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ERRORASSERT,    ///< Error Made by BLDC_ASSERT()
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_MAX
} eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR;


/**
 * @brief Enumeration of the motor error
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_NOERROR = 0,    ///< No error detected
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERROREEPROM,    ///< EEPROM access failure
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORMOTORSTALLED,    ///< Motor stalled
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORPROPELLERSECURITY,    ///< Propeller cutout security triggered
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORCOMMLOST,    ///< Communication with motor failed by timeout
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORRCEMERGENCYSTOP,    ///< RC emergency stop
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORREALTIME,    ///< Motor controler scheduler real-time out of bounds
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORMOTORSETTING,    ///< One or several incorrect values in motor settings
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORBATTERYVOLTAGE,    ///< Battery voltage out of bounds
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORLIPOCELLS,    ///< Incorrect number of LIPO cells
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORMOSFET,    ///< Defectuous MOSFET or broken motor phases
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORTEMPERATURE,    ///< Too hot or too cold Cypress temperature
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORBOOTLOADER,    ///< Not use for BLDC but useful for HAL
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ERRORASSERT,    ///< Error Made by BLDC_ASSERT()
    ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_MAX
} eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR;


/**
 * @brief The type of photo format
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_RAW = 0,    ///< Take raw image
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_JPEG,    ///< Take a 4:3 jpeg photo
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_SNAPSHOT,    ///< Take a 16:9 snapshot from camera
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_JPEG_FISHEYE,    ///< Take jpeg fisheye image only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE;


/**
 * @brief The type auto white balance
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_AUTO = 0,    ///< Auto guess of best white balance params
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_TUNGSTEN,    ///< Tungsten white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_DAYLIGHT,    ///< Daylight white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_CLOUDY,    ///< Cloudy white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_COOL_WHITE,    ///< White balance for a flash
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE;


/**
 * @brief Video stabilization mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ROLL_PITCH = 0,    ///< Video flat on roll and pitch
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_PITCH,    ///< Video flat on pitch only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ROLL,    ///< Video flat on roll only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_NONE,    ///< Video follows drone angles
    ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE;


/**
 * @brief The type of photo format
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_RAW = 0,    ///< Take raw image
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_JPEG,    ///< Take a 4:3 jpeg photo
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_SNAPSHOT,    ///< Take a 16:9 snapshot from camera
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_JPEG_FISHEYE,    ///< Take jpeg fisheye image only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE;


/**
 * @brief The type auto white balance
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_AUTO = 0,    ///< Auto guess of best white balance params
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_TUNGSTEN,    ///< Tungsten white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_DAYLIGHT,    ///< Daylight white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_CLOUDY,    ///< Cloudy white balance
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_COOL_WHITE,    ///< White balance for a flash
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE;


/**
 * @brief Video stabilization mode
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ROLL_PITCH = 0,    ///< Video flat on roll and pitch
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_PITCH,    ///< Video flat on pitch only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ROLL,    ///< Video flat on roll only
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_NONE,    ///< Video follows drone angles
    ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_MAX
} eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE;


/**
 * @brief Current video streaming status.
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENABLED = 0,    ///< Video streaming is enabled.
    ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_DISABLED,    ///< Video streaming is disabled.
    ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ERROR,    ///< Video streaming failed to start.
    ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_MAX
} eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED;


/**
 * @brief The type of the home position
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_TAKEOFF = 0,    ///< The drone will try to return to the take off position
    ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_PILOT,    ///< The drone will try to return to the pilot position
    ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_MAX
} eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE;


/**
 * @brief The state of the gps update
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_UPDATED = 0,    ///< Drone GPS update succeed
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_INPROGRESS,    ///< Drone GPS update In progress
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_FAILED,    ///< Drone GPS update failed
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_MAX
} eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE;


/**
 * @brief The type of the home position
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_TAKEOFF = 0,    ///< The drone will try to return to the take off position
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_PILOT,    ///< The drone will try to return to the pilot position
    ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE;


/**
 * @brief Type of the electric frequency
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_FIFTYHERTZ = 0,    ///< Electric frequency of the country is 50hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_SIXTYHERTZ,    ///< Electric frequency of the country is 60hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_MAX
} eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY;


/**
 * @brief Mode of the anti flickering functionnality
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_AUTO = 0,    ///< Anti flickering based on the electric frequency previously sent
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_FIXEDFIFTYHERTZ,    ///< Anti flickering based on a fixed frequency of 50Hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_FIXEDSIXTYHERTZ,    ///< Anti flickering based on a fixed frequency of 60Hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_MAX
} eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE;


/**
 * @brief Type of the electric frequency
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_FIFTYHERTZ = 0,    ///< Electric frequency of the country is 50hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_SIXTYHERTZ,    ///< Electric frequency of the country is 60hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_MAX
} eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY;


/**
 * @brief Mode of the anti flickering functionnality
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_AUTO = 0,    ///< Anti flickering based on the electric frequency previously sent
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_FIXEDFIFTYHERTZ,    ///< Anti flickering based on a fixed frequency of 50Hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_FIXEDSIXTYHERTZ,    ///< Anti flickering based on a fixed frequency of 60Hz
    ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_MAX
} eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE;


/**
 * @brief The type of the return home
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_TAKEOFF = 0,    ///< The drone will try to return to the take off position
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_PILOT,    ///< The drone will try to return to the pilot position
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_FIRST_FIX,    ///< The drone has not enough information, it will try to return to the first GPS fix
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE;


/**
 * @brief The type of the return home chosen
 */
typedef enum
{
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_TAKEOFF = 0,    ///< The drone will try to return to the take off position
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_PILOT,    ///< The drone will try to return to the pilot position
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_FIRST_FIX,    ///< The drone has not enough information, it will try to return to the first GPS fix
    ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_MAX
} eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE;

// Feature JumpingSumo

/**
 * @brief Type of Posture
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_STANDING = 0,    ///< Standing type
    ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_JUMPER,    ///< Jumper type
    ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_KICKER,    ///< Kicker type
    ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_MAX
} eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE;


/**
 * @brief State of posture
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_STANDING = 0,    ///< Standing state
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_JUMPER,    ///< Jumper state
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_KICKER,    ///< Kicker state
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_STUCK,    ///< Stuck state
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_UNKNOWN,    ///< Unknown state
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE;


/**
 * @brief JS alert state
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_NONE = 0,    ///< No alert
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_CRITICAL_BATTERY,    ///< Critical battery alert
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_LOW_BATTERY,    ///< Low battery alert
    ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE;


/**
 * @brief Type of jump
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_LONG = 0,    ///< Long jump.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_HIGH,    ///< High jump
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_MAX
} eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE;


/**
 * @brief Animation ID.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_STOP = 0,    ///< Stop ongoing animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SPIN,    ///< Start a spin animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_TAP,    ///< Start a tap animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SLOWSHAKE,    ///< Start a slow shake animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_METRONOME,    ///< Start a Metronome animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_ONDULATION,    ///< Start a standing dance animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SPINJUMP,    ///< Start a spin jump animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SPINTOPOSTURE,    ///< Start a spin that end in standing posture, or in jumper if it was standing animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SPIRAL,    ///< Start a spiral animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_SLALOM,    ///< Start a slalom animation.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_MAX
} eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID;


/**
 * @brief State of jump load
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_UNKNOWN = 0,    ///< Unknown state (obsolete).
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_UNLOADED,    ///< Unloaded state.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_LOADED,    ///< Loaded state.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_BUSY,    ///< Unknown state (obsolete).
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_LOW_BATTERY_UNLOADED,    ///< Unloaded state and low battery.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_LOW_BATTERY_LOADED,    ///< Loaded state and low battery.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE;


/**
 * @brief State of jump type.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_NONE = 0,    ///< None.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_LONG,    ///< Long jump type.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_HIGH,    ///< High jump type.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE;


/**
 * @brief Enum describing the problem of the motor
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_NONE = 0,    ///< None.
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_BLOCKED,    ///< Motor blocked
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_OVER_HEATED,    ///< Motor over heated
    ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_MAX
} eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR;


/**
 * @brief Command to record video
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_STOP = 0,    ///< Stop the video recording
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_START,    ///< Start the video recording
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD;


/**
 * @brief Command to record video
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_STOP = 0,    ///< Stop the video recording
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_START,    ///< Start the video recording
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD;


/**
 * @brief State of video
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_STOPPED = 0,    ///< Video was stopped
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_STARTED,    ///< Video was started
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_FAILED,    ///< Video was failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE;


/**
 * @brief State of device picture recording
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_READY = 0,    ///< The picture recording is ready
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_BUSY,    ///< The picture recording is busy
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_NOTAVAILABLE,    ///< The picture recording is not available
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_CAMERA_KO,    ///< Picture camera is out of order
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MEMORYFULL,    ///< Memory full ; cannot save one additional picture
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_LOWBATTERY,    ///< Battery is too low to start/keep recording.
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR;


/**
 * @brief State of device video recording
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_STOPPED = 0,    ///< Video is stopped
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_STARTED,    ///< Video is started
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_NOTAVAILABLE,    ///< The video recording is not available
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_CAMERA_KO,    ///< Video camera is out of order
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_MEMORYFULL,    ///< Memory full ; cannot save one additional video
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_LOWBATTERY,    ///< Battery is too low to start/keep recording.
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR;


/**
 * @brief Last event of picture recording
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_TAKEN = 0,    ///< Picture taken and saved
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_FAILED,    ///< Picture failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_UNKNOWN,    ///< Unknown generic error ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_BUSY,    ///< Picture recording is busy ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_NOTAVAILABLE,    ///< Picture recording not available ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MEMORYFULL,    ///< Memory full ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_LOWBATTERY,    ///< Battery is too low to record.
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR;


/**
 * @brief Event of video recording
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_START = 0,    ///< Video start
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_STOP,    ///< Video stop and saved
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_FAILED,    ///< Video failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_UNKNOWN,    ///< Unknown generic error ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_BUSY,    ///< Video recording is busy ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_NOTAVAILABLE,    ///< Video recording not available ; only when state is failed
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_MEMORYFULL,    ///< Memory full
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_LOWBATTERY,    ///< Battery is too low to record.
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_AUTOSTOPPED,    ///< Video was auto stopped
    ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR;


/**
 * @brief The type of wifi selection (auto, manual)
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_AUTO = 0,    ///< Auto selection
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_MANUAL,    ///< Manual selection
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE;


/**
 * @brief The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND;


/**
 * @brief The type of wifi selection settings
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_ALL = 0,    ///< Auto selection
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_2_4GHZ,    ///< Auto selection 2.4ghz
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_AUTO_5GHZ,    ///< Auto selection 5 ghz
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MANUAL,    ///< Manual selection
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE;


/**
 * @brief The actual  wifi band state
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND;


/**
 * @brief The band(s) : 2.4 Ghz, 5 Ghz, or both
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_ALL,    ///< Both 2.4 and 5 GHz bands
    ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND;


/**
 * @brief The band : 2.4 GHz or 5 GHz
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND;


/**
 * @brief The band of this channel : 2.4 GHz or 5 GHz
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_MAX
} eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND;


/**
 * @brief The audio theme to set.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_DEFAULT = 0,    ///< Default audio theme (depends on the product color)
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_ROBOT,    ///< Robot audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_INSECT,    ///< Insect audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_MONSTER,    ///< Monster audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_MAX
} eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME;


/**
 * @brief The audio theme to set.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_DEFAULT = 0,    ///< Default audio theme (depends on the product color)
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_ROBOT,    ///< Robot audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_INSECT,    ///< Insect audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_MONSTER,    ///< Monster audio theme.
    ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_MAX
} eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME;


/**
 * @brief Error code.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ERROR_OK = 0,    ///< The script was parsed successfully.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ERROR_FILE_CORRUPTED,    ///< The MD5 hash codes are different or file is unreadable.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ERROR_INVALID_FORMAT,    ///< The parser is not well formed or can not be parsed.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ERROR_FILE_TOO_LARGE,    ///< The file is larger than maximum allowed size.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ERROR_UNSUPPORTED,    ///< Script version is not supported by device.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_MAX
} eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE;


/**
 * @brief Error code.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ERROR_OK = 0,    ///< The script was deleted successfully.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ERROR_NO_SUCH_SCRIPT,    ///< No script with this uuid exists.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ERROR_INTERNAL_FAILURE,    ///< An internal error occured while attempting to delete the script.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_MAX
} eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE;


/**
 * @brief Error code.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_SCRIPT_STARTED = 0,    ///< The script started playing successfully.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_SCRIPT_FINISHED,    ///< The script finished successfully.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_SCRIPT_NO_SUCH_SCRIPT,    ///< No script with this uuid exists.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_SCRIPT_ERROR,    ///< An error occured while playing the script.
    ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_MAX
} eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE;


/**
 * @brief Current video streaming status.
 */
typedef enum
{
    ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENABLED = 0,    ///< Video streaming is enabled.
    ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_DISABLED,    ///< Video streaming is disabled.
    ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ERROR,    ///< Video streaming failed to start.
    ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_MAX
} eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED;

// Feature MiniDrone

/**
 * @brief Drone flying state
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_LANDED = 0,    ///< Landed state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_TAKINGOFF,    ///< Taking off state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_HOVERING,    ///< Hovering state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_FLYING,    ///< Flying state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_LANDING,    ///< Landing state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_EMERGENCY,    ///< Emergency state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ROLLING,    ///< Rolling state
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_INIT,    ///< Initializing state (user should let the drone steady for a while)
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_MAX
} eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE;


/**
 * @brief Drone alert state
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_NONE = 0,    ///< No alert
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_USER,    ///< User emergency alert
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_CUT_OUT,    ///< Cut out alert
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_CRITICAL_BATTERY,    ///< Critical battery alert
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_LOW_BATTERY,    ///< Low battery alert
    ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_MAX
} eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE;


/**
 * @brief Direction for the flip
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_FRONT = 0,    ///< Flip direction front
    ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_BACK,    ///< Flip direction back
    ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_RIGHT,    ///< Flip direction right
    ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_LEFT,    ///< Flip direction left
    ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_MAX
} eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION;


/**
 * @brief State of device picture recording
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_READY = 0,    ///< The picture recording is ready
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_BUSY,    ///< The picture recording is busy
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_NOTAVAILABLE,    ///< The picture recording is not available
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_MAX
} eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_CAMERA_KO,    ///< Picture camera is out of order
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MEMORYFULL,    ///< Memory full ; cannot save one additional picture
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_LOWBATTERY,    ///< Battery is too low to start/keep recording.
    ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_MAX
} eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR;


/**
 * @brief Last event of picture recording
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_TAKEN = 0,    ///< Picture taken and saved
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_FAILED,    ///< Picture failed
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_MAX
} eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT;


/**
 * @brief Error to explain the event
 */
typedef enum
{
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_UNKNOWN,    ///< Unknown generic error ; only when state is failed
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_BUSY,    ///< Picture recording is busy ; only when state is failed
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_NOTAVAILABLE,    ///< Picture recording not available ; only when state is failed
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MEMORYFULL,    ///< Memory full ; only when state is failed
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_LOWBATTERY,    ///< Battery is too low to record.
    ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_MAX
} eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR;

// Feature SkyController

/**
 * @brief Wifi status
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_CONNECTED = 0,    ///< Connected
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_ERROR,    ///< Error
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_DISCONNECTED,    ///< Disconnected
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_MAX
} eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS;


/**
 * @brief The band of this channel : 2.4 GHz or 5 GHz
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_MAX
} eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND;


/**
 * @brief Wifi status to Device
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_NOTCONNECTED = 0,    ///< Not Connected
    ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_CONNECTING,    ///< Connecting to Device
    ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_CONNECTED,    ///< Connected to Device
    ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_DISCONNECTING,    ///< Disconnecting from Device
    ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_MAX
} eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS;


/**
 * @brief Variant of the product
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_BEBOP = 0,    ///< SkyController of the bebop generation.
    ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_BEBOP2,    ///< SkyController of the bebop2 generation.
    ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_MAX
} eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT;


/**
 * @brief The type of wifi selection (only manual at the moment)
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_MANUAL = 0,    ///< Manual selection
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_MAX
} eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE;


/**
 * @brief The allowed band : 2.4 Ghz or 5 Ghz
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_MAX
} eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND;


/**
 * @brief The type of wifi selection (only manual at the moment)
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MANUAL = 0,    ///< Manual selection
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_MAX
} eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE;


/**
 * @brief The allowed band : 2.4 Ghz or 5 Ghz
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_MAX
} eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND;


/**
 * @brief The type (axis/button) of the control
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_AXIS = 0,    ///< An analog axis (one of the 4 joysticks)
    ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_BUTTON,    ///< A button (including small joystick clicks)
    ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_MAX
} eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE;


/**
 * @brief The source
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_SKYCONTROLLER = 0,    ///< Use the SkyController joysticks
    ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_CONTROLLER,    ///< Use the Tablet (or smartphone, or whatever) controls
    ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_MAX
} eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE;


/**
 * @brief The source
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_SKYCONTROLLER = 0,    ///< Use the SkyController joysticks
    ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_CONTROLLER,    ///< Use the Tablet (or smartphone, or whatever) controls
    ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_MAX
} eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE;


/**
 * @brief The global status of the calibration
 */
typedef enum
{
    ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_UNRELIABLE = 0,    ///< A calibration is needed
    ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_ASSESSING,    ///< A calibration is applied, but still need to be checked
    ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_CALIBRATED,    ///< The sensor is properly calibrated
    ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_MAX
} eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS;

// Feature unknown_feature_1

/**
 * @brief Type of UnknownFeature_1
 */
typedef enum
{
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_NONE = 0,    ///< No unknown feature_1
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_LOOK_AT,    ///< LookAt unknown feature_1 type
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_GEOGRAPHIC,    ///< Follow the target keeping the same vector
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_RELATIVE,    ///< Follow the target keeping the same orientation to its direction
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_MAX
} eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE;


/**
 * @brief Type of the current UnknownFeature_1 animation
 */
typedef enum
{
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_NONE = 0,    ///< No current unknown feature_1 animation
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_SPIRAL,    ///< Current unknown feature_1 animation is spiral
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_SWING,    ///< Current unknown feature_1 animation is swing
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_BOOMERANG,    ///< Current unknown feature_1 animation is boomerang
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_CANDLE,    ///< Current unknown feature_1 animation is candle
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_DOLLY_SLIDE,    ///< Current unknown feature_1 animation is dolly slide
    ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_MAX
} eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE;


/**
 * @brief Types of UnknownFeature_1 available
 */
typedef enum
{
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_NONE = 0,    ///< No unknown feature_1 available
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_LOOK_AT,    ///< LookAt available, no other types
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_LOOK_AND_FOLLOW,    ///< LookAt, Geographic and Relative unknown feature_1 are available
    ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_MAX
} eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE;

// Feature common

/**
 * @brief Cause of the disconnection of the product
 */
typedef enum
{
    ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_OFF_BUTTON = 0,    ///< The button off has been pressed
    ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_UNKNOWN,    ///< Unknown generic cause
    ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_MAX
} eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE;


/**
 * @brief Sensor name
 */
typedef enum
{
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_IMU = 0,    ///< Inertial Measurement Unit sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_BAROMETER,    ///< Barometer sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_ULTRASOUND,    ///< Ultrasonic sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_GPS,    ///< GPS sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_MAGNETOMETER,    ///< Magnetometer sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_VERTICAL_CAMERA,    ///< Vertical Camera sensor
    ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_MAX
} eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME;


/**
 * @brief The Model of the product.
 */
typedef enum
{
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_TRAVIS = 0,    ///< Travis (RS taxi) model.
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_MARS,    ///< Mars (RS space) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_SWAT,    ///< SWAT (RS SWAT) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_MCLANE,    ///< Mc Lane (RS police) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_BLAZE,    ///< Blaze (RS fire) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_ORAK,    ///< Orak (RS carbon hydrofoil) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_RS_NEWZ,    ///< New Z (RS wooden hydrofoil) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_MARSHALL,    ///< Marshall (JS fire) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_DIESEL,    ///< Diesel (JS SWAT) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_BUZZ,    ///< Buzz (JS space) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_MAX,    ///< Max (JS F1) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_JETT,    ///< Jett (JS flames) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_JS_TUKTUK,    ///< Tuk-Tuk (JS taxi) model
    ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_MAX
} eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL;


/**
 * @brief type of the played mavlink file
 */
typedef enum
{
    ARCOMMANDS_COMMON_MAVLINK_START_TYPE_FLIGHTPLAN = 0,    ///< Mavlink file for FlightPlan
    ARCOMMANDS_COMMON_MAVLINK_START_TYPE_MAPMYHOUSE,    ///< Mavlink file for MapMyHouse
    ARCOMMANDS_COMMON_MAVLINK_START_TYPE_MAX
} eARCOMMANDS_COMMON_MAVLINK_START_TYPE;


/**
 * @brief State of the mavlink
 */
typedef enum
{
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_PLAYING = 0,    ///< Mavlink file is playing
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_STOPPED,    ///< Mavlink file is stopped (arg filepath and type are useless in this state)
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_PAUSED,    ///< Mavlink file is paused
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_MAX
} eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE;


/**
 * @brief type of the played mavlink file
 */
typedef enum
{
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_FLIGHTPLAN = 0,    ///< Mavlink file for FlightPlan
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_MAPMYHOUSE,    ///< Mavlink file for MapMyHouse
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_MAX
} eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE;


/**
 * @brief State of play error
 */
typedef enum
{
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_NONE = 0,    ///< There is no error
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_NOTINOUTDOORMODE,    ///< The drone is not in outdoor mode
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_GPSNOTFIXED,    ///< The gps is not fixed
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_NOTCALIBRATED,    ///< The magnetometer of the drone is not calibrated
    ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_MAX
} eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR;


/**
 * @brief The axis to calibrate
 */
typedef enum
{
    ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_XAXIS = 0,    ///< If the current calibration axis should be the x axis
    ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_YAXIS,    ///< If the current calibration axis should be the y axis
    ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_ZAXIS,    ///< If the current calibration axis should be the z axis
    ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_NONE,    ///< If none of the axis should be calibrated
    ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_MAX
} eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS;


/**
 * @brief Drone FlightPlan component id (unique)
 */
typedef enum
{
    ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_GPS = 0,    ///< GPS for Drone FlightPlan
    ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_CALIBRATION,    ///< Calibration for Drone FlightPlan
    ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_MAVLINK_FILE,    ///< Mavlink file for Drone FlightPlan
    ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_TAKEOFF,    ///< Take off
    ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_MAX
} eARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT;


/**
 * @brief Animation to start.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_HEADLIGHTS_FLASH = 0,    ///< Flash headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_HEADLIGHTS_BLINK,    ///< Blink headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_HEADLIGHTS_OSCILLATION,    ///< Oscillating headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SPIN,    ///< Spin animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_TAP,    ///< Tap animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SLOW_SHAKE,    ///< Slow shake animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_METRONOME,    ///< Metronome animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_ONDULATION,    ///< Standing dance animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SPIN_JUMP,    ///< Spin jump animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SPIN_TO_POSTURE,    ///< Spin that end in standing posture, or in jumper if it was standing animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SPIRAL,    ///< Spiral animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_SLALOM,    ///< Slalom animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_BOOST,    ///< Boost animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_MAX
} eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM;


/**
 * @brief Animation to stop.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_HEADLIGHTS_FLASH = 0,    ///< Flash headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_HEADLIGHTS_BLINK,    ///< Blink headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_HEADLIGHTS_OSCILLATION,    ///< Oscillating headlights.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SPIN,    ///< Spin animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_TAP,    ///< Tap animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SLOW_SHAKE,    ///< Slow shake animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_METRONOME,    ///< Metronome animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_ONDULATION,    ///< Standing dance animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SPIN_JUMP,    ///< Spin jump animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SPIN_TO_POSTURE,    ///< Spin that end in standing posture, or in jumper if it was standing animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SPIRAL,    ///< Spiral animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_SLALOM,    ///< Slalom animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_BOOST,    ///< Boost animation.
    ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_MAX
} eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM;


/**
 * @brief Animation type.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_HEADLIGHTS_FLASH = 0,    ///< Flash headlights.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_HEADLIGHTS_BLINK,    ///< Blink headlights.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_HEADLIGHTS_OSCILLATION,    ///< Oscillating headlights.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SPIN,    ///< Spin animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_TAP,    ///< Tap animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SLOW_SHAKE,    ///< Slow shake animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_METRONOME,    ///< Metronome animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_ONDULATION,    ///< Standing dance animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SPIN_JUMP,    ///< Spin jump animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SPIN_TO_POSTURE,    ///< Spin that end in standing posture, or in jumper if it was standing animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SPIRAL,    ///< Spiral animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_SLALOM,    ///< Slalom animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_BOOST,    ///< Boost animation.
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_MAX
} eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM;


/**
 * @brief State of the animation
 */
typedef enum
{
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_STOPPED = 0,    ///< animation is stopped
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_STARTED,    ///< animation is started
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_NOTAVAILABLE,    ///< The animation is not available
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_MAX
} eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE;


/**
 * @brief Error to explain the state
 */
typedef enum
{
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_OK = 0,    ///< No Error
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_UNKNOWN,    ///< Unknown generic error
    ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_MAX
} eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR;


/**
 * @brief Accessory configuration to set.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_NO_ACCESSORY = 0,    ///< No accessory.
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_STD_WHEELS,    ///< Standard wheels
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_TRUCK_WHEELS,    ///< Truck wheels
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_HULL,    ///< Hull
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_HYDROFOIL,    ///< Hydrofoil
    ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_MAX
} eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY;


/**
 * @brief Accessory configurations supported by the product.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_NO_ACCESSORY = 0,    ///< No accessory.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_STD_WHEELS,    ///< Standard wheels
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_TRUCK_WHEELS,    ///< Truck wheels
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_HULL,    ///< Hull
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_HYDROFOIL,    ///< Hydrofoil
    ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_MAX
} eARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY;


/**
 * @brief Accessory configuration reported by firmware.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_UNCONFIGURED = 0,    ///< No accessory configuration set. Controller needs to set one.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_NO_ACCESSORY,    ///< No accessory.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_STD_WHEELS,    ///< Standard wheels
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_TRUCK_WHEELS,    ///< Truck wheels
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_HULL,    ///< Hull
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_HYDROFOIL,    ///< Hydrofoil
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_MAX
} eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY;


/**
 * @brief Error code.
 */
typedef enum
{
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_OK = 0,    ///< No error. Accessory config change successful.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_UNKNOWN,    ///< Cannot change accessory configuration for some reason.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_FLYING,    ///< Cannot change accessory configuration while flying.
    ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_MAX
} eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR;


/**
 * @brief The new maximum charge rate.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_SLOW = 0,    ///< Fully charge the battery at a slow rate. Typically limit max charge current to 512 mA.
    ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_MODERATE,    ///< Almost fully-charge the battery at moderate rate (> 512mA) but slower than the fastest rate.
    ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_FAST,    ///< Almost fully-charge the battery at the highest possible rate supported by the charger.
    ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_MAX
} eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE;


/**
 * @brief The current maximum charge rate.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_SLOW = 0,    ///< Fully charge the battery at a slow rate. Typically limit max charge current to 512 mA.
    ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_MODERATE,    ///< Almost fully-charge the battery at moderate rate (> 512 mA) but slower than the fastest rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_FAST,    ///< Almost fully-charge the battery at the highest possible rate supported by the charger.
    ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE;


/**
 * @brief Charger status.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_DISCHARGING = 0,    ///< The battery is discharging.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_CHARGING_SLOW,    ///< The battery is charging at a slow rate about 512 mA.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_CHARGING_MODERATE,    ///< The battery is charging at a moderate rate (> 512 mA) but slower than the fastest rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_CHARGING_FAST,    ///< The battery is charging at a the fastest rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_BATTERY_FULL,    ///< The charger is plugged and the battery is fully charged.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS;


/**
 * @brief The current charging phase.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_UNKNOWN = 0,    ///< The charge phase is unknown or irrelevant.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_CONSTANT_CURRENT_1,    ///< First phase of the charging process. The battery is charging with constant current.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_CONSTANT_CURRENT_2,    ///< Second phase of the charging process. The battery is charging with constant current, with a higher voltage than the first phase.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_CONSTANT_VOLTAGE,    ///< Last part of the charging process. The battery is charging with a constant voltage.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_CHARGED,    ///< The battery is fully charged.
    ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE;


/**
 * @brief The charge rate recorded by the firmware for the last charge.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_UNKNOWN = 0,    ///< The last charge rate is not known.
    ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_SLOW,    ///< Slow charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_MODERATE,    ///< Moderate charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_FAST,    ///< Fast charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE;


/**
 * @brief The current charging phase.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_UNKNOWN = 0,    ///< The charge phase is unknown or irrelevant.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_CONSTANT_CURRENT_1,    ///< First phase of the charging process. The battery is charging with constant current.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_CONSTANT_CURRENT_2,    ///< Second phase of the charging process. The battery is charging with constant current, with a higher voltage than the first phase.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_CONSTANT_VOLTAGE,    ///< Last part of the charging process. The battery is charging with a constant voltage.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_CHARGED,    ///< The battery is fully charged.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_DISCHARGING,    ///< The battery is discharging; Other arguments refers to the last charge.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE;


/**
 * @brief The charge rate. If phase is DISCHARGING, refers to the last charge.
 */
typedef enum
{
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_UNKNOWN = 0,    ///< The charge rate is not known.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_SLOW,    ///< Slow charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_MODERATE,    ///< Moderate charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_FAST,    ///< Fast charge rate.
    ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_MAX
} eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE;

// Feature commonDebug

/**
 * @brief Setting type.
 */
typedef enum
{
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_BOOL = 0,    ///< Boolean Setting. (ex: 0, 1)
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_DECIMAL,    ///< Decimal Setting. (ex: -3.5, 0, 2, 3.6, 6.5)
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_TEXT,    ///< Single line text Setting.
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_MAX
} eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE;


/**
 * @brief Setting mode.
 */
typedef enum
{
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_READ_ONLY = 0,    ///< Controller can only read setting.
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_READ_WRITE,    ///< Controller can read and write setting.
    ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_MAX
} eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE;

// Feature pro

/**
 * @brief Status of the supported features
 */
typedef enum
{
    ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_OK = 0,    ///< Response is valid, pro features available
    ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_CHALLENGE_ERROR,    ///< The response received is not valid
    ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_MAX
} eARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS;

// Feature wifi

/**
 * @brief The band : 2.4 Ghz or 5 Ghz
 */
typedef enum
{
    ARCOMMANDS_WIFI_BAND_2_4GHZ = 0,    ///< 2.4 GHz band
    ARCOMMANDS_WIFI_BAND_5GHZ,    ///< 5 GHz band
    ARCOMMANDS_WIFI_BAND_MAX
} eARCOMMANDS_WIFI_BAND;

#define ARCOMMANDS_FLAG_WIFI_BAND_2_4GHZ (1 << ARCOMMANDS_WIFI_BAND_2_4GHZ)    ///< 2.4 GHz band
#define ARCOMMANDS_FLAG_WIFI_BAND_5GHZ (1 << ARCOMMANDS_WIFI_BAND_5GHZ)    ///< 5 GHz band


/**
 * @brief The wifi selection type available
 */
typedef enum
{
    ARCOMMANDS_WIFI_SELECTION_TYPE_AUTO_ALL = 0,    ///< Auto selection on all channels
    ARCOMMANDS_WIFI_SELECTION_TYPE_AUTO_2_4_GHZ,    ///< Auto selection 2.4ghz
    ARCOMMANDS_WIFI_SELECTION_TYPE_AUTO_5_GHZ,    ///< Auto selection 5 ghz
    ARCOMMANDS_WIFI_SELECTION_TYPE_MANUAL,    ///< manual selection
    ARCOMMANDS_WIFI_SELECTION_TYPE_MAX
} eARCOMMANDS_WIFI_SELECTION_TYPE;


/**
 * @brief The type of wifi security (open, wpa2)
 */
typedef enum
{
    ARCOMMANDS_WIFI_SECURITY_TYPE_OPEN = 0,    ///< Wifi is not protected by any security (default)
    ARCOMMANDS_WIFI_SECURITY_TYPE_WPA2,    ///< Wifi is protected by wpa2
    ARCOMMANDS_WIFI_SECURITY_TYPE_MAX
} eARCOMMANDS_WIFI_SECURITY_TYPE;


/**
 * @brief Type of the key sent
 */
typedef enum
{
    ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_PLAIN = 0,    ///< Key is plain text, not encrypted
    ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_MAX
} eARCOMMANDS_WIFI_SECURITY_KEY_TYPE;


/**
 * @brief Type of environement
 */
typedef enum
{
    ARCOMMANDS_WIFI_ENVIRONEMENT_INDOOR = 0,    ///< indoor environement
    ARCOMMANDS_WIFI_ENVIRONEMENT_OUTDOOR,    ///< outdoor environement
    ARCOMMANDS_WIFI_ENVIRONEMENT_MAX
} eARCOMMANDS_WIFI_ENVIRONEMENT;

#define ARCOMMANDS_FLAG_WIFI_ENVIRONEMENT_INDOOR (1 << ARCOMMANDS_WIFI_ENVIRONEMENT_INDOOR)    ///< indoor environement
#define ARCOMMANDS_FLAG_WIFI_ENVIRONEMENT_OUTDOOR (1 << ARCOMMANDS_WIFI_ENVIRONEMENT_OUTDOOR)    ///< outdoor environement


/**
 * @brief Type of country selection
 */
typedef enum
{
    ARCOMMANDS_WIFI_COUNTRY_SELECTION_MANUAL = 0,    ///< Manual selection.
    ARCOMMANDS_WIFI_COUNTRY_SELECTION_AUTO,    ///< Automatic selection.
    ARCOMMANDS_WIFI_COUNTRY_SELECTION_MAX
} eARCOMMANDS_WIFI_COUNTRY_SELECTION;


#endif /* _LIBARCOMMANDS_ARCOMMANDS_TYPES_H_ */
