/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**
 * @file libARCommands/ARCOMMANDS_Filter.h
 * @brief libARCommands filter header.
 * This file contains all declarations needed to create and use a commands filter
 * @note Autogenerated file
 **/
#ifndef _LIBARCOMMANDS_ARCOMMANDS_FILTER_H_
#define _LIBARCOMMANDS_ARCOMMANDS_FILTER_H_
#include <libARCommands/ARCOMMANDS_Types.h>
#include <inttypes.h>

/**
 * @brief Error code for ARCOMMANDS_Filter functions.
 */
typedef enum {
    ARCOMMANDS_FILTER_OK = 0, ///< No error.
    ARCOMMANDS_FILTER_ERROR_ALLOC, ///< Memory allocation error.
    ARCOMMANDS_FILTER_ERROR_BAD_STATUS, ///< The given status is not a valid status.
    ARCOMMANDS_FILTER_ERROR_BAD_FILTER, ///< The given filter is not a valid filter.
    ARCOMMANDS_FILTER_ERROR_BAD_BUFFER, ///< The given buffer is not a valid buffer.
    ARCOMMANDS_FILTER_ERROR_OTHER, ///< Any other error.
} eARCOMMANDS_FILTER_ERROR;

/**
 * @brief Status code for ARCOMMANDS_Filter_FilterCommand function
 */
typedef enum {
    ARCOMMANDS_FILTER_STATUS_ALLOWED = 0, ///< The command should pass the filter
    ARCOMMANDS_FILTER_STATUS_BLOCKED, ///< The command should not pass the filter
    ARCOMMANDS_FILTER_STATUS_UNKNOWN, ///< Unknown command. The command was possibly added in a newer version of libARCommands, or is an invalid command.
    ARCOMMANDS_FILTER_STATUS_ERROR, ///< The filtering of the command failed.
} eARCOMMANDS_FILTER_STATUS;

/**
 * @brief ARCOMMANDS_Filter object holder
 */
typedef struct ARCOMMANDS_Filter_t ARCOMMANDS_Filter_t;

/**
 * @brief Creates a new ARCOMMANDS_Filter_t
 * @param defaultBehavior The default behavior of the filter (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @param error Optionnal pointer which will hold the error code.
 * @warning This function allocates memory.
 * @note The memory must be freed by a call to ARCOMMANDS_Filter_DeleteFilter.
 * @return A new ARCOMMANDS_Filter_t instance. NULL in case of error.
 */
ARCOMMANDS_Filter_t* ARCOMMANDS_Filter_NewFilter (eARCOMMANDS_FILTER_STATUS defaultBehavior, eARCOMMANDS_FILTER_ERROR *error);

/**
 * @brief Deletes an ARCOMMANDS_Filter_t
 * @param filter The filter to delete.
 */
void ARCOMMANDS_Filter_DeleteFilter (ARCOMMANDS_Filter_t **filter);

/**
 * @brief Filter an ARCommand
 * @param filter The ARCOMMANDS_Filter_t to use for filtering.
 * @param buffer The ARCommand buffer.
 * @param len The ARCommand buffer length.
 * @param error Optionnal pointer which will hold the error code.
 * @return An eARCOMMANDS_FILTER_STATUS status code
 */
eARCOMMANDS_FILTER_STATUS ARCOMMANDS_Filter_FilterCommand (ARCOMMANDS_Filter_t *filter, uint8_t *buffer, uint32_t len, eARCOMMANDS_FILTER_ERROR *error);


// Filter ON/OFF functions
// Feature generic

/**
 * @brief Sets the filter behavior for all commands generic.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetGenericBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command generic.default.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetGenericDefaultBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature ARDrone3

/**
 * @brief Sets the filter behavior for all commands ARDrone3.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Piloting

/**
 * @brief Sets the filter behavior for all commands ARDrone3.Piloting.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.FlatTrim.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingFlatTrimBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.TakeOff.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.PCMD.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.Landing.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingLandingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.Emergency.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEmergencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.NavigateHome.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingNavigateHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.AutoTakeOffMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingAutoTakeOffModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.moveBy.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingMoveByBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.UserTakeOff.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingUserTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Piloting.Circle.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingCircleBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Animations

/**
 * @brief Sets the filter behavior for all commands ARDrone3.Animations.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Animations.Flip.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AnimationsFlipBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Camera

/**
 * @brief Sets the filter behavior for all commands ARDrone3.Camera.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Camera.Orientation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecord

/**
 * @brief Sets the filter behavior for all commands ARDrone3.MediaRecord.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecord.Picture.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecord.Video.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecord.PictureV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecord.VideoV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.MediaRecordState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordState.PictureStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordState.VideoStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordState.PictureStateChangedV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordState.VideoStateChangedV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordEvent

/**
 * @brief Sets the filter behavior for all commands ARDrone3.MediaRecordEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordEvent.PictureEventChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaRecordEvent.VideoEventChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventVideoEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PilotingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.FlatTrimChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateFlatTrimChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.FlyingStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateFlyingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.AlertStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.NavigateHomeStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateNavigateHomeStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.PositionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStatePositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.SpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.AttitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAttitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.AutoTakeOffModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAutoTakeOffModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingState.AltitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingEvent

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PilotingEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingEvent.moveByEnd.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEventMoveByEndBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Network

/**
 * @brief Sets the filter behavior for all commands ARDrone3.Network.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Network.WifiScan.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Network.WifiAuthChannel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.NetworkState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkState.WifiScanListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiScanListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkState.AllWifiScanChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiScanChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkState.WifiAuthChannelListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkState.AllWifiAuthChannelChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingSettings

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PilotingSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.MaxAltitude.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.MaxTilt.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxTiltBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.AbsolutControl.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsAbsolutControlBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.MaxDistance.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxDistanceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.NoFlyOverMaxDistance.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalAcceleration.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalAcceleration.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxRotationSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.BankedTurn.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBankedTurnBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.MinAltitude.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMinAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.CirclingDirection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingDirectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.CirclingRadius.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingRadiusBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.CirclingAltitude.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.PitchMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsPitchModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettings.LandingMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsLandingModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingSettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PilotingSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.MaxAltitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.MaxTiltChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxTiltChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AbsolutControlChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAbsolutControlChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.MaxDistanceChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxDistanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.NoFlyOverMaxDistanceChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalAcceleration.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalAcceleration.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxRotationSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.BankedTurnChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBankedTurnChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.MinAltitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMinAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.CirclingDirectionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.CirclingRadiusChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.CirclingAltitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.PitchModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStatePitchModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PilotingSettingsState.LandingModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateLandingModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettings

/**
 * @brief Sets the filter behavior for all commands ARDrone3.SpeedSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettings.MaxVerticalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettings.MaxRotationSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettings.HullProtection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsHullProtectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettings.Outdoor.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsOutdoorBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettings.MaxPitchRollRotationSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.SpeedSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettingsState.MaxVerticalSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettingsState.MaxRotationSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettingsState.HullProtectionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateHullProtectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettingsState.OutdoorChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateOutdoorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SpeedSettingsState.MaxPitchRollRotationSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkSettings

/**
 * @brief Sets the filter behavior for all commands ARDrone3.NetworkSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkSettings.WifiSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkSettings.wifiSecurity.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkSettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.NetworkSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkSettingsState.WifiSelectionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkSettingsState.wifiSecurityChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.NetworkSettingsState.wifiSecurity.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.SettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.ProductMotorVersionListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateProductMotorVersionListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.ProductGPSVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateProductGPSVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.MotorErrorStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.MotorSoftwareVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorSoftwareVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.MotorFlightsStatusChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorFlightsStatusChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.MotorErrorLastErrorChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorLastErrorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.SettingsState.P7ID.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateP7IDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PictureSettings

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PictureSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.PictureFormatSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsPictureFormatSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.AutoWhiteBalanceSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.ExpositionSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsExpositionSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.SaturationSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsSaturationSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.TimelapseSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsTimelapseSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.VideoAutorecordSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoAutorecordSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettings.VideoStabilizationMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoStabilizationModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PictureSettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PictureSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.PictureFormatChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStatePictureFormatChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.AutoWhiteBalanceChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.ExpositionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateExpositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.SaturationChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateSaturationChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.TimelapseChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateTimelapseChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.VideoAutorecordChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoAutorecordChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PictureSettingsState.VideoStabilizationModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaStreaming

/**
 * @brief Sets the filter behavior for all commands ARDrone3.MediaStreaming.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaStreaming.VideoEnable.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingVideoEnableBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaStreamingState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.MediaStreamingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.MediaStreamingState.VideoEnableChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateVideoEnableChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GPSSettings

/**
 * @brief Sets the filter behavior for all commands ARDrone3.GPSSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettings.SetHome.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsSetHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettings.ResetHome.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsResetHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettings.SendControllerGPS.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsSendControllerGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettings.HomeType.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsHomeTypeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettings.ReturnHomeDelay.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsReturnHomeDelayBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GPSSettingsState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.GPSSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.HomeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.ResetHomeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateResetHomeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.GPSFixStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSFixStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.GPSUpdateStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.HomeTypeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeTypeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSSettingsState.ReturnHomeDelayChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CameraState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.CameraState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.CameraState.Orientation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.CameraState.defaultCameraOrientation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateDefaultCameraOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Antiflickering

/**
 * @brief Sets the filter behavior for all commands ARDrone3.Antiflickering.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Antiflickering.electricFrequency.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringElectricFrequencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.Antiflickering.setMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringSetModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AntiflickeringState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.AntiflickeringState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.AntiflickeringState.electricFrequencyChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateElectricFrequencyChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.AntiflickeringState.modeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GPSState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.GPSState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSState.NumberOfSatelliteChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateNumberOfSatelliteChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSState.HomeTypeAvailabilityChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeAvailabilityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.GPSState.HomeTypeChosenChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeChosenChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PROState

/**
 * @brief Sets the filter behavior for all commands ARDrone3.PROState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PROStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command ARDrone3.PROState.Features.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PROStateFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature JumpingSumo

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Piloting

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.Piloting.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Piloting.PCMD.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Piloting.Posture.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingPostureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Piloting.addCapOffset.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingAddCapOffsetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.PilotingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.PilotingState.PostureChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStatePostureChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.PilotingState.AlertStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.PilotingState.SpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Animations

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.Animations.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Animations.JumpStop.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpStopBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Animations.JumpCancel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpCancelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Animations.JumpLoad.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpLoadBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Animations.Jump.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Animations.SimpleAnimation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsSimpleAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AnimationsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.AnimationsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AnimationsState.JumpLoadChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpLoadChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AnimationsState.JumpTypeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpTypeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AnimationsState.JumpMotorProblemChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SettingsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.SettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.SettingsState.ProductGPSVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSettingsStateProductGPSVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecord

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.MediaRecord.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecord.Picture.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecord.Video.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecord.PictureV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecord.VideoV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.MediaRecordState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordState.PictureStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordState.VideoStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordState.PictureStateChangedV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordState.VideoStateChangedV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordEvent

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.MediaRecordEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordEvent.PictureEventChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaRecordEvent.VideoEventChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventVideoEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkSettings

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.NetworkSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkSettings.WifiSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkSettingsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.NetworkSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkSettingsState.WifiSelectionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Network

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.Network.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Network.WifiScan.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.Network.WifiAuthChannel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.NetworkState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkState.WifiScanListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiScanListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkState.AllWifiScanChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiScanChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkState.WifiAuthChannelListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkState.AllWifiAuthChannelChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.NetworkState.LinkQualityChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateLinkQualityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AudioSettings

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.AudioSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AudioSettings.MasterVolume.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsMasterVolumeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AudioSettings.Theme.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsThemeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AudioSettingsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.AudioSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AudioSettingsState.MasterVolumeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.AudioSettingsState.ThemeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateThemeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class RoadPlan

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.RoadPlan.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlan.AllScriptsMetadata.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanAllScriptsMetadataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlan.ScriptUploaded.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptUploadedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlan.ScriptDelete.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptDeleteBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlan.PlayScript.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanPlayScriptBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class RoadPlanState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.RoadPlanState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlanState.ScriptMetadataListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlanState.AllScriptsMetadataChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlanState.ScriptUploadChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptUploadChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlanState.ScriptDeleteChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptDeleteChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.RoadPlanState.PlayScriptChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStatePlayScriptChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettings

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.SpeedSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.SpeedSettings.Outdoor.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsOutdoorBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettingsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.SpeedSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.SpeedSettingsState.OutdoorChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateOutdoorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaStreaming

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.MediaStreaming.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaStreaming.VideoEnable.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingVideoEnableBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaStreamingState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.MediaStreamingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.MediaStreamingState.VideoEnableChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateVideoEnableChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class VideoSettings

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.VideoSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.VideoSettings.Autorecord.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsAutorecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class VideoSettingsState

/**
 * @brief Sets the filter behavior for all commands JumpingSumo.VideoSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command JumpingSumo.VideoSettingsState.AutorecordChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateAutorecordChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature MiniDrone

/**
 * @brief Sets the filter behavior for all commands MiniDrone.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Piloting

/**
 * @brief Sets the filter behavior for all commands MiniDrone.Piloting.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.FlatTrim.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingFlatTrimBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.TakeOff.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.PCMD.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.Landing.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingLandingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.Emergency.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingEmergencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Piloting.AutoTakeOffMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingAutoTakeOffModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.PilotingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingState.FlatTrimChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateFlatTrimChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingState.FlyingStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateFlyingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingState.AlertStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingState.AutoTakeOffModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateAutoTakeOffModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Animations

/**
 * @brief Sets the filter behavior for all commands MiniDrone.Animations.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Animations.Flip.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsFlipBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Animations.Cap.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsCapBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecord

/**
 * @brief Sets the filter behavior for all commands MiniDrone.MediaRecord.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.MediaRecord.Picture.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.MediaRecord.PictureV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.MediaRecordState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.MediaRecordState.PictureStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.MediaRecordState.PictureStateChangedV2.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MediaRecordEvent

/**
 * @brief Sets the filter behavior for all commands MiniDrone.MediaRecordEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.MediaRecordEvent.PictureEventChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingSettings

/**
 * @brief Sets the filter behavior for all commands MiniDrone.PilotingSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingSettings.MaxAltitude.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingSettings.MaxTilt.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxTiltBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class PilotingSettingsState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.PilotingSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingSettingsState.MaxAltitudeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.PilotingSettingsState.MaxTiltChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxTiltChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettings

/**
 * @brief Sets the filter behavior for all commands MiniDrone.SpeedSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettings.MaxVerticalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettings.MaxRotationSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettings.Wheels.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsWheelsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettings.MaxHorizontalSpeed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SpeedSettingsState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.SpeedSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettingsState.MaxVerticalSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettingsState.MaxRotationSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettingsState.WheelsChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateWheelsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SpeedSettingsState.MaxHorizontalSpeedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Settings

/**
 * @brief Sets the filter behavior for all commands MiniDrone.Settings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Settings.CutOutMode.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsCutOutModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SettingsState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.SettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SettingsState.ProductMotorsVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductMotorsVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SettingsState.ProductInertialVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductInertialVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.SettingsState.CutOutModeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateCutOutModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class FloodControlState

/**
 * @brief Sets the filter behavior for all commands MiniDrone.FloodControlState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneFloodControlStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.FloodControlState.FloodControlChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneFloodControlStateFloodControlChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GPS

/**
 * @brief Sets the filter behavior for all commands MiniDrone.GPS.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.GPS.ControllerLatitudeForRun.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSControllerLatitudeForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.GPS.ControllerLongitudeForRun.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSControllerLongitudeForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Configuration

/**
 * @brief Sets the filter behavior for all commands MiniDrone.Configuration.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Configuration.ControllerType.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerTypeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command MiniDrone.Configuration.ControllerName.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerNameBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature SkyController

/**
 * @brief Sets the filter behavior for all commands SkyController.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class WifiState

/**
 * @brief Sets the filter behavior for all commands SkyController.WifiState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.WifiState.WifiList.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.WifiState.ConnexionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateConnexionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.WifiState.WifiAuthChannelListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.WifiState.AllWifiAuthChannelChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.WifiState.WifiSignalChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiSignalChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Wifi

/**
 * @brief Sets the filter behavior for all commands SkyController.Wifi.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Wifi.RequestWifiList.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiRequestWifiListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Wifi.RequestCurrentWifi.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiRequestCurrentWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Wifi.ConnectToWifi.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiConnectToWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Wifi.ForgetWifi.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiForgetWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Wifi.WifiAuthChannel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Device

/**
 * @brief Sets the filter behavior for all commands SkyController.Device.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Device.RequestDeviceList.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceRequestDeviceListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Device.RequestCurrentDevice.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceRequestCurrentDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Device.ConnectToDevice.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceConnectToDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class DeviceState

/**
 * @brief Sets the filter behavior for all commands SkyController.DeviceState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.DeviceState.DeviceList.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateDeviceListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.DeviceState.ConnexionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateConnexionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Settings

/**
 * @brief Sets the filter behavior for all commands SkyController.Settings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Settings.AllSettings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsAllSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Settings.Reset.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsResetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SettingsState

/**
 * @brief Sets the filter behavior for all commands SkyController.SettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SettingsState.AllSettingsChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateAllSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SettingsState.ResetChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateResetChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SettingsState.ProductSerialChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductSerialChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SettingsState.ProductVariantChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductVariantChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Common

/**
 * @brief Sets the filter behavior for all commands SkyController.Common.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Common.AllStates.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonAllStatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CommonState

/**
 * @brief Sets the filter behavior for all commands SkyController.CommonState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.CommonState.AllStatesChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonStateAllStatesChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SkyControllerState

/**
 * @brief Sets the filter behavior for all commands SkyController.SkyControllerState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SkyControllerState.BatteryChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBatteryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SkyControllerState.GpsFixChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsFixChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.SkyControllerState.GpsPositionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsPositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AccessPointSettings

/**
 * @brief Sets the filter behavior for all commands SkyController.AccessPointSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettings.AccessPointSSID.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointSSIDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettings.AccessPointChannel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettings.WifiSelection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AccessPointSettingsState

/**
 * @brief Sets the filter behavior for all commands SkyController.AccessPointSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettingsState.AccessPointSSIDChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettingsState.AccessPointChannelChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AccessPointSettingsState.WifiSelectionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Camera

/**
 * @brief Sets the filter behavior for all commands SkyController.Camera.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCameraBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Camera.ResetOrientation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCameraResetOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GamepadInfos

/**
 * @brief Sets the filter behavior for all commands SkyController.GamepadInfos.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.GamepadInfos.getGamepadControls.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosGetGamepadControlsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GamepadInfosState

/**
 * @brief Sets the filter behavior for all commands SkyController.GamepadInfosState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.GamepadInfosState.gamepadControl.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateGamepadControlBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.GamepadInfosState.allGamepadControlsSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ButtonMappings

/**
 * @brief Sets the filter behavior for all commands SkyController.ButtonMappings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappings.getCurrentButtonMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappings.getAvailableButtonMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappings.setButtonMapping.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsSetButtonMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappings.defaultButtonMapping.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsDefaultButtonMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ButtonMappingsState

/**
 * @brief Sets the filter behavior for all commands SkyController.ButtonMappingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappingsState.currentButtonMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappingsState.allCurrentButtonMappingsSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappingsState.availableButtonMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonMappingsState.allAvailableButtonsMappingsSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AxisMappings

/**
 * @brief Sets the filter behavior for all commands SkyController.AxisMappings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappings.getCurrentAxisMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappings.getAvailableAxisMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappings.setAxisMapping.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsSetAxisMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappings.defaultAxisMapping.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsDefaultAxisMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AxisMappingsState

/**
 * @brief Sets the filter behavior for all commands SkyController.AxisMappingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappingsState.currentAxisMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappingsState.allCurrentAxisMappingsSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappingsState.availableAxisMappings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisMappingsState.allAvailableAxisMappingsSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AxisFilters

/**
 * @brief Sets the filter behavior for all commands SkyController.AxisFilters.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFilters.getCurrentAxisFilters.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFilters.getPresetAxisFilters.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetPresetAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFilters.setAxisFilter.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersSetAxisFilterBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFilters.defaultAxisFilters.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersDefaultAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AxisFiltersState

/**
 * @brief Sets the filter behavior for all commands SkyController.AxisFiltersState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFiltersState.currentAxisFilters.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFiltersState.allCurrentFiltersSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFiltersState.presetAxisFilters.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStatePresetAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.AxisFiltersState.allPresetFiltersSent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CoPiloting

/**
 * @brief Sets the filter behavior for all commands SkyController.CoPiloting.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.CoPiloting.setPilotingSource.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingSetPilotingSourceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CoPilotingState

/**
 * @brief Sets the filter behavior for all commands SkyController.CoPilotingState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.CoPilotingState.pilotingSource.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingStatePilotingSourceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Calibration

/**
 * @brief Sets the filter behavior for all commands SkyController.Calibration.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.Calibration.enableMagnetoCalibrationQualityUpdates.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CalibrationState

/**
 * @brief Sets the filter behavior for all commands SkyController.CalibrationState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.CalibrationState.MagnetoCalibrationState.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.CalibrationState.MagnetoCalibrationQualityUpdatesState.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ButtonEvents

/**
 * @brief Sets the filter behavior for all commands SkyController.ButtonEvents.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonEventsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command SkyController.ButtonEvents.Settings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonEventsSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature unknown_feature_1

/**
 * @brief Sets the filter behavior for all commands unknown_feature_1.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.geographic_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1GeographicRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.relative_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RelativeRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.look_at_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1LookAtRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.spiral_anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.swing_anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.boomerang_anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.candle_anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.dolly_slide_anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.user_framing_position.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.user_GPS_data.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserGPSDataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.user_baro_data.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserBaroDataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.lynx_detection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1LynxDetectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.availability.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1AvailabilityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.geographic_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1GeographicConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.relative_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RelativeConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.anim_run.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1AnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.spiral_anim_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.swing_anim_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.boomerang_anim_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.candle_anim_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.dolly_slide_anim_config_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command unknown_feature_1.user_framing_position_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature common

/**
 * @brief Sets the filter behavior for all commands common.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Network

/**
 * @brief Sets the filter behavior for all commands common.Network.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Network.Disconnect.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkDisconnectBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class NetworkEvent

/**
 * @brief Sets the filter behavior for all commands common.NetworkEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.NetworkEvent.Disconnection.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkEventDisconnectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Settings

/**
 * @brief Sets the filter behavior for all commands common.Settings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Settings.AllSettings.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsAllSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Settings.Reset.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsResetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Settings.ProductName.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsProductNameBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Settings.Country.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Settings.AutoCountry.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsAutoCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class SettingsState

/**
 * @brief Sets the filter behavior for all commands common.SettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.AllSettingsChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateAllSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.ResetChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateResetChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.ProductNameChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductNameChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.ProductVersionChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.ProductSerialHighChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialHighChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.ProductSerialLowChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialLowChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.CountryChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.SettingsState.AutoCountryChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateAutoCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Common

/**
 * @brief Sets the filter behavior for all commands common.Common.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Common.AllStates.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonAllStatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Common.CurrentDate.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonCurrentDateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Common.CurrentTime.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonCurrentTimeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Common.Reboot.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonRebootBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CommonState

/**
 * @brief Sets the filter behavior for all commands common.CommonState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.AllStatesChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateAllStatesChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.BatteryStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateBatteryStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.MassStorageStateListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.MassStorageInfoStateListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.CurrentDateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCurrentDateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.CurrentTimeChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCurrentTimeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.MassStorageInfoRemainingListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoRemainingListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.WifiSignalChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateWifiSignalChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.SensorsStatesListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateSensorsStatesListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.ProductModel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateProductModelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CommonState.CountryListKnown.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCountryListKnownBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class OverHeat

/**
 * @brief Sets the filter behavior for all commands common.OverHeat.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.OverHeat.SwitchOff.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatSwitchOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.OverHeat.Ventilate.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatVentilateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class OverHeatState

/**
 * @brief Sets the filter behavior for all commands common.OverHeatState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.OverHeatState.OverHeatChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.OverHeatState.OverHeatRegulationChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatRegulationChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Controller

/**
 * @brief Sets the filter behavior for all commands common.Controller.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonControllerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Controller.isPiloting.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonControllerIsPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class WifiSettings

/**
 * @brief Sets the filter behavior for all commands common.WifiSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.WifiSettings.OutdoorSetting.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsOutdoorSettingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class WifiSettingsState

/**
 * @brief Sets the filter behavior for all commands common.WifiSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.WifiSettingsState.outdoorSettingsChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsStateOutdoorSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Mavlink

/**
 * @brief Sets the filter behavior for all commands common.Mavlink.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Mavlink.Start.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStartBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Mavlink.Pause.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkPauseBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Mavlink.Stop.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStopBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class MavlinkState

/**
 * @brief Sets the filter behavior for all commands common.MavlinkState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.MavlinkState.MavlinkFilePlayingStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.MavlinkState.MavlinkPlayErrorStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Calibration

/**
 * @brief Sets the filter behavior for all commands common.Calibration.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Calibration.MagnetoCalibration.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationMagnetoCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CalibrationState

/**
 * @brief Sets the filter behavior for all commands common.CalibrationState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CalibrationState.MagnetoCalibrationStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CalibrationState.MagnetoCalibrationRequiredState.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CalibrationState.MagnetoCalibrationAxisToCalibrateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CalibrationState.MagnetoCalibrationStartedChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class CameraSettingsState

/**
 * @brief Sets the filter behavior for all commands common.CameraSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCameraSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.CameraSettingsState.CameraSettingsChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCameraSettingsStateCameraSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class GPS

/**
 * @brief Sets the filter behavior for all commands common.GPS.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.GPS.ControllerPositionForRun.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonGPSControllerPositionForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class FlightPlanState

/**
 * @brief Sets the filter behavior for all commands common.FlightPlanState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.FlightPlanState.AvailabilityStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateAvailabilityStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.FlightPlanState.ComponentStateListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateComponentStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class FlightPlanEvent

/**
 * @brief Sets the filter behavior for all commands common.FlightPlanEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.FlightPlanEvent.StartingErrorEvent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventStartingErrorEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.FlightPlanEvent.SpeedBridleEvent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventSpeedBridleEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ARLibsVersionsState

/**
 * @brief Sets the filter behavior for all commands common.ARLibsVersionsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ARLibsVersionsState.ControllerLibARCommandsVersion.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ARLibsVersionsState.SkyControllerLibARCommandsVersion.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ARLibsVersionsState.DeviceLibARCommandsVersion.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Audio

/**
 * @brief Sets the filter behavior for all commands common.Audio.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Audio.ControllerReadyForStreaming.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioControllerReadyForStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AudioState

/**
 * @brief Sets the filter behavior for all commands common.AudioState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.AudioState.AudioStreamingRunning.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioStateAudioStreamingRunningBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Headlights

/**
 * @brief Sets the filter behavior for all commands common.Headlights.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Headlights.intensity.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsIntensityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class HeadlightsState

/**
 * @brief Sets the filter behavior for all commands common.HeadlightsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.HeadlightsState.intensityChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsStateIntensityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Animations

/**
 * @brief Sets the filter behavior for all commands common.Animations.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Animations.StartAnimation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStartAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Animations.StopAnimation.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStopAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Animations.StopAllAnimations.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStopAllAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AnimationsState

/**
 * @brief Sets the filter behavior for all commands common.AnimationsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.AnimationsState.List.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStateListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Accessory

/**
 * @brief Sets the filter behavior for all commands common.Accessory.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Accessory.Config.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryConfigBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class AccessoryState

/**
 * @brief Sets the filter behavior for all commands common.AccessoryState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.AccessoryState.SupportedAccessoriesListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateSupportedAccessoriesListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.AccessoryState.AccessoryConfigChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.AccessoryState.AccessoryConfigModificationEnabled.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigModificationEnabledBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class Charger

/**
 * @brief Sets the filter behavior for all commands common.Charger.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.Charger.SetMaxChargeRate.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerSetMaxChargeRateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ChargerState

/**
 * @brief Sets the filter behavior for all commands common.ChargerState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ChargerState.MaxChargeRateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateMaxChargeRateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ChargerState.CurrentChargeStateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateCurrentChargeStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ChargerState.LastChargeRateChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateLastChargeRateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.ChargerState.ChargingInfo.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateChargingInfoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class RunState

/**
 * @brief Sets the filter behavior for all commands common.RunState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonRunStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command common.RunState.RunIdChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonRunStateRunIdChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature commonDebug

/**
 * @brief Sets the filter behavior for all commands commonDebug.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Stats

/**
 * @brief Sets the filter behavior for all commands commonDebug.Stats.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.Stats.SendPacket.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsSendPacketBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.Stats.StartSendingPacketFromDrone.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsStartSendingPacketFromDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.Stats.StopSendingPacketFromDrone.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsStopSendingPacketFromDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class StatsEvent

/**
 * @brief Sets the filter behavior for all commands commonDebug.StatsEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.StatsEvent.SendPacket.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsEventSendPacketBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class DebugSettings

/**
 * @brief Sets the filter behavior for all commands commonDebug.DebugSettings.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.DebugSettings.GetAll.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsGetAllBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.DebugSettings.Set.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsSetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class DebugSettingsState

/**
 * @brief Sets the filter behavior for all commands commonDebug.DebugSettingsState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.DebugSettingsState.Info.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateInfoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command commonDebug.DebugSettingsState.ListChanged.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature pro

/**
 * @brief Sets the filter behavior for all commands pro.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

// Command class Pro

/**
 * @brief Sets the filter behavior for all commands pro.Pro.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.Pro.BoughtFeatures.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProBoughtFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.Pro.Response.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProResponseBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.Pro.ActivateFeatures.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProActivateFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ProState

/**
 * @brief Sets the filter behavior for all commands pro.ProState.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.ProState.SupportedFeatures.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateSupportedFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.ProState.FeaturesActivated.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateFeaturesActivatedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);


// Command class ProEvent

/**
 * @brief Sets the filter behavior for all commands pro.ProEvent.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command pro.ProEvent.ChallengeEvent.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProEventChallengeEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



// Feature wifi

/**
 * @brief Sets the filter behavior for all commands wifi.XXX.XXX.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the commands (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.scan.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.update_authorized_channels.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiUpdateAuthorizedChannelsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.set_ap_channel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetApChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.set_security.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.set_country.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.set_environement.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetEnvironementBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.scanned_item.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiScannedItemBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.authorized_channel.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiAuthorizedChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.ap_channel_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiApChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.security_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSecurityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.country_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.environement_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiEnvironementChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);

/**
 * @brief Sets the filter behavior for the command wifi.rssi_changed.
 * @param filter The filter to be modified.
 * @param behavior The behavior to use for the command (must be either ARCOMMANDS_FILTER_STATUS_BLOCKED or ARCOMMANDS_FILTER_STATUS_ALLOWED).
 * @return An eARCOMMANDS_FILTER_ERROR enum.
 */
eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiRssiChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior);



#endif /* _LIBARCOMMANDS_ARCOMMANDS_FILTER_H_ */
