import string

gHTTPResponses = {
        100: "Continue",
        101: "Switching Protocols",
        200: "OK",
        201: "Created",
        202: "Accepted",
        203: "Non-Authoritative Information",
        204: "No Content",
        205: "Reset Content",
        206: "Partial Content",
        300: "Multiple Choices",
        301: "Moved Permanently",
        302: "Moved Temporarily",
        303: "See Other",
        304: "Not Modified",
        305: "Use Proxy",
        400: "Bad Request",
        401: "Unauthorized",
        402: "Payment Required",
        403: "Forbidden",
        404: "Not Found",
        405: "Method Not Allowed",
        406: "Not Acceptable",
        407: "Proxy Authentication Required",
        408: "Request Time-out",
        409: "Conflict",
        410: "Gone",
        411: "Length Required",
        412: "Precondition Failed",
        413: "Request Entity Too Large",
        414: "Request-URI Too Large",
        415: "Unsupported Media Type",
        500: "Internal Server Error",
        501: "Not Implemented",
        502: "Bad Gateway",
        503: "Service Unavailable",
        504: "Gateway Time-out",
        505: "HTTP Version not supported"
        }

# Default error message
errorMessage_Default = \
"""
<html><head>
<title><?cs var:code?> <?cs var:message?></title>
</head><body>
<h1><?cs var:message ?></h1>
<p>Error code <?cs var:code ?>.
<p>Message: <?cs var:message ?>.
<p>Reason:\n <pre><?cs var:reason?></pre>
<hr />
<?cs each:_e=environ ?>
  <?cs name:_e ?>=<?cs var:_e ?><br>
<?cs /each ?>
</body></html>
"""

errorMessage_404 = \
"""
<html><head>
<title><?cs var:code?> <?cs var:message?></title>
</head><body>
<h1>Not Found</h1>
<p>The requested URL <?cs var:environ.REQUEST_URI?> was not found on this server.</p>
<hr />
<?cs each:_e=environ ?>
  <?cs name:_e ?>=<?cs var:_e ?><br>
<?cs /each ?>
</body></html>
"""
