# Detect compiler version and enable C++17 if supported
if ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "Clang")
    if ("${CMAKE_CXX_COMPILER_VERSION}" VERSION_LESS "3.6")
        message(FATAL_ERROR "Please use Clang version 3.6 or newer to compile this project.")
    elseif ("${CMAKE_CXX_COMPILER_VERSION}" VERSION_LESS "5")
        message(WARNING "C++17 support with Clang ${CMAKE_CXX_COMPILER_VERSION} is experimental.")
        add_compile_options("-std=c++1z")
    else()
        add_compile_options("-std=c++17")
    endif()
elseif ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "AppleClang")
    message(WARNING "Detecting C++17 support for AppleClang is not supported, will enable it anyway.")
    add_compile_options("-std=c++17")
elseif ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU")
    if ("${CMAKE_CXX_COMPILER_VERSION}" VERSION_LESS "6")
        message(FATAL_ERROR "Please use GCC version 6 or newer to compile this project.")
    else()
        message(WARNING "C++17 support with GCC ${CMAKE_CXX_COMPILER_VERSION} is experimental.")
        add_compile_options("-std=c++17")
    endif()
elseif ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "MSVC")
    add_compile_options("/std:c++17")
else()
    message(WARNING "Unknown compiler, C++17 support will not be explicitly enabled.")
endif()