# MoveIt! Fake Controller Manager

This package implements a series of fake trajectory controllers for MoveIt -- to be used in simulation.
For example, the `demo.launch` generated by MoveIt's `setup_assistant`, employs fake controllers for nice visualization in `rviz`.

For configuration, edit the file `config/fake_controllers.yaml`, and adjust the desired controller type.
The following controllers are available:
- interpolate: perform smooth interpolation between via points - the default for visualization
- via points:  traverse via points, w/o interpolation in between - useful for visual debugging
- last point:  warp directly to the last point of the trajectory - fastest method for offline benchmarking

```yaml
fake_interpolating_controller_rate: 10 (Hz)
controller_list:
  - name: fake_arm_controller
    type: interpolate | via points | last point
    joints:
      - joint_1
      - joint_2
      - joint_3
      - joint_4
      - joint_5
      - joint_6
  - name: fake_gripper_controller
    joints:
      []
```

In order to load an initial pose, one can have a list of (group, pose) pairs as follows:

```yaml
initial:
  - group: arm
    pose:  home
```
