/*******************************************************************************
 * Copyright (c) 2017 Nerian Vision Technologies
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

/*
 *  A collection of all available program settings
 */
struct Settings {
    enum ColorScheme {
        COLOR_SCHEME_NONE = 0,
        COLOR_SCHEME_RED_BLUE = 1,
        COLOR_SCHEME_RAINBOW = 2
    };

    std::string readDir;
    std::string writeDir;
    bool readImages;
    double maxFrameRate;
    bool nonGraphical;
    std::string remoteHost;
    std::string localHost;
    bool tcp;
    ColorScheme colorScheme;
    int remotePort;
    int localPort;
    bool writeRaw16Bit;
    bool writePointCloud;
    float pointCloudMaxDist;
    int displayImage;
    bool disableReception;
    bool printTimestamps;
    int zoomPercent;
};

#endif
