/*******************************************************************************
 * Copyright (c) 2019 Nerian Vision GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#include <visiontransfer/deviceenumeration.h>
#include <visiontransfer/asynctransfer.h>
#include <visiontransfer/imagepair.h>
#include <iostream>
#include <exception>
#include <vector>
#include <cstdio>
#include <cstring>

#ifdef _WIN32
#   include <windows.h>
#else
#   include <unistd.h>
#endif

#ifdef _MSC_VER
// Visual studio does not come with snprintf
#define snprintf _snprintf_s
#endif

using namespace std;
using namespace visiontransfer;

int main() {
    try {
        // Create an image transfer object that will serve as server
        AsyncTransfer asyncTransfer("0.0.0.0", "7681", ImageProtocol::PROTOCOL_UDP, true);

        // Initialize the image pair meta data
        ImagePair imagePair;
        imagePair.setWidth(640);
        imagePair.setHeight(480);
        imagePair.setPixelFormat(0, ImagePair::FORMAT_8_BIT_MONO);
        imagePair.setPixelFormat(1, ImagePair::FORMAT_8_BIT_MONO);
        imagePair.setRowStride(0, imagePair.getBytesPerPixel(0)*imagePair.getWidth());
        imagePair.setRowStride(1, imagePair.getBytesPerPixel(0)*imagePair.getWidth());
        std::vector<unsigned char> pixelData(imagePair.getRowStride(0) * imagePair.getHeight());
        imagePair.setPixelData(0, &pixelData[0]);
        imagePair.setPixelData(1, &pixelData[0]);

        int transfer = 0;
        while(true) {
#ifdef _WIN32
            Sleep(500);
#else
            usleep(50000);
#endif
            if(!asyncTransfer.isConnected()) {
                // Continue waiting until a client connects
                continue;
            }

            if(transfer == 0) {
                cout << "Client IP: " << asyncTransfer.getRemoteAddress() << endl;
            }

            // Generate test image data
            for(int y=0; y<imagePair.getHeight(); y++) {
                for(int x=0; x<imagePair.getWidth(); x++) {
                    pixelData[y*imagePair.getRowStride(0) + x] = (y + x + transfer) & 0xff;
                }
            }
            transfer++;

            // Send the image data
            asyncTransfer.sendImagePairAsync(imagePair);
        }
    } catch(const std::exception& ex) {
        std::cerr << "Exception occurred: " << ex.what() << std::endl;
    }

    return 0;
}
