/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.hrp.joystick.rtc;

import RTC.ReturnCode_t;
import RTC.Time;
import RTC.TimedFloatSeq;
import jp.go.aist.hrp.joystick.views.joystickView;
import jp.go.aist.rtm.RTC.DataFlowComponentBase;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.util.DataRef;
import org.eclipse.swt.graphics.Point;

public class JoystickImpl
extends DataFlowComponentBase {
    protected TimedFloatSeq m_pos_val;
    protected DataRef<TimedFloatSeq> m_pos;
    protected OutPort<TimedFloatSeq> m_posOut;
    protected TimedFloatSeq m_vel_val;
    protected DataRef<TimedFloatSeq> m_vel;
    protected OutPort<TimedFloatSeq> m_velOut;

    public JoystickImpl(Manager manager) {
        super(manager);
    }

    protected ReturnCode_t onInitialize() {
        this.m_pos_val = new TimedFloatSeq(new Time(0, 0), new float[2]);
        this.m_pos = new DataRef((Object)this.m_pos_val);
        this.m_posOut = new OutPort("pos", this.m_pos);
        this.m_vel_val = new TimedFloatSeq(new Time(0, 0), new float[2]);
        this.m_vel = new DataRef((Object)this.m_vel_val);
        this.m_velOut = new OutPort("vel", this.m_vel);
        try {
            this.registerOutPort(TimedFloatSeq.class, "pos", this.m_posOut);
            this.registerOutPort(TimedFloatSeq.class, "vel", this.m_velOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onFinalize() {
        System.out.println("Joystick Finalized");
        return super.onFinalize();
    }

    protected ReturnCode_t onStartup(int ec_id) {
        System.out.println("Joystick Started");
        return super.onStartup(ec_id);
    }

    protected ReturnCode_t onShutdown(int ec_id) {
        System.out.println("Joystick Shutting down");
        return super.onShutdown(ec_id);
    }

    protected ReturnCode_t onActivated(int ec_id) {
        System.out.println("Joystick Activated");
        return super.onActivated(ec_id);
    }

    protected ReturnCode_t onDeactivated(int ec_id) {
        System.out.println("Joystick Deactivated");
        return super.onDeactivated(ec_id);
    }

    protected ReturnCode_t onExecute(int ec_id) {
        Point p = joystickView.getJoystickPosition();
        float[] pos = new float[]{p.x, p.y};
        float[] vel = this.convert(p);
        this.m_pos_val.data = pos;
        this.m_vel_val.data = vel;
        this.m_posOut.write();
        this.m_velOut.write();
        return ReturnCode_t.RTC_OK;
    }

    protected float[] convert(Point p) {
        double k = 1.0;
        double _th = Math.atan2(p.y, p.x);
        double _v = k * Math.hypot(p.x, p.y);
        double _vl = _v * Math.cos(_th - 0.7853981633974483);
        double _vr = _v * Math.sin(_th - 0.7853981633974483);
        if (_vr == -0.0) {
            _vr *= -1.0;
        }
        float[] v = new float[]{(float)_vl, (float)_vr};
        return v;
    }

    public ReturnCode_t onAborting(int ec_id) {
        System.out.println("Joystick Aborted");
        return super.onAborting(ec_id);
    }

    public ReturnCode_t onError(int ec_id) {
        System.out.println("Joystick Error : " + ec_id);
        return super.onError(ec_id);
    }

    protected ReturnCode_t onReset(int ec_id) {
        System.out.println("Joystick Reset");
        return super.onReset(ec_id);
    }

    protected ReturnCode_t onStateUpdate(int ec_id) {
        return super.onStateUpdate(ec_id);
    }

    protected ReturnCode_t onRateChanged(int ec_id) {
        return super.onRateChanged(ec_id);
    }
}

