/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import java.util.Vector;
import jp.go.aist.rtm.RTC.util.CallbackFunction;
import jp.go.aist.rtm.RTC.util.ListenerBase;
import jp.go.aist.rtm.RTC.util.ListenerObject;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class Timer
implements Runnable {
    private TimeValue m_interval = new TimeValue();
    private boolean m_running;
    private Vector<Task> m_tasks = new Vector();

    public Timer(TimeValue timeValue) {
        this.m_interval = new TimeValue(timeValue);
        this.m_running = false;
    }

    public int open() {
        Thread thread = new Thread(this);
        thread.start();
        return 0;
    }

    public int svc() {
        while (this.m_running) {
            try {
                this.invoke();
                if (this.m_interval.getSec() != 0L) {
                    Thread.sleep(this.m_interval.getSec() * 1000L);
                }
                Thread.sleep((int)this.m_interval.getUsec() / 1000, (int)this.m_interval.getUsec() % 1000 * 1000);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public void run() {
        this.svc();
    }

    public synchronized void start() {
        if (!this.m_running) {
            this.m_running = true;
            this.open();
        }
    }

    public synchronized void stop() {
        this.m_running = false;
    }

    public void invoke() {
        if (this.m_tasks == null) {
            this.m_tasks = new Vector();
        }
        for (int i = 0; i < this.m_tasks.size(); ++i) {
            this.m_tasks.elementAt((int)i).remains = this.m_tasks.elementAt((int)i).remains.minus(this.m_interval);
            if (this.m_tasks.elementAt((int)i).remains.sign() > 0) continue;
            this.m_tasks.elementAt((int)i).listener.invoke();
            this.m_tasks.elementAt((int)i).remains = this.m_tasks.elementAt((int)i).period;
        }
    }

    public synchronized ListenerBase registerListener(ListenerBase listenerBase, TimeValue timeValue) {
        if (this.m_tasks == null) {
            this.m_tasks = new Vector();
        }
        for (int i = 0; i < this.m_tasks.size(); ++i) {
            if (!this.m_tasks.elementAt((int)i).listener.equals(listenerBase)) continue;
            this.m_tasks.elementAt((int)i).period = timeValue;
            this.m_tasks.elementAt((int)i).remains = timeValue;
            return listenerBase;
        }
        this.m_tasks.add(new Task(listenerBase, timeValue));
        return listenerBase;
    }

    public ListenerBase registerListenerObj(CallbackFunction callbackFunction, TimeValue timeValue) {
        return this.registerListener(new ListenerObject(callbackFunction), timeValue);
    }

    public synchronized boolean unregisterListener(ListenerBase listenerBase) {
        for (int i = 0; i < this.m_tasks.size(); ++i) {
            if (!this.m_tasks.elementAt((int)i).listener.equals(listenerBase)) continue;
            this.m_tasks.remove(this.m_tasks.elementAt(i));
            return true;
        }
        return false;
    }

    private class Task {
        public ListenerBase listener;
        TimeValue period;
        TimeValue remains;

        public Task(ListenerBase listenerBase, TimeValue timeValue) {
            this.listener = listenerBase;
            this.period = new TimeValue(timeValue);
            this.remains = new TimeValue(timeValue);
        }
    }
}

