/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import RTC.ComponentProfile;
import RTC.DataFlowComponentPOA;
import RTC.ExecutionContext;
import RTC.ExecutionContextHelper;
import RTC.ExecutionContextListHolder;
import RTC.ExecutionContextService;
import RTC.ExecutionContextServiceHelper;
import RTC.ExecutionContextServiceListHolder;
import RTC.LightweightRTObject;
import RTC.Port;
import RTC.PortProfile;
import RTC.RTObject;
import RTC.ReturnCode_t;
import _SDOPackage.Configuration;
import _SDOPackage.DeviceProfile;
import _SDOPackage.InterfaceNotImplemented;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.Monitoring;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.OrganizationListHolder;
import _SDOPackage.SDOService;
import _SDOPackage.SDOServiceHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileHolder;
import _SDOPackage.ServiceProfileListHolder;
import jp.go.aist.rtm.RTC.ConfigAdmin;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.SDOPackage.Configuration_impl;
import jp.go.aist.rtm.RTC.port.DataInPort;
import jp.go.aist.rtm.RTC.port.DataOutPort;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.port.PortAdmin;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTObject_impl
extends DataFlowComponentPOA {
    static final String[] default_conf = new String[]{"implementation_id", "", "type_name", "", "description", "", "version", "", "vendor", "", "category", "", "activity_type", "", "max_instance", "", "language", "", "lang_type", "", "conf", "", ""};
    protected Manager m_pManager;
    protected ORB m_pORB;
    protected POA m_pPOA;
    protected OrganizationListHolder m_sdoOwnedOrganizations = new OrganizationListHolder();
    protected ServiceProfileListHolder m_sdoSvcProfiles = new ServiceProfileListHolder();
    protected Configuration_impl m_pSdoConfigImpl;
    protected Configuration m_pSdoConfig;
    protected OrganizationListHolder m_sdoOrganizations = new OrganizationListHolder();
    protected NVListHolder m_sdoStatus = new NVListHolder();
    protected ComponentProfile m_profile = new ComponentProfile();
    protected RTObject m_objref;
    protected PortAdmin m_portAdmin;
    protected ExecutionContextServiceListHolder m_execContexts;
    protected boolean m_created;
    protected boolean m_alive;
    protected Properties m_properties = new Properties();
    protected ConfigAdmin m_configsets;

    public RTObject_impl(Manager manager) {
        this.m_pManager = manager;
        this.m_pORB = manager.getORB();
        this.m_pPOA = manager.getPOA();
        this.m_portAdmin = new PortAdmin(manager.getORB(), manager.getPOA());
        this.m_created = true;
        this.m_alive = false;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
    }

    public RTObject_impl(ORB orb, POA poa) {
        this.m_pManager = null;
        this.m_pORB = orb;
        this.m_pPOA = poa;
        this.m_portAdmin = new PortAdmin(orb, poa);
        this.m_created = true;
        this.m_alive = false;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
    }

    protected ReturnCode_t onInitialize() {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onFinalize() {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStartup(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onShutdown(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onActivated(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onDeactivated(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onExecute(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onAborting(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onError(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onReset(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStateUpdate(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onRateChanged(int ec_id) {
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t initialize() {
        ReturnCode_t ret = this.on_initialize();
        this.m_created = false;
        if (ret == ReturnCode_t.RTC_OK) {
            if (this.m_execContexts == null) {
                this.m_execContexts = new ExecutionContextServiceListHolder();
                this.m_execContexts.value = new ExecutionContextService[0];
            }
            if (this.m_execContexts.value.length > 0) {
                this.m_execContexts.value[0].start();
            }
            this.m_alive = true;
        }
        return ret;
    }

    @Override
    public ReturnCode_t _finalize() {
        if (this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        int intIdx = 0;
        while (intIdx < this.m_execContexts.value.length) {
            if (this.m_execContexts.value[intIdx].is_running()) {
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
            ++intIdx;
        }
        ReturnCode_t ret = this.on_finalize();
        this.shutdown();
        return ret;
    }

    @Override
    public ReturnCode_t exit() {
        if (this.m_execContexts.value.length > 0) {
            this.m_execContexts.value[0].stop();
            this.m_alive = false;
        }
        int intIdx = 0;
        while (intIdx < this.m_execContexts.value.length) {
            this.m_execContexts.value[intIdx].deactivate_component((LightweightRTObject)this.m_objref._duplicate());
            ++intIdx;
        }
        ReturnCode_t ret = this._finalize();
        return ret;
    }

    @Override
    public boolean is_alive() {
        return this.m_alive;
    }

    @Override
    public ExecutionContext[] get_contexts() {
        ExecutionContextListHolder execlist = new ExecutionContextListHolder();
        execlist.value = new ExecutionContext[this.m_execContexts.value.length];
        int intIdx = 0;
        while (intIdx < this.m_execContexts.value.length) {
            execlist.value[intIdx] = (ExecutionContext)ExecutionContextHelper.narrow(this.m_execContexts.value[intIdx])._duplicate();
            ++intIdx;
        }
        return execlist.value;
    }

    @Override
    public ExecutionContext get_context(int ec_id) {
        if (ec_id > this.m_execContexts.value.length - 1) {
            return null;
        }
        ExecutionContextService ec = this.m_execContexts.value[ec_id];
        return ec;
    }

    @Override
    public ComponentProfile get_component_profile() {
        try {
            ComponentProfile profile = new ComponentProfile();
            profile.instance_name = new String(this.m_profile.instance_name);
            profile.type_name = new String(this.m_profile.type_name);
            profile.description = new String(this.m_profile.description);
            profile.version = new String(this.m_profile.version);
            profile.vendor = new String(this.m_profile.vendor);
            profile.category = new String(this.m_profile.category);
            profile.port_profiles = this.m_profile.port_profiles;
            profile.parent = this.m_profile.parent;
            profile.properties = this.m_profile.properties;
            profile.port_profiles = this.m_portAdmin.getPortProfileList().value;
            return profile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Port[] get_ports() {
        try {
            return this.m_portAdmin.getPortList().value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ExecutionContextService[] get_execution_context_services() {
        try {
            ExecutionContextServiceListHolder exec_context = new ExecutionContextServiceListHolder(this.m_execContexts.value);
            return exec_context.value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int attach_executioncontext(ExecutionContext exec_context) {
        ExecutionContextService ecs = ExecutionContextServiceHelper.narrow(exec_context);
        if (ecs == null) {
            return -1;
        }
        if (this.m_execContexts == null) {
            this.m_execContexts = new ExecutionContextServiceListHolder();
            this.m_execContexts.value = new ExecutionContextService[0];
        }
        CORBA_SeqUtil.push_back(this.m_execContexts, (ExecutionContextService)ecs._duplicate());
        return this.m_execContexts.value.length - 1;
    }

    @Override
    public ReturnCode_t detach_executioncontext(int ec_id) {
        if (ec_id > this.m_execContexts.value.length - 1) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        ExecutionContextService ec = this.m_execContexts.value[ec_id];
        if (ec == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        this.m_execContexts.value[ec_id] = null;
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t on_initialize() {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onInitialize();
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_finalize() {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onFinalize();
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_startup(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onStartup(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_shutdown(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onShutdown(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_activated(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            this.m_configsets.update();
            ret = this.onActivated(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_deactivated(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onDeactivated(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_aborting(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onAborting(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_error(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onError(ec_id);
            this.m_configsets.update();
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_reset(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onReset(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_execute(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onExecute(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_state_update(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onStateUpdate(ec_id);
            this.m_configsets.update();
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public ReturnCode_t on_rate_changed(int ec_id) {
        ReturnCode_t ret = ReturnCode_t.RTC_ERROR;
        try {
            ret = this.onRateChanged(ec_id);
        }
        catch (Exception ex) {
            return ReturnCode_t.RTC_ERROR;
        }
        return ret;
    }

    @Override
    public Organization[] get_owned_organizations() throws NotAvailable {
        try {
            return (Organization[])this.m_sdoOwnedOrganizations.value.clone();
        }
        catch (Exception ex) {
            throw new NotAvailable();
        }
    }

    @Override
    public String get_sdo_id() throws NotAvailable, InternalError {
        try {
            String sdo_id = this.m_profile.instance_name;
            return sdo_id;
        }
        catch (Exception ex) {
            throw new InternalError("get_sdo_id()");
        }
    }

    @Override
    public String get_sdo_type() throws NotAvailable, InternalError {
        try {
            String sdo_type = this.m_profile.description;
            return sdo_type;
        }
        catch (Exception ex) {
            throw new InternalError("get_sdo_type()");
        }
    }

    @Override
    public DeviceProfile get_device_profile() throws NotAvailable, InternalError {
        try {
            DeviceProfile dprofile = new DeviceProfile();
            dprofile.device_type = this.m_profile.category;
            dprofile.manufacturer = this.m_profile.vendor;
            dprofile.model = this.m_profile.type_name;
            dprofile.version = this.m_profile.version;
            dprofile.properties = this.m_profile.properties;
            return dprofile;
        }
        catch (Exception ex) {
            throw new InternalError("get_device_profile()");
        }
    }

    @Override
    public ServiceProfile[] get_service_profiles() throws NotAvailable, InternalError {
        try {
            return (ServiceProfile[])this.m_sdoSvcProfiles.value.clone();
        }
        catch (Exception ex) {
            throw new InternalError("get_service_profiles()");
        }
    }

    @Override
    public ServiceProfile get_service_profile(String id) throws InvalidParameter, NotAvailable, InternalError {
        if (id == null || id.equals("")) {
            throw new InvalidParameter("get_service_profile(): Empty name.");
        }
        try {
            int intIdx = 0;
            while (intIdx < this.m_sdoSvcProfiles.value.length) {
                if (id.equals(this.m_sdoSvcProfiles.value[intIdx].id)) {
                    ServiceProfileHolder sprofile = new ServiceProfileHolder(this.m_sdoSvcProfiles.value[intIdx]);
                    return sprofile.value;
                }
                ++intIdx;
            }
        }
        catch (Exception ex) {
            throw new InternalError("get_service_profile()");
        }
        return null;
    }

    @Override
    public SDOService get_sdo_service(String id) throws InvalidParameter, NotAvailable, InternalError {
        if (id == null || id.equals("")) {
            throw new InvalidParameter("get_service(): Empty name.");
        }
        try {
            int intIdx = 0;
            while (intIdx < this.m_sdoSvcProfiles.value.length) {
                if (id.equals(this.m_sdoSvcProfiles.value[intIdx].id)) {
                    SDOServiceHolder service = new SDOServiceHolder(this.m_sdoSvcProfiles.value[intIdx].service);
                    return service.value;
                }
                ++intIdx;
            }
        }
        catch (Exception ex) {
            throw new InternalError("get_service()");
        }
        return null;
    }

    @Override
    public Configuration get_configuration() throws InterfaceNotImplemented, NotAvailable, InternalError {
        if (this.m_pSdoConfig == null) {
            throw new InterfaceNotImplemented();
        }
        try {
            Configuration config = this.m_pSdoConfig;
            return config;
        }
        catch (Exception ex) {
            throw new InternalError("get_configuration()");
        }
    }

    @Override
    public Monitoring get_monitoring() throws InterfaceNotImplemented, NotAvailable, InternalError {
        throw new InterfaceNotImplemented();
    }

    @Override
    public Organization[] get_organizations() throws NotAvailable, InternalError {
        try {
            return (Organization[])this.m_sdoOrganizations.value.clone();
        }
        catch (Exception ex) {
            throw new InternalError("get_organizations()");
        }
    }

    @Override
    public NameValue[] get_status_list() throws NotAvailable, InternalError {
        try {
            return (NameValue[])this.m_sdoStatus.value.clone();
        }
        catch (Exception ex) {
            throw new InternalError("get_status_list()");
        }
    }

    @Override
    public Any get_status(String name) throws InvalidParameter, NotAvailable, InternalError {
        int index = CORBA_SeqUtil.find(this.m_sdoStatus, (equalFunctor)new nv_name(name));
        if (index < 0) {
            throw new InvalidParameter("get_status(): Not found");
        }
        try {
            Any status = ORBUtil.getOrb().create_any();
            status.insert_any(this.m_sdoStatus.value[index].value);
            return status;
        }
        catch (Exception ex) {
            throw new InternalError("get_status()");
        }
    }

    public final String getInstanceName() {
        return this.m_profile.instance_name;
    }

    public void setInstanceName(String instance_name) {
        this.m_properties.setProperty("instance_name", instance_name);
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
    }

    public final String getTypeName() {
        return this.m_profile.type_name;
    }

    public final String getCategory() {
        return this.m_profile.category;
    }

    public String[] getNamingNames() {
        return this.m_properties.getProperty("naming.names").split(",");
    }

    public void setObjRef(RTObject rtobj) {
        this.m_objref = rtobj;
    }

    public final RTObject getObjRef() {
        return (RTObject)this.m_objref._duplicate();
    }

    public void setProperties(Properties prop) {
        this.m_properties.merge(prop);
        if (this.m_profile == null) {
            this.m_profile = new ComponentProfile();
        }
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
        this.m_profile.type_name = this.m_properties.getProperty("type_name");
        this.m_profile.description = this.m_properties.getProperty("description");
        this.m_profile.version = this.m_properties.getProperty("version");
        this.m_profile.vendor = this.m_properties.getProperty("vendor");
        this.m_profile.category = this.m_properties.getProperty("category");
        this.m_profile.properties = new NameValue[0];
        this.m_profile.port_profiles = new PortProfile[0];
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public boolean bindParameter(String param_name, ValueHolder var, String def_val) {
        this.m_configsets.bindParameter(param_name, var, def_val);
        return true;
    }

    public void updateParameters(String config_set) {
        this.m_configsets.update(config_set);
    }

    public void registerPort(PortBase port) {
        this.m_portAdmin.registerPort(port);
        port.setOwner(this.getObjRef());
    }

    public <DataType, Buffer> void registerInPort(Class<DataType> DATA_TYPE_CLASS, String name, InPort<DataType> inport) throws Exception {
        DataInPort<DataType> port = new DataInPort<DataType>(DATA_TYPE_CLASS, name, inport);
        this.registerPort(port);
    }

    public <DataType, Buffer> void registerOutPort(Class<DataType> DATA_TYPE_CLASS, String name, OutPort<DataType> outport) throws Exception {
        DataOutPort<DataType> port = new DataOutPort<DataType>(DATA_TYPE_CLASS, name, outport);
        this.registerPort(port);
    }

    public void deletePort(PortBase port) {
        this.m_portAdmin.deletePort(port);
    }

    public void deletePortByName(String port_name) {
        this.m_portAdmin.deletePortByName(port_name);
    }

    public void finalizePorts() {
        this.m_portAdmin.finalizePorts();
    }

    protected void shutdown() {
        try {
            this.finalizePorts();
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_pSdoConfigImpl));
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_pManager != null) {
            this.m_pManager.cleanupComponent(this);
        }
    }

    class nv_name
    implements equalFunctor {
        private String m_name;

        public nv_name(String name) {
            this.m_name = name;
        }

        public boolean equalof(Object nv) {
            return this.m_name.equals(((NameValue)nv).name);
        }
    }
}

