/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.executionContext;

import RTC.DataFlowComponent;
import RTC.DataFlowComponentHelper;
import RTC.ExecutionContextProfile;
import RTC.ExecutionContextProfileHolder;
import RTC.ExecutionContextService;
import RTC.ExecutionKind;
import RTC.LifeCycleState;
import RTC.LightweightRTObject;
import RTC.ReturnCode_t;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.StateAction;
import jp.go.aist.rtm.RTC.StateHolder;
import jp.go.aist.rtm.RTC.StateMachine;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class PeriodicExecutionContext
extends ExecutionContextBase
implements Runnable {
    protected Vector<Comp> m_comps = new Vector();
    protected boolean m_running = false;
    protected ExecutionContextProfile m_profile = new ExecutionContextProfile();
    protected long m_usec;
    protected ExecutionContextService m_ref;
    protected boolean m_nowait = false;

    public PeriodicExecutionContext() {
        if (this.m_profile == null) {
            this.m_profile = new ExecutionContextProfile();
        }
        this.m_profile.kind = ExecutionKind.PERIODIC;
        this.m_profile.rate = 0.0;
        this.m_usec = 0L;
    }

    public PeriodicExecutionContext(DataFlowComponent owner) {
        this(owner, 1000.0);
    }

    public PeriodicExecutionContext(DataFlowComponent owner, double rate) {
        this.m_profile.kind = ExecutionKind.PERIODIC;
        this.m_profile.rate = rate;
        if (rate == 0.0) {
            rate = 1.0E-7;
        }
        this.m_usec = (long)(1000000.0 / rate);
        if (this.m_usec == 0L) {
            this.m_nowait = true;
        }
    }

    public void setObjRef(ExecutionContextService ref) {
        this.m_ref = ref;
    }

    public ExecutionContextService getRef() {
        return this.m_ref;
    }

    public int open() {
        Thread t = new Thread(this);
        t.start();
        return 0;
    }

    public int svc() {
        do {
            TimeValue tv = new TimeValue(0L, this.m_usec);
            int intIdx = 0;
            while (intIdx < this.m_comps.size()) {
                this.m_comps.elementAt(intIdx).invoke();
                ++intIdx;
            }
            while (!this.m_running) {
                try {
                    Thread.sleep(0L, (int)tv.getUsec());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.m_nowait) continue;
            try {
                Thread.sleep(0L, (int)tv.getUsec());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.m_running);
        return 0;
    }

    public void run() {
        this.svc();
    }

    public int close(long flags) {
        return 0;
    }

    public boolean is_running() {
        return this.m_running;
    }

    public ReturnCode_t start() {
        if (this.m_running) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            this.m_comps.elementAt(intIdx).invoke_on_startup();
            ++intIdx;
        }
        this.m_running = true;
        this.open();
        return ReturnCode_t.RTC_OK;
    }

    public ReturnCode_t stop() {
        if (!this.m_running) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            this.m_comps.elementAt(intIdx).invoke_on_shutdown();
            ++intIdx;
        }
        this.m_running = false;
        return ReturnCode_t.RTC_OK;
    }

    public double get_rate() {
        return this.m_profile.rate;
    }

    public ReturnCode_t set_rate(double rate) {
        if (rate > 0.0) {
            this.m_profile.rate = rate;
            this.m_usec = (long)(1000000.0 / rate);
            if (this.m_usec == 0L) {
                this.m_nowait = true;
            }
            int intIdx = 0;
            while (intIdx < this.m_comps.size()) {
                this.m_comps.elementAt(intIdx).invoke_on_rate_changed();
                ++intIdx;
            }
            return ReturnCode_t.RTC_OK;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    public ReturnCode_t activate_component(LightweightRTObject comp) {
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            find_comp find = new find_comp((LightweightRTObject)comp._duplicate());
            if (find.eqaulof(this.m_comps.elementAt(intIdx))) {
                if (!this.m_comps.elementAt((int)intIdx)._sm.m_sm.isIn(LifeCycleState.INACTIVE_STATE)) {
                    return ReturnCode_t.PRECONDITION_NOT_MET;
                }
                this.m_comps.elementAt((int)intIdx)._sm.m_sm.goTo(LifeCycleState.ACTIVE_STATE);
                return ReturnCode_t.RTC_OK;
            }
            ++intIdx;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    public ReturnCode_t deactivate_component(LightweightRTObject comp) {
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            find_comp find = new find_comp((LightweightRTObject)comp._duplicate());
            if (find.eqaulof(this.m_comps.elementAt(intIdx))) {
                if (!this.m_comps.elementAt((int)intIdx)._sm.m_sm.isIn(LifeCycleState.ACTIVE_STATE)) {
                    return ReturnCode_t.PRECONDITION_NOT_MET;
                }
                this.m_comps.elementAt((int)intIdx)._sm.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
                return ReturnCode_t.RTC_OK;
            }
            ++intIdx;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    public ReturnCode_t reset_component(LightweightRTObject comp) {
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            find_comp find = new find_comp((LightweightRTObject)comp._duplicate());
            if (find.eqaulof(this.m_comps.elementAt(intIdx))) {
                if (!this.m_comps.elementAt((int)intIdx)._sm.m_sm.isIn(LifeCycleState.ERROR_STATE)) {
                    return ReturnCode_t.PRECONDITION_NOT_MET;
                }
                this.m_comps.elementAt((int)intIdx)._sm.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
                return ReturnCode_t.RTC_OK;
            }
            ++intIdx;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    public LifeCycleState get_component_state(LightweightRTObject comp) {
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            find_comp find = new find_comp((LightweightRTObject)comp._duplicate());
            if (find.eqaulof(this.m_comps.elementAt(intIdx))) {
                return (LifeCycleState)this.m_comps.elementAt((int)intIdx)._sm.m_sm.getState();
            }
            ++intIdx;
        }
        return LifeCycleState.UNKNOWN_STATE;
    }

    public ExecutionKind get_kind() {
        return this.m_profile.kind;
    }

    public ReturnCode_t add(LightweightRTObject comp) {
        if (comp == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        try {
            DataFlowComponent dfp = DataFlowComponentHelper.narrow(comp);
            int id = dfp.attach_executioncontext(this.m_ref);
            this.m_comps.add(new Comp((LightweightRTObject)comp._duplicate(), (DataFlowComponent)dfp._duplicate(), id));
            return ReturnCode_t.RTC_OK;
        }
        catch (Exception ex) {
            return ReturnCode_t.BAD_PARAMETER;
        }
    }

    public ReturnCode_t remove(LightweightRTObject comp) {
        int intIdx = 0;
        while (intIdx < this.m_comps.size()) {
            find_comp find = new find_comp((LightweightRTObject)comp._duplicate());
            if (find.eqaulof(this.m_comps.elementAt(intIdx))) {
                this.m_comps.remove(this.m_comps.elementAt(intIdx));
                return ReturnCode_t.RTC_OK;
            }
            ++intIdx;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    public ExecutionContextProfile get_profile() {
        ExecutionContextProfileHolder p = new ExecutionContextProfileHolder(this.m_profile);
        return p.value;
    }

    public static void PeriodicExecutionContextInit(Manager manager) {
        manager.registerECFactory("jp.go.aist.rtm.RTC.executionContext.PeriodicExecutionContext");
    }

    public ExecutionContextBase ECNewFunc() {
        return this;
    }

    public void ECDeleteFunc(ExecutionContextBase comp) {
        comp = null;
    }

    protected abstract class DFPBase {
        public int ec_id;
        public StateMachine<LifeCycleState, DFPBase> m_sm;

        public DFPBase(int id) {
            this.ec_id = id;
            this.m_sm = new StateMachine(3);
            this.m_sm.setListener(this);
            StateHolder st = new StateHolder();
            this.m_sm.setEntryAction(LifeCycleState.ACTIVE_STATE, new onActivated());
            this.m_sm.setDoAction(LifeCycleState.ACTIVE_STATE, new onExecute());
            this.m_sm.setPostDoAction(LifeCycleState.ACTIVE_STATE, new onStateUpdate());
            this.m_sm.setExitAction(LifeCycleState.ACTIVE_STATE, new onDeactivated());
            this.m_sm.setEntryAction(LifeCycleState.ERROR_STATE, new onAborting());
            this.m_sm.setDoAction(LifeCycleState.ERROR_STATE, new onError());
            this.m_sm.setExitAction(LifeCycleState.ERROR_STATE, new onReset());
            st.prev = LifeCycleState.INACTIVE_STATE;
            st.curr = LifeCycleState.INACTIVE_STATE;
            st.next = LifeCycleState.INACTIVE_STATE;
            this.m_sm.setStartState(st);
            this.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
        }

        public abstract void on_startup();

        public abstract void on_shutdown();

        public abstract void on_activated(StateHolder var1);

        public abstract void on_deactivated(StateHolder var1);

        public abstract void on_aborting(StateHolder var1);

        public abstract void on_error(StateHolder var1);

        public abstract void on_reset(StateHolder var1);

        public abstract void on_execute(StateHolder var1);

        public abstract void on_state_update(StateHolder var1);

        public abstract void on_rate_changed();

        public void worker() {
            this.m_sm.worker();
        }

        public LifeCycleState get_state() {
            return this.m_sm.getState();
        }

        private class onActivated
        implements StateAction {
            private onActivated() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_activated(state);
            }
        }

        private class onExecute
        implements StateAction {
            private onExecute() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_execute(state);
            }
        }

        private class onStateUpdate
        implements StateAction {
            private onStateUpdate() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_state_update(state);
            }
        }

        private class onDeactivated
        implements StateAction {
            private onDeactivated() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_deactivated(state);
            }
        }

        private class onAborting
        implements StateAction {
            private onAborting() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_aborting(state);
            }
        }

        private class onError
        implements StateAction {
            private onError() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_error(state);
            }
        }

        private class onReset
        implements StateAction {
            private onReset() {
            }

            public void doAction(StateHolder state) {
                DFPBase.this.on_reset(state);
            }
        }
    }

    protected class DFP
    extends DFPBase {
        private DataFlowComponent m_obj;
        private boolean m_active;

        public DFP(DataFlowComponent obj, int id) {
            super(id);
            this.m_obj = obj;
            this.m_active = true;
        }

        public void on_startup() {
            this.m_obj.on_startup(this.ec_id);
        }

        public void on_shutdown() {
            this.m_obj.on_shutdown(this.ec_id);
        }

        public void on_activated(StateHolder st) {
            if (this.m_obj.on_activated(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        public void on_deactivated(StateHolder st) {
            if (this.m_obj.on_deactivated(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        public void on_aborting(StateHolder st) {
            this.m_obj.on_aborting(this.ec_id);
        }

        public void on_error(StateHolder st) {
            this.m_obj.on_error(this.ec_id);
        }

        public void on_reset(StateHolder st) {
            if (this.m_obj.on_reset(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        public void on_execute(StateHolder st) {
            if (this.m_obj.on_execute(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        public void on_state_update(StateHolder st) {
            if (this.m_obj.on_state_update(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        public void on_rate_changed() {
            this.m_obj.on_rate_changed(this.ec_id);
        }
    }

    protected class Comp {
        public LightweightRTObject _ref;
        public DFP _sm;

        public Comp(LightweightRTObject ref, DataFlowComponent dfp, int id) {
            this._ref = ref;
            this._sm = new DFP(dfp, id);
        }

        public Comp(Comp comp) {
            this._ref = comp._ref;
            this._sm = new DFP(comp._sm.m_obj, comp._sm.ec_id);
        }

        public Comp substitute(Comp comp) {
            this._ref = comp._ref;
            this._sm.m_obj = comp._sm.m_obj;
            this._sm.ec_id = comp._sm.ec_id;
            return this;
        }

        public void invoke() {
            this._sm.worker();
        }

        public void invoke_on_startup() {
            this._sm.on_startup();
        }

        public void invoke_on_shutdown() {
            this._sm.on_shutdown();
        }

        public void invoke_on_rate_changed() {
            this._sm.on_rate_changed();
        }
    }

    protected class find_comp {
        private LightweightRTObject m_comp;

        public find_comp(LightweightRTObject comp) {
            this.m_comp = comp;
        }

        public boolean eqaulof(Comp comp) {
            return comp._ref._is_equivalent(this.m_comp);
        }
    }
}

