/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.log;

import jp.go.aist.rtm.RTC.log.MedLogbuf;

public class LogStream {
    public static final int SILENT = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int NORMAL = 4;
    public static final int DEBUG = 5;
    public static final int TRACE = 6;
    public static final int VERBOSE = 7;
    public static final int PARANOID = 8;
    public static final int MANDATORY = 9;
    public static final String SILENT_H = "SILENT   :";
    public static final String ERROR_H = "ERROR    :";
    public static final String WARN_H = "WARN     :";
    public static final String INFO_H = "INFO     :";
    public static final String NORMAL_H = "NORMAL   :";
    public static final String DEBUG_H = "DEBUG    :";
    public static final String TRACE_H = "TRACE    :";
    public static final String VERBOSE_H = "VERBOSE  :";
    public static final String PARANOID_H = "PARANOID :";
    public static final String MANDATORY_H = "MANDATORY:";
    private MedLogbuf m_MedLogBuf;
    private int m_LogLevel;

    public static int strToLogLevel(String loglevel) {
        if (loglevel.equals("SILENT")) {
            return 0;
        }
        if (loglevel.equals("ERROR")) {
            return 1;
        }
        if (loglevel.equals("WARN")) {
            return 2;
        }
        if (loglevel.equals("INFO")) {
            return 3;
        }
        if (loglevel.equals("NORNAL")) {
            return 4;
        }
        if (loglevel.equals("DEBUG")) {
            return 5;
        }
        if (loglevel.equals("TRACE")) {
            return 6;
        }
        if (loglevel.equals("VERBOSE")) {
            return 7;
        }
        if (loglevel.equals("PARANOID")) {
            return 8;
        }
        if (loglevel.equals("MANDATORY")) {
            return 9;
        }
        return 4;
    }

    public LogStream(MedLogbuf buf) {
        this.m_MedLogBuf = buf;
        this.m_LogLevel = 4;
    }

    public void setLogLevel(int level) {
        this.m_LogLevel = level;
    }

    public void setLogLevel(String level) {
        this.m_LogLevel = LogStream.strToLogLevel(level);
    }

    public void setLogLock(boolean lock) {
    }

    public LogStream level(int level) {
        return this;
    }

    public void println(int level, String contents) {
        if (this.m_LogLevel >= level) {
            this.m_MedLogBuf.log(String.valueOf(this.logLevelToStr(level)) + " " + contents);
        }
    }

    private String logLevelToStr(int loglevel) {
        if (loglevel == 0) {
            return SILENT_H;
        }
        if (loglevel == 1) {
            return ERROR_H;
        }
        if (loglevel == 2) {
            return WARN_H;
        }
        if (loglevel == 3) {
            return INFO_H;
        }
        if (loglevel == 4) {
            return NORMAL_H;
        }
        if (loglevel == 5) {
            return DEBUG_H;
        }
        if (loglevel == 6) {
            return TRACE_H;
        }
        if (loglevel == 7) {
            return VERBOSE_H;
        }
        if (loglevel == 8) {
            return PARANOID_H;
        }
        if (loglevel == 9) {
            return MANDATORY_H;
        }
        return NORMAL_H;
    }
}

