#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file ComponentActionListener.py
# @brief component action listener class
# @date $Date$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2011
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


#============================================================

##
# @if jp
# @brief PreComponentActionListener Υ
#
# - PRE_ON_INITIALIZE:    onInitialize ľ
# - PRE_ON_FINALIZE:      onFinalize ľ
# - PRE_ON_STARTUP:       onStartup ľ
# - PRE_ON_SHUTDOWN:      onShutdown ľ
# - PRE_ON_ACTIVATED:     onActivated ľ
# - PRE_ON_DEACTIVATED:   onDeactivated ľ
# - PRE_ON_ABORTING:      onAborted ľ
# - PRE_ON_ERROR:         onError ľ
# - PRE_ON_RESET:         onReset ľ
# - PRE_ON_EXECUTE:       onExecute ľ
# - PRE_ON_STATE_UPDATE:  onStateUpdate ľ
# - PRE_ON_RATE_CHANGED:  onRateChanged ľ
#
# @else
# @brief The types of ConnectorDataListener
# 
# @endif
class PreComponentActionListenerType:
  """
  """

  def __init__(self):
    pass

  PRE_ON_INITIALIZE                 = 0
  PRE_ON_FINALIZE                   = 1
  PRE_ON_STARTUP                    = 2
  PRE_ON_SHUTDOWN                   = 3
  PRE_ON_ACTIVATED                  = 4
  PRE_ON_DEACTIVATED                = 5
  PRE_ON_ABORTING                   = 6
  PRE_ON_ERROR                      = 7
  PRE_ON_RESET                      = 8
  PRE_ON_EXECUTE                    = 9
  PRE_ON_STATE_UPDATE               = 10
  PRE_ON_RATE_CHANGED               = 11
  PRE_COMPONENT_ACTION_LISTENER_NUM = 12


##
# @if jp
# @class PreComponentActionListener 饹
# @brief PreComponentActionListener 饹
#
# OMG RTCͤƤʲΥݡͥȥȤˤĤ
# ơ
#
# - on_initialize()
# - on_finalize()
# - on_startup()
# - on_shutdown()
# - on_activated
# - on_deactivated()
# - on_aborted()
# - on_error()
# - on_reset()
# - on_execute()
# - on_state_update()
# - on_rate_changed()
#
# ƥб桼ɤƤФľΥߥ
# ǥ뤵ꥹʥ饹δ쥯饹
#
# - PRE_ON_INITIALIZE:
# - PRE_ON_FINALIZE:
# - PRE_ON_STARTUP:
# - PRE_ON_SHUTDOWN:
# - PRE_ON_ACTIVATED:
# - PRE_ON_DEACTIVATED:
# - PRE_ON_ABORTING:
# - PRE_ON_ERROR:
# - PRE_ON_RESET:
# - PRE_IN_EXECUTE:
# - PRE_ON_STATE_UPDATE:
# - PRE_ON_RATE_CHANGED:
#
# @else
# @class PreComponentActionListener class
# @brief PreComponentActionListener class
#
# This class is abstract base class for listener classes that
# provides callbacks for various events in rtobject.
#
# @endif
class PreComponentActionListener:
  """
  """

  def __init__(self):
    pass

  ##
  # @if jp
  #
  # @brief PreComponentActionListenerType ʸѴ
  #
  # PreComponentActionListenerType ʸѴ
  #
  # @param type Ѵо PreComponentActionListenerType
  #
  # @return ʸѴ
  #
  # @else
  #
  # @brief Convert PreComponentActionListenerType into the string.
  #
  # Convert PreComponentActionListenerType into the string.
  #
  # @param type The target PreComponentActionListenerType for transformation
  #
  # @return Trnasformation result of string representation
  #
  # @endif
  # static const char* toString(PreComponentActionListenerType type) 
  def toString(type):
    typeString = ["PRE_ON_INITIALIZE",
                  "PRE_ON_FINALIZE",
                  "PRE_ON_STARTUP",
                  "PRE_ON_SHUTDOWN",
                  "PRE_ON_ACTIVATED",
                  "PRE_ON_DEACTIVATED",
                  "PRE_ON_ABORTING",
                  "PRE_ON_ERROR",
                  "PRE_ON_RESET",
                  "PRE_ON_EXECUTE",
                  "PRE_ON_STATE_UPDATE",
                  "PRE_ON_RATE_CHANGED",
                  "PRE_COMPONENT_ACTION_LISTENER_NUM"]
    if type < PreComponentActionListenerType.PRE_COMPONENT_ACTION_LISTENER_NUM:
      return typeString[type]

    return ""
  toString = staticmethod(toString)

  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    pass

  ##
  # @if jp
  #
  # @brief ۥХåؿ
  #
  # PreComponentActionListener ΥХåؿ
  #
  # @else
  #
  # @brief Virtual Callback function
  #
  # This is a the Callback function for PreComponentActionListener.
  #
  # @endif
  # virtual void operator()(UniqueId ec_id) = 0;
  def __call__(self, ec_id):
    pass


#============================================================

##
# @if jp
# @brief PostCompoenntActionListener Υ
#
# - POST_ON_INITIALIZE:
# - POST_ON_FINALIZE:
# - POST_ON_STARTUP:
# - POST_ON_SHUTDOWN:
# - POST_ON_ACTIVATED:
# - POST_ON_DEACTIVATED:
# - POST_ON_ABORTING:
# - POST_ON_ERROR:
# - POST_ON_RESET:
# - POST_ON_EXECUTE:
# - POST_ON_STATE_UPDATE:
# - POST_ON_RATE_CHANGED:
#
# @else
# @brief The types of ConnectorDataListener
# 
# @endif
class PostComponentActionListenerType:
  """
  """
  def __init__(self):
    pass

  POST_ON_INITIALIZE                 = 0
  POST_ON_FINALIZE                   = 1
  POST_ON_STARTUP                    = 2
  POST_ON_SHUTDOWN                   = 3
  POST_ON_ACTIVATED                  = 4
  POST_ON_DEACTIVATED                = 5
  POST_ON_ABORTING                   = 6
  POST_ON_ERROR                      = 7
  POST_ON_RESET                      = 8
  POST_ON_EXECUTE                    = 9
  POST_ON_STATE_UPDATE               = 10
  POST_ON_RATE_CHANGED               = 11
  POST_COMPONENT_ACTION_LISTENER_NUM = 12



##
# @if jp
# @class PostComponentActionListener 饹
# @brief PostComponentActionListener 饹
#
# OMG RTCͤƤʲΥݡͥȥȤˤĤ
# ơ
#
# - on_initialize()
# - on_finalize()
# - on_startup()
# - on_shutdown()
# - on_activated
# - on_deactivated()
# - on_aborted()
# - on_error()
# - on_reset()
# - on_execute()
# - on_state_update()
# - on_rate_changed()
#
# ƥб桼ɤƤФľΥߥ
# ǥ뤵ꥹʥ饹δ쥯饹
#
# - POST_ON_INITIALIZE:
# - POST_ON_FINALIZE:
# - POST_ON_STARTUP:
# - POST_ON_SHUTDOWN:
# - POST_ON_ACTIVATED:
# - POST_ON_DEACTIVATED:
# - POST_ON_ABORTING:
# - POST_ON_ERROR:
# - POST_ON_RESET:
# - POST_ON_EXECUTE:
# - POST_ON_STATE_UPDATE:
# - POST_ON_RATE_CHANGED:
#
# @else
# @class PostComponentActionListener class
# @brief PostComponentActionListener class
#
# This class is abstract base class for listener classes that
# provides callbacks for various events in rtobject.
#
# @endif
class PostComponentActionListener:
  """
  """

  def __init__(self):
    pass

  ##
  # @if jp
  #
  # @brief PostComponentActionListenerType ʸѴ
  #
  # PostComponentActionListenerType ʸѴ
  #
  # @param type Ѵо PostComponentActionListenerType
  #
  # @return ʸѴ
  #
  # @else
  #
  # @brief Convert PostComponentActionListenerType into the string.
  #
  # Convert PostComponentActionListenerType into the string.
  #
  # @param type The target PostComponentActionListenerType for transformation
  #
  # @return Trnasformation result of string representation
  #
  # @endif
  # static const char* toString(PostComponentActionListenerType type)
  def toString(type):
    typeString = ["POST_ON_INITIALIZE",
                  "POST_ON_FINALIZE",
                  "POST_ON_STARTUP",
                  "POST_ON_SHUTDOWN",
                  "POST_ON_ACTIVATED",
                  "POST_ON_DEACTIVATED",
                  "POST_ON_ABORTING",
                  "POST_ON_ERROR",
                  "POST_ON_RESET",
                  "POST_ON_EXECUTE",
                  "POST_ON_STATE_UPDATE",
                  "POST_ON_RATE_CHANGED",
                  "POST_COMPONENT_ACTION_LISTENER_NUM"]
    if type < PostComponentActionListenerType.POST_COMPONENT_ACTION_LISTENER_NUM:
      return typeString[type]
    return "";

  toString = staticmethod(toString)

  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    pass

  ##
  # @if jp
  #
  # @brief ۥХåؿ
  #
  # PostComponentActionListener ΥХåؿ
  #
  # @else
  #
  # @brief Virtual Callback function
  #
  # This is a the Callback function for PostComponentActionListener.
  #
  # @endif
  #virtual void operator()(UniqueId ec_id,
  #                        ReturnCode_t ret) = 0;
  def __call__(self, ec_id, ret):
    pass



#============================================================
##
# @if jp
# @brief PortActionListener Υ
#
# - ADD_PORT:             Port ɲû
# - REMOVE_PORT:          Port 
#
# @else
# @brief The types of PortActionListener
# 
# @endif
class PortActionListenerType:
  """
  """
  
  def __init__(self):
    pass

  ADD_PORT                 = 0
  REMOVE_PORT              = 1
  PORT_ACTION_LISTENER_NUM = 2



##
# @if jp
# @class PortActionListener 饹
# @brief PortActionListener 饹
#
# ƥб桼ɤƤФľΥߥ
# ǥ뤵ꥹʥ饹δ쥯饹
#
# - ADD_PORT:
# - REMOVE_PORT:
#
# @else
# @class PortActionListener class
# @brief PortActionListener class
#
# This class is abstract base class for listener classes that
# provides callbacks for various events in rtobject.
#
# @endif
class PortActionListener:
  """
  """

  def __init__(self):
    pass

  ##
  # @if jp
  #
  # @brief PortActionListenerType ʸѴ
  #
  # PortActionListenerType ʸѴ
  #
  # @param type Ѵо PortActionListenerType
  #
  # @return ʸѴ
  #
  # @else
  #
  # @brief Convert PortActionListenerType into the string.
  #
  # Convert PortActionListenerType into the string.
  #
  # @param type The target PortActionListenerType for transformation
  #
  # @return Trnasformation result of string representation
  #
  # @endif
  #static const char* toString(PortActionListenerType type)
  def toString(type):
    typeString = ["ADD_PORT",
                  "REMOVE_PORT",
                  "PORT_ACTION_LISTENER_NUM"]
    if type < PortActionListenerType.PORT_ACTION_LISTENER_NUM:
      return typeString[type]
    return ""

  toString = staticmethod(toString)

  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  #virtual ~PortActionListener();
  def __del__(self):
    pass

  ##
  # @if jp
  #
  # @brief ۥХåؿ
  #
  # PortActionListener ΥХåؿ
  #
  # @else
  #
  # @brief Virtual Callback function
  #
  # This is a the Callback function for PortActionListener
  #
  # @endif
  #virtual void operator()(const ::RTC::PortProfile& pprof) = 0;
  def __call__(self, pprof):
    pass


#============================================================
##
# @if jp
# @brief ExecutionContextActionListener Υ
#
# - EC_ATTACHED:          ExecutionContext ɲû
# - EC_DETACHED:          ExecutionContext 
#
# @else
# @brief The types of ExecutionContextActionListener
# 
# @endif
class ExecutionContextActionListenerType:
  """
  """
  def __init__(self):
    pass

  EC_ATTACHED            = 0
  EC_DETACHED            = 1
  EC_ACTION_LISTENER_NUM = 2

##
# @if jp
# @class ExecutionContextActionListener 饹
# @brief ExecutionContextActionListener 饹
#
# ƥб桼ɤƤФľΥߥ
# ǥ뤵ꥹʥ饹δ쥯饹
#
# - ADD_PORT:
# - REMOVE_PORT:
#
# @else
# @class ExecutionContextActionListener class
# @brief ExecutionContextActionListener class
#
# This class is abstract base class for listener classes that
# provides callbacks for various events in rtobject.
#
# @endif
class ExecutionContextActionListener:
  """
  """

  def __init__(self):
    pass


  ##
  # @if jp
  #
  # @brief ExecutionContextActionListenerType ʸѴ
  #
  # ExecutionContextActionListenerType ʸѴ
  #
  # @param type Ѵо ExecutionContextActionListenerType
  #
  # @return ʸѴ
  #
  # @else
  #
  # @brief Convert ExecutionContextActionListenerType into the string.
  #
  # Convert ExecutionContextActionListenerType into the string.
  #
  # @param type The target ExecutionContextActionListenerType for transformation
  #
  # @return Trnasformation result of string representation
  #
  # @endif
  #static const char* toString(ExecutionContextActionListenerType type)
  def toString(type):
    typeString = ["ATTACH_EC",
                  "DETACH_EC",
                  "EC_ACTION_LISTENER_NUM"]
    if type < ExecutionContextActionListenerType.EC_ACTION_LISTENER_NUM:
      return typeString[type]
    return ""

  toString = staticmethod(toString)


  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    pass

  ##
  # @if jp
  #
  # @brief ۥХåؿ
  #
  # ExecutionContextActionListener ΥХåؿ
  #
  # @else
  #
  # @brief Virtual Callback function
  #
  # This is a the Callback function for ExecutionContextActionListener
  #
  # @endif
  #virtual void operator()(UniqueId ec_id) = 0;
  def __call__(self, ec_id):
    pass


class Entry:
  def __init__(self,listener, autoclean):
    self.listener  = listener
    self.autoclean = autoclean
    return


#============================================================
##
# @if jp
# @class PreComponentActionListenerHolder 
# @brief PreComponentActionListener ۥ饹
#
# ʣ PreComponentActionListener ݻ륯饹
#
# @else
# @class PreComponentActionListenerHolder
# @brief PreComponentActionListener holder class
#
# This class manages one ore more instances of
# PreComponentActionListener class.
#
# @endif
class PreComponentActionListenerHolder:
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  # @else
  # @brief Constructor
  # @endif
  def __init__(self):
    self._listeners = []
    return
  
    
  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    for (idx, listener) in enumerate(self._listeners):
      if listener.autoclean:
        self._listeners[idx] = None
    return

  ##
  # @if jp
  #
  # @brief ꥹʡɲ
  #
  # ꥹʡɲä롣
  #
  # @param listener ɲäꥹ
  # @param autoclean true:ǥȥ饯Ǻ,
  #                  false:ǥȥ饯Ǻʤ
  # @else
  #
  # @brief Add the listener.
  #
  # This method adds the listener. 
  #
  # @param listener Added listener
  # @param autoclean true:The listener is deleted at the destructor.,
  #                  false:The listener is not deleted at the destructor. 
  # @endif
  #void addListener(PreComponentActionListener* listener, bool autoclean);
  def addListener(self, listener, autoclean):
    self._listeners.append(Entry(listener, autoclean))
    return
    
  ##
  # @if jp
  #
  # @brief ꥹʡκ
  #
  # ꥹʤ롣
  #
  # @param listener ꥹ
  # @else
  #
  # @brief Remove the listener. 
  #
  # This method removes the listener. 
  #
  # @param listener Removed listener
  # @endif
  #void removeListener(PreComponentActionListener* listener);
  def removeListener(self, listener):
    len_ = len(self._listeners)
    for i in range(len_):
      idx = (len_ - 1) - i
      if self._listeners[idx].listener == listener:
        if self._listeners[idx].autoclean:
          self._listeners[idx].listener = None
          del self._listeners[idx]
          return
    return

  ##
  # @if jp
  #
  # @brief ꥹʡΤ
  #
  # ϿƤꥹʤΥХå᥽åɤƤӽФ
  #
  # @param info ConnectorInfo
  # @else
  #
  # @brief Notify listeners. 
  #
  # This calls the Callback method of the registered listener. 
  #
  # @param info ConnectorInfo
  # @endif
  #void notify(UniqueId ec_id);
  def notify(self, ec_id):
    for listener in self._listeners:
      listener.listener(ec_id)
    return

      

##
# @if jp
# @class PostComponentActionListenerHolder
# @brief PostComponentActionListener ۥ饹
#
# ʣ PostComponentActionListener ݻ륯饹
#
# @else
# @class PostComponentActionListenerHolder
# @brief PostComponentActionListener holder class
#
# This class manages one ore more instances of
# PostComponentActionListener class.
#
# @endif
class PostComponentActionListenerHolder:
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  # @else
  # @brief Constructor
  # @endif
  def __init__(self):
    self._listeners = []
    return


  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    for (idx, listener) in enumerate(self._listeners):
      if listener.autoclean:
        self._listeners[idx] = None
    return
    
  ##
  # @if jp
  #
  # @brief ꥹʡɲ
  #
  # ꥹʡɲä롣
  #
  # @param listener ɲäꥹ
  # @param autoclean true:ǥȥ饯Ǻ,
  #                  false:ǥȥ饯Ǻʤ
  # @else
  #
  # @brief Add the listener.
  #
  # This method adds the listener. 
  #
  # @param listener Added listener
  # @param autoclean true:The listener is deleted at the destructor.,
  #                  false:The listener is not deleted at the destructor. 
  # @endif
  #void addListener(PostComponentActionListener* listener, bool autoclean);
  def addListener(self, listener, autoclean):
    self._listeners.append(Entry(listener, autoclean))
    return
    
  ##
  # @if jp
  #
  # @brief ꥹʡκ
  #
  # ꥹʤ롣
  #
  # @param listener ꥹ
  # @else
  #
  # @brief Remove the listener. 
  #
  # This method removes the listener. 
  #
  # @param listener Removed listener
  # @endif
  #void removeListener(PostComponentActionListener* listener);
  def removeListener(self, listener):
    len_ = len(self._listeners)
    for i in range(len_):
      idx = (len_ - 1) - i
      if self._listeners[idx].listener == listener:
        if self._listeners[idx].autoclean:
          self._listeners[idx].listener = None
          del self._listeners[idx]
          return
    return
    
  
  ##
  # @if jp
  #
  # @brief ꥹʡΤ
  #
  # ϿƤꥹʤΥХå᥽åɤƤӽФ
  #
  # @param info ConnectorInfo
  # @param cdrdata ǡ
  # @else
  #
  # @brief Notify listeners. 
  #
  # This calls the Callback method of the registered listener. 
  #
  # @param info ConnectorInfo
  # @param cdrdata Data
  # @endif
  #void notify(UniqueId ec_id, ReturnCode_t ret);
  def notify(self, ec_id, ret):
    for listener in self._listeners:
      listener.listener(ec_id, ret)
    return
    


#============================================================
##
# @if jp
# @class PortActionListenerHolder
# @brief PortActionListener ۥ饹
#
# ʣ PortActionListener ݻ륯饹
#
# @else
# @class PortActionListenerHolder
# @brief PortActionListener holder class
#
# This class manages one ore more instances of
# PortActionListener class.
#
# @endif
class PortActionListenerHolder:
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  # @else
  # @brief Constructor
  # @endif
  def __init__(self):
    self._listeners = []
    return


  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    for (idx, listener) in enumerate(self._listeners):
      if listener.autoclean:
        self._listeners[idx] = None
    pass
    
  ##
  # @if jp
  #
  # @brief ꥹʡɲ
  #
  # ꥹʡɲä롣
  #
  # @param listener ɲäꥹ
  # @param autoclean true:ǥȥ饯Ǻ,
  #                  false:ǥȥ饯Ǻʤ
  # @else
  #
  # @brief Add the listener.
  #
  # This method adds the listener. 
  #
  # @param listener Added listener
  # @param autoclean true:The listener is deleted at the destructor.,
  #                  false:The listener is not deleted at the destructor. 
  # @endif
  #void addListener(PortActionListener* listener, bool autoclean);
  def addListener(self, listener, autoclean):
    self._listeners.append(Entry(listener, autoclean))
    return
    

  ##
  # @if jp
  #
  # @brief ꥹʡκ
  #
  # ꥹʤ롣
  #
  # @param listener ꥹ
  # @else
  #
  # @brief Remove the listener. 
  #
  # This method removes the listener. 
  #
  # @param listener Removed listener
  # @endif
  #void removeListener(PortActionListener* listener);
  def removeListener(self, listener):
    len_ = len(self._listeners)
    for i in range(len_):
      idx = (len_ - 1) - i
      if self._listeners[idx].listener == listener:
        if self._listeners[idx].autoclean:
          self._listeners[idx].listener = None
          del self._listeners[idx]
          return
    return
    
  ##
  # @if jp
  #
  # @brief ꥹʡΤ
  #
  # ϿƤꥹʤΥХå᥽åɤƤӽФ
  #
  # @param info ConnectorInfo
  # @param cdrdata ǡ
  # @else
  #
  # @brief Notify listeners. 
  #
  # This calls the Callback method of the registered listener. 
  #
  # @param info ConnectorInfo
  # @param cdrdata Data
  # @endif
  #void notify(const RTC::PortProfile& pprofile);
  def notify(self, pprofile):
    for listener in self._listeners:
      listener.listener(pprofile)
    return

    

##
# @if jp
# @class ExecutionContextActionListenerHolder
# @brief ExecutionContextActionListener ۥ饹
#
# ʣ ExecutionContextActionListener ݻ륯饹
#
# @else
# @class ExecutionContextActionListenerHolder
# @brief ExecutionContextActionListener holder class
#
# This class manages one ore more instances of
# ExecutionContextActionListener class.
#
# @endif
class ExecutionContextActionListenerHolder:
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  # @else
  # @brief Constructor
  # @endif
  def __init__(self):
    self._listeners = []
    return


  ##
  # @if jp
  # @brief ǥȥ饯
  # @else
  # @brief Destructor
  # @endif
  def __del__(self):
    for (idx, listener) in enumerate(self._listeners):
      if listener.autoclean:
        self._listeners[idx] = None
    pass
    

  ##
  # @if jp
  #
  # @brief ꥹʡɲ
  #
  # ꥹʡɲä롣
  #
  # @param listener ɲäꥹ
  # @param autoclean true:ǥȥ饯Ǻ,
  #                  false:ǥȥ饯Ǻʤ
  # @else
  #
  # @brief Add the listener.
  #
  # This method adds the listener. 
  #
  # @param listener Added listener
  # @param autoclean true:The listener is deleted at the destructor.,
  #                  false:The listener is not deleted at the destructor. 
  # @endif
  #void addListener(ExecutionContextActionListener* listener, bool autoclean);
  def addListener(self, listener, autoclean):
    self._listeners.append(Entry(listener, autoclean))
    return

    
  ##
  # @if jp
  #
  # @brief ꥹʡκ
  #
  # ꥹʤ롣
  #
  # @param listener ꥹ
  # @else
  #
  # @brief Remove the listener. 
  #
  # This method removes the listener. 
  #
  # @param listener Removed listener
  # @endif
  #void removeListener(ExecutionContextActionListener* listener);
  def removeListener(self, listener):
    len_ = len(self._listeners)
    for i in range(len_):
      idx = (len_ - 1) - i
      if self._listeners[idx].listener == listener:
        if self._listeners[idx].autoclean:
          self._listeners[idx].listener = None
          del self._listeners[idx]
          return
    return


  ##
  # @if jp
  #
  # @brief ꥹʡΤ
  #
  # ϿƤꥹʤΥХå᥽åɤƤӽФ
  #
  # @param info ConnectorInfo
  # @param cdrdata ǡ
  # @else
  #
  # @brief Notify listeners. 
  #
  # This calls the Callback method of the registered listener. 
  #
  # @param info ConnectorInfo
  # @param cdrdata Data
  # @endif
  #void notify(UniqueId ec_id);
  def notify(self, ec_id):
    for listener in self._listeners:
      listener.listener(ec_id)
    return



##
# @if jp
# @class ComponentActionListeners
# @brief ComponentActionListeners 饹
#
#
# @else
# @class ComponentActionListeners
# @brief ComponentActionListeners class
#
#
# @endif
class ComponentActionListeners:
  """
  """

  def __init__(self):
    pass

  ##
  # @if jp
  # @brief PreComponentActionListenerTypeꥹ
  # PreComponentActionListenerTypeꥹʤǼ
  # @else
  # @brief PreComponentActionListenerType listener array
  # The PreComponentActionListenerType listener is stored. 
  # @endif
  preaction_num = PreComponentActionListenerType.PRE_COMPONENT_ACTION_LISTENER_NUM
  preaction_ = [PreComponentActionListenerHolder() 
                for i in range(preaction_num)]

  ##
  # @if jp
  # @brief PostComponentActionListenerTypeꥹ
  # PostComponentActionListenerTypeꥹʤǼ
  # @else
  # @brief PostComponentActionListenerType listener array
  # The PostComponentActionListenerType listener is stored.
  # @endif
  postaction_num = PostComponentActionListenerType.POST_COMPONENT_ACTION_LISTENER_NUM
  postaction_ = [PostComponentActionListenerHolder()
                 for i in range(postaction_num)]

  ##
  # @if jp
  # @brief PortActionListenerTypeꥹ
  # PortActionListenerTypeꥹʤǼ
  # @else
  # @brief PortActionListenerType listener array
  # The PortActionListenerType listener is stored.
  # @endif
  portaction_num = PortActionListenerType.PORT_ACTION_LISTENER_NUM
  portaction_ = [PortActionListenerHolder()
                 for i in range(portaction_num)]
  
  ##
  # @if jp
  # @brief ExecutionContextActionListenerTypeꥹ
  # ExecutionContextActionListenerTypeꥹʤǼ
  # @else
  # @brief ExecutionContextActionListenerType listener array
  # The ExecutionContextActionListenerType listener is stored.
  # @endif
  ecaction_num = ExecutionContextActionListenerType.EC_ACTION_LISTENER_NUM
  ecaction_ = [ExecutionContextActionListenerHolder()
               for i in range(ecaction_num)]
