#!/usr/bin/env python
# -*- coding: euc-jp -*-

#
# \file test_GlobalFactory.py
# \brief test for RTComponent factory class
# \date $Date: $
# \author Shinji Kurihara
#
# Copyright (C) 2003-2005
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.
#

import sys
sys.path.insert(1,"../")

import OpenRTM_aist
import unittest

from GlobalFactory import *

class Test:
	def __init__(self):
		pass

	def test(self):
		return True

class TestGlobalFactory(unittest.TestCase):

	def setUp(self):
		self.factory = GlobalFactory.instance()
		self.factory.addFactory("test",Test,OpenRTM_aist.Delete)
		return

	def tearDown(self):
		self.factory.removeFactory("test")
		return

	def test_isinstance(self):
		self.assertEqual(self.factory,GlobalFactory.instance())

	def test_hasFactory(self):
		# addFactoryˤϿեȥꥪ֥Ȥ䤤碌
		self.assertEqual(self.factory.hasFactory("test"),True)
		# addFactoryˤϿƤʤեȥꥪ֥Ȥ䤤碌
		self.assertEqual(self.factory.hasFactory("testtest"),False)
		# addFactoryˤϿƤʤեȥꥪ֥Ȥ䤤碌(ʸ)
		self.assertEqual(self.factory.hasFactory(""),False)
		return

	def test_getIdentifiers(self):
		# եȥ꤬ϿѤߤξ䤤碌
		self.assertEqual(self.factory.getIdentifiers(),["test"])
		GlobalFactory.instance().addFactory("test2",Test,OpenRTM_aist.Delete)
		self.assertEqual(self.factory.getIdentifiers(),["test","test2"])
		# եȥ꤬ϿƤʤ䤤碌
		self.factory.removeFactory("test")
		self.factory.removeFactory("test2")
		self.assertEqual(self.factory.getIdentifiers(),[])
		return
	
	def test_addFactory(self):
		# creatorꤷʤ硢INVALID_ARG֤뤫?
		self.assertEqual(GlobalFactory.instance().addFactory("test",None,OpenRTM_aist.Delete),
				 GlobalFactory.INVALID_ARG)

		# ϿѤߤIDˤaddFactory()򥳡뤷硢ALREADY_EXISTS֤뤫?
		self.assertEqual(GlobalFactory.instance().addFactory("test",Test,OpenRTM_aist.Delete),
				 GlobalFactory.ALREADY_EXISTS)

		# idcreatorꤷaddFactory()򥳡뤷硢FACTORY_OK֤뤫?
		self.assertEqual(GlobalFactory.instance().addFactory("test1",Test,OpenRTM_aist.Delete),
				 GlobalFactory.FACTORY_OK)
		self.factory.removeFactory("test1")


		return

	def test_removeFactory(self):
		# ϿƤʤIDǥ뤷硢NOT_FOUND֤뤫?
		self.assertEqual(self.factory.removeFactory("testtest"),
				 GlobalFactory.NOT_FOUND)
				 
		# ϿѤߤIDǥ뤷硢FACTORY_OK֤뤫?
		self.assertEqual(self.factory.removeFactory("test"),
				 GlobalFactory.FACTORY_OK)

		# եȥ꤬줿?
		self.assertEqual(self.factory.getIdentifiers(),[])
		return

	def test_createObject(self):
		# ϿƤʤIDǥ뤷硢None֤뤫?
		self.assertEqual(self.factory.createObject("testtest"),
				 None)
		# ϿѤߤIDǥ뤷硢֥Ȥ֤뤫?
		self.assertEqual(self.factory.createObject("test").test(),True)
		return

	def test_deleteObject(self):
		# ϿƤʤIDǥ뤷
		self.factory.deleteObject(self.factory.createObject("test"),"testtest")
		# IDꤷʤǥ뤷
		self.factory.deleteObject(self.factory.createObject("test"))
		return

############### test #################
if __name__ == '__main__':
        unittest.main()
