/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateDeviceControllers.py script          *
 *                                                        *
 **********************************************************/

/**
* @file ARCONTROLLER_Device.c
* @brief Device controller allow to drive a device.
*/

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <time.h>
#include <json/json.h>

#include <libARSAL/ARSAL_Mutex.h>
#include <libARSAL/ARSAL_Sem.h>
#include <libARSAL/ARSAL_Time.h>
#include <libARController/ARCONTROLLER_Network.h>
#include <libARController/ARCONTROLLER_Feature.h>
#include <libARController/ARCONTROLLER_DICTIONARY_Key.h>
#include <libARController/ARCONTROLLER_Dictionary.h>
#include <libARController/ARCONTROLLER_Frame.h>
#include <libARController/ARCONTROLLER_Stream.h>
#include <libARController/ARCONTROLLER_Device.h>

#include "ARCONTROLLER_Device.h"

#define ARCONTROLLER_DEVICE_TAG "ARCONTROLLER_Device"

/*****************************************
 *
 *             local header:
 *
 ****************************************/

static int ARCONTROLLER_Device_ElementCompare(ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *a, ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *b);

static int ARCONTROLLER_Device_ExtensionElementCompare(ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *a, ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *b);

/*****************************************
 *
 *             implementation:
 *
 ****************************************/

ARCONTROLLER_Device_t *ARCONTROLLER_Device_New (ARDISCOVERY_Device_t *discoveryDevice, eARCONTROLLER_ERROR *error)
{
    // -- Create a new Device Controller --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    eARDISCOVERY_ERROR dicoveryError = ARDISCOVERY_OK;
    ARCONTROLLER_Device_t *deviceController =  NULL;
    
    // Check parameters
    if (discoveryDevice == NULL)
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    // Allocate the Device Controller
    deviceController = malloc (sizeof(ARCONTROLLER_Device_t));
    if (deviceController != NULL)
    {
        //initialization of the device controller
        deviceController->generic = NULL;
        deviceController->aRDrone3 = NULL;
        deviceController->jumpingSumo = NULL;
        deviceController->miniDrone = NULL;
        deviceController->skyController = NULL;
        deviceController->unknown_feature_1 = NULL;
        deviceController->common = NULL;
        deviceController->commonDebug = NULL;
        deviceController->pro = NULL;
        deviceController->wifi = NULL;
        deviceController->privatePart = NULL;
    }
    else
    {
        localError = ARCONTROLLER_ERROR_ALLOC;
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        // Allocate the private part of the Device Controller
        deviceController->privatePart = malloc (sizeof(ARCONTROLLER_Device_Private_t));
        if (deviceController->privatePart != NULL)
        {
            //initialization of the private part of the device controller
            deviceController->privatePart->networkController = NULL;
            deviceController->privatePart->state = ARCONTROLLER_DEVICE_STATE_STOPPED;
            deviceController->privatePart->controllerLooperThread = NULL;
            deviceController->privatePart->commandCallbacks = NULL;
            deviceController->privatePart->stateChangedCallbacks = NULL;
            deviceController->privatePart->startCancelled = 0;
            // Video Part
            deviceController->privatePart->hasVideo = 0;
            deviceController->privatePart->videoIsMP4Compliant = 0;
            deviceController->privatePart->videoDecoderConfigCallback = NULL;
            deviceController->privatePart->videoReceiveCallback = NULL;
            deviceController->privatePart->videoTimeoutCallback = NULL;
            deviceController->privatePart->videoReceiveCustomData = NULL;
            // Extension part
            deviceController->privatePart->extensionState = ARCONTROLLER_DEVICE_STATE_STOPPED;
            deviceController->privatePart->extensionStateChangedCallbacks = NULL;
            deviceController->privatePart->extensionName = NULL;
            deviceController->privatePart->extensionProduct = ARDISCOVERY_PRODUCT_MAX;
            
            // Create the mutex/condition 
            if ((ARSAL_Mutex_Init (&(deviceController->privatePart->mutex)) != 0) ||
               (ARSAL_Sem_Init (&(deviceController->privatePart->initSem), 0, 0) != 0))
            {
                localError = ARCONTROLLER_ERROR_INIT_MUTEX;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
        
    }
    // No else: skipped by an error
    
    if (localError == ARCONTROLLER_OK)
    {
        // Copy the device
        
        deviceController->privatePart->discoveryDevice = ARDISCOVERY_Device_NewByCopy (discoveryDevice, &dicoveryError);
        if (dicoveryError != ARDISCOVERY_OK)
        {
            localError = ARCONTROLLER_ERROR_INIT_DEVICE_COPY;
        }
    }
    
    // Get networkConfiguration of the device
    if (localError == ARCONTROLLER_OK)
    {
        dicoveryError = ARDISCOVERY_Device_InitNetworkConfiguration (deviceController->privatePart->discoveryDevice, &(deviceController->privatePart->networkConfiguration));
        if (dicoveryError != ARDISCOVERY_OK)
        {
            localError = ARCONTROLLER_ERROR_INIT_DEVICE_GET_NETWORK_CONFIG;
        }
    }
    // No else: skipped by an error
    
    if (localError == ARCONTROLLER_OK)
    {
        // Check if the device has video
        if (deviceController->privatePart->networkConfiguration.deviceToControllerARStreamData != -1)
        {
            deviceController->privatePart->hasVideo = 1;
        }
        //NO else ; device has not video
    }
    // No else: skipped by an error
    
    if (localError == ARCONTROLLER_OK)
    {
        // Creation of the features:
        switch (discoveryDevice->productID)
        {
            case ARDISCOVERY_PRODUCT_ARDRONE:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->aRDrone3 = ARCONTROLLER_FEATURE_ARDrone3_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_JS:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->jumpingSumo = ARCONTROLLER_FEATURE_JumpingSumo_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_JS_EVO_LIGHT:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->jumpingSumo = ARCONTROLLER_FEATURE_JumpingSumo_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_JS_EVO_RACE:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->jumpingSumo = ARCONTROLLER_FEATURE_JumpingSumo_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_MINIDRONE:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->miniDrone = ARCONTROLLER_FEATURE_MiniDrone_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_LIGHT:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->miniDrone = ARCONTROLLER_FEATURE_MiniDrone_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_BRICK:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->miniDrone = ARCONTROLLER_FEATURE_MiniDrone_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_HYDROFOIL:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->miniDrone = ARCONTROLLER_FEATURE_MiniDrone_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_SKYCONTROLLER:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->skyController = ARCONTROLLER_FEATURE_SkyController_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_UNKNOWN_PRODUCT_1:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->jumpingSumo = ARCONTROLLER_FEATURE_JumpingSumo_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            case ARDISCOVERY_PRODUCT_BEBOP_2:
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->common = ARCONTROLLER_FEATURE_Common_New (deviceController->privatePart->networkController, &localError);
                }
                
                if (localError == ARCONTROLLER_OK)
                {
                    deviceController->aRDrone3 = ARCONTROLLER_FEATURE_ARDrone3_New (deviceController->privatePart->networkController, &localError);
                }
                
                break;
            
            default:
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "device : %d not known", discoveryDevice->productID);
                break;
        }
    }
    // No else: skipped by an error
    
    // delete the Device Controller if an error occurred
    if (localError != ARCONTROLLER_OK)
    {
        ARCONTROLLER_Device_Delete (&deviceController);
    }
    // No else: skipped no error 
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return deviceController;
}

void ARCONTROLLER_Device_Delete (ARCONTROLLER_Device_t **deviceController)
{
    // -- Delete the Device Controller --
    
    if (deviceController != NULL)
    {
        if ((*deviceController) != NULL)
        {
            if ((*deviceController)->privatePart != NULL)
            {
                // delete all extension related vars
                ARCONTROLLER_Device_DeleteExtension(*deviceController);
                
                ARSAL_Mutex_Destroy (&((*deviceController)->privatePart->mutex));
                
                ARSAL_Sem_Destroy (&((*deviceController)->privatePart->initSem));
                
                if ((*deviceController)->privatePart->commandCallbacks != NULL)
                {
                    // -- Delete all callback in array --
                    ARCONTROLLER_Dictionary_DeleteCallbackList(&((*deviceController)->privatePart->commandCallbacks));
                }
                
                if ((*deviceController)->privatePart->stateChangedCallbacks != NULL)
                {
                    // -- Delete all callback in array --
                    ARCONTROLLER_Device_DeleteCallbackList(&((*deviceController)->privatePart->stateChangedCallbacks));
                }
                
                // Delete features:
                switch ((*deviceController)->privatePart->discoveryDevice->productID)
                {
                    case ARDISCOVERY_PRODUCT_ARDRONE:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_ARDrone3_Delete (&((*deviceController)->aRDrone3));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_JS:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_JumpingSumo_Delete (&((*deviceController)->jumpingSumo));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_JS_EVO_LIGHT:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_JumpingSumo_Delete (&((*deviceController)->jumpingSumo));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_JS_EVO_RACE:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_JumpingSumo_Delete (&((*deviceController)->jumpingSumo));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_MINIDRONE:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_MiniDrone_Delete (&((*deviceController)->miniDrone));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_LIGHT:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_MiniDrone_Delete (&((*deviceController)->miniDrone));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_BRICK:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_MiniDrone_Delete (&((*deviceController)->miniDrone));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_MINIDRONE_EVO_HYDROFOIL:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_MiniDrone_Delete (&((*deviceController)->miniDrone));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_SKYCONTROLLER:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_SkyController_Delete (&((*deviceController)->skyController));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_UNKNOWN_PRODUCT_1:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_JumpingSumo_Delete (&((*deviceController)->jumpingSumo));
                        
                        break;
                    
                    case ARDISCOVERY_PRODUCT_BEBOP_2:
                        ARCONTROLLER_FEATURE_Common_Delete (&((*deviceController)->common));
                        
                        ARCONTROLLER_FEATURE_ARDrone3_Delete (&((*deviceController)->aRDrone3));
                        
                        break;
                    
                    default:
                        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "device : %d not known", (*deviceController)->privatePart->discoveryDevice->productID);
                        break;
                }
                
                ARDISCOVERY_Device_Delete (&((*deviceController)->privatePart->discoveryDevice));
                
                // free the private part of the Device Controller
                free ((*deviceController)->privatePart);
                (*deviceController)->privatePart = NULL;
            }
            
            // free the Device Controller
            free (*deviceController);
            (*deviceController) = NULL;
        }
    }
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_DeleteExtension (ARCONTROLLER_Device_t *deviceController)
{
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    if (deviceController != NULL && deviceController->privatePart != NULL)
    {
        if (deviceController->privatePart->stateChangedCallbacks != NULL)
        {
            // -- Delete all callback in array --
            ARCONTROLLER_Device_DeleteExtensionCallbackList(&(deviceController->privatePart->extensionStateChangedCallbacks));
        }
        
        // Delete extension feature
        switch (deviceController->privatePart->extensionProduct)
        {
            case ARDISCOVERY_PRODUCT_ARDRONE:
            case ARDISCOVERY_PRODUCT_BEBOP_2:
                ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
                ARCONTROLLER_FEATURE_ARDrone3_Delete (&(deviceController->aRDrone3));
                ARSAL_Mutex_Unlock(&(deviceController->privatePart->mutex));
                break;
            case ARDISCOVERY_PRODUCT_MAX:
                // not connected to an extension device, so don't do anything
                break;
            default:
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "device : %d can not be an extension", deviceController->privatePart->extensionProduct);
                error = ARCONTROLLER_ERROR_EXTENSION_PRODUCT_NOT_VALID;
                break;
        }
        
        if (deviceController->privatePart->extensionName != NULL)
        {
            free(deviceController->privatePart->extensionName);
            deviceController->privatePart->extensionName = NULL;
        }
    }
    return error;
}
eARCONTROLLER_ERROR ARCONTROLLER_Device_RegisterCallbacks (ARCONTROLLER_Device_t *deviceController, void* specificFeature)
{
    // -- Register the Callbacks --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if (deviceController == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if ((deviceController->generic != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->generic)))
    {
    }
    
    if ((deviceController->aRDrone3 != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->aRDrone3)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLATTRIMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFISCANCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_ARDrone3_AddCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->jumpingSumo != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->jumpingSumo)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFISCANCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_ALLSCRIPTSMETADATACHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->miniDrone != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->miniDrone)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLATTRIMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_WHEELSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_CUTOUTMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_MiniDrone_AddCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_FLOODCONTROLSTATE_FLOODCONTROLCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->skyController != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->skyController)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFISIGNALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_DEVICELIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_ALLSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_RESETCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTSERIALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COMMONSTATE_ALLSTATESCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_BATTERYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSFIXCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTSSIDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_ALLGAMEPADCONTROLSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CURRENTBUTTONMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLCURRENTBUTTONMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_AVAILABLEBUTTONMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLAVAILABLEBUTTONSMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_CURRENTAXISMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLCURRENTAXISMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_AVAILABLEAXISMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLAVAILABLEAXISMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_CURRENTAXISFILTERS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLCURRENTFILTERSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_PRESETAXISFILTERS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLPRESETFILTERSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONQUALITYUPDATESSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_SkyController_AddCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONEVENTS_SETTINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->unknown_feature_1 != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->unknown_feature_1)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_AVAILABILITY, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RUN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_ANIMRUN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_USERFRAMINGPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->common != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->common)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_NETWORKEVENT_DISCONNECTION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_ALLSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_RESETCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTNAMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALHIGHCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALLOWCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_COUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_AUTOCOUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_ALLSTATESCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_BATTERYSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGESTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTDATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTTIMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_WIFISIGNALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_PRODUCTMODEL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_COUNTRYLISTKNOWN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATREGULATIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_WIFISETTINGSSTATE_OUTDOORSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONREQUIREDSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTARTEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_AVAILABILITYSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_STARTINGERROREVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_SPEEDBRIDLEEVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_CONTROLLERLIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_SKYCONTROLLERLIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_DEVICELIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_AUDIOSTATE_AUDIOSTREAMINGRUNNING, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_HEADLIGHTSSTATE_INTENSITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGMODIFICATIONENABLED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Common_AddCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_RUNSTATE_RUNIDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->commonDebug != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->commonDebug)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_CommonDebug_AddCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_STATSEVENT_SENDPACKET, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_CommonDebug_AddCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_CommonDebug_AddCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_LISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->pro != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->pro)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Pro_AddCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_SUPPORTEDFEATURES, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Pro_AddCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_FEATURESACTIVATED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Pro_AddCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROEVENT_CHALLENGEEVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    if ((deviceController->wifi != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->wifi)))
    {
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_SECURITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_COUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_ENVIRONEMENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
        if (error == ARCONTROLLER_OK)
        {
            error = ARCONTROLLER_FEATURE_Wifi_AddCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_RSSICHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_UnregisterCallbacks (ARCONTROLLER_Device_t *deviceController, void *specificFeature)
{
    // -- Unregister the Callbacks --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    eARCONTROLLER_ERROR removingError = ARCONTROLLER_OK;
    
    // Check parameters
    if (deviceController == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if ((deviceController->generic != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->generic)))
        {
        }
        
        if ((deviceController->aRDrone3 != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->aRDrone3)))
        {
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLATTRIMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLATTRIMCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFISCANCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFISCANCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (deviceController->aRDrone3, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->jumpingSumo != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->jumpingSumo)))
        {
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFISCANCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFISCANCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_ALLSCRIPTSMETADATACHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_ALLSCRIPTSMETADATACHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (deviceController->jumpingSumo, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->miniDrone != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->miniDrone)))
        {
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLATTRIMCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLATTRIMCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_WHEELSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_WHEELSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_CUTOUTMODECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_CUTOUTMODECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (deviceController->miniDrone, ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_FLOODCONTROLSTATE_FLOODCONTROLCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_FLOODCONTROLSTATE_FLOODCONTROLCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->skyController != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->skyController)))
        {
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_ALLWIFIAUTHCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_ALLWIFIAUTHCHANNELCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFISIGNALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFISIGNALCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_DEVICELIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_DEVICELIST; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_ALLSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_ALLSETTINGSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_RESETCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_RESETCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTSERIALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTSERIALCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COMMONSTATE_ALLSTATESCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COMMONSTATE_ALLSTATESCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_BATTERYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_BATTERYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSFIXCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSFIXCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTSSIDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTSSIDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTCHANNELCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_ALLGAMEPADCONTROLSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_ALLGAMEPADCONTROLSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CURRENTBUTTONMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CURRENTBUTTONMAPPINGS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLCURRENTBUTTONMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLCURRENTBUTTONMAPPINGSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_AVAILABLEBUTTONMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_AVAILABLEBUTTONMAPPINGS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLAVAILABLEBUTTONSMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_ALLAVAILABLEBUTTONSMAPPINGSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_CURRENTAXISMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_CURRENTAXISMAPPINGS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLCURRENTAXISMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLCURRENTAXISMAPPINGSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_AVAILABLEAXISMAPPINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_AVAILABLEAXISMAPPINGS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLAVAILABLEAXISMAPPINGSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_ALLAVAILABLEAXISMAPPINGSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_CURRENTAXISFILTERS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_CURRENTAXISFILTERS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLCURRENTFILTERSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLCURRENTFILTERSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_PRESETAXISFILTERS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_PRESETAXISFILTERS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLPRESETFILTERSSENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_ALLPRESETFILTERSSENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONQUALITYUPDATESSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONQUALITYUPDATESSTATE; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_SkyController_RemoveCallback (deviceController->skyController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONEVENTS_SETTINGS, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONEVENTS_SETTINGS; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->unknown_feature_1 != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->unknown_feature_1)))
        {
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_AVAILABILITY, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_AVAILABILITY; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RUN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RUN; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_ANIMRUN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_ANIMRUN; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (deviceController->unknown_feature_1, ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_USERFRAMINGPOSITIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_USERFRAMINGPOSITIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->common != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->common)))
        {
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_NETWORKEVENT_DISCONNECTION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_NETWORKEVENT_DISCONNECTION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_ALLSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_ALLSETTINGSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_RESETCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_RESETCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTNAMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTNAMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTVERSIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTVERSIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALHIGHCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALHIGHCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALLOWCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALLOWCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_COUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_COUNTRYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_AUTOCOUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_AUTOCOUNTRYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_ALLSTATESCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_ALLSTATESCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_BATTERYSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_BATTERYSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGESTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGESTATELISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTDATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTDATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTTIMECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTTIMECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_WIFISIGNALCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_WIFISIGNALCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_PRODUCTMODEL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_PRODUCTMODEL; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_COUNTRYLISTKNOWN, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_COUNTRYLISTKNOWN; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATREGULATIONCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATREGULATIONCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_WIFISETTINGSSTATE_OUTDOORSETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_WIFISETTINGSSTATE_OUTDOORSETTINGSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONREQUIREDSTATE, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONREQUIREDSTATE; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTARTEDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTARTEDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_AVAILABILITYSTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_AVAILABILITYSTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_STARTINGERROREVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_STARTINGERROREVENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_SPEEDBRIDLEEVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANEVENT_SPEEDBRIDLEEVENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_CONTROLLERLIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_CONTROLLERLIBARCOMMANDSVERSION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_SKYCONTROLLERLIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_SKYCONTROLLERLIBARCOMMANDSVERSION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_DEVICELIBARCOMMANDSVERSION, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_DEVICELIBARCOMMANDSVERSION; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_AUDIOSTATE_AUDIOSTREAMINGRUNNING, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_AUDIOSTATE_AUDIOSTREAMINGRUNNING; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_HEADLIGHTSSTATE_INTENSITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_HEADLIGHTSSTATE_INTENSITYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGMODIFICATIONENABLED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGMODIFICATIONENABLED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Common_RemoveCallback (deviceController->common, ARCONTROLLER_DICTIONARY_KEY_COMMON_RUNSTATE_RUNIDCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON_RUNSTATE_RUNIDCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->commonDebug != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->commonDebug)))
        {
            removingError = ARCONTROLLER_FEATURE_CommonDebug_RemoveCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_STATSEVENT_SENDPACKET, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_STATSEVENT_SENDPACKET; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_CommonDebug_RemoveCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_CommonDebug_RemoveCallback (deviceController->commonDebug, ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_LISTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_LISTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->pro != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->pro)))
        {
            removingError = ARCONTROLLER_FEATURE_Pro_RemoveCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_SUPPORTEDFEATURES, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_SUPPORTEDFEATURES; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Pro_RemoveCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_FEATURESACTIVATED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_FEATURESACTIVATED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Pro_RemoveCallback (deviceController->pro, ARCONTROLLER_DICTIONARY_KEY_PRO_PROEVENT_CHALLENGEEVENT, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_PRO_PROEVENT_CHALLENGEEVENT; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
        if ((deviceController->wifi != NULL) && ((specificFeature == NULL) || (specificFeature == deviceController->wifi)))
        {
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_SECURITYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_SECURITYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_COUNTRYCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_COUNTRYCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_ENVIRONEMENTCHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_ENVIRONEMENTCHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
            removingError = ARCONTROLLER_FEATURE_Wifi_RemoveCallback (deviceController->wifi, ARCONTROLLER_DICTIONARY_KEY_WIFI_RSSICHANGED, ARCONTROLLER_Device_DictionaryChangedCallback, deviceController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring removing of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI_RSSICHANGED; error :%s", ARCONTROLLER_Error_ToString (removingError));
            }
            
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_Start (ARCONTROLLER_Device_t *deviceController)
{
    // -- Start the Device Controller --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARSAL_Thread_t startingThread = NULL;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK) 
    {
        if (deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_STOPPED)
        {
            ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_STARTING, ARCONTROLLER_OK);
            if (ARSAL_Thread_Create (&startingThread, ARCONTROLLER_Device_StartRun, deviceController) != 0)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Creation of Starting thread failed.");
                error = ARCONTROLLER_ERROR_INIT_THREAD;
            }
            else
            {
                ARSAL_Thread_Destroy (&startingThread);
                startingThread = NULL;
            }
            
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_Stop (ARCONTROLLER_Device_t *deviceController)
{
    // -- Stop the Device Controller --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARSAL_Thread_t stoppingThread = NULL;
    
    // Check parameters
    if (deviceController == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK) 
    {
        if (deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_RUNNING)
        {
            ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_STOPPING, ARCONTROLLER_OK);
            if (ARSAL_Thread_Create (&stoppingThread, ARCONTROLLER_Device_StopRun, deviceController) != 0)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Creation of Stopping thread failed.");
                error = ARCONTROLLER_ERROR_INIT_THREAD;
            }
            else
            {
                ARSAL_Thread_Destroy (&stoppingThread);
                stoppingThread = NULL;
            }
            
        }
        else if ((deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_STARTING) && (!deviceController->privatePart->startCancelled))
        {
            // Cancel the connection
            ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_STOPPING, ARCONTROLLER_OK);
            ARSAL_Mutex_Lock (&(deviceController->privatePart->mutex));
            deviceController->privatePart->startCancelled = 1;
            ARSAL_Sem_Post (&(deviceController->privatePart->initSem));
            ARSAL_Sem_Post (&(deviceController->privatePart->initSem));
            ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_SetVideoStreamCallbacks (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_Stream_DecoderConfigCallback_t decoderConfigCallback, ARCONTROLLER_Stream_DidReceiveFrameCallback_t receiveFrameCallback, ARCONTROLLER_Stream_TimeoutFrameCallback_t timeoutFrameCallback, void *customData)
{
    // -- Set video stream callbacks --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        if (deviceController->privatePart->hasVideo)
        {
            deviceController->privatePart->videoDecoderConfigCallback = decoderConfigCallback;
            deviceController->privatePart->videoReceiveCallback = receiveFrameCallback;
            deviceController->privatePart->videoTimeoutCallback = timeoutFrameCallback;
            deviceController->privatePart->videoReceiveCustomData = customData;
        }
        else
        {
            error = ARCONTROLLER_ERROR_NO_VIDEO;
        }
    }
    
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_SetVideoStreamMP4Compliant (ARCONTROLLER_Device_t *deviceController, int isMP4Compliant)
{
    // -- Set video stream compliant with the mp4 format. --

    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;

    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARCONTROLLER_ERROR_BAD_PARAMETER and stop the processing

    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }

    if (error == ARCONTROLLER_OK)
    {
        if (deviceController->privatePart->hasVideo)
        {
            deviceController->privatePart->videoIsMP4Compliant = isMP4Compliant;
        }
        else
        {
            error = ARCONTROLLER_ERROR_NO_VIDEO;
        }
    }

    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }

    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_AddCommandReceivedCallback (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_DICTIONARY_CALLBACK_t commandReceivedCallback, void *customData)
{
    // -- Add Command received callback --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_AddCallbackInList (&(deviceController->privatePart->commandCallbacks), commandReceivedCallback, customData);
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_RemoveCommandReceivedCallback (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_DICTIONARY_CALLBACK_t commandReceivedCallback, void *customData)
{
    // -- Remove Command received callback --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_RemoveCallbackFromList (&(deviceController->privatePart->commandCallbacks), commandReceivedCallback, customData);
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Device_GetCommandElements (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error)
{
    // -- Get Command Elements --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *elements = NULL;
    eARCONTROLLER_DICTIONARY_KEY featureKey = ARCONTROLLER_DICTIONARY_Key_GetFeatureFromCommandKey (commandKey);
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        switch (featureKey)
        {
            case ARCONTROLLER_DICTIONARY_KEY_GENERIC:
                elements = ARCONTROLLER_Generic_GetCommandElements (deviceController->generic, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_ARDRONE3:
                elements = ARCONTROLLER_ARDrone3_GetCommandElements (deviceController->aRDrone3, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO:
                elements = ARCONTROLLER_JumpingSumo_GetCommandElements (deviceController->jumpingSumo, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_MINIDRONE:
                elements = ARCONTROLLER_MiniDrone_GetCommandElements (deviceController->miniDrone, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER:
                elements = ARCONTROLLER_SkyController_GetCommandElements (deviceController->skyController, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1:
                elements = ARCONTROLLER_UnknownFeature1_GetCommandElements (deviceController->unknown_feature_1, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_COMMON:
                elements = ARCONTROLLER_Common_GetCommandElements (deviceController->common, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG:
                elements = ARCONTROLLER_CommonDebug_GetCommandElements (deviceController->commonDebug, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_PRO:
                elements = ARCONTROLLER_Pro_GetCommandElements (deviceController->pro, commandKey, &localError);
                
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_WIFI:
                elements = ARCONTROLLER_Wifi_GetCommandElements (deviceController->wifi, commandKey, &localError);
                
                break;
            
            default :
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error commandKey :%d not known", commandKey);
                break;
        }
        
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return elements;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_AddStateChangedCallback (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_Device_StateChangedCallback_t stateChangedCallback, void *customData)
{
    // -- Add State Changed callback --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_AddCallbackInList (&(deviceController->privatePart->stateChangedCallbacks), stateChangedCallback, customData);
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_AddExtensionStateChangedCallback (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_Device_ExtensionStateChangedCallback_t extensionStateChangedCallback, void *customData)
{
    // -- Add Extension State Changed callback --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_AddExtensionCallbackInList (&(deviceController->privatePart->extensionStateChangedCallbacks), extensionStateChangedCallback, customData);
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_RemoveStateChangedCallback (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_Device_StateChangedCallback_t stateChangedCallback, void *customData)
{
    // -- Remove State Changed Callback --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int locked = 0;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        locked = 1;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_RemoveCallbackFromList (&(deviceController->privatePart->stateChangedCallbacks), stateChangedCallback, customData);
    }
    
    if (locked)
    {
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
        locked = 0;
    }
    
    return error;
}

eARCONTROLLER_DEVICE_STATE ARCONTROLLER_Device_GetState (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_ERROR *error)
{
    // -- Get State --
    
    eARCONTROLLER_DEVICE_STATE state = ARCONTROLLER_DEVICE_STATE_MAX;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        
        state = deviceController->privatePart->state;
        
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return state;
}

eARCONTROLLER_DEVICE_STATE ARCONTROLLER_Device_GetExtensionState (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_ERROR *error)
{
    // -- Get Extension State --
    
    eARCONTROLLER_DEVICE_STATE extensionState = ARCONTROLLER_DEVICE_STATE_MAX;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        
        extensionState = deviceController->privatePart->extensionState;
        
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return extensionState;
}

void ARCONTROLLER_Device_GetExtensionName (ARCONTROLLER_Device_t *deviceController, char *buffer, int bufferSize, eARCONTROLLER_ERROR *error)
{
    // -- Get Extension Name --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL) ||
        (buffer == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        
        if (deviceController->privatePart->extensionName != NULL)
        {
            int desiredChars = snprintf(buffer, bufferSize, "%s", deviceController->privatePart->extensionName);
            if (desiredChars >= bufferSize)
            {
                localError = ARCONTROLLER_ERROR_BUFFER_SIZE;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_STATE;
        }
        
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
}

eARDISCOVERY_PRODUCT ARCONTROLLER_Device_GetExtensionProduct (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_ERROR *error)
{
    // -- Get Extension Product --
    
    eARDISCOVERY_PRODUCT extensionProduct = ARDISCOVERY_PRODUCT_MAX;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
        
        extensionProduct = deviceController->privatePart->extensionProduct;
        
        ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return extensionProduct;
}


/********************
* Private Functions *
*********************/

void *ARCONTROLLER_Device_StartRun (void *data)
{
    // -- Thread Run of Start --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) data;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_StartNetwork (deviceController);
    }
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_SetNetworkControllerToFeatures (deviceController);
    }
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_StartControllerLooperThread (deviceController);
    }
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_RegisterCallbacks (deviceController, NULL);
    }
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_OnStart (deviceController, 0);
    }
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_RUNNING, ARCONTROLLER_OK);
    }
    else
    {
        // Failed or canceled : Stop the DeviceController.
        
        if (deviceController->privatePart->startCancelled)
        {
            // DeviceController start canceled 
            error = ARCONTROLLER_ERROR_CANCELED;
        }
        ARSAL_PRINT(ARSAL_PRINT_INFO, ARCONTROLLER_DEVICE_TAG, "Start failed or canceled.");
        ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_STOPPING, error);
        ARCONTROLLER_Device_StopRun (deviceController);
    }
    
    // Print error
    if (error != ARCONTROLLER_OK)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Start fail error :%s", ARCONTROLLER_Error_ToString (error));
    }
    
    return NULL;
}
void *ARCONTROLLER_Device_StopRun (void *data)
{
    // -- Thread Run of Stop --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) data;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_UnregisterCallbacks (deviceController, NULL);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_StopControllerLooperThread (deviceController);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_StopNetwork (deviceController);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE_STOPPED, ARCONTROLLER_OK);
    }
    //else // TODO see what to do
    //{
    //    ARCONTROLLER_Device_SetState (deviceController, ARCONTROLLER_DEVICE_STATE ???? , ARCONTROLLER_OK;
    //}
    
    // Print error
    if (error != ARCONTROLLER_OK)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Stop fail error :%s", ARCONTROLLER_Error_ToString (error));
    }
    
    return NULL;
}

void *ARCONTROLLER_Device_ExtensionStopRun (void *data)
{
    // -- Thread Run of Stop --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) data;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        switch (deviceController->privatePart->extensionProduct)
        {
            case ARDISCOVERY_PRODUCT_ARDRONE:
            case ARDISCOVERY_PRODUCT_BEBOP_2:
                if (error == ARCONTROLLER_OK && deviceController->aRDrone3 != NULL)
                {
                    error = ARCONTROLLER_Device_UnregisterCallbacks (deviceController, deviceController->aRDrone3);
                }
                
                if (error == ARCONTROLLER_OK)
                {
                    ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
                    ARCONTROLLER_FEATURE_ARDrone3_Delete (&(deviceController->aRDrone3));
                    ARSAL_Mutex_Unlock(&(deviceController->privatePart->mutex));
                }
                break;
            default:
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "device : %d can not be an extension", deviceController->privatePart->extensionProduct);
                error = ARCONTROLLER_ERROR_EXTENSION_PRODUCT_NOT_VALID;
                    break;
        }
    }
    // reset extension values
    if (error == ARCONTROLLER_OK)
    {
        if (deviceController->privatePart->extensionName != NULL)
        {
            free(deviceController->privatePart->extensionName);
            deviceController->privatePart->extensionName = NULL;
        }
        deviceController->privatePart->extensionProduct = ARDISCOVERY_PRODUCT_MAX;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        ARCONTROLLER_Device_SetExtensionState (deviceController, ARCONTROLLER_DEVICE_STATE_STOPPED, ARCONTROLLER_OK);
    }
    //else TODO: see what to do in case of error here
    
    // Print error
    if (error != ARCONTROLLER_OK)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Stop fail error :%s", ARCONTROLLER_Error_ToString (error));
    }
    
    return NULL;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_StartNetwork (ARCONTROLLER_Device_t *deviceController)
{
    // -- Start the Network --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Create the Network Controller
        deviceController->privatePart->networkController = ARCONTROLLER_Network_New (deviceController->privatePart->discoveryDevice, ARCONTROLLER_Device_OnDisconnectCallback, ARCONTROLLER_Device_SendJsonCallback, ARCONTROLLER_Device_ReceiveJsonCallback, deviceController, &error);
    }
    // No else: skipped by an error
    
    if (error == ARCONTROLLER_OK)
    {
        // If device has video
        if (deviceController->privatePart->hasVideo)
        {
            error = ARCONTROLLER_Network_SetVideoReceiveCallback (deviceController->privatePart->networkController, deviceController->privatePart->videoDecoderConfigCallback, deviceController->privatePart->videoReceiveCallback, deviceController->privatePart->videoTimeoutCallback, deviceController->privatePart->videoReceiveCustomData);
        }
    }
    // No else: skipped by an error
    
    if ((error == ARCONTROLLER_OK) && (deviceController->privatePart->hasVideo))
    {
        error = ARCONTROLLER_Network_SetVideoStreamMP4Compliant (deviceController->privatePart->networkController, deviceController->privatePart->videoIsMP4Compliant);
    }
    // No else: skipped by an error

    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_StopNetwork (ARCONTROLLER_Device_t *deviceController)
{
    // -- Stop the Network --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Delete network:
        ARCONTROLLER_Network_Delete (&(deviceController->privatePart->networkController)); //TODO read error !!!!!!!! 
        
    }
    // No else: skipped by an error
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_SetNetworkControllerToFeatures (ARCONTROLLER_Device_t *deviceController)
{
    // -- Set the Network Controoler to the Features --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    eARCONTROLLER_ERROR settingError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if (deviceController->generic != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_Generic_SetNetworkController (deviceController->generic, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_GENERIC; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->aRDrone3 != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_ARDrone3_SetNetworkController (deviceController->aRDrone3, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_ARDRONE3; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->jumpingSumo != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_JumpingSumo_SetNetworkController (deviceController->jumpingSumo, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->miniDrone != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_MiniDrone_SetNetworkController (deviceController->miniDrone, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_MINIDRONE; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->skyController != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_SkyController_SetNetworkController (deviceController->skyController, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->unknown_feature_1 != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_UnknownFeature1_SetNetworkController (deviceController->unknown_feature_1, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->common != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_Common_SetNetworkController (deviceController->common, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMON; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->commonDebug != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_CommonDebug_SetNetworkController (deviceController->commonDebug, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->pro != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_Pro_SetNetworkController (deviceController->pro, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_PRO; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
        if (deviceController->wifi != NULL)
        {
            settingError = ARCONTROLLER_FEATURE_Wifi_SetNetworkController (deviceController->wifi, deviceController->privatePart->networkController);
            if (error != ARCONTROLLER_OK)
            {
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured durring setting the network Controller to the feature of the callback for ARCONTROLLER_DICTIONARY_KEY_WIFI; error :%s", ARCONTROLLER_Error_ToString (settingError));
            }
            
        }
        
    }
    // No else: skipped by an error
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_StartControllerLooperThread (ARCONTROLLER_Device_t *deviceController)
{
    // -- Create the Sending Looper Thread --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if (ARSAL_Thread_Create (&(deviceController->privatePart->controllerLooperThread), ARCONTROLLER_Device_ControllerLooperThread, deviceController) != 0)
        {
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Creation of Controller Looper thread failed.");
            error = ARCONTROLLER_ERROR_INIT_THREAD;
        }
    }
    // No else: skipped by an error
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_StopControllerLooperThread (ARCONTROLLER_Device_t *deviceController)
{
    // -- Create the Sending Looper Thread --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if (deviceController->privatePart->controllerLooperThread != NULL)
        {
            ARSAL_Thread_Join (deviceController->privatePart->controllerLooperThread, NULL);
            ARSAL_Thread_Destroy (&(deviceController->privatePart->controllerLooperThread));
            deviceController->privatePart->controllerLooperThread = NULL;
        }
    }
    // No else: skipped by an error
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_OnStart (ARCONTROLLER_Device_t *deviceController, int isExtensionDevice)
{
    // -- Device On Start --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_SetInitialDate (deviceController);
    }
    // No else: skipped by an error
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_GetInitialSettings (deviceController, isExtensionDevice);
    }
    // No else: skipped by an error
    
    if ((error == ARCONTROLLER_OK) && (!deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_Device_GetInitialStates (deviceController, isExtensionDevice);
    }
    // No else: skipped by an error
    
    // Manage cancel
    if ((error == ARCONTROLLER_OK) && (deviceController->privatePart->startCancelled))
    {
        error = ARCONTROLLER_ERROR_CANCELED;
    }
    // No else: skipped by an error or not canceled
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_SetInitialDate (ARCONTROLLER_Device_t *deviceController)
{
    // -- Set Initial Date --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    time_t currentTime = (time_t)-1;
    struct tm ts;
    char data[20];
    int dataSize = 0;
    char strTime[20];
    int strTimeSize = 0;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        currentTime = time(NULL);
        if (currentTime == ((time_t)-1))
        {
            error = ARCONTROLLER_ERROR_INIT_GET_DATE;
        }
    }
    // No else: skipped by an error
    
    if (error == ARCONTROLLER_OK)
    {
        ts = *localtime(&currentTime);
        dataSize = strftime(data, sizeof(data), "%Y-%m-%d", &ts);
        if (dataSize == 0)
        {
            error = ARCONTROLLER_ERROR_INIT_GET_DATE;
        }
    }
    // No else: skipped by an error
    
    if (error == ARCONTROLLER_OK)
    {
        error = deviceController->common->sendCommonCurrentDate (deviceController->common, data);
    }
    // No else: skipped by an error
    
    if (error == ARCONTROLLER_OK)
    {
        ts = *localtime(&currentTime);
        strTimeSize = strftime(strTime, sizeof(data), "T%H%M%S%z", &ts);
        if (strTimeSize == 0)
        {
            error = ARCONTROLLER_ERROR_INIT_GET_DATE;
        }
    }
    // No else: skipped by an error
    
    if (error == ARCONTROLLER_OK)
    {
        error = deviceController->common->sendCommonCurrentTime (deviceController->common, strTime);
    }
    // No else: skipped by an error
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_GetInitialSettings (ARCONTROLLER_Device_t *deviceController, int onExtensionDevice)
{
    // -- Get initial all Settings --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if (deviceController == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if (!onExtensionDevice && deviceController->skyController != NULL)
        {
            error = deviceController->skyController->sendSettingsAllSettings (deviceController->skyController);
        }
        else
        {
            error = deviceController->common->sendSettingsAllSettings (deviceController->common);
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Sem_Wait (&(deviceController->privatePart->initSem));
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_GetInitialStates (ARCONTROLLER_Device_t *deviceController, int onExtensionDevice)
{
    // -- Get initial all States --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if (deviceController == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        if (!onExtensionDevice && deviceController->skyController != NULL)
        {
            error = deviceController->skyController->sendCommonAllStates (deviceController->skyController);
        }
        else
        {
            error = deviceController->common->sendCommonAllStates (deviceController->common);
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Sem_Wait (&(deviceController->privatePart->initSem));
    }
    
    return error;
}

void ARCONTROLLER_Device_DictionaryChangedCallback (eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_ELEMENT_t *elementDictionary, void *customData)
{
    // -- Callback of changing of a dictionary --
    
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    
    if (error == ARCONTROLLER_OK)
    {
        // Notify All Callback
        ARCONTROLLER_DICTIONARY_NotifyAllCallbackInList (&(deviceController->privatePart->commandCallbacks), commandKey, elementDictionary);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        switch (commandKey)
        {
            case ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_ALLSTATESCHANGED:
            case ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COMMONSTATE_ALLSTATESCHANGED:
                ARCONTROLLER_Device_OnAllStatesEnd (deviceController);
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_ALLSETTINGSCHANGED:
            case ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_ALLSETTINGSCHANGED:
                ARCONTROLLER_Device_OnAllSettingsEnd (deviceController);
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED:
                ARSAL_PRINT (ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Connexion changed received");
                ARCONTROLLER_Device_OnSkyControllerConnectionChangedReceived (deviceController);
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED:
                ARCONTROLLER_Device_OnARDrone3VideoEnableChanged (deviceController, elementDictionary);
                break;
            
            case ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED:
                ARCONTROLLER_Device_OnJumpingSumoVideoEnableChanged (deviceController, elementDictionary);
                break;
            
            default :
                //Do Nothing
                break;
            
        }
        
    }
    
}

void ARCONTROLLER_Device_OnAllStatesEnd (ARCONTROLLER_Device_t *deviceController)
{
    // -- End of receiving of initial all States --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Sem_Post (&(deviceController->privatePart->initSem));
    }
    
}

void ARCONTROLLER_Device_OnAllSettingsEnd (ARCONTROLLER_Device_t *deviceController)
{
    // -- End of receiving of initial all Settings --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Sem_Post (&(deviceController->privatePart->initSem));
    }
    
}

void ARCONTROLLER_Device_OnSkyControllerConnectionChangedReceived (ARCONTROLLER_Device_t *deviceController)
{
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *element = NULL;
    ARCONTROLLER_DICTIONARY_ARG_t *arg = NULL;

    eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS connectionStatus = ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_MAX;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        element = ARCONTROLLER_Device_GetCommandElements(deviceController, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED, &error);
    }
    // read the connection status from the command
    if (error == ARCONTROLLER_OK)
    {
        HASH_FIND_STR (element->arguments, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS, arg);
        if (arg != NULL)
        {
            connectionStatus = arg->value.U8;
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "ConnectionStatus : %i", connectionStatus);
        }
        
        // if not all args are valid, generate an error
        if (connectionStatus == ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_MAX)
        {
            error = ARCONTROLLER_ERROR;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        switch (connectionStatus)
        {
            case ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_CONNECTED:
            {
                ARSAL_Thread_t startingThread = NULL;
                char *productName = NULL;
                eARDISCOVERY_PRODUCT product = ARDISCOVERY_PRODUCT_MAX;
                
                // read product and name
                if (error == ARCONTROLLER_OK)
                {
                    HASH_FIND_STR (element->arguments, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_DEVICENAME, arg);
                    if (arg != NULL)
                    {
                        productName = arg->value.String;
                    }
                    
                    HASH_FIND_STR (element->arguments, ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_DEVICEPRODUCTID, arg);
                    if (arg != NULL)
                    {
                        product = ARDISCOVERY_getProductFromProductID(arg->value.U16);
                    }
                    
                    // if not all args are valid, generate an error
                    if ((productName == NULL) ||
                        (product == ARDISCOVERY_PRODUCT_MAX))
                    {
                        error = ARCONTROLLER_ERROR;
                    }
                }
                
                // product should be of the Bebop family
                if (error == ARCONTROLLER_OK)
                {
                    if (ARDISCOVERY_PRODUCT_FAMILY_ARDRONE != ARDISCOVERY_getProductFamily(product))
                    {
                        error = ARCONTROLLER_ERROR_EXTENSION_PRODUCT_NOT_VALID;
                    }
                }
                
                if (error == ARCONTROLLER_OK)
                {
                    deviceController->privatePart->extensionProduct = product;
                    if (asprintf((&(deviceController->privatePart->extensionName)), "%s", productName) <= 0)
                    {
                        error = ARCONTROLLER_ERROR_ALLOC;
                    }
                }
                
                if (error == ARCONTROLLER_OK)
                {
                    ARCONTROLLER_Device_SetExtensionState(deviceController, ARCONTROLLER_DEVICE_STATE_STARTING, error);
                    if (ARSAL_Thread_Create (&startingThread, ARCONTROLLER_Device_ExtensionStartRun, deviceController) != 0)
                    {
                        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Creation of Starting thread failed.");
                        error = ARCONTROLLER_ERROR_INIT_THREAD;
                    }
                    else
                    {
                        // Destroy the pointer because we don't care about it. The thread will run anyway
                        ARSAL_Thread_Destroy (&startingThread);
                        startingThread = NULL;
                        
                        // TODO: what to do ???
                    }
                }
            }
            break;
            case ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_DISCONNECTING:
            
                ARCONTROLLER_Device_SetExtensionState(deviceController, ARCONTROLLER_DEVICE_STATE_STOPPING, error);
                
                break;
            
            case ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_NOTCONNECTED:
            {
                if (deviceController->privatePart->extensionProduct != ARDISCOVERY_PRODUCT_MAX)
                {
                    ARSAL_Thread_t stoppingThread = NULL;
                    
                    if (ARSAL_Thread_Create (&stoppingThread, ARCONTROLLER_Device_ExtensionStopRun, deviceController) != 0)
                    {
                        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Creation of Stopping thread failed.");
                        error = ARCONTROLLER_ERROR_INIT_THREAD;
                    }
                    else
                    {
                        // Destroy the pointer because we don't care about it. The thread will run anyway
                        ARSAL_Thread_Destroy (&stoppingThread);
                        stoppingThread = NULL;
                        
                        // TODO: what to do ???
                    }
                    
                }
            }
            break;
            
            default:
                break;
        }
    }
    
    if (error != ARCONTROLLER_OK)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error ARController_Device_OnSkyControllerConnectionChangedReceived : %s", ARCONTROLLER_Error_ToString (error));
    }
}
void *ARCONTROLLER_Device_ExtensionStartRun (void *data)
{
    // -- Start the Thread of the Extension --

    // Local declarations
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) data;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;

    switch (deviceController->privatePart->extensionProduct)
    {
        case ARDISCOVERY_PRODUCT_ARDRONE:
        case ARDISCOVERY_PRODUCT_BEBOP_2:
            // TODO: see how to automate this (product AND features)
            ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
            deviceController->aRDrone3 = ARCONTROLLER_FEATURE_ARDrone3_New (deviceController->privatePart->networkController, &error);
            if (error == ARCONTROLLER_OK)
            {
                error = ARCONTROLLER_Device_RegisterCallbacks (deviceController, deviceController->aRDrone3);
            }
            ARSAL_Mutex_Unlock(&(deviceController->privatePart->mutex));
            break;
        
        default:
            error = ARCONTROLLER_ERROR_EXTENSION_PRODUCT_NOT_VALID;
            break;
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Device_OnStart (deviceController, 1);
    }
    
    if (error != ARCONTROLLER_OK)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error ExtensionStartRun : %s", ARCONTROLLER_Error_ToString (error));
    }
    ARCONTROLLER_Device_SetExtensionState (deviceController, ARCONTROLLER_DEVICE_STATE_RUNNING, error);
    
    return NULL;
}

void ARCONTROLLER_Device_OnARDrone3VideoEnableChanged (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_DICTIONARY_ELEMENT_t *elementDictionary)
{
    // -- ARDrone3 video enable changed --

    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_ARG_t *arg = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *element = NULL;
    eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED videoState = ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_MAX;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL)||
        (elementDictionary == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // get the command received in the device controller
        HASH_FIND_STR (elementDictionary, ARCONTROLLER_DICTIONARY_SINGLE_KEY, element);
        
        if (element == NULL)
        {
            error = ARCONTROLLER_ERROR_NO_ELEMENT;
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "element is NULL");
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // get the value
        HASH_FIND_STR (element->arguments, ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED, arg);
        
        if (arg != NULL)
        {
            videoState = arg->value.I32;
        }
        else
        {
            error = ARCONTROLLER_ERROR_NO_ARGUMENTS;
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "argument is NULL");
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        switch (videoState)
        {
            case ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENABLED:
                ARCONTROLLER_Network_StartVideoStream(deviceController->privatePart->networkController);
                break;
                
            case ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_DISABLED:
                ARCONTROLLER_Network_StopVideoStream(deviceController->privatePart->networkController);
                break;
                
            case ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ERROR:
                //Do nothing
                break;
                
            default:
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "videoState unknown :%d ", videoState);
                break;
        }
    }
}

void ARCONTROLLER_Device_OnJumpingSumoVideoEnableChanged (ARCONTROLLER_Device_t *deviceController, ARCONTROLLER_DICTIONARY_ELEMENT_t *elementDictionary)
{
    // -- Jumping Sumo video enable changed --

    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_ARG_t *arg = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *element = NULL;
    eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED videoState = ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_MAX;
    
    // Check parameters
    if ((deviceController == NULL) ||
        (deviceController->privatePart == NULL)||
        (elementDictionary == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // get the command received in the device controller
        HASH_FIND_STR (elementDictionary, ARCONTROLLER_DICTIONARY_SINGLE_KEY, element);
        
        if (element == NULL)
        {
            error = ARCONTROLLER_ERROR_NO_ELEMENT;
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "element is NULL");
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // get the value
        HASH_FIND_STR (element->arguments, ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED, arg);
        
        if (arg != NULL)
        {
            videoState = arg->value.I32;
        }
        else
        {
            error = ARCONTROLLER_ERROR_NO_ARGUMENTS;
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "argument is NULL");
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        switch (videoState)
        {
            case ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENABLED:
                ARCONTROLLER_Network_StartVideoStream(deviceController->privatePart->networkController);
                break;
                
            case ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_DISABLED:
                ARCONTROLLER_Network_StopVideoStream(deviceController->privatePart->networkController);
                break;
                
            case ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ERROR:
                //Do nothing
                break;
                
            default:
                ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "videoState unknown :%d ", videoState);
                break;
        }
    }
}

eARDISCOVERY_ERROR ARCONTROLLER_Device_SendJsonCallback (json_object *jsonObj, void *customData)
{
    // -- Connection callback to receive the Json --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = customData;
    eARDISCOVERY_ERROR error = ARDISCOVERY_OK;
    
    json_object *valueJsonObj = NULL;
    
    // Check parameters
    if ((jsonObj == NULL) ||
        (deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARDISCOVERY_ERROR_BAD_PARAMETER;
    }
    
    if (error == ARDISCOVERY_OK)
    {
        // add ARDISCOVERY_CONNECTION_JSON_CONTROLLER_NAME_KEY
        valueJsonObj = json_object_new_string ("DEFAULT_SDK_CONTROLLER"); //TODO get from the device controller
        json_object_object_add (jsonObj, ARDISCOVERY_CONNECTION_JSON_CONTROLLER_NAME_KEY, valueJsonObj);
        
        // add ARDISCOVERY_CONNECTION_JSON_CONTROLLER_TYPE_KEY
        valueJsonObj = json_object_new_string ("DEFAULT_SDK_TYPE"); //TODO get from the device controller
        json_object_object_add (jsonObj, ARDISCOVERY_CONNECTION_JSON_CONTROLLER_TYPE_KEY, valueJsonObj);
        
    }
    
    return error;
}

eARDISCOVERY_ERROR ARCONTROLLER_Device_ReceiveJsonCallback (json_object *jsonObj, void *customData)
{
     // -- Connection callback to receive the Json --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = customData;
    eARDISCOVERY_ERROR error = ARDISCOVERY_OK;
    
    if ((jsonObj == NULL) ||
        (deviceController == NULL) ||
        (deviceController->privatePart == NULL))
    {
        error = ARDISCOVERY_ERROR_BAD_PARAMETER;
    }
    
    if (error == ARDISCOVERY_OK)
    {
    }
    
    return error;
}

void ARCONTROLLER_Device_OnDisconnectCallback (void *customData)
{
     // -- Disconnection callback --
    
    // Local declarations
    ARCONTROLLER_Device_t *deviceController = (ARCONTROLLER_Device_t *) customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error =ARCONTROLLER_Device_Stop (deviceController);
    }
}

void *ARCONTROLLER_Device_ControllerLooperThread (void *data)
{
    // -- Sending Looper Thread --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_Device_t *deviceController = data;
    u_int8_t cmdBuffer[ARCONTROLLER_DEVICE_DEFAULT_LOOPER_CMD_BUFFER_SIZE];
    int controllerLoopIntervalUs = 0;
    
    // Check parameters
    if ((deviceController == NULL) || (deviceController->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        controllerLoopIntervalUs = MSEC_TO_USEC (deviceController->privatePart->networkConfiguration.controllerLoopIntervalMs);
        if (!(controllerLoopIntervalUs > 0))
        {
            error = ARCONTROLLER_ERROR;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        while ((deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_RUNNING) ||
               (deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_STARTING) ||
               (deviceController->privatePart->state == ARCONTROLLER_DEVICE_STATE_PAUSED))
        {
            //TODO manager pause !!!!!!!!!!!!!!!!!!!!!!!!!
            usleep (controllerLoopIntervalUs);
            
            ARSAL_Mutex_Lock(&(deviceController->privatePart->mutex));
            
            if (deviceController->aRDrone3 != NULL)
            {
                error = ARCONTROLLER_ARDrone3_SendPilotingPCMDStruct (deviceController->aRDrone3, cmdBuffer, ARCONTROLLER_DEVICE_DEFAULT_LOOPER_CMD_BUFFER_SIZE);
                if (error != ARCONTROLLER_OK)
                {
                    ARSAL_PRINT (ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured while send PCMD : %s", ARCONTROLLER_Error_ToString (error));
                }
            }
            
            if (deviceController->jumpingSumo != NULL)
            {
                error = ARCONTROLLER_JumpingSumo_SendPilotingPCMDStruct (deviceController->jumpingSumo, cmdBuffer, ARCONTROLLER_DEVICE_DEFAULT_LOOPER_CMD_BUFFER_SIZE);
                if (error != ARCONTROLLER_OK)
                {
                    ARSAL_PRINT (ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured while send PCMD : %s", ARCONTROLLER_Error_ToString (error));
                }
            }
            
            if (deviceController->miniDrone != NULL)
            {
                error = ARCONTROLLER_MiniDrone_SendPilotingPCMDStruct (deviceController->miniDrone, cmdBuffer, ARCONTROLLER_DEVICE_DEFAULT_LOOPER_CMD_BUFFER_SIZE);
                if (error != ARCONTROLLER_OK)
                {
                    ARSAL_PRINT (ARSAL_PRINT_ERROR, ARCONTROLLER_DEVICE_TAG, "Error occured while send PCMD : %s", ARCONTROLLER_Error_ToString (error));
                }
            }
            
            ARSAL_Mutex_Unlock(&(deviceController->privatePart->mutex));
        }
    }
    
    return NULL;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_AddCallbackInList (ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t **callbackList, ARCONTROLLER_Device_StateChangedCallback_t callback, void *customData)
{
    // -- Add callback in array --
    
    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *newElement = NULL;

    // Add the callback
    newElement = malloc (sizeof(ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t));
    if (newElement != NULL)
    {
        newElement->callback = callback;
        newElement->customData = customData;
        DL_APPEND ((*callbackList), newElement);
    }
    else
    {
        error = ARCONTROLLER_ERROR_ALLOC;
    }

    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_AddExtensionCallbackInList (ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t **callbackList, ARCONTROLLER_Device_ExtensionStateChangedCallback_t callback, void *customData)
{
    // -- Add extension callback in array --
    
    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *newElement = NULL;

    // Add the callback
    newElement = malloc (sizeof(ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t));
    if (newElement != NULL)
    {
        newElement->callback = callback;
        newElement->customData = customData;
        DL_APPEND ((*callbackList), newElement);
    }
    else
    {
        error = ARCONTROLLER_ERROR_ALLOC;
    }

    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_RemoveCallbackFromList (ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t **callbackList, ARCONTROLLER_Device_StateChangedCallback_t callback, void *customData)
{
    // -- Remove callback from array --

    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *elementFind = NULL;
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t likeElement;

    // Element to find
    likeElement.callback = callback;
    likeElement.customData = customData;

    DL_SEARCH ((*callbackList), elementFind, &likeElement, ARCONTROLLER_Device_ElementCompare);
    if (elementFind != NULL)
    {
        DL_DELETE ((*callbackList), elementFind);
    }
    else
    {
        error = ARCONTROLLER_ERROR_COMMAND_CALLBACK_NOT_REGISTERED;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_Device_RemoveExtensionCallbackFromList (ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t **callbackList, ARCONTROLLER_Device_ExtensionStateChangedCallback_t callback, void *customData)
{
    // -- Remove callback from array --

    // Local declarations
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *elementFind = NULL;
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t likeElement;

    // Element to find
    likeElement.callback = callback;
    likeElement.customData = customData;

    DL_SEARCH ((*callbackList), elementFind, &likeElement, ARCONTROLLER_Device_ExtensionElementCompare);
    if (elementFind != NULL)
    {
        DL_DELETE ((*callbackList), elementFind);
    }
    else
    {
        error = ARCONTROLLER_ERROR_COMMAND_CALLBACK_NOT_REGISTERED;
    }
    
    return error;
}

void ARCONTROLLER_Device_DeleteCallbackList (ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t **callbackList)
{
    // -- Delete all callback in array --
    
    // Local declarations
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *element = NULL;
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *elementTmp = NULL;

    // Delete each element, use the safe iterator
    DL_FOREACH_SAFE ((*callbackList), element, elementTmp)
    {
        DL_DELETE ((*callbackList), element);
    }
}

void ARCONTROLLER_Device_DeleteExtensionCallbackList (ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t **callbackList)
{
    // -- Delete all callback in array --
    
    // Local declarations
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *element = NULL;
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *elementTmp = NULL;

    // Delete each element, use the safe iterator
    DL_FOREACH_SAFE ((*callbackList), element, elementTmp)
    {
        DL_DELETE ((*callbackList), element);
    }
}

void ARCONTROLLER_Device_NotifyAllCallbackInList (ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t **callbackList, eARCONTROLLER_DEVICE_STATE state, eARCONTROLLER_ERROR error)
{
    // -- Notify all listeners --
    
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *callbackElement = NULL;
    ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *callbackElementTmp = NULL;

    // for each callback
    DL_FOREACH_SAFE ((*callbackList), callbackElement, callbackElementTmp)
    {
        if (callbackElement->callback != NULL)
        {
            callbackElement->callback (state, error, callbackElement->customData);
        }
    }
}

void ARCONTROLLER_Device_NotifyAllExtensionCallbackInList (ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t **callbackList, eARCONTROLLER_DEVICE_STATE state, eARDISCOVERY_PRODUCT product, const char *name, eARCONTROLLER_ERROR error)
{
    // -- Notify all listeners --
    
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *callbackElement = NULL;
    ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *callbackElementTmp = NULL;

    // for each callback
    DL_FOREACH_SAFE ((*callbackList), callbackElement, callbackElementTmp)
    {
        if (callbackElement->callback != NULL)
        {
            callbackElement->callback (state, product, name, error, callbackElement->customData);
        }
    }
}

void ARCONTROLLER_Device_SetState (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_DEVICE_STATE state,  eARCONTROLLER_ERROR error)
{
    // -- Set the Device Controller State and notify all listeners.
    
    ARSAL_Mutex_Lock (&(deviceController->privatePart->mutex));
    deviceController->privatePart->state = state;
    ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    ARCONTROLLER_Device_NotifyAllCallbackInList (&(deviceController->privatePart->stateChangedCallbacks), deviceController->privatePart->state, error);
    
}

void ARCONTROLLER_Device_SetExtensionState (ARCONTROLLER_Device_t *deviceController, eARCONTROLLER_DEVICE_STATE state,  eARCONTROLLER_ERROR error)
{
    // -- Set the Device Controller Extension State and notify all listeners.
    
    ARSAL_Mutex_Lock (&(deviceController->privatePart->mutex));
    deviceController->privatePart->extensionState = state;
    ARSAL_Mutex_Unlock (&(deviceController->privatePart->mutex));
    ARCONTROLLER_Device_NotifyAllExtensionCallbackInList (&(deviceController->privatePart->extensionStateChangedCallbacks), deviceController->privatePart->extensionState, deviceController->privatePart->extensionProduct, deviceController->privatePart->extensionName, error);
    
}

/*****************************************
 *
 *             local implementation:
 *
 ****************************************/

static int ARCONTROLLER_Device_ElementCompare(ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *a, ARCONTROLLER_Device_STATECHANGEDCALLBACKELEMENT_t *b)
{
    return !((a->callback == b->callback) && (a->customData == b->customData));
}

static int ARCONTROLLER_Device_ExtensionElementCompare(ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *a, ARCONTROLLER_Device_EXTENSIONSTATECHANGEDCALLBACKELEMENT_t *b)
{
    return !((a->callback == b->callback) && (a->customData == b->customData));
}

