/*
 * Copyright 2017 Fraunhofer Institute for Manufacturing Engineering and Automation (IPA)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#ifndef __GENERIC_ARM_CTRL_V4_H_
#define __GENERIC_ARM_CTRL_V4_H_

#include "ros/ros.h"
//#include "Manipulation/ManipUtil/Joint.h"
//#include "ManipUtil/datastructsManipulator.h"
//#include "ManipUtil/ManipulatorXML.h"
//#include "Interfaces/KinematicsInterface.h"
//#include "Interfaces/armInterface_ctrl.h"

#include <trajectory_msgs/JointTrajectory.h>

#include <cob_trajectory_controller/RefVal_JS.h>
#include <cob_trajectory_controller/TimeStamp.h>

class genericArmCtrl
{
	public:

		genericArmCtrl(int DOF, double PTPvel = 0.7, double PTPacc = 0.2, double maxError = 0.7);
		~genericArmCtrl();

		std::vector<double> GetPTPvel() const;
		std::vector<double> GetPTPacc() const;
		void SetPTPvel(double vel);
		void SetPTPacc(double acc);

		double overlap_time;

		// void stop(); --> TODO: better reset

		bool step(std::vector<double> current_pos, std::vector<double> & desired_vel);

		bool moveThetas(std::vector<double> conf_goal, std::vector<double> conf_current);
		bool moveTrajectory(trajectory_msgs::JointTrajectory pfad, std::vector<double> conf_current);


//		bool movePos(AbsPos position);

		int m_DOF;

		RefVal_JS* m_pRefVals;

		std::vector<double> m_vel_js;
		std::vector<double> last_q;
		std::vector<double> last_q1;
		std::vector<double> last_q2;
		std::vector<double> last_q3;
		std::vector<double> m_acc_js;
		bool isMoving;

		TimeStamp startTime_;
		double TotalTime_;
		double m_P;
		double m_Vorsteuer;
		double m_AllowedError;
		double m_CurrentError;
		double m_TargetError;
		double m_ExtraTime;	// Zusätzliche Zeit, um evtl. verbleibende Regelfehler auszuregeln
};



#endif
