/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * Copyright (c) 2016 University of Connecticut
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Robert Martin <robert.martin@engr.uconn.edu>
 */

#ifndef AQUA_SIM_PT_TAG_H
#define AQUA_SIM_PT_TAG_H

#include "ns3/tag.h"

namespace ns3 {

/**
 * \ingroup aqua-sim-ng
 *
 * \brief Generic packet tag used to assist in declaring protocols used for each packet
 */
class AquaSimPtTag : public Tag
{
public:
  AquaSimPtTag();

  void SetPacketType(uint16_t pt);
  uint16_t GetPacketType() const;

  static TypeId GetTypeId(void);
  virtual TypeId GetInstanceTypeId (void) const;
  virtual uint32_t GetSerializedSize (void) const;
  virtual void Serialize (TagBuffer i) const;
  virtual void Deserialize (TagBuffer i);
  virtual void Print (std::ostream &os) const;

  typedef enum {
        // add by Peng Xie
    PT_UWVB,
    PT_UWVBVA,
    PT_RMAC,
    PT_TMAC,
        // DBR packets : hai
    PT_DBR,
        //added by Yibo Zhu
        /*UWAN-MAC*/
    PT_UWAN_SYNC,
    PT_UWAN_ML,
    PT_UWAN_HELLO,
    PT_OTMAN, /*COPE-MAC*/
    PT_FAMA,  /*FAMA*/
    PT_SFAMA, /*Slotted FAMA*/
    PT_UW_SROUTE,  /*Static Routing for Underwater*/
    PT_UW_MESSAGE, /*the packet generated by uw_sink agent*/
    PT_UWALOHA,
    PT_UW_DROUTING,
        /*for Geo-MAC GOAL*/
    PT_GOAL_REQ,
    PT_GOAL_REP,
    PT_GOAL_ACK,
    } PacketType_tag;

private:
  uint16_t m_packetType;
};  // class AquaSimPtTag

}; // namespace ns3

#endif // AQUA_SIM_PT_TAG_H
