// !!! DO NOT EDIT THIS FILE - IT'S ONLY A CONVENCIENCE COPY OF THE CORRESPONDING *Shader.h FILE !!!

#version 410 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 2) in vec4 vtranslation_and_scale; //(x,y,z) contain the translation and (w) the scal factor

// Ouput data
out vec4 fragmentColor;

// Values that stay constant for the whole mesh.
uniform mat4 VP;

uniform vec4 startColor;
uniform vec4 endColor;
// if interpolation is false, no color interpolation takes place. The startColor will be used.
uniform bool interpolation;
uniform vec3 interpolationLength;
uniform vec3 translationOffset;

void main(){
  vec3 v_translation = vtranslation_and_scale.xyz + translationOffset;
  float scale = vtranslation_and_scale.w;

  // this matrix scales the vertex and then translate it
  mat4 M = mat4(vec4(scale,0,0,0),
                vec4(0,scale,0,0),
                vec4(0,0,scale,0),
                vec4(v_translation,1));

  // calculate position
  gl_Position = VP * M * vec4(vertexPosition_modelspace, 1.0f);
  gl_PointSize = 6.f;

  // calculate the interpolated color
  if (interpolation) {
    float vertexPos_world_z = v_translation.z + scale * vertexPosition_modelspace.z;
    float a = (mod(vertexPos_world_z, interpolationLength.z)) / interpolationLength.z;
    a = a > 0.5f ? -2*a+2 : 2*a;
    fragmentColor = (a * startColor + (1 - a) * endColor);
  }
  else {
    fragmentColor = startColor;
  }
}
