# Wrappers for Intel® RealSense™ Technology

* [Python](./python/) - Supports both Python 2 and 3
* [Node.js](./nodejs) - Support Node.js v6 above
* [ROS](https://github.com/intel-ros/realsense/releases) - Integration with Robot Operating System
* [LabVIEW](./labview) - Integration with National Instruments LabVIEW
* [OpenCV](./opencv) - Integration with OpenCV computer-vision library
* [DLIB](./dlib) - Integration with DLIB computer-vision library
* [OpenVINO](./openvino) - Integration with OpenVINO™ toolkit
* [PCL](./pcl) - Basic integration with the Point-Cloud Library
* [.NET](./csharp) - Support for .NET languages with examples in C#
* [Unity](./unity) - Unity assets for using RealSense SDK 2.0
* [Matlab](./matlab) - Supports 64bit Windows installations
* [OpenNI2](./openni2) - OpenNI2 integration
* [Unreal Engine 4](./unrealengine4) - Unreal Engine 4 integration

If you are interested in official support for a language / framework, please let us know via [a new Issue](https://github.com/IntelRealSense/librealsense/issues/new)

## Community Projects:

* [Java](https://github.com/edwinRNDR/librealsense/tree/master/wrappers/java) - community effort to add Java support ([word of causion by the author](https://github.com/IntelRealSense/librealsense/issues/1594#issuecomment-429216051))
> A warm **thank you** to [@edwinRNDR](https://github.com/edwinRNDR) and [@cansik](https://github.com/cansik) for further expanding RealSense eco-system!
