# Locomotor, [I choo choo choose you](http://orig03.deviantart.net/70c5/f/2010/040/4/1/i_choo_choo_choose_you_card_by_mrockz.png)

The main idea of locomotor is to isolate each action (updating the costmaps, and making the plans) and allow the user to control what happens when each event succeeds or fails. By using callbacks generated by the `Locomotor` class, users can implement their own state machine and customize the robot's behavior.

The customizability also includes the ability to control which thread each action runs in. This package provides the `Executor` class which creates a new `ros::CallbackQueue` (i.e. thread). The simplest version can run with a single `Executor` using the global `CallbackQueue` in a single thread, but an arbitrary number can be employed. The costmap/planner actions are run within specific `Exector`s.

## nav_core2 components
First, the robot's goal is specified via the `setGoal` function. To navigate to that goal, we have four primary components, the two planners and their associated costmaps.

 * Global and Local `Costmap`s - Provide the `update()` method.
 * `GlobalPlanner` - provides the `makePlan` method.
 * `LocalPlanner` - provides the `computeVelocityCommands` method and others

To add one of these actions to the callback queue, you make a request, and then the actual work is done in another function, executed from the callback queue:

Component        | Request                        | Actual Execution
---------------- | ------------------------------ | -----------------
Global `Costmap` | `requestGlobalCostmapUpdate()` | `doCostmapUpdate()`
Local `Costmap`  | `requestLocalCostmapUpdate()`  | `doCostmapUpdate()`
`GlobalPlanner`  | `requestGlobalPlan()`          | `makeGlobalPlan()`
`LocalPlanner`   | `requestLocalPlan()`           | `makeLocalPlan()`

The parameters for these methods (not shown here) specify
 * which executor to do the work with
 * a callback for when the action succeeds
 * a callback for when the action fails
 * which executor's callback queue to put the callback

The `requestLocalPlan()` function also specifies a callback for what to do if the robot has reached its goal, and the navigation is complete. For whatever reason, if the robot is unable to complete the navigation, you can `requestNavigationFailure` which will trigger a separate callback to handle that.

## Plugin Management
The `Costmap`s are loaded via a simple `pluginlib` interface, on the assumption that there will be just one Global Costmap and one Local Costmap.

However, the planners are loaded using [the Plugin Mux utility](../../nav_2d_utils/doc/PluginMux.md) so that multiple different planners are available for switching between. Any number of (local and global) planners are loaded into different namespaces. However, only one is marked as active at any particular time. This allows for easy switching between planners, done using the string namespace.

One could easily imagine handling different types of Goals by first setting which planners to use, i.e. if you receive a Docking goal, you could set the local planner to the docking local planner and then attempt to dock.

## Publishing
The `Locomotor` class also contains two Publisher objects for publishing the global plan and the commanded velocity. These are separated into separate objects to allow for switching between different published data types.
 * The global plan can be published as `nav_msgs::Path` (default) or `nav_2d_msgs::Path2D`, or not at all.
 * The command velocity can be published as `geometry_msgs::Twist` (default), `nav_2d_msgs::Twist2DStamped`, `nav_2d_msgs::Twist2D` or not at all.

In addition, the global plan can be compressed before publishing, by specifying a non-negative `global_plan_epsilon` (default is 0.1). The larger the epsilon, the more the path is compressed.
