/**
 * Copyright (c) 2018, University Osnabrück
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University Osnabrück nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL University Osnabrück BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 /*
 * MCTable.hpp
 *
 *  Created on: 04.02.2011
 *      Author: Thomas Wiemann
 */

#ifndef __MCTABLE_HPP__
#define __MCTABLE_HPP__

namespace lvr2
{

const static int MCTable[256][13] =
    {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 3, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 9, 0, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 3, 1, 8, 1, 9,-1,-1,-1,-1,-1,-1,-1},
    {11, 1, 2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 3, 0, 1, 2,11,-1,-1,-1,-1,-1,-1,-1},
    { 9, 0, 2, 9, 2,11,-1,-1,-1,-1,-1,-1,-1},
    { 3, 2, 8, 2,11, 8, 8,11, 9,-1,-1,-1,-1},
    {10, 2, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    {10, 2, 0,10, 0, 8,-1,-1,-1,-1,-1,-1,-1},
    {10, 2, 3, 0, 1, 9,-1,-1,-1,-1,-1,-1,-1},
    { 2, 1,10, 1, 9,10,10, 9, 8,-1,-1,-1,-1},
    {11, 1, 3,11, 3,10,-1,-1,-1,-1,-1,-1,-1},
    { 1, 0,11, 0, 8,11,11, 8,10,-1,-1,-1,-1},
    { 0, 3, 9, 3,10, 9, 9,10,11,-1,-1,-1,-1},
    { 8,11, 9, 8,10,11,-1,-1,-1,-1,-1,-1,-1},
    { 8, 4, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 3, 0, 4, 3, 4, 7,-1,-1,-1,-1,-1,-1,-1},
    { 1, 9, 0, 8, 4, 7,-1,-1,-1,-1,-1,-1,-1},
    { 9, 4, 1, 4, 7, 1, 1, 7, 3,-1,-1,-1,-1},
    {11, 1, 2, 8, 4, 7,-1,-1,-1,-1,-1,-1,-1},
    { 2,11, 1, 0, 4, 7, 0, 7, 3,-1,-1,-1,-1},
    { 4, 7, 8, 0, 2,11, 0,11, 9,-1,-1,-1,-1},
    { 2, 7, 3, 2, 9, 7, 7, 9, 4, 2,11, 9,-1},
    { 2, 3,10, 7, 8, 4,-1,-1,-1,-1,-1,-1,-1},
    { 7,10, 4,10, 2, 4, 4, 2, 0,-1,-1,-1,-1},
    { 3,10, 2, 4, 7, 8, 9, 0, 1,-1,-1,-1,-1},
    { 2, 7,10, 2, 1, 7, 1, 4, 7, 1, 9, 4,-1},
    { 8, 4, 7,10,11, 1,10, 1, 3,-1,-1,-1,-1},
    {10, 4, 7, 1, 4,10, 1,10,11, 1, 0, 4,-1},
    { 3, 8, 0, 7,10, 4,10, 9, 4,10,11, 9,-1},
    { 7,10, 4, 4,10, 9,10,11, 9,-1,-1,-1,-1},
    { 9, 5, 4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 3, 0, 8, 4, 9, 5,-1,-1,-1,-1,-1,-1,-1},
    { 5, 4, 0, 5, 0, 1,-1,-1,-1,-1,-1,-1,-1},
    { 4, 8, 5, 8, 3, 5, 5, 3, 1,-1,-1,-1,-1},
    { 2,11, 1, 9, 5, 4,-1,-1,-1,-1,-1,-1,-1},
    { 0, 8, 3, 5, 4, 9,11, 1, 2,-1,-1,-1,-1},
    {11, 5, 2, 5, 4, 2, 2, 4, 0,-1,-1,-1,-1},
    { 3, 4, 8, 3, 2, 4, 2, 5, 4, 2,11, 5,-1},
    {10, 2, 3, 9, 5, 4,-1,-1,-1,-1,-1,-1,-1},
    { 9, 5, 4, 8,10, 2, 8, 2, 0,-1,-1,-1,-1},
    { 3,10, 2, 1, 5, 4, 1, 4, 0,-1,-1,-1,-1},
    { 8, 5, 4, 2, 5, 8, 2, 8,10, 2, 1, 5,-1},
    { 5, 4, 9, 1, 3,10, 1,10,11,-1,-1,-1,-1},
    { 0, 9, 1, 4, 8, 5, 8,11, 5, 8,10,11,-1},
    { 3, 4, 0, 3,11, 4, 4,11, 5, 3,10,11,-1},
    { 4, 8, 5, 5, 8,11, 8,10,11,-1,-1,-1,-1},
    { 9, 5, 7, 9, 7, 8,-1,-1,-1,-1,-1,-1,-1},
    { 0, 9, 3, 9, 5, 3, 3, 5, 7,-1,-1,-1,-1},
    { 8, 0, 7, 0, 1, 7, 7, 1, 5,-1,-1,-1,-1},
    { 1, 7, 3, 1, 5, 7,-1,-1,-1,-1,-1,-1,-1},
    { 1, 2,11, 5, 7, 8, 5, 8, 9,-1,-1,-1,-1},
    { 9, 1, 0,11, 5, 2, 5, 3, 2, 5, 7, 3,-1},
    { 5, 2,11, 8, 2, 5, 8, 5, 7, 8, 0, 2,-1},
    {11, 5, 2, 2, 5, 3, 5, 7, 3,-1,-1,-1,-1},
    {10, 2, 3, 8, 9, 5, 8, 5, 7,-1,-1,-1,-1},
    { 9, 2, 0, 9, 7, 2, 2, 7,10, 9, 5, 7,-1},
    { 0, 3, 8, 2, 1,10, 1, 7,10, 1, 5, 7,-1},
    { 2, 1,10,10, 1, 7, 1, 5, 7,-1,-1,-1,-1},
    { 3, 9, 1, 3, 8, 9, 7,10,11, 7,11, 5,-1},
    { 9, 1, 0,11, 7,10,11, 5, 7,-1,-1,-1,-1},
    { 3, 8, 0, 7,11, 5, 7,10,11,-1,-1,-1,-1},
    {10, 5, 7,10,11, 5,-1,-1,-1,-1,-1,-1,-1},
    {11, 6, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 3, 0,11, 6, 5,-1,-1,-1,-1,-1,-1,-1},
    { 0, 1, 9, 5,11, 6,-1,-1,-1,-1,-1,-1,-1},
    {11, 6, 5, 9, 8, 3, 9, 3, 1,-1,-1,-1,-1},
    { 1, 2, 6, 1, 6, 5,-1,-1,-1,-1,-1,-1,-1},
    { 0, 8, 3, 2, 6, 5, 2, 5, 1,-1,-1,-1,-1},
    { 5, 9, 6, 9, 0, 6, 6, 0, 2,-1,-1,-1,-1},
    { 9, 6, 5, 3, 6, 9, 3, 9, 8, 3, 2, 6,-1},
    { 3,10, 2,11, 6, 5,-1,-1,-1,-1,-1,-1,-1},
    { 6, 5,11, 2, 0, 8, 2, 8,10,-1,-1,-1,-1},
    { 1, 9, 0, 6, 5,11,10, 2, 3,-1,-1,-1,-1},
    { 1,11, 2, 5, 9, 6, 9,10, 6, 9, 8,10,-1},
    {10, 6, 3, 6, 5, 3, 3, 5, 1,-1,-1,-1,-1},
    { 0, 5, 1, 0,10, 5, 5,10, 6, 0, 8,10,-1},
    { 0, 5, 9, 0, 3, 5, 3, 6, 5, 3,10, 6,-1},
    { 5, 9, 6, 6, 9,10, 9, 8,10,-1,-1,-1,-1},
    {11, 6, 5, 4, 7, 8,-1,-1,-1,-1,-1,-1,-1},
    { 5,11, 6, 7, 3, 0, 7, 0, 4,-1,-1,-1,-1},
    { 5,11, 6, 0, 1, 9, 8, 4, 7,-1,-1,-1,-1},
    { 4, 5, 9, 6, 7,11, 7, 1,11, 7, 3, 1,-1},
    { 7, 8, 4, 5, 1, 2, 5, 2, 6,-1,-1,-1,-1},
    { 4, 1, 0, 4, 5, 1, 6, 7, 3, 6, 3, 2,-1},
    { 9, 4, 5, 8, 0, 7, 0, 6, 7, 0, 2, 6,-1},
    { 4, 5, 9, 6, 3, 2, 6, 7, 3,-1,-1,-1,-1},
    { 7, 8, 4, 2, 3,10,11, 6, 5,-1,-1,-1,-1},
    {10, 6, 7,11, 2, 5, 2, 4, 5, 2, 0, 4,-1},
    {10, 6, 7, 8, 0, 3, 1,11, 2, 9, 4, 5,-1},
    { 6, 7,10, 1,11, 2, 9, 4, 5,-1,-1,-1,-1},
    { 6, 7,10, 4, 5, 8, 5, 3, 8, 5, 1, 3,-1},
    { 6, 7,10, 4, 1, 0, 4, 5, 1,-1,-1,-1,-1},
    { 4, 5, 9, 3, 8, 0,10, 6, 7,-1,-1,-1,-1},
    { 9, 4, 5, 7,10, 6,-1,-1,-1,-1,-1,-1,-1},
    {11, 6, 4,11, 4, 9,-1,-1,-1,-1,-1,-1,-1},
    { 8, 3, 0, 9,11, 6, 9, 6, 4,-1,-1,-1,-1},
    { 1,11, 0,11, 6, 0, 0, 6, 4,-1,-1,-1,-1},
    { 8, 6, 4, 8, 1, 6, 6, 1,11, 8, 3, 1,-1},
    { 9, 1, 4, 1, 2, 4, 4, 2, 6,-1,-1,-1,-1},
    { 1, 0, 9, 3, 2, 8, 2, 4, 8, 2, 6, 4,-1},
    { 2, 4, 0, 2, 6, 4,-1,-1,-1,-1,-1,-1,-1},
    { 3, 2, 8, 8, 2, 4, 2, 6, 4,-1,-1,-1,-1},
    { 2, 3,10, 6, 4, 9, 6, 9,11,-1,-1,-1,-1},
    { 0,11, 2, 0, 9,11, 4, 8,10, 4,10, 6,-1},
    {11, 2, 1,10, 6, 3, 6, 0, 3, 6, 4, 0,-1},
    {11, 2, 1,10, 4, 8,10, 6, 4,-1,-1,-1,-1},
    { 1, 4, 9,10, 4, 1,10, 1, 3,10, 6, 4,-1},
    { 0, 9, 1, 4,10, 6, 4, 8,10,-1,-1,-1,-1},
    {10, 6, 3, 3, 6, 0, 6, 4, 0,-1,-1,-1,-1},
    { 8, 6, 4, 8,10, 6,-1,-1,-1,-1,-1,-1,-1},
    { 6, 7,11, 7, 8,11,11, 8, 9,-1,-1,-1,-1},
    { 9, 3, 0, 6, 3, 9, 6, 9,11, 6, 7, 3,-1},
    { 6, 1,11, 6, 7, 1, 7, 0, 1, 7, 8, 0,-1},
    { 6, 7,11,11, 7, 1, 7, 3, 1,-1,-1,-1,-1},
    { 7, 2, 6, 7, 9, 2, 2, 9, 1, 7, 8, 9,-1},
    { 1, 0, 9, 3, 6, 7, 3, 2, 6,-1,-1,-1,-1},
    { 8, 0, 7, 7, 0, 6, 0, 2, 6,-1,-1,-1,-1},
    { 2, 7, 3, 2, 6, 7,-1,-1,-1,-1,-1,-1,-1},
    { 7,10, 6, 3, 8, 2, 8,11, 2, 8, 9,11,-1},
    {10, 6, 7,11, 0, 9,11, 2, 0,-1,-1,-1,-1},
    { 2, 1,11, 7,10, 6, 8, 0, 3,-1,-1,-1,-1},
    { 1,11, 2, 6, 7,10,-1,-1,-1,-1,-1,-1,-1},
    { 7,10, 6, 3, 9, 1, 3, 8, 9,-1,-1,-1,-1},
    { 9, 1, 0,10, 6, 7,-1,-1,-1,-1,-1,-1,-1},
    { 0, 3, 8,10, 6, 7,-1,-1,-1,-1,-1,-1,-1},
    {10, 6, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    {10, 7, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 0, 8, 3,10, 7, 6,-1,-1,-1,-1,-1,-1,-1},
    { 9, 0, 1,10, 7, 6,-1,-1,-1,-1,-1,-1,-1},
    { 7, 6,10, 3, 1, 9, 3, 9, 8,-1,-1,-1,-1},
    { 1, 2,11, 6,10, 7,-1,-1,-1,-1,-1,-1,-1},
    { 2,11, 1, 7, 6,10, 8, 3, 0,-1,-1,-1,-1},
    {10, 7, 6,11, 9, 0,11, 0, 2,-1,-1,-1,-1},
    { 7, 6,10, 3, 2, 8, 8, 2,11, 8,11, 9,-1},
    { 2, 3, 7, 2, 7, 6,-1,-1,-1,-1,-1,-1,-1},
    { 8, 7, 0, 7, 6, 0, 0, 6, 2,-1,-1,-1,-1},
    { 1, 9, 0, 3, 7, 6, 3, 6, 2,-1,-1,-1,-1},
    { 7, 6, 2, 7, 2, 9, 2, 1, 9, 7, 9, 8,-1},
    { 6,11, 7,11, 1, 7, 7, 1, 3,-1,-1,-1,-1},
    { 6,11, 1, 6, 1, 7, 7, 1, 0, 7, 0, 8,-1},
    { 9, 0, 3, 6, 9, 3, 6,11, 9, 6, 3, 7,-1},
    { 6,11, 7, 7,11, 8,11, 9, 8,-1,-1,-1,-1},
    { 8, 4, 6, 8, 6,10,-1,-1,-1,-1,-1,-1,-1},
    {10, 3, 6, 3, 0, 6, 6, 0, 4,-1,-1,-1,-1},
    { 0, 1, 9, 4, 6,10, 4,10, 8,-1,-1,-1,-1},
    { 1, 9, 4,10, 1, 4,10, 3, 1,10, 4, 6,-1},
    {11, 1, 2,10, 8, 4,10, 4, 6,-1,-1,-1,-1},
    {11, 1, 2,10, 3, 6, 6, 3, 0, 6, 0, 4,-1},
    { 0, 2,11, 0,11, 9, 4,10, 8, 4, 6,10,-1},
    { 2,10, 3, 6, 9, 4, 6,11, 9,-1,-1,-1,-1},
    { 3, 8, 2, 8, 4, 2, 2, 4, 6,-1,-1,-1,-1},
    { 2, 0, 4, 2, 4, 6,-1,-1,-1,-1,-1,-1,-1},
    { 1, 9, 0, 3, 8, 2, 2, 8, 4, 2, 4, 6,-1},
    { 9, 4, 1, 1, 4, 2, 4, 6, 2,-1,-1,-1,-1},
    { 8, 4, 6, 8, 6, 1, 6,11, 1, 8, 1, 3,-1},
    { 1, 0,11,11, 0, 6, 0, 4, 6,-1,-1,-1,-1},
    { 8, 0, 3, 9, 6,11, 9, 4, 6,-1,-1,-1,-1},
    {11, 4, 6,11, 9, 4,-1,-1,-1,-1,-1,-1,-1},
    { 9, 5, 4, 7, 6,10,-1,-1,-1,-1,-1,-1,-1},
    { 4, 9, 5, 3, 0, 8,10, 7, 6,-1,-1,-1,-1},
    { 6,10, 7, 4, 0, 1, 4, 1, 5,-1,-1,-1,-1},
    { 6,10, 7, 4, 8, 5, 5, 8, 3, 5, 3, 1,-1},
    { 6,10, 7, 1, 2,11, 9, 5, 4,-1,-1,-1,-1},
    {10, 7, 6, 8, 3, 0, 1, 2,11, 9, 5, 4,-1},
    {10, 7, 6,11, 5, 2, 2, 5, 4, 2, 4, 0,-1},
    { 7, 4, 8, 2,10, 3,11, 5, 6,-1,-1,-1,-1},
    { 4, 9, 5, 6, 2, 3, 6, 3, 7,-1,-1,-1,-1},
    { 9, 5, 4, 8, 7, 0, 0, 7, 6, 0, 6, 2,-1},
    { 4, 0, 1, 4, 1, 5, 6, 3, 7, 6, 2, 3,-1},
    { 7, 4, 8, 5, 2, 1, 5, 6, 2,-1,-1,-1,-1},
    { 4, 9, 5, 6,11, 7, 7,11, 1, 7, 1, 3,-1},
    { 5, 6,11, 0, 9, 1, 8, 7, 4,-1,-1,-1,-1},
    { 5, 6,11, 7, 0, 3, 7, 4, 0,-1,-1,-1,-1},
    {11, 5, 6, 4, 8, 7,-1,-1,-1,-1,-1,-1,-1},
    { 5, 6, 9, 6,10, 9, 9,10, 8,-1,-1,-1,-1},
    { 0, 9, 5, 0, 5, 3, 3, 5, 6, 3, 6,10,-1},
    { 0, 1, 5, 0, 5,10, 5, 6,10, 0,10, 8,-1},
    {10, 3, 6, 6, 3, 5, 3, 1, 5,-1,-1,-1,-1},
    { 1, 2,11, 5, 6, 9, 9, 6,10, 9,10, 8,-1},
    { 1, 0, 9, 6,11, 5,10, 3, 2,-1,-1,-1,-1},
    { 6,11, 5, 2, 8, 0, 2,10, 8,-1,-1,-1,-1},
    { 3, 2,10,11, 5, 6,-1,-1,-1,-1,-1,-1,-1},
    { 9, 5, 6, 3, 9, 6, 3, 8, 9, 3, 6, 2,-1},
    { 5, 6, 9, 9, 6, 0, 6, 2, 0,-1,-1,-1,-1},
    { 0, 3, 8, 2, 5, 6, 2, 1, 5,-1,-1,-1,-1},
    { 1, 6, 2, 1, 5, 6,-1,-1,-1,-1,-1,-1,-1},
    {11, 5, 6, 9, 3, 8, 9, 1, 3,-1,-1,-1,-1},
    { 0, 9, 1, 5, 6,11,-1,-1,-1,-1,-1,-1,-1},
    { 8, 0, 3,11, 5, 6,-1,-1,-1,-1,-1,-1,-1},
    {11, 5, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    {10, 7, 5,10, 5,11,-1,-1,-1,-1,-1,-1,-1},
    { 3, 0, 8, 7, 5,11, 7,11,10,-1,-1,-1,-1},
    { 9, 0, 1,11,10, 7,11, 7, 5,-1,-1,-1,-1},
    { 3, 1, 9, 3, 9, 8, 7,11,10, 7, 5,11,-1},
    { 2,10, 1,10, 7, 1, 1, 7, 5,-1,-1,-1,-1},
    { 0, 8, 3, 2,10, 1, 1,10, 7, 1, 7, 5,-1},
    { 9, 0, 2, 9, 2, 7, 2,10, 7, 9, 7, 5,-1},
    {10, 3, 2, 8, 5, 9, 8, 7, 5,-1,-1,-1,-1},
    {11, 2, 5, 2, 3, 5, 5, 3, 7,-1,-1,-1,-1},
    { 5,11, 2, 8, 5, 2, 8, 7, 5, 8, 2, 0,-1},
    { 9, 0, 1,11, 2, 5, 5, 2, 3, 5, 3, 7,-1},
    { 1,11, 2, 5, 8, 7, 5, 9, 8,-1,-1,-1,-1},
    { 1, 3, 7, 1, 7, 5,-1,-1,-1,-1,-1,-1,-1},
    { 8, 7, 0, 0, 7, 1, 7, 5, 1,-1,-1,-1,-1},
    { 0, 3, 9, 9, 3, 5, 3, 7, 5,-1,-1,-1,-1},
    { 9, 7, 5, 9, 8, 7,-1,-1,-1,-1,-1,-1,-1},
    { 4, 5, 8, 5,11, 8, 8,11,10,-1,-1,-1,-1},
    { 3, 0, 4, 3, 4,11, 4, 5,11, 3,11,10,-1},
    { 0, 1, 9, 4, 5, 8, 8, 5,11, 8,11,10,-1},
    { 5, 9, 4, 1,10, 3, 1,11,10,-1,-1,-1,-1},
    { 8, 4, 5, 2, 8, 5, 2,10, 8, 2, 5, 1,-1},
    { 3, 2,10, 1, 4, 5, 1, 0, 4,-1,-1,-1,-1},
    { 9, 4, 5, 8, 2,10, 8, 0, 2,-1,-1,-1,-1},
    {10, 3, 2, 9, 4, 5,-1,-1,-1,-1,-1,-1,-1},
    { 3, 8, 4, 3, 4, 2, 2, 4, 5, 2, 5,11,-1},
    {11, 2, 5, 5, 2, 4, 2, 0, 4,-1,-1,-1,-1},
    { 0, 3, 8, 5, 9, 4,11, 2, 1,-1,-1,-1,-1},
    { 2, 1,11, 9, 4, 5,-1,-1,-1,-1,-1,-1,-1},
    { 4, 5, 8, 8, 5, 3, 5, 1, 3,-1,-1,-1,-1},
    { 5, 0, 4, 5, 1, 0,-1,-1,-1,-1,-1,-1,-1},
    { 3, 8, 0, 4, 5, 9,-1,-1,-1,-1,-1,-1,-1},
    { 9, 4, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 7, 4,10, 4, 9,10,10, 9,11,-1,-1,-1,-1},
    { 3, 0, 8, 7, 4,10,10, 4, 9,10, 9,11,-1},
    {10, 7, 4, 1,10, 4, 1,11,10, 1, 4, 0,-1},
    { 8, 7, 4,10, 1,11,10, 3, 1,-1,-1,-1,-1},
    { 2,10, 7, 2, 7, 1, 1, 7, 4, 1, 4, 9,-1},
    { 3, 2,10, 4, 8, 7, 9, 1, 0,-1,-1,-1,-1},
    { 7, 4,10,10, 4, 2, 4, 0, 2,-1,-1,-1,-1},
    { 2,10, 3, 7, 4, 8,-1,-1,-1,-1,-1,-1,-1},
    { 2, 3, 7, 2, 7, 9, 7, 4, 9, 2, 9,11,-1},
    { 4, 8, 7, 0,11, 2, 0, 9,11,-1,-1,-1,-1},
    { 2, 1,11, 0, 7, 4, 0, 3, 7,-1,-1,-1,-1},
    {11, 2, 1, 8, 7, 4,-1,-1,-1,-1,-1,-1,-1},
    { 9, 1, 4, 4, 1, 7, 1, 3, 7,-1,-1,-1,-1},
    { 1, 0, 9, 8, 7, 4,-1,-1,-1,-1,-1,-1,-1},
    { 3, 4, 0, 3, 7, 4,-1,-1,-1,-1,-1,-1,-1},
    { 8, 7, 4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 9,11, 8,11,10,-1,-1,-1,-1,-1,-1,-1},
    { 0, 9, 3, 3, 9,10, 9,11,10,-1,-1,-1,-1},
    { 1,11, 0, 0,11, 8,11,10, 8,-1,-1,-1,-1},
    {11, 3, 1,11,10, 3,-1,-1,-1,-1,-1,-1,-1},
    { 2,10, 1, 1,10, 9,10, 8, 9,-1,-1,-1,-1},
    {10, 3, 2, 0, 9, 1,-1,-1,-1,-1,-1,-1,-1},
    {10, 0, 2,10, 8, 0,-1,-1,-1,-1,-1,-1,-1},
    {10, 3, 2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 3, 8, 2, 2, 8,11, 8, 9,11,-1,-1,-1,-1},
    { 9, 2, 0, 9,11, 2,-1,-1,-1,-1,-1,-1,-1},
    { 8, 0, 3, 1,11, 2,-1,-1,-1,-1,-1,-1,-1},
    {11, 2, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 1, 3, 8, 9, 1,-1,-1,-1,-1,-1,-1,-1},
    { 9, 1, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    { 8, 0, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}};

} //namespace lvr


#endif
