#ifndef LVR2_ASCII_VIEWER_BRAILLE_HPP
#define LVR2_ASCII_VIEWER_BRAILLE_HPP

#include "BitField.hpp"
#include <iostream>

namespace lvr2 {

const static wchar_t BrailleTable[] = {
    /////////////////////// 

    L'\u2800', // 00000000
    L'\u2801', // 00000001
    L'\u2802', // 00000010
    L'\u2803', // 00000011
    L'\u2804', // 00000100
    L'\u2805', // 00000101
    L'\u2806', // 00000110
    L'\u2807', // 00000111

    L'\u2840', // 00001000
    L'\u2841', // 00001001
    L'\u2842', // 00001010
    L'\u2843', // 00001011
    L'\u2844', // 00001100
    L'\u2845', // 00001101
    L'\u2846', // 00001110
    L'\u2847', // 00001111

    L'\u2808', // 00010000
    L'\u2809', // 00010001
    L'\u280A', // 00010010
    L'\u280B', // 00010011
    L'\u280C', // 00010100
    L'\u280D', // 00010101
    L'\u280E', // 00010110
    L'\u280F', // 00010111

    L'\u2848', // 00011000
    L'\u2849', // 00011001
    L'\u284A', // 00011010
    L'\u284B', // 00011011
    L'\u284C', // 00011100
    L'\u284D', // 00011101
    L'\u284E', // 00011110
    L'\u284F', // 00011111

    //////////////////////

    L'\u2810', // 00100000
    L'\u2811', // 00100001
    L'\u2812', // 00100010
    L'\u2813', // 00100011
    L'\u2814', // 00100100
    L'\u2815', // 00100101
    L'\u2816', // 00100110
    L'\u2817', // 00100111

    L'\u2850', // 00101000
    L'\u2851', // 00101001
    L'\u2852', // 00101010
    L'\u2853', // 00101011
    L'\u2854', // 00101100
    L'\u2855', // 00101101
    L'\u2856', // 00101110
    L'\u2857', // 00101111

    L'\u2818', // 00110000
    L'\u2819', // 00110001
    L'\u281A', // 00110010
    L'\u281B', // 00110011
    L'\u281C', // 00110100
    L'\u281D', // 00110101
    L'\u281E', // 00110110
    L'\u281F', // 00110111

    L'\u2858', // 00111000
    L'\u2859', // 00111001
    L'\u285A', // 00111010
    L'\u285B', // 00111011
    L'\u285C', // 00111100
    L'\u285D', // 00111101
    L'\u285E', // 00111110
    L'\u285F', // 00111111

    //////////////////////

    L'\u2820', // 01000000
    L'\u2821', // 01000001
    L'\u2822', // 01000010
    L'\u2823', // 01000011
    L'\u2824', // 01000100
    L'\u2825', // 01000101
    L'\u2826', // 01000110
    L'\u2827', // 01000111

    L'\u2860', // 01001000
    L'\u2861', // 01001001
    L'\u2862', // 01001010
    L'\u2863', // 01001011
    L'\u2864', // 01001100
    L'\u2865', // 01001101
    L'\u2866', // 01001110
    L'\u2867', // 01001111

    L'\u2828', // 01010000
    L'\u2829', // 01010001
    L'\u282A', // 01010010
    L'\u282B', // 01010011
    L'\u282C', // 01010100
    L'\u282D', // 01010101
    L'\u282E', // 01010110
    L'\u282F', // 01010111

    L'\u2868', // 01011000
    L'\u2869', // 01011001
    L'\u286A', // 01011010
    L'\u286B', // 01011011
    L'\u286C', // 01011100
    L'\u286D', // 01011101
    L'\u286E', // 01011110
    L'\u286F', // 01011111

    //////////////////////

    L'\u2830', // 01100000
    L'\u2831', // 01100001
    L'\u2832', // 01100010
    L'\u2833', // 01100011
    L'\u2834', // 01100100
    L'\u2835', // 01100101
    L'\u2836', // 01100110
    L'\u2837', // 01100111

    L'\u2870', // 01101000
    L'\u2871', // 01101001
    L'\u2872', // 01101010
    L'\u2873', // 01101011
    L'\u2874', // 01101100
    L'\u2875', // 01101101
    L'\u2876', // 01101110
    L'\u2877', // 01101111

    L'\u2838', // 01110000
    L'\u2839', // 01110001
    L'\u283A', // 01110010
    L'\u283B', // 01110011
    L'\u283C', // 01110100
    L'\u283D', // 01110101
    L'\u283E', // 01110110
    L'\u283F', // 01110111

    L'\u2878', // 01111000
    L'\u2879', // 01111001
    L'\u287A', // 01111010
    L'\u287B', // 01111011
    L'\u287C', // 01111100
    L'\u287D', // 01111101
    L'\u287E', // 01111110
    L'\u287F', // 01111111

    ////////////////////////////////////////////////////////////////

    /////////////////////// 

    L'\u2880', // 10000000
    L'\u2881', // 10000001
    L'\u2882', // 10000010
    L'\u2883', // 10000011
    L'\u2884', // 10000100
    L'\u2885', // 10000101
    L'\u2886', // 10000110
    L'\u2887', // 10000111

    L'\u28C0', // 10001000
    L'\u28C1', // 10001001
    L'\u28C2', // 10001010
    L'\u28C3', // 10001011
    L'\u28C4', // 10001100
    L'\u28C5', // 10001101
    L'\u28C6', // 10001110
    L'\u28C7', // 10001111

    L'\u2888', // 10010000
    L'\u2889', // 10010001
    L'\u288A', // 10010010
    L'\u288B', // 10010011
    L'\u288C', // 10010100
    L'\u288D', // 10010101
    L'\u288E', // 10010110
    L'\u288F', // 10010111

    L'\u28C8', // 10011000
    L'\u28C9', // 10011001
    L'\u28CA', // 10011010
    L'\u28CB', // 10011011
    L'\u28CC', // 10011100
    L'\u28CD', // 10011101
    L'\u28CE', // 10011110
    L'\u28CF', // 10011111

    //////////////////////

    L'\u2890', // 10100000
    L'\u2891', // 10100001
    L'\u2892', // 10100010
    L'\u2893', // 10100011
    L'\u2894', // 10100100
    L'\u2895', // 10100101
    L'\u2896', // 10100110
    L'\u2897', // 10100111

    L'\u28D0', // 10101000
    L'\u28D1', // 10101001
    L'\u28D2', // 10101010
    L'\u28D3', // 10101011
    L'\u28D4', // 10101100
    L'\u28D5', // 10101101
    L'\u28D6', // 10101110
    L'\u28D7', // 10101111

    L'\u2898', // 10110000
    L'\u2899', // 10110001
    L'\u289A', // 10110010
    L'\u289B', // 10110011
    L'\u289C', // 10110100
    L'\u289D', // 10110101
    L'\u289E', // 10110110
    L'\u289F', // 10110111

    L'\u28D8', // 10111000
    L'\u28D9', // 10111001
    L'\u28DA', // 10111010
    L'\u28DB', // 10111011
    L'\u28DC', // 10111100
    L'\u28DD', // 10111101
    L'\u28DE', // 10111110
    L'\u28DF', // 10111111

    //////////////////////

    L'\u28A0', // 11000000
    L'\u28A1', // 11000001
    L'\u28A2', // 11000010
    L'\u28A3', // 11000011
    L'\u28A4', // 11000100
    L'\u28A5', // 11000101
    L'\u28A6', // 11000110
    L'\u28A7', // 11000111

    L'\u28E0', // 11001000
    L'\u28E1', // 11001001
    L'\u28E2', // 11001010
    L'\u28E3', // 11001011
    L'\u28E4', // 11001100
    L'\u28E5', // 11001101
    L'\u28E6', // 11001110
    L'\u28E7', // 11001111

    L'\u28A8', // 11010000
    L'\u28A9', // 11010001
    L'\u28AA', // 11010010
    L'\u28AB', // 11010011
    L'\u28AC', // 11010100
    L'\u28AD', // 11010101
    L'\u28AE', // 11010110
    L'\u28AF', // 11010111

    L'\u28E8', // 11011000
    L'\u28E9', // 11011001
    L'\u28EA', // 11011010
    L'\u28EB', // 11011011
    L'\u28EC', // 11011100
    L'\u28ED', // 11011101
    L'\u28EE', // 11011110
    L'\u28EF', // 11011111

    //////////////////////

    L'\u28B0', // 11100000
    L'\u28B1', // 11100001
    L'\u28B2', // 11100010
    L'\u28B3', // 11100011
    L'\u28B4', // 11100100
    L'\u28B5', // 11100101
    L'\u28B6', // 11100110
    L'\u28B7', // 11100111

    L'\u28F0', // 11101000
    L'\u28F1', // 11101001
    L'\u28F2', // 11101010
    L'\u28F3', // 11101011
    L'\u28F4', // 11101100
    L'\u28F5', // 11101101
    L'\u28F6', // 11101110
    L'\u28F7', // 11101111

    L'\u28B8', // 11110000
    L'\u28B9', // 11110001
    L'\u28BA', // 11110010
    L'\u28BB', // 11110011
    L'\u28BC', // 11110100
    L'\u28BD', // 11110101
    L'\u28BE', // 11110110
    L'\u28BF', // 11110111

    L'\u28F8', // 11111000
    L'\u28F9', // 11111001
    L'\u28FA', // 11111010
    L'\u28FB', // 11111011
    L'\u28FC', // 11111100
    L'\u28FD', // 11111101
    L'\u28FE', // 11111110
    L'\u28FF', // 11111111
};

struct BrailleChar : public BitField<2,4> 
{
    using BitField<2,4>::BitField;

    wchar_t getChar() {
        return BrailleTable[data];
    }

    template< typename charT > friend
    std::basic_ostream< charT> & operator << ( std::basic_ostream< charT >& os, const BrailleChar& bc )
    { 
        return os << BrailleTable[bc.data]; 
    }
};


} // namespace lvr2

#endif // LVR2_ASCII_VIEWER_BRAILLE_HPP