/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.orb.ORB;
import java.lang.reflect.Field;
import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.InPortConsumerFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public class OutPortPushConnector
extends OutPortConnector {
    private InPortConsumer m_consumer;
    private PublisherBase m_publisher;
    private BufferBase<OutputStream> m_buffer;
    private Streamable m_streamable = null;
    private Field m_field = null;
    private ORB m_spi_orb;
    private OutPortBase m_outport;
    ConnectorListeners m_listeners;

    public OutPortPushConnector(ConnectorBase.ConnectorInfo connectorInfo, InPortConsumer inPortConsumer, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        super(connectorInfo);
        try {
            this._Constructor(connectorInfo, inPortConsumer, connectorListeners, bufferBase);
        }
        catch (Exception exception) {
            throw new Exception("bad_alloc()");
        }
    }

    public OutPortPushConnector(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners, InPortConsumer inPortConsumer) throws Exception {
        super(connectorInfo);
        BufferBase<OutputStream> bufferBase = null;
        try {
            this._Constructor(connectorInfo, inPortConsumer, connectorListeners, bufferBase);
        }
        catch (Exception exception) {
            throw new Exception("bad_alloc()");
        }
    }

    private void _Constructor(ConnectorBase.ConnectorInfo connectorInfo, InPortConsumer inPortConsumer, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        this.m_consumer = inPortConsumer;
        this.m_publisher = null;
        this.m_buffer = bufferBase;
        this.m_listeners = connectorListeners;
        this.m_publisher = this.createPublisher(connectorInfo);
        if (this.m_buffer == null) {
            this.m_buffer = this.createBuffer(connectorInfo);
        }
        if (this.m_publisher == null || this.m_buffer == null || this.m_consumer == null) {
            if (this.m_publisher == null) {
                this.rtcout.println(0, "m_publisher is null");
            }
            if (this.m_buffer == null) {
                this.rtcout.println(0, "m_buffer is null");
            }
            if (this.m_consumer == null) {
                this.rtcout.println(0, "m_consumer is null");
            }
            throw new Exception("bad_alloc()");
        }
        ReturnCode returnCode = this.m_publisher.init(connectorInfo.properties);
        if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
            throw new Exception("bad_alloc()");
        }
        this.m_buffer.init(connectorInfo.properties.getNode("buffer"));
        this.m_consumer.init(connectorInfo.properties);
        this.m_publisher.setConsumer(this.m_consumer);
        this.m_publisher.setBuffer(this.m_buffer);
        this.m_publisher.setListener(this.m_profile, this.m_listeners);
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
        this.onConnect();
    }

    @Override
    public <DataType> ReturnCode write(DataType DataType) {
        this.rtcout.println(2, "write()");
        OutPort outPort = (OutPort)this.m_outport;
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.m_isLittleEndian);
        outPort.write_stream(DataType, (OutputStream)encapsOutputStream);
        return this.m_publisher.write((OutputStream)encapsOutputStream, 0, 0);
    }

    @Override
    public ReturnCode disconnect() {
        FactoryGlobal factoryGlobal;
        this.rtcout.println(2, "disconnect()");
        this.onDisconnect();
        if (this.m_publisher != null) {
            this.rtcout.println(3, "delete publisher");
            factoryGlobal = PublisherBaseFactory.instance();
            factoryGlobal.deleteObject(this.m_publisher.getName(), this.m_publisher);
        }
        this.m_publisher = null;
        if (this.m_consumer != null) {
            this.rtcout.println(3, "delete consumer");
            factoryGlobal = InPortConsumerFactory.instance();
            factoryGlobal.deleteObject(this.m_consumer);
        }
        this.m_consumer = null;
        if (this.m_buffer != null) {
            this.rtcout.println(3, "delete buffer");
            factoryGlobal = BufferFactory.instance();
            factoryGlobal.deleteObject(this.m_buffer);
        }
        this.m_buffer = null;
        this.rtcout.println(2, "disconnect() done");
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
        this.m_publisher.activate();
    }

    @Override
    public BufferBase<OutputStream> getBuffer() {
        return this.m_buffer;
    }

    @Override
    public void setOutPortBase(OutPortBase outPortBase) {
        this.m_outport = outPortBase;
    }

    @Override
    public void deactivate() {
        this.m_publisher.deactivate();
    }

    protected PublisherBase createPublisher(ConnectorBase.ConnectorInfo connectorInfo) {
        String string = connectorInfo.properties.getProperty("subscription_type", "flush");
        string = StringUtil.normalize(string);
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        return (PublisherBase)publisherBaseFactory.createObject(string);
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.ConnectorInfo connectorInfo) {
        String string = connectorInfo.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }

    protected void onConnect() {
        this.m_listeners.connector_[5].notify(this.m_profile);
    }

    protected void onDisconnect() {
        this.m_listeners.connector_[6].notify(this.m_profile);
    }
}

