/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.InPortProviderFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.InPortProvider;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import org.omg.CORBA.portable.OutputStream;

public class InPortPushConnector
extends InPortConnector {
    private InPortProvider m_provider;
    private boolean m_deleteBuffer;

    public InPortPushConnector(ConnectorBase.Profile profile, InPortProvider inPortProvider, BufferBase<OutputStream> bufferBase) throws Exception {
        super(profile, bufferBase);
        this.m_provider = inPortProvider;
        this.m_deleteBuffer = bufferBase == null;
        if (this.m_buffer == null) {
            this.m_buffer = this.createBuffer(profile);
        }
        if (this.m_buffer == null || this.m_provider == null) {
            if (this.m_buffer == null) {
                this.rtcout.println(0, "    m_buffer is null.");
            }
            if (this.m_provider == null) {
                this.rtcout.println(0, "    m_provider is null.");
            }
            throw new Exception("bad_alloc()");
        }
        this.m_provider.init(profile.properties);
        this.m_provider.setBuffer(this.m_buffer);
    }

    @Override
    public ReturnCode read(DataRef<OutputStream> dataRef) {
        this.rtcout.println(2, "read()");
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode = this.m_buffer.read(dataRef, 0, 0);
        return this.convertReturn(returnCode);
    }

    @Override
    public ReturnCode disconnect() {
        FactoryGlobal factoryGlobal;
        if (this.m_provider != null) {
            factoryGlobal = InPortProviderFactory.instance();
            factoryGlobal.deleteObject(this.m_provider);
        }
        this.m_provider = null;
        if (this.m_buffer != null && this.m_deleteBuffer) {
            factoryGlobal = BufferFactory.instance();
            factoryGlobal.deleteObject(this.m_buffer);
        }
        this.m_buffer = null;
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.Profile profile) {
        String string = profile.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }

    protected ReturnCode convertReturn(jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode) {
        switch (returnCode) {
            case BUFFER_OK: {
                return ReturnCode.PORT_OK;
            }
            case BUFFER_EMPTY: {
                return ReturnCode.BUFFER_EMPTY;
            }
            case TIMEOUT: {
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case PRECONDITION_NOT_MET: {
                return ReturnCode.PRECONDITION_NOT_MET;
            }
        }
        return ReturnCode.PORT_ERROR;
    }
}

