/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.SDOPackage;

import _SDOPackage.Configuration;
import _SDOPackage.ConfigurationHelper;
import _SDOPackage.ConfigurationPOA;
import _SDOPackage.ConfigurationSet;
import _SDOPackage.ConfigurationSetListHolder;
import _SDOPackage.DeviceProfile;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.OrganizationListHolder;
import _SDOPackage.Parameter;
import _SDOPackage.ParameterListHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileHolder;
import _SDOPackage.ServiceProfileListHolder;
import java.util.UUID;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ConfigAdmin;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.Any;

public class Configuration_impl
extends ConfigurationPOA {
    protected Configuration m_objref;
    protected DeviceProfile m_deviceProfile = new DeviceProfile();
    protected ServiceProfileListHolder m_serviceProfiles;
    protected ParameterListHolder m_parameters;
    protected ConfigAdmin m_configsets;
    protected OrganizationListHolder m_organizations;

    public Configuration_impl(ConfigAdmin configsets) {
        this.m_configsets = configsets;
        this.m_objref = this._this();
    }

    public Configuration _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = ConfigurationHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.m_objref;
    }

    private void toProperties(Properties prop, ConfigurationSet conf) {
        NVListHolder nvlist = new NVListHolder();
        nvlist.value = conf.configuration_data;
        NVUtil.copyToProperties(prop, nvlist);
    }

    private void toConfigurationSet(ConfigurationSet conf, Properties prop) {
        conf.description = new String(prop.getProperty("description"));
        conf.id = new String(prop.getName());
        NVListHolder nvlist = new NVListHolder();
        NVUtil.copyFromProperties(nvlist, prop);
        conf.configuration_data = nvlist.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set_device_profile(DeviceProfile dProfile) throws InvalidParameter, NotAvailable, InternalError {
        try {
            if (this.m_deviceProfile == null) {
                this.m_deviceProfile = new DeviceProfile();
            }
            DeviceProfile deviceProfile = this.m_deviceProfile;
            synchronized (deviceProfile) {
                this.m_deviceProfile = dProfile;
            }
        }
        catch (Exception ex) {
            throw new InternalError("Unknown Error:set_device_profile()");
        }
        return true;
    }

    public boolean set_service_profile(ServiceProfile sProfile) throws InvalidParameter, NotAvailable, InternalError {
        block6: {
            if (this.m_serviceProfiles == null) {
                this.m_serviceProfiles = new ServiceProfileListHolder();
                this.m_serviceProfiles.value = new ServiceProfile[0];
            }
            if (sProfile.id != null && !sProfile.id.equals("")) break block6;
            ServiceProfileHolder prof = new ServiceProfileHolder(sProfile);
            prof.value.id = UUID.randomUUID().toString();
            CORBA_SeqUtil.push_back(this.m_serviceProfiles, prof.value);
            return true;
        }
        try {
            int index = 0;
            while (index < this.m_serviceProfiles.value.length) {
                if (sProfile.id.equals(this.m_serviceProfiles.value[index].id)) {
                    CORBA_SeqUtil.erase(this.m_serviceProfiles, index);
                    break;
                }
                ++index;
            }
            CORBA_SeqUtil.push_back(this.m_serviceProfiles, sProfile);
            return true;
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::set_service_profile");
        }
    }

    public boolean add_organization(Organization org) throws InvalidParameter, NotAvailable, InternalError {
        try {
            if (this.m_organizations == null) {
                this.m_organizations = new OrganizationListHolder();
                this.m_organizations.value = new Organization[0];
            }
            CORBA_SeqUtil.push_back(this.m_organizations, org);
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::set_service_profile");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove_service_profile(String id) throws InvalidParameter, NotAvailable, InternalError {
        try {
            int index = 0;
            while (true) {
                if (index >= this.m_serviceProfiles.value.length) {
                    return true;
                }
                if (id.equals(this.m_serviceProfiles.value[index].id)) {
                    CORBA_SeqUtil.erase(this.m_serviceProfiles, index);
                    return true;
                }
                ++index;
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::remove_service_profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove_organization(String organization_id) throws InvalidParameter, NotAvailable, InternalError {
        try {
            OrganizationListHolder organizationListHolder = this.m_organizations;
            synchronized (organizationListHolder) {
                int index = 0;
                while (true) {
                    if (index >= this.m_organizations.value.length) {
                        return true;
                    }
                    if (organization_id.equals(this.m_organizations.value[index].get_organization_id())) {
                        CORBA_SeqUtil.erase(this.m_organizations, index);
                        return true;
                    }
                    ++index;
                }
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::remove_service_profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter[] get_configuration_parameters() throws NotAvailable, InternalError {
        try {
            if (this.m_parameters == null) {
                this.m_parameters = new ParameterListHolder();
                this.m_parameters.value = new Parameter[0];
            }
            ParameterListHolder parameterListHolder = this.m_parameters;
            synchronized (parameterListHolder) {
                ParameterListHolder param = new ParameterListHolder(this.m_parameters.value);
                return param.value;
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::get_configuration_parameters()");
        }
    }

    public synchronized NameValue[] get_configuration_parameter_values() throws NotAvailable, InternalError {
        NVListHolder nvlist = new NVListHolder();
        nvlist.value = new NameValue[0];
        return nvlist.value;
    }

    public Any get_configuration_parameter_value(String name) throws InvalidParameter, NotAvailable, InternalError {
        if (name == null || name.equals("")) {
            throw new InvalidParameter("Name is empty.");
        }
        Any value = ORBUtil.getOrb().create_any();
        return value;
    }

    public boolean set_configuration_parameter(String name, Any value) throws InvalidParameter, NotAvailable, InternalError {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSet[] get_configuration_sets() throws NotAvailable, InternalError {
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                ConfigurationSetListHolder config_sets = new ConfigurationSetListHolder();
                config_sets.value = new ConfigurationSet[0];
                Vector<Properties> cf = new Vector<Properties>(this.m_configsets.getConfigurationSets());
                config_sets.value = new ConfigurationSet[cf.size()];
                int intIdx = 0;
                while (intIdx < cf.size()) {
                    if (config_sets.value[intIdx] == null) {
                        config_sets.value[intIdx] = new ConfigurationSet();
                    }
                    this.toConfigurationSet(config_sets.value[intIdx], cf.elementAt(intIdx));
                    ++intIdx;
                }
                return config_sets.value;
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::get_configuration_sets()");
        }
    }

    public synchronized ConfigurationSet get_configuration_set(String config_id) throws NotAvailable, InternalError {
        if (config_id == null || config_id.equals("")) {
            throw new InternalError("ID is empty");
        }
        if (!this.m_configsets.haveConfig(config_id)) {
            throw new InternalError("No such ConfigurationSet");
        }
        Properties configset = new Properties(this.m_configsets.getConfigurationSet(config_id));
        try {
            ConfigurationSet config = new ConfigurationSet();
            this.toConfigurationSet(config, configset);
            return config;
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::get_configuration_set()");
        }
    }

    public boolean set_configuration_set_values(String config_id, ConfigurationSet configuration_set) throws InvalidParameter, NotAvailable, InternalError {
        if (config_id == null || config_id.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        try {
            Properties conf = new Properties(config_id);
            this.toProperties(conf, configuration_set);
            return this.m_configsets.setConfigurationSetValues(config_id, conf);
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::set_configuration_set_values()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSet get_active_configuration_set() throws NotAvailable, InternalError {
        if (!this.m_configsets.isActive()) {
            throw new NotAvailable();
        }
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                ConfigurationSet config = new ConfigurationSet();
                this.toConfigurationSet(config, this.m_configsets.getActiveConfigurationSet());
                return config;
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::get_active_configuration_set()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add_configuration_set(ConfigurationSet configuration_set) throws InvalidParameter, NotAvailable, InternalError {
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                String config_id = new String(configuration_set.id);
                Properties config = new Properties(config_id);
                this.toProperties(config, configuration_set);
                return this.m_configsets.addConfigurationSet(config);
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::add_configuration_set()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove_configuration_set(String config_id) throws InvalidParameter, NotAvailable, InternalError {
        if (config_id == null || config_id.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                return this.m_configsets.removeConfigurationSet(config_id);
            }
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::remove_configuration_set()");
        }
    }

    public boolean activate_configuration_set(String config_id) throws InvalidParameter, NotAvailable, InternalError {
        if (config_id == null || config_id.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        try {
            this.m_configsets.activateConfigurationSet(config_id);
        }
        catch (Exception ex) {
            throw new InternalError("Configuration::activate_configuration_set()");
        }
        return false;
    }

    public Configuration getObjRef() {
        return this.m_objref;
    }

    public final DeviceProfile getDeviceProfile() {
        return this.m_deviceProfile;
    }

    public final ServiceProfileListHolder getServiceProfiles() {
        return this.m_serviceProfiles;
    }

    public final ServiceProfile getServiceProfile(String id) {
        int index = 0;
        while (index < this.m_serviceProfiles.value.length) {
            if (id.equals(this.m_serviceProfiles.value[index].id)) {
                return this.m_serviceProfiles.value[index];
            }
            ++index;
        }
        return new ServiceProfile();
    }

    public final OrganizationListHolder getOrganizations() {
        return this.m_organizations;
    }
}

