/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port.publisher;

import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.Properties;

public class PublisherPeriodic
extends PublisherBase
implements Runnable {
    private InPortConsumer m_consumer;
    private boolean m_running;
    private long m_millisec;
    private int m_nanosec;

    public PublisherPeriodic(InPortConsumer consumer, Properties property) {
        double hz;
        this.m_consumer = consumer;
        String rate = new String(property.getProperty("dataport.push_rate"));
        if (!rate.equals("")) {
            hz = Double.valueOf(rate);
            if (hz == 0.0) {
                hz = 1000.0;
            }
        } else {
            hz = 1000.0;
        }
        int usec = (int)(1000000.0 / hz);
        this.m_millisec = usec / 1000;
        this.m_nanosec = usec % 1000 * 1000;
        this.open();
    }

    public void update() {
    }

    public int svc() {
        while (this.m_running) {
            this.m_consumer.push();
            try {
                Thread.sleep(this.m_millisec, this.m_nanosec);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void run() {
        this.svc();
    }

    public int open() {
        this.m_running = true;
        Thread t = new Thread(this);
        t.start();
        return 0;
    }

    public void release() {
        this.m_running = false;
    }
}

