#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file PushConnector.py
# @brief Push type connector class
# @date $Date$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2009
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.
#


##
# @if jp
# @class DataPortStatus mixin class
# @brief DataPortStatus mixin 饹
#
# Υ饹ϡenum줿꥿󥳡ɤ򡢥ǡݡȴϢΥ
# ֥饹ǶѤ뤿 mixin 饹Ǥ롣Υ꥿󥳡
# ɤѤ륯饹ǤϡDataPortStatus 饹public Ѿ
# define ƤDATAPORTSTATUS_ENUM 򥯥饹˵Ҥ뤳Ȥ
# ǽȤʤ롣ˤꡢenum  ReturnCode_t Ȥ typedef 
# ʸReturnCode_t ѤǤ褦ˤȤȤˡ֤̾ enum
# 줿Ƽ̻Ҥ饹̾Ƴ롣
#
# @else
# @class DataPortStatus mixin class
# @brief DataPortStatus mixin class
#
# This is a mixin class to provide enumed return codes that are
# commonly utilised in data port related sub-classes. To use this
# class, sub-class should inherit this class as a public super
# class, and declare DATAPORTSTATUS_ENUM defined
# below. Consequently, ReturnCode_t type that is typedefed by this
# macro can be used in the sub-class, and enumed identifiers are
# imported to the class's namespace.
#
# @endif
#
class DataPortStatus:
  """
  """

  def __init__(self):
    pass

  ##
  # @if jp
  # brief DataPortStatus ꥿󥳡
  #
  # ǡݡȴϢΥ饹Ƕ̤Υ꥿󥳡
  #  
  # - PORT_OK:              ｪλ
  # - PORT_ERROR:           ۾ｪλ
  # - BUFFER_ERROR:         Хåե顼
  # - BUFFER_FULL:          Хåեե
  # - BUFFER_EMPTY:         Хåեץƥ
  # - BUFFER_TIMEOUT:       Хåեॢ
  # - SEND_FULL:            ǡä¦Хåեե
  # - SEND_TIMEOUT:         ǡä¦ॢȤ
  # - RECV_EMPTY:           ǡ褦Ȥǡ
  # - RECV_TIMEOUT:         ǡ褦ȤदȤ
  # - INVALID_ARGS:         ʰ
  # - PRECONDITION_NOT_MET: Ƥʤ
  # - CONNECTION_LOST:      ³Ǥ줿
  # - UNKNOWN_ERROR:        ʥ顼
  #
  # ǡݡȤΥǡϩΥ顼ȯĽ꤫ƤӽФ¦إ顼
  # 뤿ˤΥ顼ɤѤ롣ˡϩΥ
  # 顼Υ顼ʤɤͤ뤬ʬγ̤ȯ륨
  # 顼ʲ󤹤롣
  #
  # (1) Push
  #  a) InPortConsumer  Publisher/Activity ֤ȯ꥿󥳡
  #     PORT_OK, PORT_ERROR, SEND_FULL, SEND_TIMEOUT, CONNECTION_LOST,
  #     UNKNOWN_ERROR
  #
  #  b) Activity  OutPort  Buffer/Connector ֤ȯ꥿󥳡
  #     PORT_OK, PORT_ERROR, BUFFER_ERROR, BUFFER_FULL, BUFFER_TIMEOUT,
  #     UNKNOWN_ERROR, 
  #
  # (2) Pull
  #  a) Activity  InPort δ֤ȯ꥿󥳡
  #     PORT_OK, PORT_ERROR, RECV_EMPTY, RECV_TIMEOUT, CONNETION_LOST,
  #     UNKNOWN_ERROR
  #
  # ƴؿ֤꥿󥳡ɤϴؿȤΥե󥹤򻲾ȤΤȡ
  #
  # @else
  # @brief DataPortStatus return codes
  #
  # Common return codes for data ports related classes.
  #
  # - PORT_OK:              Normal return
  # - PORT_ERROR:           Error return
  # - BUFFER_ERROR:         Buffer error
  # - BUFFER_FULL:          Buffer full
  # - BUFFER_EMPTY:         Buffer empty
  # - BUFFER_TIMEOUT:       Buffer timeout
  # - SEND_FULL:            Buffer full although OutPort tried to send data
  # - SEND_TIMEOUT:         Timeout although OutPort tried to send data
  # - RECV_EMPTY:           Buffer empty although InPort tried to receive
  #                         data
  # - RECV_TIMEOUT:         Timeout although InPort tried to receive data
  # - INVALID_ARGS:         Invalid arguments
  # - PRECONDITION_NOT_MET: Precondition not met
  # - CONNECTION_LOST:      Connection has been lost
  # - UNKNOWN_ERROR:        Unknown error
  #
  # This error codes might be used to propagate error status from
  # the error occurring point to the function caller in the data
  # stream path. It would occur in data-transfer path and data
  # receiver/sender. The errors that occur in the interface of each
  # portion of data port are shown below.
  #
  # (1) Push Type
  #  a) The return codes between InPortConsumer and Publisher/Activity
  #     PORT_OK, PORT_ERROR, SEND_FULL, SEND_TIMEOUT, CONNECTION_LOST,
  #     UNKNOWN_ERROR
  #  b) The return codes between Activity and Buffer/Connector of OutPort
  #     PORT_OK, PORT_ERROR, BUFFER_ERROR, BUFFER_FULL, BUFFER_TIMEOUT,
  #     UNKNOWN_ERROR, 
  #
  # (2) Pull Type
  #  a) The return codes between Activity and InPort
  #     PORT_OK, PORT_ERROR, RECV_EMPTY, RECV_TIMEOUT, CONNETION_LOST,
  #     UNKNOWN_ERROR
  #
  # See function references for detailed return codes for each function.
  #
  # @endif
  #
  PORT_OK              = 0
  PORT_ERROR           = 1
  BUFFER_ERROR         = 2
  BUFFER_FULL          = 3
  BUFFER_EMPTY         = 4
  BUFFER_TIMEOUT       = 5
  SEND_FULL            = 6
  SEND_TIMEOUT         = 7
  RECV_EMPTY           = 8
  RECV_TIMEOUT         = 9
  INVALID_ARGS         = 10
  PRECONDITION_NOT_MET = 11    
  CONNECTION_LOST      = 12
  UNKNOWN_ERROR        = 13

  ##
  # @if jp
  #
  # @brief DataPortStatus ꥿󥳡ɤʸѴ
  #
  # DataPortStatus ꥿󥳡ɤʸѴ
  #
  # @param status Ѵо DataPortStatus ꥿󥳡
  #
  # @return ʸѴ
  #
  # @else
  #
  # @brief Convert DataPortStatus into the string.
  #
  # Convert DataPortStatus into the string.
  #
  # @param status The target DataPortStatus for transformation
  #
  # @return Trnasformation result of string representation
  #
  # @endif
  #
  def toString(status):
    str = ["PORT_OK",
           "PORT_ERROR",
           "BUFFER_ERROR",
           "BUFFER_FULL",
           "BUFFER_EMPTY",
           "BUFFER_TIMEOUT",
           "SEND_FULL",
           "SEND_TIMEOUT",
           "RECV_EMPTY",
           "RECV_TIMEOUT",
           "INVALID_ARGS",
           "PRECONDITION_NOT_MET",
           "CONNECTION_LOST",
           "UNKNOWN_ERROR"]
    return str[status]

  toString = staticmethod(toString)
