#!/usr/bin/env python
# -*- coding: euc-jp -*-


##
# @file PortCallBack.py
# @brief PortCallBack class
# @date $Date: 2007/09/20 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
# 
# Copyright (C) 2006-2008
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.
 

#============================================================
# callback functor base classes
#

##
# @if jp
# @class ConnectCallback
# @brief connect/notify_connect() ΥХåݥ饹
#
# PortФconnect/notify_connect() ƤӽФ˸ƤӽФ
# Хåե󥯥 RTC::ConnectorProfile 롣
#
# @param profile ConnectorProfile
#
# @since 1.0.0
#
# @else
# @class ConnectCallback
# @brief Callback functor abstract for connect/notify_connect() funcs
#
# This is the interface for callback functor for connect/notify_connect()
# invocation in Port. Argument is RTC::ConnectorProfile that is given
# these functions.
#
# @param profile ConnectorProfile
#
# @since 1.0.0
#
# @endif
#
class ConnectionCallback:
  """
  """

  ##
  # @if jp
  #
  # @brief Хåؿ
  #
  # connect/notify_connect() ƤӽФ˸ƤӽФ
  # Хåؿ
  #
  # @param self
  # @param profile ConnectorProfile
  #
  # @else
  #
  # @brief Callback method
  #
  # This is the callback method invoked when connect/notify_connect()
  # invocation in Port.
  #
  # @param self
  # @param profile ConnectorProfile
  #
  # @endif
  #
  # virtual void operator()(RTC::ConnectorProfile& profile) = 0;
  def __call__(self, profile):
    pass


##
# @if jp
# @class DisconnectCallback
# @brief disconnect/notify_disconnect() ΥХåݥ饹
#
# PortФdisconnect/notify_disconnect() ƤӽФ˸ƤӽФ
# Хåե󥯥³ID롣
#
# @since 1.0.0
#
# @else
# @class DisconnectCallback
# @brief Callback functor abstract for disconnect/notify_disconnect() funcs
#
# This is the interface for callback functor for 
# disconnect/notify_disconnect() invocation in Port.
# Argument is connector ID is given these functions.
#
# @since 1.0.0
#
# @endif
#
class DisconnectCallback:
  """
  """

  ##
  # @if jp
  #
  # @brief Хåؿ
  #
  # disconnect/notify_disconnect() ƤӽФ˸ƤӽФ
  # Хåؿ
  #
  # @param self
  # @param connector_id Connector ID
  #
  # @else
  #
  # @brief Callback method
  #
  # This is the callback method invoked when disconnect/notify_disconnect()
  # invocation in Port.
  #
  # @param self
  # @param connector_id Connector ID
  #
  # @endif
  #
  # virtual void operator()(const char* connector_id) = 0;
  def __call__(self, connector_id):
    pass


##
# @if jp
# @class OnWrite
# @brief write() ΥХå饹(֥饹)
#
# DataPortΥХåե˥ǡwrite()ľ˸ƤӽФ륳Хå<BR>
# ֥饹Ǥμ
#
# @since 0.4.0
#
# @else
# @class OnPut
# @brief OnPut abstract class
#
# @endif
class OnWrite:
  """
  """

  ##
  # @if jp
  #
  # @brief Хåؿ
  #
  # Хåե˥ǡ񤭹ޤľ˸ƤӽФ륳Хåؿ
  #
  # @param self
  # @param value Хåե˽񤭹ޤǡ
  #
  # @else
  #
  # @brief Callback function
  #
  # This is the callback method invoked immediately before data is written
  # into the buffer.
  #
  # @param self
  # @param value Data that is written into the buffer
  #
  # @endif
  #
  def __call__(self, value):
    pass



##
# @if jp
# @class OnWriteConvert
# @brief write() ΥǡѴХå饹(֥饹)
#
# InPort/OutPortΥХåե˥ǡ write()˸ƤӽФ<BR>
# ֥饹Ǥμ
# Хåѥ󥿡ե
# ΥХåͤХåե˳Ǽ롣
#
# @since 0.4.0
#
# @else
# @class OnWriteConvert
# @brief OnWriteConvert abstract class
#
# @endif
class OnWriteConvert:
  """
  """

  ##
  # @if jp
  #
  # @brief Хåؿ
  #
  # Хåե˥ǡ񤭹ޤݤ˸ƤӽФ륳Хåؿ
  #
  # @param self
  # @param value Ѵǡ
  # @return Ѵǡ
  #
  # @else
  #
  # @brief Callback function
  #
  # This is the callback function invoked when data is written into the
  # buffer.
  #
  # @param self
  # @param value Data to be converted
  # @return Converted data
  #
  # @endif
  #
  def __call__(self,value):
    pass



##
# @if jp
# @class OnRead
# @brief read() ΥХå饹(֥饹)
#
# InPort/OutPortΥХåեǡ read()ľ˸ƤӽФ
# Хåѥ󥿡ե<BR>
# ֥饹Ǥμ
#
# @since 0.4.0
#
# @else
# @class OnRead
# @brief OnRead abstract class
#
# @endif
class OnRead:
  """
  """

  ##
  # @if jp
  #
  # @brief Хå᥽å
  #
  # Хåեǡɤ߽Фľ˸ƤӽФ륳Хåؿ
  #
  # @else
  #
  # @brief Callback function
  #
  # This is the callback method invoked immediately before data is readout
  # from the buffer.
  #
  # @endif
  def __call__(self):
    pass



##
# @if jp
# @class OnReadConvert
# @brief read() ΥǡѴХå饹(֥饹)
#
# InPort/OutPortΥХåեǡ read()ݤ˸ƤӽФ
# Хåѥ󥿡ե
# ΥХåͤread()ͤȤʤ롣<BR>
# ֥饹Ǥμ
#
# @since 0.4.0
#
# @else
# @class OnReadConvert
# @brief OnReadConvert abstract class
#
# @endif
class OnReadConvert:
  """
  """

  ##
  # @if jp
  #
  # @brief Хå᥽å
  #
  # Хåեǡɤ߽Фݤ˸ƤӽФ륳Хåؿ
  # Ǥꡢoperator()() ͤ InPort  read() ͤȤʤ롢
  # ޤϥǡѿ˳Ǽ롣
  #
  # @param self
  # @param value Хåեɤߤ줿ǡ
  # @return ѴΥǡǡݡѿˤϤͤǼ롣
  #
  # @else
  #
  # @brief Callback method
  #
  # This function is the callback function invoked when data is
  # readout from the buffer, and the return value of operator()()
  # is used as return value of InPort's read() or it is stored in
  # the InPort data variable.
  #
  # @param self
  # @param value Data that is readout from buffer
  # @return Converted data. These data are stored in the port's variable.
  #
  # @endif
  #
  def __call__(self,value):
    pass
