// -*- C++ -*-
/*!
 * @file  InPortConsumer.h
 * @brief InPortConsumer class
 * @date  $Date: 2007-12-31 03:08:03 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: InPortConsumer.h 2146 2011-05-27 09:56:11Z n-ando $
 *
 */

#ifndef RTC_INPORTCONSUMER_H
#define RTC_INPORTCONSUMER_H

#include <coil/Factory.h>
#include <rtm/DataPortStatus.h>

namespace coil
{
  class Properties;
};

// Why RtORB does not allow forward declaration?
#ifndef ORB_IS_RTORB
namespace SDOPackage
{
  class NVList;
};
#endif // ORB_IS_RTORB

class cdrMemoryStream;

namespace RTC
{
  /*!
   * @if jp
   *
   * @class InPortConsumer
   *
   * @brief InPortConsumer ݥ饹
   *
   * ϥݡȥ󥷥塼ޤΤݥ󥿡ե饹
   * ƶݥ饹ϡʲν貾۴ؿμ󶡤ʤФʤʤ
   * - push(): ǡ
   * - clone(): ݡȤΥԡ
   * - subscribeInterface(): ǡΤؤϿ
   * - unsubscribeInterface(): ǡΤϿ
   *
   * @since 0.4.0
   *
   * @else
   * @class InPortConsumer
   *
   * @brief InPortConsumer abstract class
   *
   * This is the abstract interface class for the input port Consumer.
   * Concrete classes must implement the following pure virtual functions.
   * - push(): Send data
   * - clone(): Copy ports
   * - subscribeInterface(): Subscribe the data send notification
   * - unsubscribeInterface(): Unsubscribe the data send notification
   *
   * @since 0.4.0
   *
   * @endif
   *
   */
  class InPortConsumer
    : public DataPortStatus
  {
  public:
    DATAPORTSTATUS_ENUM
    
    /*!
     * @if jp
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~InPortConsumer(void){};

    /*!
     * @if jp
     * @brief 
     *
     * InPortConsumerγƼԤ
     *
     * @else
     * @brief Initializing configuration
     *
     * This operation would be called to configure this consumer
     * in initialization.
     *
     * @endif
     */
    virtual void init(coil::Properties& prop) = 0;

    /*!
     * @if jp
     * @brief ³ؤΥǡ
     *
     * ³ΥݡȤإǡ뤿ν貾۴ؿ
     * 
     * δؿϡʲΥ꥿󥳡ɤ֤
     *
     * - PORT_OK:         ｪλ
     * - PORT_ERROR:      ǡβǲ餫Υ顼ȯ
     * - SEND_FULL:       ǡ¦Хåեեä
     * - SEND_TIMEOUT:    ǡ¦ХåեॢȤ
     * - CONNECTION_LOST: ³Ǥ줿
     * - UNKNOWN_ERROR:   Υ顼
     *
     * @param data ǡ
     * @return ꥿󥳡
     *
     * @else
     * @brief Send data to the destination port
     *
     * Pure virtual function to send data to the destination port.
     *
     * This function might the following return codes
     *
     * - PORT_OK:         Normal return
     * - PORT_ERROR:      Error occurred in data transfer process
     * - SEND_FULL:       Buffer full although OutPort tried to send data
     * - SEND_TIMEOUT:    Timeout although OutPort tried to send data
     * - CONNECTION_LOST: Connection lost
     * - UNKNOWN_ERROR:   Unknown error
     *
     * @endif
     */
    virtual ReturnCode put(const cdrMemoryStream& data) = 0;

    /*!
     * @if jp
     * @brief InterfaceProfile
     *
     * InterfaceProfile롣
     * ǻꤹץѥƥ NameValue ֥Ȥ
     * dataport.interface_type ͤĴ١ݡȤꤵƤ
     * 󥿡եפȰפΤ߾롣
     *
     * @param properties InterfaceProfileץѥƥ
     *
     * @else
     * @brief Publish InterfaceProfile information
     *
     * Publish interfaceProfile information.
     * Check the dataport.interface_type value of the NameValue object 
     * specified by an argument in property information and get information
     * only when the interface type of the specified port is matched.
     *
     * @param properties Properties to get InterfaceProfile information
     *
     * @endif
     */
    virtual void publishInterfaceProfile(SDOPackage::NVList& properties) = 0;

    /*!
     * @if jp
     * @brief ǡμؤϿ
     *
     * ꤵ줿ץѥƥƤ˴ŤơǡΤμϿ
     * ν貾۴ؿ
     *
     * @param properties Ͽ˻Ȥץѥƥ
     *
     * @return Ͽ
     *
     * @else
     * @brief Subscribe the data send notification
     *
     * Pure virtual function to subscribe the data send notification
     * based on specified property information.
     *
     * @param properties Properties for reference when subscribing
     *
     * @return Subscription result
     *
     * @endif
     */
    virtual bool subscribeInterface(const SDOPackage::NVList& properties) = 0;
    
    /*!
     * @if jp
     * @brief ǡμ꤫Ͽ
     *
     * ǡΤμ꤫Ͽ뤿ν貾۴ؿ
     *
     * @param properties Ͽ˻Ȥץѥƥ
     *
     * @else
     * @brief Unsubscribe the data send notification
     *
     * Pure virtual function to unsubscribe the data send notification.
     *
     * @param properties Properties for reference when unsubscribing
     *
     * @endif
     */
    virtual void unsubscribeInterface(const SDOPackage::NVList& properties) = 0;
    
    /*!
     * @if jp
     * @brief 󥿡եץե뤿Υե󥯥
     * @else
     * @brief Functor to publish interface profile
     * @endif
     */
    struct publishInterfaceProfileFunc
    {
      publishInterfaceProfileFunc(SDOPackage::NVList& prop) : m_prop(prop) {}
      void operator()(InPortConsumer* consumer)
      {
        consumer->publishInterfaceProfile(m_prop);
      }
      SDOPackage::NVList& m_prop;
    };

    /*!
     * @if jp
     * @brief 󥿡եץե뤿Υե󥯥
     * @else
     * @brief Functor to publish interface profile
     * @endif
     */
    struct subscribeInterfaceFunc
    {
      subscribeInterfaceFunc(SDOPackage::NVList& prop) : m_prop(prop) {}
      bool operator()(InPortConsumer* consumer)
      {
        return consumer->subscribeInterface(m_prop);
      }
      SDOPackage::NVList& m_prop;
    };

  
  };

  typedef ::coil::GlobalFactory<InPortConsumer> InPortConsumerFactory;

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  EXTERN template class DLL_PLUGIN ::coil::GlobalFactory<InPortConsumer>;
#endif
};     // namespace RTC

#endif // RTC_INPORTCONSUMER_H
