<!--

 @file default.xsl
 @brief XSL file for CppUnit test result page
 @date $Date: 2006-11-27 07:34:28 $
 @author Noriaki Ando <n-ando@aist.go.jp>
 Copyright (C) 2006 Noriaki Ando

 $Id: default.xsl 775 2008-07-28 16:14:45Z n-ando $

-->
<?xml version="1.0" encoding="shift_jis"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" version="1.0" xml:lang="ja">

<xsl:template match="/">
  <HTML>
  <HEAD>
  <TITLE>UnitTesť</TITLE>
  <link rel="stylesheet" type="text/css" href="default.css" />
  <meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS" />  
  </HEAD>
  <BODY>
  <H1>CppUnit eXg</H1>
  <H2>eXgv</H2>
  <P>
  :   <xsl:value-of select="TestRun/Statistics/Tests" />
  s:   <xsl:value-of select="TestRun/Statistics/FailuresTotal" />
  G[: <xsl:value-of select="TestRun/Statistics/Errors" />
  </P>
  <H2>eXgꗗ</H2>
  <xsl:apply-templates select="TestRun" />

  </BODY>
  </HTML>
</xsl:template>

<xsl:template match="TestRun">
  <TABLE>
  <TR>
  <TH>ID</TH>
  <TH>seXg</TH>
  <TH></TH>
  <TH>t@C(s)</TH>
  <TH>s̓e</TH>
  </TR>
  <xsl:for-each select="FailedTests/FailedTest">
  <TR>
  <TD><xsl:value-of select="@id" /></TD>
  <TD><xsl:value-of select="Name" /></TD>
  <TD><xsl:value-of select="FailureType" /></TD>
  <TD><xsl:value-of select="Location/File" />
  (<xsl:value-of select="Location/Line" />)</TD>
  <TD>
  <xsl:value-of select="./text()" />
  <xsl:value-of select="Message" />
  </TD>
  </TR>
  </xsl:for-each>
  <TR>
  <TH>ID</TH>
  <TH>eXg</TH>
  <TH></TH>
  <TH>t@C(s)</TH>
  <TH>s̓e</TH>
  </TR>
  <xsl:for-each select="SuccessfulTests/Test">
  <TR>
  <TD><xsl:value-of select="@id" /></TD>
  <TD><xsl:value-of select="Name" /></TD>
  <TD>Success</TD>
  <TD> ---- </TD>
  <TD> ---- </TD>
  </TR>
  </xsl:for-each>
  </TABLE>
</xsl:template>

</xsl:stylesheet>

