/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**
 * @file libARCommands/ARCOMMANDS_Version.h
 * @brief libARCommands versionning header.
 * This file contains all versionning informations for libARCommands
 **/
#ifndef _LIBARCOMMANDS_VERSION_H_
#define _LIBARCOMMANDS_VERSION_H_


/* VERSION NUMBERS */
/* DO NOT EDIT --> Autogenerated ! */

#define ARCOMMANDS_VERSION_MAJOR (3)
#define ARCOMMANDS_VERSION_MINOR (1)
#define ARCOMMANDS_VERSION_REVISION (0)
#define ARCOMMANDS_VERSION_COMMIT (13)

#define ARCOMMANDS_VERSION_STRING "3.1.0.13"

/* Functions */

/**
 * @brief Checks whether the first version is newer than the second.
 * @param v1M Major version of the first version.
 * @param v1m Minor version of the first version.
 * @param v1r Revision version of the first version.
 * @param v1c Commit version of the first version.
 * @param v2M Major version of the first version.
 * @param v2m Minor version of the first version.
 * @param v2r Revision version of the first version.
 * @param v2c Commit version of the first version.
 * @return a negative integer if v1 is newer than v2, 0 if v1 and v2 are the same, or a positive integer if v2 is newer than v1.
 */
int ARCOMMANDS_Version_CompareVersions(int v1M, int v1m, int v1r, int v1c,
                                       int v2M, int v2m, int v2r, int v2c);

/**
 * @brief Compare two version code by String representation.
 * If a version code is incomplete, the remaining part is considered to be all zeros.
 * i.e. "3" is the same as "3.0.0.0" and "3.1.2" is the same as "3.1.2.0".
 * @param v1 The first version code.
 * @param v2 The second version code.
 * @return a negative integer if v1 is newer than v2, 0 if v1 and v2 are the same, or a positive integer if v2 is newer than v1.
 */
int ARCOMMANDS_Version_CompareVersionCodes(const char *v1, const char *v2);


#endif /* _LIBARCOMMANDS_VERSION_H_ */
