/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateDeviceControllerCategories.py script *
 *                                                        *
 **********************************************************/
#import <libARSAL/ARSAL.h>
#import "DeviceControllerProtected.h"
#import "MiniDroneDeviceController+libARCommands.h"

NSString *const MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification = @"MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification = @"MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotificationStateKey = @"MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotificationStateKey";
NSString *const MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification = @"MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingStateAlertStateChangedNotificationStateKey = @"MiniDroneDeviceControllerPilotingStateAlertStateChangedNotificationStateKey";
NSString *const MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification = @"MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotificationStateKey = @"MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotificationStateKey";
NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification = @"MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification";
NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationStateKey = @"MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationStateKey";
NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationMass_storage_idKey = @"MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationMass_storage_idKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification = @"MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationCurrentKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationCurrentKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMinKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMinKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMaxKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMaxKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification = @"MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationCurrentKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationCurrentKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMinKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMinKey";
NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMaxKey = @"MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMaxKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification = @"MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationCurrentKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationCurrentKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMinKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMinKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMaxKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMaxKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification = @"MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationCurrentKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationCurrentKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMinKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMinKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMaxKey = @"MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMaxKey";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification = @"MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification";
NSString *const MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotificationPresentKey = @"MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotificationPresentKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification = @"MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification";
NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationMotorKey = @"MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationMotorKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationTypeKey = @"MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationTypeKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationSoftwareKey = @"MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationSoftwareKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationHardwareKey = @"MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationHardwareKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification = @"MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification";
NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationSoftwareKey = @"MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationSoftwareKey";
NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationHardwareKey = @"MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationHardwareKey";
NSString *const MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification = @"MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification";
NSString *const MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotificationEnableKey = @"MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotificationEnableKey";
NSString *const MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification = @"MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification";
NSString *const MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotificationDelayKey = @"MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotificationDelayKey";

@implementation MiniDroneDeviceController (libARCommands)
const char *MiniDroneDeviceController_TAG = "MiniDrone DeviceController";

#pragma mark static C callback
static void minidrone_pilotingstate_flattrimchanged_callback(void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionary];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification object:self userInfo:dict];
}

static void minidrone_pilotingstate_flyingstatechanged_callback(eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE state, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithInt:state]] forKeys:@[MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotificationStateKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification object:self userInfo:dict];
}

static void minidrone_pilotingstate_alertstatechanged_callback(eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithInt:state]] forKeys:@[MiniDroneDeviceControllerPilotingStateAlertStateChangedNotificationStateKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification object:self userInfo:dict];
}

static void minidrone_pilotingstate_autotakeoffmodechanged_callback(uint8_t state, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:state]] forKeys:@[MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotificationStateKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification object:self userInfo:dict];
}

static void minidrone_mediarecordstate_picturestatechanged_callback(uint8_t state, uint8_t mass_storage_id, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:state], [NSNumber numberWithUnsignedChar:mass_storage_id]] forKeys:@[MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationStateKey, MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationMass_storage_idKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification object:self userInfo:dict];
}

static void minidrone_pilotingsettingsstate_maxaltitudechanged_callback(float current, float min, float max, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithFloat:current], [NSNumber numberWithFloat:min], [NSNumber numberWithFloat:max]] forKeys:@[MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationCurrentKey, MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMinKey, MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMaxKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification object:self userInfo:dict];
}

static void minidrone_pilotingsettingsstate_maxtiltchanged_callback(float current, float min, float max, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithFloat:current], [NSNumber numberWithFloat:min], [NSNumber numberWithFloat:max]] forKeys:@[MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationCurrentKey, MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMinKey, MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMaxKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification object:self userInfo:dict];
}

static void minidrone_speedsettingsstate_maxverticalspeedchanged_callback(float current, float min, float max, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithFloat:current], [NSNumber numberWithFloat:min], [NSNumber numberWithFloat:max]] forKeys:@[MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationCurrentKey, MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMinKey, MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMaxKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification object:self userInfo:dict];
}

static void minidrone_speedsettingsstate_maxrotationspeedchanged_callback(float current, float min, float max, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithFloat:current], [NSNumber numberWithFloat:min], [NSNumber numberWithFloat:max]] forKeys:@[MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationCurrentKey, MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMinKey, MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMaxKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification object:self userInfo:dict];
}

static void minidrone_speedsettingsstate_wheelschanged_callback(uint8_t present, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:present]] forKeys:@[MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotificationPresentKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification object:self userInfo:dict];
}

static void minidrone_settingsstate_productmotorsversionchanged_callback(uint8_t motor, char * type, char * software, char * hardware, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:motor], [NSString stringWithCString:type encoding:NSUTF8StringEncoding], [NSString stringWithCString:software encoding:NSUTF8StringEncoding], [NSString stringWithCString:hardware encoding:NSUTF8StringEncoding]] forKeys:@[MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationMotorKey, MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationTypeKey, MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationSoftwareKey, MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationHardwareKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification object:self userInfo:dict];
}

static void minidrone_settingsstate_productinertialversionchanged_callback(char * software, char * hardware, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:software encoding:NSUTF8StringEncoding], [NSString stringWithCString:hardware encoding:NSUTF8StringEncoding]] forKeys:@[MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationSoftwareKey, MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationHardwareKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification object:self userInfo:dict];
}

static void minidrone_settingsstate_cutoutmodechanged_callback(uint8_t enable, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:enable]] forKeys:@[MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotificationEnableKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification object:self userInfo:dict];
}

static void minidrone_floodcontrolstate_floodcontrolchanged_callback(uint16_t delay, void *custom)
{
    MiniDroneDeviceController *self = (__bridge MiniDroneDeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedShort:delay]] forKeys:@[MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotificationDelayKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification object:self userInfo:dict];
}

void batteryStateChangedCallback (uint8_t percent, void *custom)
{
    // callback of changing of battery level
    DeviceController *deviceController = (__bridge MiniDroneDeviceController*)custom;
    
    NSLog(@"batteryStateChangedCallback ... %d  ; %@", percent, deviceController);
}

- (void)registerMiniDroneARCommandsCallbacks
{
    // Battery state
    ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback(batteryStateChangedCallback, (__bridge void *)self);
    // Command class PilotingState
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback(minidrone_pilotingstate_flattrimchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback(minidrone_pilotingstate_flyingstatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback(minidrone_pilotingstate_alertstatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback(minidrone_pilotingstate_autotakeoffmodechanged_callback, (__bridge void *)(self));
    // Command class MediaRecordState
    ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback(minidrone_mediarecordstate_picturestatechanged_callback, (__bridge void *)(self));
    // Command class Event
    // Command class PilotingSettingsState
    ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback(minidrone_pilotingsettingsstate_maxaltitudechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback(minidrone_pilotingsettingsstate_maxtiltchanged_callback, (__bridge void *)(self));
    // Command class SpeedSettingsState
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback(minidrone_speedsettingsstate_maxverticalspeedchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback(minidrone_speedsettingsstate_maxrotationspeedchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback(minidrone_speedsettingsstate_wheelschanged_callback, (__bridge void *)(self));
    // Command class SettingsState
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback(minidrone_settingsstate_productmotorsversionchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback(minidrone_settingsstate_productinertialversionchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback(minidrone_settingsstate_cutoutmodechanged_callback, (__bridge void *)(self));
    // Command class FloodControlState
    ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback(minidrone_floodcontrolstate_floodcontrolchanged_callback, (__bridge void *)(self));
}

- (void)unregisterMiniDroneARCommandsCallbacks
{
    // Battery state
    ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback (NULL, NULL);
    // Command class PilotingState
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback(NULL, NULL);
    // Command class MediaRecordState
    ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback(NULL, NULL);
    // Command class Event
    // Command class PilotingSettingsState
    ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback(NULL, NULL);
    // Command class SpeedSettingsState
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback(NULL, NULL);
    // Command class SettingsState
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback(NULL, NULL);
    // Command class FloodControlState
    ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback(NULL, NULL);
}

#pragma mark ARCommands sending function 
    // Command class Piloting
- (BOOL)MiniDroneDeviceController_SendPilotingFlatTrim:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send FlatTrim command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingFlatTrim(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send FlatTrim command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingTakeOff:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send TakeOff command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingTakeOff(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send TakeOff command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingPCMD:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withFlag:(uint8_t)flag withRoll:(int8_t)roll withPitch:(int8_t)pitch withYaw:(int8_t)yaw withGaz:(int8_t)gaz withPsi:(float)psi
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send PCMD command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD(cmdbuf, sizeof(cmdbuf), &actualSize, flag, roll, pitch, yaw, gaz, psi);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send PCMD command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingLanding:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Landing command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingLanding(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Landing command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingEmergency:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Emergency command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingEmergency(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Emergency command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingAutoTakeOffMode:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withState:(uint8_t)state
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send AutoTakeOffMode command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingAutoTakeOffMode(cmdbuf, sizeof(cmdbuf), &actualSize, state);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send AutoTakeOffMode command.");
    }

    return sentStatus;
}
    // Command class Animations
- (BOOL)MiniDroneDeviceController_SendAnimationsFlip:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withDirection:(eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION)direction
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Flip command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsFlip(cmdbuf, sizeof(cmdbuf), &actualSize, direction);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Flip command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendAnimationsCap:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withOffset:(int16_t)offset
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Cap command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsCap(cmdbuf, sizeof(cmdbuf), &actualSize, offset);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Cap command.");
    }

    return sentStatus;
}
    // Command class MediaRecord
- (BOOL)MiniDroneDeviceController_SendMediaRecordPicture:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withMass_storage_id:(uint8_t)mass_storage_id
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Picture command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPicture(cmdbuf, sizeof(cmdbuf), &actualSize, mass_storage_id);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Picture command.");
    }

    return sentStatus;
}
    // Command class PilotingSettings
- (BOOL)MiniDroneDeviceController_SendPilotingSettingsMaxAltitude:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send MaxAltitude command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxAltitude(cmdbuf, sizeof(cmdbuf), &actualSize, current);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send MaxAltitude command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendPilotingSettingsMaxTilt:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send MaxTilt command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxTilt(cmdbuf, sizeof(cmdbuf), &actualSize, current);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send MaxTilt command.");
    }

    return sentStatus;
}
    // Command class SpeedSettings
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsMaxVerticalSpeed:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send MaxVerticalSpeed command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxVerticalSpeed(cmdbuf, sizeof(cmdbuf), &actualSize, current);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send MaxVerticalSpeed command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsMaxRotationSpeed:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send MaxRotationSpeed command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxRotationSpeed(cmdbuf, sizeof(cmdbuf), &actualSize, current);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send MaxRotationSpeed command.");
    }

    return sentStatus;
}
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsWheels:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withPresent:(uint8_t)present
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Wheels command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsWheels(cmdbuf, sizeof(cmdbuf), &actualSize, present);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send Wheels command.");
    }

    return sentStatus;
}
    // Command class Settings
- (BOOL)MiniDroneDeviceController_SendSettingsCutOutMode:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withEnable:(uint8_t)enable
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send CutOutMode command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSettingsCutOutMode(cmdbuf, sizeof(cmdbuf), &actualSize, enable);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, MiniDroneDeviceController_TAG, "Failed to send CutOutMode command.");
    }

    return sentStatus;
}
@end

// END GENERATED CODE
