/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../../Xml/commands.xml file    *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <libARCommands/ARCOMMANDS_Filter.h>
#include <jni.h>
#include <stdlib.h>

JNIEXPORT jlong JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeNewFilter(JNIEnv *env, jobject thizz, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = ARCOMMANDS_Filter_NewFilter (behavior, NULL);
    return (jlong)(intptr_t)filter;
}

JNIEXPORT void JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeDeleteFilter(JNIEnv *env, jobject thizz, jlong cFilter)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    ARCOMMANDS_Filter_DeleteFilter (&filter);
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeFilterCommand(JNIEnv *env, jobject thizz, jlong cFilter, jlong cCommand, jint len)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    uint8_t *command = (uint8_t *)(intptr_t)cCommand;
    eARCOMMANDS_FILTER_STATUS status = ARCOMMANDS_Filter_FilterCommand (filter, command, len, NULL);
    return (jint)status;
}

    // Feature generic
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetGenericBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetGenericBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetGenericDefaultBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetGenericDefaultBehavior (filter, behavior);
    return (jint)err;
}


    // Feature ARDrone3
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3Behavior (filter, behavior);
    return (jint)err;
}

    // - Class Piloting
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Animations
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AnimationsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AnimationsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Camera
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3CameraBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3CameraBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecord
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Network
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PictureSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PictureSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaStreaming
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaStreamingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaStreamingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaStreamingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaStreamingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GPSSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GPSSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CameraState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3CameraStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3CameraStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Antiflickering
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AntiflickeringState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GPSState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PROState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PROStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PROStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingFlatTrimBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingFlatTrimBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingTakeOffBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingTakeOffBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingPCMDBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingPCMDBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingLandingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingLandingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingEmergencyBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingEmergencyBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingNavigateHomeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingNavigateHomeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingAutoTakeOffModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingAutoTakeOffModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingMoveByBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingMoveByBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingUserTakeOffBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingUserTakeOffBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingCircleBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingCircleBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AnimationsFlipBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AnimationsFlipBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3CameraOrientationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3CameraOrientationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordPictureBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordVideoBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordPictureV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordVideoV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkWifiScanBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkWifiScanBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkWifiAuthChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkWifiAuthChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsMaxAltitudeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxAltitudeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsMaxTiltBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxTiltBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsAbsolutControlBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsAbsolutControlBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsMaxDistanceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxDistanceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsBankedTurnBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBankedTurnBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsMinAltitudeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMinAltitudeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsCirclingDirectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingDirectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsCirclingRadiusBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingRadiusBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsCirclingAltitudeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingAltitudeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsPitchModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsPitchModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsLandingModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsLandingModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsMaxVerticalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxVerticalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsMaxRotationSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxRotationSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsHullProtectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsHullProtectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsOutdoorBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsOutdoorBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsWifiSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsWifiSecurityBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSecurityBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsPictureFormatSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsPictureFormatSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsExpositionSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsExpositionSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsSaturationSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsSaturationSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsTimelapseSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsTimelapseSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsVideoAutorecordSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoAutorecordSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsVideoStabilizationModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoStabilizationModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaStreamingVideoEnableBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaStreamingVideoEnableBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsSetHomeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsSetHomeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsResetHomeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsResetHomeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsSendControllerGPSBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsSendControllerGPSBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsHomeTypeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsHomeTypeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsReturnHomeDelayBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsReturnHomeDelayBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringElectricFrequencyBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringElectricFrequencyBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringSetModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringSetModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordStatePictureStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordStateVideoStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordStatePictureStateChangedV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordStateVideoStateChangedV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordEventPictureEventChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordEventPictureEventChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaRecordEventVideoEventChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaRecordEventVideoEventChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateFlatTrimChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateFlatTrimChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateFlyingStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateFlyingStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateAlertStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateAlertStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateNavigateHomeStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateNavigateHomeStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStatePositionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStatePositionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateAttitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateAttitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateAutoTakeOffModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateAutoTakeOffModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingStateAltitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingStateAltitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingEventMoveByEndBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingEventMoveByEndBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkStateWifiScanListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiScanListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkStateAllWifiScanChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiScanChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkStateWifiAuthChannelListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiAuthChannelListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkStateAllWifiAuthChannelChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiAuthChannelChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateMaxTiltChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxTiltChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAbsolutControlChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAbsolutControlChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateMaxDistanceChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxDistanceChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateBankedTurnChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBankedTurnChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateMinAltitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMinAltitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStatePitchModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStatePitchModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PilotingSettingsStateLandingModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateLandingModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateHullProtectionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateHullProtectionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateOutdoorChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateOutdoorChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsStateWifiSelectionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSelectionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsStateWifiSecurityChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3NetworkSettingsStateWifiSecurityBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateProductMotorVersionListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateProductMotorVersionListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateProductGPSVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateProductGPSVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateMotorErrorStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateMotorSoftwareVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorSoftwareVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateMotorFlightsStatusChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorFlightsStatusChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateMotorErrorLastErrorChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorLastErrorChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3SettingsStateP7IDBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3SettingsStateP7IDBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStatePictureFormatChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStatePictureFormatChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateExpositionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateExpositionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateSaturationChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateSaturationChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateTimelapseChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateTimelapseChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateVideoAutorecordChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoAutorecordChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3MediaStreamingStateVideoEnableChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateVideoEnableChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateHomeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateResetHomeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateResetHomeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateGPSFixStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSFixStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateHomeTypeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeTypeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3CameraStateOrientationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3CameraStateOrientationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3CameraStateDefaultCameraOrientationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3CameraStateDefaultCameraOrientationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringStateElectricFrequencyChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateElectricFrequencyChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3AntiflickeringStateModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSStateNumberOfSatelliteChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSStateNumberOfSatelliteChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSStateHomeTypeAvailabilityChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeAvailabilityChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3GPSStateHomeTypeChosenChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeChosenChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetARDrone3PROStateFeaturesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetARDrone3PROStateFeaturesBehavior (filter, behavior);
    return (jint)err;
}


    // Feature JumpingSumo
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Piloting
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Animations
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AnimationsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecord
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Network
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AudioSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AudioSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class RoadPlan
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanBehavior (filter, behavior);
    return (jint)err;
}

    // - Class RoadPlanState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSpeedSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSpeedSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaStreaming
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaStreamingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaStreamingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaStreamingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class VideoSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoVideoSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class VideoSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoVideoSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingPCMDBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingPCMDBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingPostureBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingPostureBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingAddCapOffsetBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingAddCapOffsetBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsJumpStopBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpStopBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsJumpCancelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpCancelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsJumpLoadBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpLoadBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsJumpBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsSimpleAnimationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsSimpleAnimationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordPictureBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordVideoBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordPictureV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordVideoV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkSettingsWifiSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsWifiSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkWifiScanBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiScanBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkWifiAuthChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiAuthChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsMasterVolumeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsMasterVolumeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsThemeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsThemeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanAllScriptsMetadataBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanAllScriptsMetadataBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanScriptUploadedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptUploadedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanScriptDeleteBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptDeleteBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanPlayScriptBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanPlayScriptBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSpeedSettingsOutdoorBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsOutdoorBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaStreamingVideoEnableBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingVideoEnableBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoVideoSettingsAutorecordBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsAutorecordBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingStatePostureChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingStatePostureChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingStateAlertStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingStateAlertStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoPilotingStateSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoPilotingStateSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsStateJumpLoadChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpLoadChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsStateJumpTypeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpTypeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSettingsStateProductGPSVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSettingsStateProductGPSVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordStatePictureStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordStateVideoStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordStatePictureStateChangedV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordStateVideoStateChangedV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordEventPictureEventChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventPictureEventChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaRecordEventVideoEventChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventVideoEventChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateWifiScanListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiScanListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateAllWifiScanChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiScanChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoNetworkStateLinkQualityChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoNetworkStateLinkQualityChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoAudioSettingsStateThemeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateThemeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStateScriptUploadChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptUploadChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStateScriptDeleteChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptDeleteChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoRoadPlanStatePlayScriptChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStatePlayScriptChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoSpeedSettingsStateOutdoorChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateOutdoorChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoMediaStreamingStateVideoEnableChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateVideoEnableChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetJumpingSumoVideoSettingsStateAutorecordChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateAutorecordChangedBehavior (filter, behavior);
    return (jint)err;
}


    // Feature MiniDrone
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Piloting
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Animations
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneAnimationsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneAnimationsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecord
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MediaRecordEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class PilotingSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SpeedSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Settings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class FloodControlState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneFloodControlStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneFloodControlStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GPS
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneGPSBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneGPSBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Configuration
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneConfigurationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneConfigurationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingFlatTrimBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingFlatTrimBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingTakeOffBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingTakeOffBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingPCMDBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingPCMDBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingLandingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingLandingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingEmergencyBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingEmergencyBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingAutoTakeOffModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingAutoTakeOffModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneAnimationsFlipBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneAnimationsFlipBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneAnimationsCapBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneAnimationsCapBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordPictureBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordPictureV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsMaxAltitudeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxAltitudeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsMaxTiltBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxTiltBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsMaxVerticalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxVerticalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsMaxRotationSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxRotationSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsWheelsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsWheelsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsCutOutModeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsCutOutModeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneGPSControllerLatitudeForRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneGPSControllerLatitudeForRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneGPSControllerLongitudeForRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneGPSControllerLongitudeForRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneConfigurationControllerTypeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerTypeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneConfigurationControllerNameBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerNameBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingStateFlatTrimChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingStateFlatTrimChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingStateFlyingStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingStateFlyingStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingStateAlertStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingStateAlertStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingStateAutoTakeOffModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingStateAutoTakeOffModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordStatePictureStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordStatePictureStateChangedV2Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedV2Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneMediaRecordEventPictureEventChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventPictureEventChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDronePilotingSettingsStateMaxTiltChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxTiltChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsStateWheelsChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateWheelsChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsStateProductMotorsVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductMotorsVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsStateProductInertialVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductInertialVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneSettingsStateCutOutModeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneSettingsStateCutOutModeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetMiniDroneFloodControlStateFloodControlChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetMiniDroneFloodControlStateFloodControlChangedBehavior (filter, behavior);
    return (jint)err;
}


    // Feature SkyController
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerBehavior (filter, behavior);
    return (jint)err;
}

    // - Class WifiState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Wifi
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Device
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceBehavior (filter, behavior);
    return (jint)err;
}

    // - Class DeviceState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Settings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Common
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCommonBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCommonBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CommonState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCommonStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCommonStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SkyControllerState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSkyControllerStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AccessPointSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AccessPointSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Camera
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCameraBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCameraBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GamepadInfos
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerGamepadInfosBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerGamepadInfosBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GamepadInfosState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerGamepadInfosStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ButtonMappings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ButtonMappingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AxisMappings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AxisMappingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AxisFilters
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AxisFiltersState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CoPiloting
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCoPilotingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCoPilotingBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CoPilotingState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCoPilotingStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCoPilotingStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Calibration
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCalibrationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCalibrationBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CalibrationState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCalibrationStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCalibrationStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ButtonEvents
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonEventsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonEventsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiRequestWifiListBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiRequestWifiListBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiRequestCurrentWifiBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiRequestCurrentWifiBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiConnectToWifiBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiConnectToWifiBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiForgetWifiBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiForgetWifiBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiWifiAuthChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiWifiAuthChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceRequestDeviceListBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceRequestDeviceListBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceRequestCurrentDeviceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceRequestCurrentDeviceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceConnectToDeviceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceConnectToDeviceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsAllSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsAllSettingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsResetBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsResetBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCommonAllStatesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCommonAllStatesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsAccessPointSSIDBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointSSIDBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsAccessPointChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsWifiSelectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsWifiSelectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCameraResetOrientationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCameraResetOrientationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerGamepadInfosGetGamepadControlsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerGamepadInfosGetGamepadControlsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsSetButtonMappingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsSetButtonMappingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsDefaultButtonMappingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsDefaultButtonMappingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsSetAxisMappingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsSetAxisMappingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsDefaultAxisMappingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsDefaultAxisMappingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersGetPresetAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetPresetAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersSetAxisFilterBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersSetAxisFilterBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersDefaultAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersDefaultAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCoPilotingSetPilotingSourceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCoPilotingSetPilotingSourceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateWifiListBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiListBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateConnexionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateConnexionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateWifiAuthChannelListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiAuthChannelListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateAllWifiAuthChannelChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateAllWifiAuthChannelChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerWifiStateWifiSignalChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiSignalChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceStateDeviceListBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceStateDeviceListBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerDeviceStateConnexionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerDeviceStateConnexionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsStateAllSettingsChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsStateAllSettingsChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsStateResetChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsStateResetChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsStateProductSerialChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductSerialChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSettingsStateProductVariantChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductVariantChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCommonStateAllStatesChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCommonStateAllStatesChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSkyControllerStateBatteryChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBatteryChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSkyControllerStateGpsFixChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsFixChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerSkyControllerStateGpsPositionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsPositionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerGamepadInfosStateGamepadControlBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateGamepadControlBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersStatePresetAxisFiltersBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStatePresetAxisFiltersBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCoPilotingStatePilotingSourceBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCoPilotingStatePilotingSourceBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCalibrationStateMagnetoCalibrationStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetSkyControllerButtonEventsSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetSkyControllerButtonEventsSettingsBehavior (filter, behavior);
    return (jint)err;
}


    // Feature unknown_feature_1
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1Behavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1Behavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1GeographicRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1GeographicRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1RelativeRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1RelativeRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1LookAtRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1LookAtRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1SpiralAnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1SwingAnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1BoomerangAnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1CandleAnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1DollySlideAnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1UserFramingPositionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1UserGPSDataBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1UserGPSDataBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1UserBaroDataBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1UserBaroDataBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1LynxDetectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1LynxDetectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1AvailabilityBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1AvailabilityBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1RunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1RunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1GeographicConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1GeographicConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1RelativeConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1RelativeConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1AnimRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1AnimRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1SpiralAnimConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1SwingAnimConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1BoomerangAnimConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1CandleAnimConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1DollySlideAnimConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetUnknownFeature1UserFramingPositionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionChangedBehavior (filter, behavior);
    return (jint)err;
}


    // Feature common
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Network
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonNetworkBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonNetworkBehavior (filter, behavior);
    return (jint)err;
}

    // - Class NetworkEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonNetworkEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonNetworkEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Settings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class SettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Common
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CommonState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class OverHeat
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatBehavior (filter, behavior);
    return (jint)err;
}

    // - Class OverHeatState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Controller
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonControllerBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonControllerBehavior (filter, behavior);
    return (jint)err;
}

    // - Class WifiSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonWifiSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonWifiSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class WifiSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonWifiSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonWifiSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Mavlink
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkBehavior (filter, behavior);
    return (jint)err;
}

    // - Class MavlinkState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Calibration
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CalibrationState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class CameraSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCameraSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCameraSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class GPS
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonGPSBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonGPSBehavior (filter, behavior);
    return (jint)err;
}

    // - Class FlightPlanState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class FlightPlanEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ARLibsVersionsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonARLibsVersionsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonARLibsVersionsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Audio
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAudioBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAudioBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AudioState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAudioStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAudioStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Headlights
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonHeadlightsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonHeadlightsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class HeadlightsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonHeadlightsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonHeadlightsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Animations
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AnimationsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Accessory
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryBehavior (filter, behavior);
    return (jint)err;
}

    // - Class AccessoryState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Charger
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ChargerState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class RunState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonRunStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonRunStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonNetworkDisconnectBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonNetworkDisconnectBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsAllSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsAllSettingsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsResetBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsResetBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsProductNameBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsProductNameBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsCountryBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsCountryBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsAutoCountryBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsAutoCountryBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonAllStatesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonAllStatesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonCurrentDateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonCurrentDateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonCurrentTimeBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonCurrentTimeBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonRebootBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonRebootBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatSwitchOffBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatSwitchOffBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatVentilateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatVentilateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonControllerIsPilotingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonControllerIsPilotingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonWifiSettingsOutdoorSettingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonWifiSettingsOutdoorSettingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkStartBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkStartBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkPauseBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkPauseBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkStopBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkStopBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationMagnetoCalibrationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationMagnetoCalibrationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonGPSControllerPositionForRunBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonGPSControllerPositionForRunBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAudioControllerReadyForStreamingBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAudioControllerReadyForStreamingBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonHeadlightsIntensityBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonHeadlightsIntensityBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsStartAnimationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsStartAnimationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsStopAnimationBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsStopAnimationBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsStopAllAnimationsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsStopAllAnimationsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryConfigBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryConfigBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerSetMaxChargeRateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerSetMaxChargeRateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonNetworkEventDisconnectionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonNetworkEventDisconnectionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateAllSettingsChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateAllSettingsChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateResetChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateResetChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateProductNameChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateProductNameChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateProductVersionChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateProductVersionChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateProductSerialHighChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialHighChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateProductSerialLowChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialLowChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateCountryChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateCountryChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonSettingsStateAutoCountryChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonSettingsStateAutoCountryChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateAllStatesChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateAllStatesChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateBatteryStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateBatteryStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateMassStorageStateListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateMassStorageStateListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateMassStorageInfoStateListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoStateListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateCurrentDateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateCurrentDateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateCurrentTimeChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateCurrentTimeChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateMassStorageInfoRemainingListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoRemainingListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateWifiSignalChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateWifiSignalChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateSensorsStatesListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateSensorsStatesListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateProductModelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateProductModelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCommonStateCountryListKnownBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCommonStateCountryListKnownBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatStateOverHeatChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonOverHeatStateOverHeatRegulationChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatRegulationChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonWifiSettingsStateOutdoorSettingsChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonWifiSettingsStateOutdoorSettingsChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationStateMagnetoCalibrationStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonCameraSettingsStateCameraSettingsChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonCameraSettingsStateCameraSettingsChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanStateAvailabilityStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanStateAvailabilityStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanStateComponentStateListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanStateComponentStateListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanEventStartingErrorEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanEventStartingErrorEventBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonFlightPlanEventSpeedBridleEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonFlightPlanEventSpeedBridleEventBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAudioStateAudioStreamingRunningBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAudioStateAudioStreamingRunningBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonHeadlightsStateIntensityChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonHeadlightsStateIntensityChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAnimationsStateListBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAnimationsStateListBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryStateSupportedAccessoriesListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryStateSupportedAccessoriesListChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryStateAccessoryConfigChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonAccessoryStateAccessoryConfigModificationEnabledBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigModificationEnabledBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerStateMaxChargeRateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerStateMaxChargeRateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerStateCurrentChargeStateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerStateCurrentChargeStateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerStateLastChargeRateChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerStateLastChargeRateChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonChargerStateChargingInfoBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonChargerStateChargingInfoBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonRunStateRunIdChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonRunStateRunIdChangedBehavior (filter, behavior);
    return (jint)err;
}


    // Feature commonDebug
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Stats
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class StatsEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsEventBehavior (filter, behavior);
    return (jint)err;
}

    // - Class DebugSettings
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsBehavior (filter, behavior);
    return (jint)err;
}

    // - Class DebugSettingsState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsSendPacketBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsSendPacketBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsStartSendingPacketFromDroneBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsStartSendingPacketFromDroneBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsStopSendingPacketFromDroneBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsStopSendingPacketFromDroneBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsGetAllBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsGetAllBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsSetBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsSetBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugStatsEventSendPacketBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugStatsEventSendPacketBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsStateInfoBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateInfoBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetCommonDebugDebugSettingsStateListChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateListChangedBehavior (filter, behavior);
    return (jint)err;
}


    // Feature pro
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProBehavior (filter, behavior);
    return (jint)err;
}

    // - Class Pro
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ProState
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProStateBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProStateBehavior (filter, behavior);
    return (jint)err;
}

    // - Class ProEvent
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProEventBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProBoughtFeaturesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProBoughtFeaturesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProResponseBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProResponseBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProActivateFeaturesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProActivateFeaturesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProStateSupportedFeaturesBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProStateSupportedFeaturesBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProStateFeaturesActivatedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProStateFeaturesActivatedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetProProEventChallengeEventBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetProProEventChallengeEventBehavior (filter, behavior);
    return (jint)err;
}


    // Feature wifi
JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiScanBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiScanBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiUpdateAuthorizedChannelsBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiUpdateAuthorizedChannelsBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiSetApChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiSetApChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiSetSecurityBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiSetSecurityBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiSetCountryBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiSetCountryBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiSetEnvironementBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiSetEnvironementBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiScannedItemBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiScannedItemBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiAuthorizedChannelBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiAuthorizedChannelBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiApChannelChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiApChannelChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiSecurityChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiSecurityChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiCountryChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiCountryChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiEnvironementChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiEnvironementChangedBehavior (filter, behavior);
    return (jint)err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommandsFilter_nativeSetWifiRssiChangedBehavior (JNIEnv *env, jobject thizz, jlong cFilter, jint behavior)
{
    ARCOMMANDS_Filter_t *filter = (ARCOMMANDS_Filter_t *)(intptr_t)cFilter;
    eARCOMMANDS_FILTER_ERROR err = ARCOMMANDS_Filter_SetWifiRssiChangedBehavior (filter, behavior);
    return (jint)err;
}


/* END OF GENERAED CODE */
