/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x10000049 generated on 2021-01-06 17:58:18.905141
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x10000049);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21;
x0=IKcos(j[0]);
x1=IKcos(j[1]);
x2=IKsin(j[2]);
x3=IKcos(j[2]);
x4=IKsin(j[1]);
x5=IKsin(j[3]);
x6=IKsin(j[0]);
x7=IKcos(j[3]);
x8=IKcos(j[4]);
x9=IKsin(j[4]);
x10=((0.106)*x3);
x11=((0.0845)*x2);
x12=((0.0845)*x3);
x13=((1.0)*x3);
x14=((1.0)*x7);
x15=((1.0)*x5);
x16=(x0*x4);
x17=(x4*x6);
x18=(x0*x1);
x19=(x1*x2);
x20=(x1*x6);
x21=(x2*x4);
eetrans[0]=((((0.106)*x16))+((x5*(((((-1.0)*x11*x16))+((x12*x18))))))+((x7*((((x11*x18))+((x12*x16))))))+((x10*x16))+(((0.106)*x18*x2)));
eetrans[1]=((((0.106)*x19*x6))+((x7*((((x11*x20))+((x12*x17))))))+(((0.106)*x17))+((x5*(((((-1.0)*x11*x17))+((x12*x20))))))+((x10*x17)));
IkReal x22=((1.0)*x11);
eetrans[2]=((0.0605)+((x5*(((((-1.0)*x1*x22))+(((-1.0)*x12*x4))))))+((x1*x10))+(((0.106)*x1))+((x7*(((((-1.0)*x22*x4))+((x1*x12))))))+(((-0.106)*x21)));
eerot[0]=(((x8*((((x7*(((((-1.0)*x13*x18))+((x16*x2))))))+((x5*((((x18*x2))+((x16*x3))))))))))+((x6*x9)));
IkReal x23=((1.0)*x17);
eerot[1]=((((-1.0)*x8*((((x15*(((((-1.0)*x19*x6))+(((-1.0)*x13*x23))))))+((x14*(((((-1.0)*x2*x23))+((x20*x3))))))))))+(((-1.0)*x0*x9)));
IkReal x24=((1.0)*x13);
eerot[2]=((-1.0)*x8*((((x15*(((((-1.0)*x1*x24))+x21))))+((x14*(((((-1.0)*x19))+(((-1.0)*x24*x4)))))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 5; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x56000007; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j0mul,j1,cj1,sj1,htj1,j1mul,j2,cj2,sj2,htj2,j2mul,j3,cj3,sj3,htj3,j3mul,j4,cj4,sj4,htj4,j4mul,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

r00 = eerot[0];
r01 = eerot[1];
r02 = eerot[2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];
new_r00=r01;
new_px=py;
new_r01=((-1.0)*r00);
new_py=((-1.0)*px);
new_r02=r02;
new_pz=((-0.0605)+pz);
r00 = new_r00; r01 = new_r01; r02 = new_r02; px = new_px; py = new_py; pz = new_pz;

pp=((px*px)+(py*py)+(pz*pz));
{
IkReal j0eval[1];
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x26 = IKatan2WithCheck(IkReal(((-1.0)*px)),IkReal(((-1.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x26.valid){
continue;
}
IkReal x25=x26.value;
j0array[0]=((-1.0)*x25);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x25)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

IkReal op[4+1], zeror[4];
int numroots;
IkReal x27=py*py*py;
IkReal x28=r01*r01;
IkReal x29=r02*r02;
IkReal x30=py*py;
IkReal x31=px*px;
IkReal x32=r00*r00;
IkReal x33=pz*pz;
IkReal x34=px*px*px;
IkReal x35=((1073.62959567631)*r02);
IkReal x36=((536.814797838153)*sj0);
IkReal x37=((113.804737141688)*r00);
IkReal x38=((536.814797838153)*cj0);
IkReal x39=((113.804737141688)*pz);
IkReal x40=(cj0*py);
IkReal x41=(r00*r01);
IkReal x42=((7.66598372052774)*r02);
IkReal x43=(px*sj0);
IkReal x44=(r02*sj0);
IkReal x45=(py*x31);
IkReal x46=(cj0*pz*r01);
IkReal x47=(px*x33);
IkReal x48=(pz*r00*sj0);
IkReal x49=(px*x30);
IkReal x50=(py*x33);
IkReal x51=((113.804737141688)*r01*r02);
IkReal x52=((3.83299186026387)*x29);
IkReal x53=((0.812594274375941)*r00*x44);
IkReal x54=((0.812594274375941)*cj0*r01*r02);
IkReal x55=(py*pz*r01*sj0);
IkReal x56=(x29*x33);
IkReal x57=(x32*x43);
IkReal x58=((3.83299186026387)*x28*x40);
IkReal x59=((3.83299186026387)*cj0*px*x41);
IkReal x60=(x42*x46);
IkReal x61=(x43*x52);
IkReal x62=(x40*x52);
IkReal x63=(x42*x48);
IkReal x64=((3.83299186026387)*x57);
IkReal x65=((3.83299186026387)*py*sj0*x41);
IkReal x66=(cj0*x31*x51);
IkReal x67=(x27*x36*x41);
IkReal x68=(x27*x29*x38);
IkReal x69=(py*x43*x51);
IkReal x70=(x27*x28*x38);
IkReal x71=(x29*x39*x43);
IkReal x72=(x37*x55);
IkReal x73=(x39*x57);
IkReal x74=(x29*x34*x36);
IkReal x75=(x34*x38*x41);
IkReal x76=(x28*x39*x40);
IkReal x77=(x32*x34*x36);
IkReal x78=(x29*x39*x40);
IkReal x79=(x30*x37*x44);
IkReal x80=(px*r02*x37*x40);
IkReal x81=(px*x37*x46);
IkReal x82=(x32*x36*x49);
IkReal x83=(px*pz*r00*x35*x40);
IkReal x84=(x29*x38*x50);
IkReal x85=((1610.44439351446)*cj0*x41*x49);
IkReal x86=(x29*x38*x45);
IkReal x87=(x30*x35*x48);
IkReal x88=((1073.62959567631)*x31*x32*x40);
IkReal x89=(x38*x41*x47);
IkReal x90=(x28*x38*x50);
IkReal x91=(x28*x38*x45);
IkReal x92=((1610.44439351446)*sj0*x41*x45);
IkReal x93=(x31*x35*x46);
IkReal x94=(x36*x41*x50);
IkReal x95=(x32*x36*x47);
IkReal x96=(x29*x36*x49);
IkReal x97=((1073.62959567631)*x28*x30*x43);
IkReal x98=(x29*x36*x47);
IkReal x99=(py*pz*r01*x35*x43);
IkReal x100=(x76+x79+x78+x54+x80+x81);
IkReal x101=(x73+x72+x71+x53+x66+x69);
IkReal x102=(x70+x59+x58+x60+x61+x67+x68+x88+x89+x82+x83+x86+x87+x84+x85+x90);
IkReal x103=(x77+x75+x74+x62+x63+x64+x65+x99+x98+x91+x93+x92+x95+x94+x97+x96);
op[0]=((((-38.8222182865807)*cj0*r00*r01*sj0*(pz*pz)))+(((-7596.43581846443)*cj0*py*pz*r00*r02*sj0*(px*px)))+(((268.407398919076)*(pz*pz*pz)*(r02*r02)))+(((-0.170874370327182)*(r00*r00)*(sj0*sj0)))+(((1.91649593013194)*pz*(r02*r02)))+(((-1.91649593013194)*pz*(cj0*cj0)*(r01*r01)))+(((-268.407398919076)*px*r00*r02*(py*py)))+(((1266.07263641074)*(cj0*cj0)*(px*px)*(pz*pz)*(r01*r01)))+(((2532.14527282148)*cj0*pz*r00*r02*sj0*(py*py*py)))+(((-268.407398919076)*pz*(cj0*cj0)*(py*py)*(r01*r01)))+(((38.8222182865807)*cj0*py*pz*r00*r02*sj0))+(((633.036318205369)*(pz*pz*pz*pz)*(r00*r00)*(sj0*sj0)))+(((-268.407398919076)*pz*(px*px)*(r00*r00)*(sj0*sj0)))+(((2532.14527282148)*(py*py)*(pz*pz)*(r01*r01)))+(((633.036318205369)*(py*py*py*py)*(r00*r00)*(sj0*sj0)))+(((805.222196757229)*cj0*py*r00*r02*sj0*(pz*pz)))+(((805.222196757229)*px*r00*r02*(pz*pz)))+(((633.036318205369)*(cj0*cj0)*(py*py*py*py)*(r01*r01)))+(((-1073.62959567631)*cj0*px*py*pz*sj0*(r02*r02)))+(((-2532.14527282148)*py*pz*r01*r02*(cj0*cj0)*(px*px)))+(((-1266.07263641074)*(px*px)*(py*py)*(r00*r00)*(sj0*sj0)))+(((-38.8222182865807)*px*py*r00*r01*(sj0*sj0)))+(((-38.8222182865807)*px*py*r00*r01*(cj0*cj0)))+(((-805.222196757229)*cj0*px*r01*r02*sj0*(py*py)))+(((-268.407398919076)*r00*r02*(px*px*px)))+(((28.4511842854221)*(py*py)*(r01*r01)))+(((19.4111091432903)*(cj0*cj0)*(px*px)*(r01*r01)))+(((0.0322741982668032)*(r02*r02)))+(((2532.14527282148)*cj0*pz*r01*r02*sj0*(px*px*px)))+(((2532.14527282148)*(cj0*cj0)*(px*px)*(py*py)*(r00*r00)))+(((268.407398919076)*(cj0*cj0)*(pz*pz*pz)*(r01*r01)))+(((1.91649593013194)*py*r01*r02))+(((2532.14527282148)*py*r00*r01*(px*px*px)*(sj0*sj0)))+(((-1.91649593013194)*cj0*px*r01*r02*sj0))+(((-2532.14527282148)*cj0*px*sj0*(py*py*py)*(r01*r01)))+(((19.4111091432903)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((536.814797838153)*cj0*px*py*pz*sj0*(r01*r01)))+(((28.4511842854221)*(px*px)*(r00*r00)))+(((-536.814797838153)*px*py*pz*r00*r01*(cj0*cj0)))+(((5064.29054564295)*px*pz*r00*r02*(cj0*cj0)*(py*py)))+(((536.814797838153)*pz*(py*py)*(r01*r01)))+(((19.4111091432903)*(py*py)*(r00*r00)*(sj0*sj0)))+(((268.407398919076)*r00*r02*(px*px*px)*(sj0*sj0)))+(((-1.91649593013194)*pz*(r00*r00)*(sj0*sj0)))+(((536.814797838153)*pz*(px*px)*(r02*r02)*(sj0*sj0)))+(((-7596.43581846443)*cj0*px*pz*r01*r02*sj0*(py*py)))+(((268.407398919076)*(pz*pz*pz)*(r00*r00)*(sj0*sj0)))+(((74.9825188551078)*px*pz*r00*r02))+(((2532.14527282148)*py*r01*r02*(pz*pz*pz)))+(((536.814797838153)*py*r01*r02*(px*px)*(sj0*sj0)))+(((-1266.07263641074)*(cj0*cj0)*(px*px)*(py*py)*(r01*r01)))+(((536.814797838153)*pz*(cj0*cj0)*(py*py)*(r02*r02)))+(((-805.222196757229)*py*r01*r02*(cj0*cj0)*(pz*pz)))+(((1266.07263641074)*(py*py)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((5064.29054564295)*py*pz*r01*r02*(px*px)*(sj0*sj0)))+(((2532.14527282148)*(px*px)*(pz*pz)*(r02*r02)*(sj0*sj0)))+(((1.91649593013194)*py*r01*r02*(cj0*cj0)))+(((805.222196757229)*py*r01*r02*(pz*pz)))+(((-2532.14527282148)*pz*r01*r02*(py*py*py)))+(((2532.14527282148)*pz*r00*r02*(px*px*px)*(sj0*sj0)))+(((56.9023685708442)*px*py*r00*r01))+(((-0.170874370327182)*(cj0*cj0)*(r01*r01)))+(((-268.407398919076)*py*r01*r02*(cj0*cj0)*(px*px)))+(((5064.29054564295)*px*py*r00*r01*(pz*pz)))+(((2532.14527282148)*px*r00*r01*(cj0*cj0)*(py*py*py)))+(((633.036318205369)*(py*py*py*py)*(r02*r02)))+(((268.407398919076)*cj0*r00*r02*sj0*(py*py*py)))+(((268.407398919076)*r01*r02*(cj0*cj0)*(py*py*py)))+(((-268.407398919076)*pz*(py*py)*(r02*r02)))+(((268.407398919076)*cj0*r01*r02*sj0*(px*px*px)))+(((1073.62959567631)*px*py*pz*r00*r01))+(((-7596.43581846443)*cj0*r00*r01*sj0*(px*px)*(py*py)))+(((-805.222196757229)*cj0*py*r00*r02*sj0*(px*px)))+(((-19.4111091432903)*(cj0*cj0)*(py*py)*(r01*r01)))+(((-536.814797838153)*px*py*pz*r00*r01*(sj0*sj0)))+(((-9.04007514213177)*(py*py)*(r02*r02)))+(((1.91649593013194)*px*r00*r02*(sj0*sj0)))+(((38.8222182865807)*cj0*px*py*sj0*(r01*r01)))+(((-1266.07263641074)*cj0*r00*r01*sj0*(pz*pz*pz*pz)))+(((-268.407398919076)*py*r01*r02*(px*px)))+(((3.83299186026387)*cj0*pz*r00*r01*sj0))+(((-1266.07263641074)*(cj0*cj0)*(py*py)*(pz*pz)*(r01*r01)))+(((0.341748740654364)*cj0*r00*r01*sj0))+(((2532.14527282148)*px*r00*r02*(pz*pz*pz)))+(((-268.407398919076)*pz*(px*px)*(r02*r02)))+(((633.036318205369)*(pz*pz*pz*pz)*(r02*r02)))+(((-2532.14527282148)*px*pz*r00*r02*(py*py)*(sj0*sj0)))+(((38.8222182865807)*cj0*px*py*sj0*(r00*r00)))+(((-2532.14527282148)*cj0*py*sj0*(px*px*px)*(r00*r00)))+(((-2532.14527282148)*py*r00*r01*(cj0*cj0)*(px*px*px)))+(((-2532.14527282148)*px*py*r00*r01*(cj0*cj0)*(pz*pz)))+(((-2532.14527282148)*px*r00*r02*(pz*pz*pz)*(sj0*sj0)))+(((2532.14527282148)*cj0*py*r00*r02*sj0*(pz*pz*pz)))+(((1.91649593013194)*px*r00*r02))+(((-2532.14527282148)*py*r01*r02*(cj0*cj0)*(pz*pz*pz)))+(((-19.4111091432903)*(px*px)*(r00*r00)*(sj0*sj0)))+(((-5064.29054564295)*cj0*px*py*sj0*(pz*pz)*(r02*r02)))+(((1266.07263641074)*cj0*r00*r01*sj0*(py*py*py*py)))+(((-1266.07263641074)*(px*px)*(pz*pz)*(r02*r02)))+(((633.036318205369)*(cj0*cj0)*(pz*pz*pz*pz)*(r01*r01)))+(((2532.14527282148)*cj0*px*r01*r02*sj0*(pz*pz*pz)))+(((-2532.14527282148)*px*pz*r00*r02*(py*py)))+(((-2532.14527282148)*py*pz*r01*r02*(px*px)))+(((2532.14527282148)*cj0*px*sj0*(py*py*py)*(r00*r00)))+(((633.036318205369)*(px*px*px*px)*(r02*r02)))+(((2532.14527282148)*cj0*py*sj0*(px*px*px)*(r01*r01)))+(((37.4912594275539)*(pz*pz)*(r02*r02)))+(((536.814797838153)*px*r00*r02*(cj0*cj0)*(py*py)))+(((-38.8222182865807)*px*pz*r00*r02*(sj0*sj0)))+(((74.9825188551078)*py*pz*r01*r02))+(((-805.222196757229)*px*r00*r02*(pz*pz)*(sj0*sj0)))+(((-9.04007514213177)*(px*px)*(r02*r02)))+(((536.814797838153)*cj0*px*py*pz*sj0*(r00*r00)))+(((2532.14527282148)*cj0*px*py*sj0*(pz*pz)*(r00*r00)))+(((805.222196757229)*cj0*px*r01*r02*sj0*(pz*pz)))+(((633.036318205369)*(px*px*px*px)*(r00*r00)*(sj0*sj0)))+(((536.814797838153)*pz*(px*px)*(r00*r00)))+(((-2532.14527282148)*px*r00*r01*(py*py*py)*(sj0*sj0)))+(((-1.91649593013194)*cj0*py*r00*r02*sj0))+(((2532.14527282148)*pz*r01*r02*(cj0*cj0)*(py*py*py)))+(((1266.07263641074)*(px*px)*(py*py)*(r02*r02)))+(((-268.407398919076)*px*r00*r02*(py*py)*(sj0*sj0)))+(((-1266.07263641074)*(py*py)*(pz*pz)*(r02*r02)))+(((268.407398919076)*pz*(cj0*cj0)*(px*px)*(r01*r01)))+(((-38.8222182865807)*py*pz*r01*r02*(cj0*cj0)))+(((38.8222182865807)*cj0*px*pz*r01*r02*sj0))+(((2532.14527282148)*(px*px)*(py*py)*(r01*r01)*(sj0*sj0)))+(((-2532.14527282148)*px*py*r00*r01*(pz*pz)*(sj0*sj0)))+(((1266.07263641074)*cj0*r00*r01*sj0*(px*px*px*px)))+(((2532.14527282148)*(px*px)*(pz*pz)*(r00*r00)))+(((2532.14527282148)*(cj0*cj0)*(py*py)*(pz*pz)*(r02*r02)))+(((2532.14527282148)*cj0*px*py*sj0*(pz*pz)*(r01*r01)))+(((-268.407398919076)*r01*r02*(py*py*py)))+(((268.407398919076)*pz*(py*py)*(r00*r00)*(sj0*sj0)))+(((633.036318205369)*(cj0*cj0)*(px*px*px*px)*(r01*r01)))+(((19.4111091432903)*(cj0*cj0)*(pz*pz)*(r01*r01)))+(((-536.814797838153)*cj0*r00*r01*sj0*(pz*pz*pz)))+(((-1266.07263641074)*(px*px)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((-2532.14527282148)*pz*r00*r02*(px*px*px))));
op[1]=((((-1.0)*x101))+(((-1.0)*x103))+x100+x102);
op[2]=((((56.9023685708442)*(px*px)*(r00*r00)))+(((149.965037710216)*py*pz*r01*r02*(cj0*cj0)))+(((0.470845533721577)*(cj0*cj0)*(r01*r01)))+(((-77.6444365731613)*py*pz*r01*r02))+(((-2532.14527282148)*(px*px)*(py*py)*(r00*r00)*(sj0*sj0)))+(((-2532.14527282148)*(px*px)*(pz*pz)*(r02*r02)))+(((5064.29054564295)*(px*px)*(pz*pz)*(r00*r00)))+(((149.965037710216)*px*py*r00*r01*(sj0*sj0)))+(((5064.29054564295)*cj0*px*py*sj0*(pz*pz)*(r01*r01)))+(((-38.8222182865807)*(pz*pz)*(r02*r02)))+(((95.7245868574249)*(py*py)*(r02*r02)))+(((5064.29054564295)*cj0*px*r01*r02*sj0*(pz*pz*pz)))+(((0.470845533721577)*(r00*r00)*(sj0*sj0)))+(((-2532.14527282148)*cj0*r00*r01*sj0*(pz*pz*pz*pz)))+(((2532.14527282148)*cj0*r00*r01*sj0*(py*py*py*py)))+(((-2532.14527282148)*(py*py)*(pz*pz)*(r02*r02)))+(((5064.29054564295)*cj0*pz*r00*r02*sj0*(py*py*py)))+(((2532.14527282148)*cj0*r00*r01*sj0*(px*px*px*px)))+(((1266.07263641074)*(pz*pz*pz*pz)*(r02*r02)))+(((5064.29054564295)*(cj0*cj0)*(py*py)*(pz*pz)*(r02*r02)))+(((74.9825188551078)*(cj0*cj0)*(py*py)*(r01*r01)))+(((-2532.14527282148)*(px*px)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((-15192.8716369289)*cj0*r00*r01*sj0*(px*px)*(py*py)))+(((-149.965037710216)*cj0*py*pz*r00*r02*sj0))+(((-5064.29054564295)*py*r00*r01*(cj0*cj0)*(px*px*px)))+(((-77.6444365731613)*px*pz*r00*r02))+(((-5064.29054564295)*pz*r00*r02*(px*px*px)))+(((113.804737141688)*px*py*r00*r01))+(((-149.965037710216)*cj0*px*py*sj0*(r01*r01)))+(((5064.29054564295)*px*r00*r01*(cj0*cj0)*(py*py*py)))+(((5064.29054564295)*pz*r00*r02*(px*px*px)*(sj0*sj0)))+(((-10128.5810912859)*cj0*px*py*sj0*(pz*pz)*(r02*r02)))+(((5064.29054564295)*cj0*px*py*sj0*(pz*pz)*(r00*r00)))+(((5064.29054564295)*cj0*px*sj0*(py*py*py)*(r00*r00)))+(((56.9023685708442)*(py*py)*(r01*r01)))+(((-2532.14527282148)*(cj0*cj0)*(px*px)*(py*py)*(r01*r01)))+(((1266.07263641074)*(cj0*cj0)*(pz*pz*pz*pz)*(r01*r01)))+(((-5064.29054564295)*py*pz*r01*r02*(px*px)))+(((-74.9825188551078)*(cj0*cj0)*(px*px)*(r01*r01)))+(((1266.07263641074)*(pz*pz*pz*pz)*(r00*r00)*(sj0*sj0)))+(((5064.29054564295)*(py*py)*(pz*pz)*(r01*r01)))+(((-5064.29054564295)*py*r01*r02*(cj0*cj0)*(pz*pz*pz)))+(((-5064.29054564295)*cj0*px*sj0*(py*py*py)*(r01*r01)))+(((2532.14527282148)*(py*py)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((1266.07263641074)*(cj0*cj0)*(px*px*px*px)*(r01*r01)))+(((2532.14527282148)*(px*px)*(py*py)*(r02*r02)))+(((95.7245868574249)*(px*px)*(r02*r02)))+(((74.9825188551078)*(px*px)*(r00*r00)*(sj0*sj0)))+(((-74.9825188551078)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((5064.29054564295)*(px*px)*(py*py)*(r01*r01)*(sj0*sj0)))+(((-5064.29054564295)*px*py*r00*r01*(pz*pz)*(sj0*sj0)))+(((-15192.8716369289)*cj0*py*pz*r00*r02*sj0*(px*px)))+(((5064.29054564295)*(px*px)*(pz*pz)*(r02*r02)*(sj0*sj0)))+(((-149.965037710216)*cj0*px*py*sj0*(r00*r00)))+(((10128.5810912859)*px*py*r00*r01*(pz*pz)))+(((-5064.29054564295)*px*py*r00*r01*(cj0*cj0)*(pz*pz)))+(((5064.29054564295)*py*r00*r01*(px*px*px)*(sj0*sj0)))+(((-74.9825188551078)*(cj0*cj0)*(pz*pz)*(r01*r01)))+(((149.965037710216)*px*pz*r00*r02*(sj0*sj0)))+(((-5064.29054564295)*px*r00*r02*(pz*pz*pz)*(sj0*sj0)))+(((149.965037710216)*cj0*r00*r01*sj0*(pz*pz)))+(((1266.07263641074)*(py*py*py*py)*(r00*r00)*(sj0*sj0)))+(((1266.07263641074)*(px*px*px*px)*(r02*r02)))+(((5064.29054564295)*pz*r01*r02*(cj0*cj0)*(py*py*py)))+(((1266.07263641074)*(py*py*py*py)*(r02*r02)))+(((-5064.29054564295)*cj0*py*sj0*(px*px*px)*(r00*r00)))+(((-5064.29054564295)*px*pz*r00*r02*(py*py)))+(((5064.29054564295)*cj0*pz*r01*r02*sj0*(px*px*px)))+(((5064.29054564295)*py*r01*r02*(pz*pz*pz)))+(((149.965037710216)*px*py*r00*r01*(cj0*cj0)))+(((-5064.29054564295)*px*pz*r00*r02*(py*py)*(sj0*sj0)))+(((5064.29054564295)*cj0*py*sj0*(px*px*px)*(r01*r01)))+(((1266.07263641074)*(px*px*px*px)*(r00*r00)*(sj0*sj0)))+(((-0.941691067443153)*cj0*r00*r01*sj0))+(((10128.5810912859)*px*pz*r00*r02*(cj0*cj0)*(py*py)))+(((5064.29054564295)*cj0*py*r00*r02*sj0*(pz*pz*pz)))+(((-5064.29054564295)*px*r00*r01*(py*py*py)*(sj0*sj0)))+(((-5064.29054564295)*pz*r01*r02*(py*py*py)))+(((-0.748045877842334)*(r02*r02)))+(((-74.9825188551078)*(py*py)*(r00*r00)*(sj0*sj0)))+(((10128.5810912859)*py*pz*r01*r02*(px*px)*(sj0*sj0)))+(((2532.14527282148)*(cj0*cj0)*(px*px)*(pz*pz)*(r01*r01)))+(((-15192.8716369289)*cj0*px*pz*r01*r02*sj0*(py*py)))+(((1266.07263641074)*(cj0*cj0)*(py*py*py*py)*(r01*r01)))+(((5064.29054564295)*px*r00*r02*(pz*pz*pz)))+(((-5064.29054564295)*py*pz*r01*r02*(cj0*cj0)*(px*px)))+(((-149.965037710216)*cj0*px*pz*r01*r02*sj0))+(((5064.29054564295)*(cj0*cj0)*(px*px)*(py*py)*(r00*r00)))+(((-2532.14527282148)*(cj0*cj0)*(py*py)*(pz*pz)*(r01*r01))));
op[3]=((((-1.0)*x100))+(((-1.0)*x103))+x101+x102);
op[4]=((((-38.8222182865807)*cj0*r00*r01*sj0*(pz*pz)))+(((-7596.43581846443)*cj0*py*pz*r00*r02*sj0*(px*px)))+(((-536.814797838153)*pz*(cj0*cj0)*(py*py)*(r02*r02)))+(((-0.170874370327182)*(r00*r00)*(sj0*sj0)))+(((-268.407398919076)*(pz*pz*pz)*(r00*r00)*(sj0*sj0)))+(((-1073.62959567631)*px*py*pz*r00*r01))+(((1266.07263641074)*(cj0*cj0)*(px*px)*(pz*pz)*(r01*r01)))+(((2532.14527282148)*cj0*pz*r00*r02*sj0*(py*py*py)))+(((38.8222182865807)*cj0*py*pz*r00*r02*sj0))+(((633.036318205369)*(pz*pz*pz*pz)*(r00*r00)*(sj0*sj0)))+(((2532.14527282148)*(py*py)*(pz*pz)*(r01*r01)))+(((805.222196757229)*px*r00*r02*(pz*pz)*(sj0*sj0)))+(((633.036318205369)*(py*py*py*py)*(r00*r00)*(sj0*sj0)))+(((633.036318205369)*(cj0*cj0)*(py*py*py*py)*(r01*r01)))+(((268.407398919076)*pz*(px*px)*(r00*r00)*(sj0*sj0)))+(((-2532.14527282148)*py*pz*r01*r02*(cj0*cj0)*(px*px)))+(((-1266.07263641074)*(px*px)*(py*py)*(r00*r00)*(sj0*sj0)))+(((-38.8222182865807)*px*py*r00*r01*(sj0*sj0)))+(((268.407398919076)*px*r00*r02*(py*py)*(sj0*sj0)))+(((-38.8222182865807)*px*py*r00*r01*(cj0*cj0)))+(((268.407398919076)*r00*r02*(px*px*px)))+(((536.814797838153)*px*py*pz*r00*r01*(cj0*cj0)))+(((-536.814797838153)*pz*(px*px)*(r00*r00)))+(((28.4511842854221)*(py*py)*(r01*r01)))+(((-3.83299186026387)*cj0*pz*r00*r01*sj0))+(((19.4111091432903)*(cj0*cj0)*(px*px)*(r01*r01)))+(((0.0322741982668032)*(r02*r02)))+(((-536.814797838153)*py*r01*r02*(px*px)*(sj0*sj0)))+(((2532.14527282148)*cj0*pz*r01*r02*sj0*(px*px*px)))+(((2532.14527282148)*(cj0*cj0)*(px*px)*(py*py)*(r00*r00)))+(((2532.14527282148)*py*r00*r01*(px*px*px)*(sj0*sj0)))+(((-2532.14527282148)*cj0*px*sj0*(py*py*py)*(r01*r01)))+(((19.4111091432903)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((-536.814797838153)*cj0*px*py*pz*sj0*(r00*r00)))+(((-268.407398919076)*pz*(py*py)*(r00*r00)*(sj0*sj0)))+(((28.4511842854221)*(px*px)*(r00*r00)))+(((-536.814797838153)*px*r00*r02*(cj0*cj0)*(py*py)))+(((5064.29054564295)*px*pz*r00*r02*(cj0*cj0)*(py*py)))+(((19.4111091432903)*(py*py)*(r00*r00)*(sj0*sj0)))+(((-7596.43581846443)*cj0*px*pz*r01*r02*sj0*(py*py)))+(((74.9825188551078)*px*pz*r00*r02))+(((2532.14527282148)*py*r01*r02*(pz*pz*pz)))+(((-805.222196757229)*px*r00*r02*(pz*pz)))+(((-1266.07263641074)*(cj0*cj0)*(px*px)*(py*py)*(r01*r01)))+(((1266.07263641074)*(py*py)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((-268.407398919076)*r00*r02*(px*px*px)*(sj0*sj0)))+(((5064.29054564295)*py*pz*r01*r02*(px*px)*(sj0*sj0)))+(((2532.14527282148)*(px*px)*(pz*pz)*(r02*r02)*(sj0*sj0)))+(((-805.222196757229)*py*r01*r02*(pz*pz)))+(((-2532.14527282148)*pz*r01*r02*(py*py*py)))+(((2532.14527282148)*pz*r00*r02*(px*px*px)*(sj0*sj0)))+(((56.9023685708442)*px*py*r00*r01))+(((-0.170874370327182)*(cj0*cj0)*(r01*r01)))+(((-1.91649593013194)*px*r00*r02*(sj0*sj0)))+(((5064.29054564295)*px*py*r00*r01*(pz*pz)))+(((1.91649593013194)*cj0*py*r00*r02*sj0))+(((-268.407398919076)*(pz*pz*pz)*(r02*r02)))+(((268.407398919076)*pz*(px*px)*(r02*r02)))+(((2532.14527282148)*px*r00*r01*(cj0*cj0)*(py*py*py)))+(((633.036318205369)*(py*py*py*py)*(r02*r02)))+(((268.407398919076)*r01*r02*(py*py*py)))+(((-805.222196757229)*cj0*py*r00*r02*sj0*(pz*pz)))+(((-7596.43581846443)*cj0*r00*r01*sj0*(px*px)*(py*py)))+(((-19.4111091432903)*(cj0*cj0)*(py*py)*(r01*r01)))+(((-268.407398919076)*cj0*r01*r02*sj0*(px*px*px)))+(((-9.04007514213177)*(py*py)*(r02*r02)))+(((38.8222182865807)*cj0*px*py*sj0*(r01*r01)))+(((-1266.07263641074)*cj0*r00*r01*sj0*(pz*pz*pz*pz)))+(((-536.814797838153)*pz*(py*py)*(r01*r01)))+(((-268.407398919076)*(cj0*cj0)*(pz*pz*pz)*(r01*r01)))+(((-1266.07263641074)*(cj0*cj0)*(py*py)*(pz*pz)*(r01*r01)))+(((0.341748740654364)*cj0*r00*r01*sj0))+(((-1.91649593013194)*py*r01*r02))+(((2532.14527282148)*px*r00*r02*(pz*pz*pz)))+(((633.036318205369)*(pz*pz*pz*pz)*(r02*r02)))+(((-2532.14527282148)*px*pz*r00*r02*(py*py)*(sj0*sj0)))+(((1.91649593013194)*cj0*px*r01*r02*sj0))+(((-268.407398919076)*r01*r02*(cj0*cj0)*(py*py*py)))+(((268.407398919076)*px*r00*r02*(py*py)))+(((-1.91649593013194)*py*r01*r02*(cj0*cj0)))+(((38.8222182865807)*cj0*px*py*sj0*(r00*r00)))+(((-2532.14527282148)*cj0*py*sj0*(px*px*px)*(r00*r00)))+(((-268.407398919076)*cj0*r00*r02*sj0*(py*py*py)))+(((-2532.14527282148)*py*r00*r01*(cj0*cj0)*(px*px*px)))+(((-2532.14527282148)*px*py*r00*r01*(cj0*cj0)*(pz*pz)))+(((-2532.14527282148)*px*r00*r02*(pz*pz*pz)*(sj0*sj0)))+(((2532.14527282148)*cj0*py*r00*r02*sj0*(pz*pz*pz)))+(((268.407398919076)*py*r01*r02*(px*px)))+(((-2532.14527282148)*py*r01*r02*(cj0*cj0)*(pz*pz*pz)))+(((-19.4111091432903)*(px*px)*(r00*r00)*(sj0*sj0)))+(((-5064.29054564295)*cj0*px*py*sj0*(pz*pz)*(r02*r02)))+(((1266.07263641074)*cj0*r00*r01*sj0*(py*py*py*py)))+(((-1266.07263641074)*(px*px)*(pz*pz)*(r02*r02)))+(((536.814797838153)*cj0*r00*r01*sj0*(pz*pz*pz)))+(((633.036318205369)*(cj0*cj0)*(pz*pz*pz*pz)*(r01*r01)))+(((2532.14527282148)*cj0*px*r01*r02*sj0*(pz*pz*pz)))+(((805.222196757229)*py*r01*r02*(cj0*cj0)*(pz*pz)))+(((-2532.14527282148)*px*pz*r00*r02*(py*py)))+(((-2532.14527282148)*py*pz*r01*r02*(px*px)))+(((2532.14527282148)*cj0*px*sj0*(py*py*py)*(r00*r00)))+(((633.036318205369)*(px*px*px*px)*(r02*r02)))+(((268.407398919076)*pz*(cj0*cj0)*(py*py)*(r01*r01)))+(((2532.14527282148)*cj0*py*sj0*(px*px*px)*(r01*r01)))+(((-536.814797838153)*pz*(px*px)*(r02*r02)*(sj0*sj0)))+(((37.4912594275539)*(pz*pz)*(r02*r02)))+(((-38.8222182865807)*px*pz*r00*r02*(sj0*sj0)))+(((74.9825188551078)*py*pz*r01*r02))+(((-536.814797838153)*cj0*px*py*pz*sj0*(r01*r01)))+(((-9.04007514213177)*(px*px)*(r02*r02)))+(((1.91649593013194)*pz*(r00*r00)*(sj0*sj0)))+(((268.407398919076)*py*r01*r02*(cj0*cj0)*(px*px)))+(((2532.14527282148)*cj0*px*py*sj0*(pz*pz)*(r00*r00)))+(((805.222196757229)*cj0*py*r00*r02*sj0*(px*px)))+(((-1.91649593013194)*px*r00*r02))+(((633.036318205369)*(px*px*px*px)*(r00*r00)*(sj0*sj0)))+(((268.407398919076)*pz*(py*py)*(r02*r02)))+(((536.814797838153)*px*py*pz*r00*r01*(sj0*sj0)))+(((-2532.14527282148)*px*r00*r01*(py*py*py)*(sj0*sj0)))+(((2532.14527282148)*pz*r01*r02*(cj0*cj0)*(py*py*py)))+(((1266.07263641074)*(px*px)*(py*py)*(r02*r02)))+(((-805.222196757229)*cj0*px*r01*r02*sj0*(pz*pz)))+(((-1266.07263641074)*(py*py)*(pz*pz)*(r02*r02)))+(((-38.8222182865807)*py*pz*r01*r02*(cj0*cj0)))+(((38.8222182865807)*cj0*px*pz*r01*r02*sj0))+(((2532.14527282148)*(px*px)*(py*py)*(r01*r01)*(sj0*sj0)))+(((-2532.14527282148)*px*py*r00*r01*(pz*pz)*(sj0*sj0)))+(((1266.07263641074)*cj0*r00*r01*sj0*(px*px*px*px)))+(((2532.14527282148)*(px*px)*(pz*pz)*(r00*r00)))+(((-268.407398919076)*pz*(cj0*cj0)*(px*px)*(r01*r01)))+(((2532.14527282148)*(cj0*cj0)*(py*py)*(pz*pz)*(r02*r02)))+(((2532.14527282148)*cj0*px*py*sj0*(pz*pz)*(r01*r01)))+(((-1.91649593013194)*pz*(r02*r02)))+(((633.036318205369)*(cj0*cj0)*(px*px*px*px)*(r01*r01)))+(((19.4111091432903)*(cj0*cj0)*(pz*pz)*(r01*r01)))+(((1073.62959567631)*cj0*px*py*pz*sj0*(r02*r02)))+(((805.222196757229)*cj0*px*r01*r02*sj0*(py*py)))+(((1.91649593013194)*pz*(cj0*cj0)*(r01*r01)))+(((-1266.07263641074)*(px*px)*(pz*pz)*(r00*r00)*(sj0*sj0)))+(((-2532.14527282148)*pz*r00*r02*(px*px*px))));
polyroots4(op,zeror,numroots);
IkReal j1array[4], cj1array[4], sj1array[4], tempj1array[1];
int numsolutions = 0;
for(int ij1 = 0; ij1 < numroots; ++ij1)
{
IkReal htj1 = zeror[ij1];
tempj1array[0]=((2.0)*(atan(htj1)));
for(int kj1 = 0; kj1 < 1; ++kj1)
{
j1array[numsolutions] = tempj1array[kj1];
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
sj1array[numsolutions] = IKsin(j1array[numsolutions]);
cj1array[numsolutions] = IKcos(j1array[numsolutions]);
numsolutions++;
}
}
bool j1valid[4]={true,true,true,true};
_nj1 = 4;
for(int ij1 = 0; ij1 < numsolutions; ++ij1)
    {
if( !j1valid[ij1] )
{
    continue;
}
    j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
htj1 = IKtan(j1/2);

_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < numsolutions; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
sj4array[0]=((((-1.0)*r01*sj0))+(((-1.0)*cj0*r00)));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal j3eval[2];
j3eval[0]=cj4;
j3eval[1]=IKsign(cj4);
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
j3eval[0]=cj4;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[2];
j3eval[0]=cj4;
j3eval[1]=sj4;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x104=((11.8343195266272)*sj1);
cj3array[0]=((-0.398584905660377)+(((55.8222619180529)*(px*px)))+(((55.8222619180529)*(pz*pz)))+(((-11.8343195266272)*cj1*pz))+(((-1.0)*px*sj0*x104))+(((55.8222619180529)*(py*py)))+((cj0*py*x104)));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x105=px*px;
IkReal x106=py*py;
IkReal x107=pz*pz;
IkReal x108=(r01*sj0);
IkReal x109=((2.0)*pz);
IkReal x110=((0.212)*cj1);
IkReal x111=((0.212)*sj1);
IkReal x112=(px*r01);
IkReal x113=(py*sj0);
IkReal x114=(cj0*r00);
IkReal x115=(cj0*px*r02);
IkReal x116=((1.0)*x107);
evalcond[0]=((-0.01837625)+(((-1.0)*py*r00*x111))+(((2.0)*px*r00*x113))+((x106*x108))+((x111*x112))+(((-1.0)*x105*x108))+((r02*x109*x113))+((x109*x115))+(((-1.0)*x110*x115))+(((-1.0)*x108*x116))+(((-1.0)*x114*x116))+((pz*x108*x110))+(((-1.0)*x106*x114))+(((-0.011236)*x114))+((pz*x110*x114))+(((-0.011236)*x108))+(((2.0)*cj0*py*x112))+(((-1.0)*r02*x110*x113))+(((-0.017914)*(IKcos(j3))))+((x105*x114)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[2];
sj4=1.0;
cj4=0;
j4=1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x117=((424000.0)*sj1);
IkReal x118=(px*sj0);
IkReal x119=(cj1*pz);
IkReal x120=(cj0*py);
IkReal x121=((338000.0)*sj3);
IkReal x122=((338000.0)*cj3);
IkReal x123=((424000.0)*cj1);
IkReal x124=(sj1*x121);
CheckValue<IkReal> x125 = IKatan2WithCheck(IkReal(((((-1.0)*x118*x123))+(((-1.0)*x120*x124))+((cj1*x120*x122))+(((-35828.0)*sj3))+((pz*x117))+(((-1.0)*cj1*x118*x122))+((x120*x123))+((pz*sj1*x122))+((x119*x121))+((x118*x124)))),IkReal(((44944.0)+(((-1.0)*x119*x122))+((x117*x120))+(((35828.0)*cj3))+((cj1*x120*x121))+(((-1.0)*sj1*x118*x122))+(((-1.0)*x117*x118))+(((-424000.0)*x119))+(((-1.0)*cj1*x118*x121))+((pz*x124))+((sj1*x120*x122)))),IKFAST_ATAN2_MAGTHRESH);
if(!x125.valid){
continue;
}
CheckValue<IkReal> x126=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x126.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x125.value)+(((1.5707963267949)*(x126.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x127=IKsin(j2);
IkReal x128=IKcos(j2);
IkReal x129=((1.0)*r01);
IkReal x130=(cj1*pz);
IkReal x131=(r00*sj1);
IkReal x132=(cj0*r00);
IkReal x133=(px*sj1);
IkReal x134=(cj0*r02);
IkReal x135=(cj1*py);
IkReal x136=(cj1*px);
IkReal x137=(r02*sj0);
IkReal x138=(r01*sj0);
IkReal x139=(pz*sj1);
IkReal x140=((0.106)*x127);
IkReal x141=((0.106)*x128);
IkReal x142=((0.0845)*x128);
IkReal x143=((0.0845)*x127);
IkReal x144=((1.0)*py*sj1);
IkReal x145=(sj3*x142);
IkReal x146=(cj3*x143);
IkReal x147=(sj3*x143);
IkReal x148=(cj3*x142);
IkReal x149=(x141+x148);
IkReal x150=(x140+x145+x146);
evalcond[0]=(((cj0*x135))+x150+x139+(((-1.0)*sj0*x136)));
evalcond[1]=((-0.106)+(((-1.0)*x149))+(((-1.0)*cj0*x144))+x147+x130+((sj0*x133)));
evalcond[2]=(((x138*x139))+((cj0*pz*x131))+(((-1.0)*x137*x144))+(((-1.0)*x150))+((r00*x135))+(((-1.0)*x133*x134))+(((-1.0)*x129*x136)));
evalcond[3]=((((-1.0)*x149))+(((0.106)*x138))+(((0.106)*x132))+((x135*x137))+(((-1.0)*x130*x132))+((py*x131))+x147+((x134*x136))+(((-1.0)*x129*x133))+(((-1.0)*sj0*x129*x130)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x151=((11.8343195266272)*sj1);
cj3array[0]=((-0.398584905660377)+((cj0*py*x151))+(((55.8222619180529)*(px*px)))+(((55.8222619180529)*(pz*pz)))+(((-11.8343195266272)*cj1*pz))+(((55.8222619180529)*(py*py)))+(((-1.0)*px*sj0*x151)));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x152=px*px;
IkReal x153=py*py;
IkReal x154=pz*pz;
IkReal x155=(r01*sj0);
IkReal x156=((2.0)*pz);
IkReal x157=((0.212)*cj1);
IkReal x158=((0.212)*sj1);
IkReal x159=(px*r01);
IkReal x160=(py*sj0);
IkReal x161=(cj0*r00);
IkReal x162=(cj0*px*r02);
IkReal x163=((1.0)*x154);
evalcond[0]=((0.01837625)+(((-1.0)*r02*x157*x160))+((x153*x155))+(((-1.0)*x157*x162))+((r02*x156*x160))+(((-1.0)*x152*x155))+((pz*x157*x161))+(((-0.011236)*x161))+((x152*x161))+(((-0.011236)*x155))+(((-1.0)*x161*x163))+((x156*x162))+(((0.017914)*(IKcos(j3))))+(((2.0)*px*r00*x160))+(((-1.0)*py*r00*x158))+((x158*x159))+(((-1.0)*x153*x161))+(((-1.0)*x155*x163))+(((2.0)*cj0*py*x159))+((pz*x155*x157)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[2];
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x164=((424000.0)*sj1);
IkReal x165=(px*sj0);
IkReal x166=(cj1*pz);
IkReal x167=(cj0*py);
IkReal x168=((338000.0)*sj3);
IkReal x169=((338000.0)*cj3);
IkReal x170=((424000.0)*cj1);
IkReal x171=(sj1*x168);
CheckValue<IkReal> x172=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x172.valid){
continue;
}
CheckValue<IkReal> x173 = IKatan2WithCheck(IkReal(((((-35828.0)*sj3))+(((-1.0)*cj1*x165*x169))+((pz*x164))+((x167*x170))+((pz*sj1*x169))+((x166*x168))+((x165*x171))+((cj1*x167*x169))+(((-1.0)*x167*x171))+(((-1.0)*x165*x170)))),IkReal(((44944.0)+(((-1.0)*x166*x169))+((pz*x171))+(((35828.0)*cj3))+(((-1.0)*cj1*x165*x168))+(((-1.0)*sj1*x165*x169))+(((-424000.0)*x166))+((x164*x167))+((cj1*x167*x168))+((sj1*x167*x169))+(((-1.0)*x164*x165)))),IKFAST_ATAN2_MAGTHRESH);
if(!x173.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x172.value)))+(x173.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x174=IKsin(j2);
IkReal x175=IKcos(j2);
IkReal x176=((1.0)*r01);
IkReal x177=(cj1*pz);
IkReal x178=(r00*sj1);
IkReal x179=(cj0*r00);
IkReal x180=(px*sj1);
IkReal x181=(cj0*r02);
IkReal x182=(cj1*py);
IkReal x183=(cj1*px);
IkReal x184=(r02*sj0);
IkReal x185=(r01*sj0);
IkReal x186=(pz*sj1);
IkReal x187=((0.106)*x174);
IkReal x188=((0.106)*x175);
IkReal x189=((0.0845)*x175);
IkReal x190=((0.0845)*x174);
IkReal x191=((1.0)*py*sj1);
IkReal x192=(sj3*x189);
IkReal x193=(cj3*x190);
IkReal x194=(cj3*x189);
IkReal x195=(sj3*x190);
IkReal x196=(x194+x188);
IkReal x197=(x193+x192+x187);
evalcond[0]=((((-1.0)*sj0*x183))+((cj0*x182))+x197+x186);
evalcond[1]=((-0.106)+((sj0*x180))+(((-1.0)*x196))+x177+x195+(((-1.0)*cj0*x191)));
evalcond[2]=(((r00*x182))+((x185*x186))+((cj0*pz*x178))+x197+(((-1.0)*x180*x181))+(((-1.0)*x176*x183))+(((-1.0)*x184*x191)));
evalcond[3]=((((-1.0)*x177*x179))+((py*x178))+(((-1.0)*x195))+(((0.106)*x185))+x196+(((-1.0)*x176*x180))+(((0.106)*x179))+(((-1.0)*sj0*x176*x177))+((x182*x184))+((x181*x183)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2, j3]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x198=px*px;
IkReal x199=py*py;
IkReal x200=pz*pz;
IkReal x201=(px*r00);
IkReal x202=(py*sj0);
IkReal x203=(pz*r02);
IkReal x204=(r01*sj0);
IkReal x205=(cj0*r00);
IkReal x206=((53.0)*sj1);
IkReal x207=((106000.0)*cj1);
IkReal x208=(py*r01);
IkReal x209=((106000.0)*sj1);
IkReal x210=((1000000.0)*cj0*px);
IkReal x211=((500000.0)*x200);
IkReal x212=((500000.0)*x199);
IkReal x213=((500000.0)*x198);
CheckValue<IkReal> x214=IKPowWithIntegerCheck(cj4,-1);
if(!x214.valid){
continue;
}
CheckValue<IkReal> x215=IKPowWithIntegerCheck(sj4,-1);
if(!x215.valid){
continue;
}
if( IKabs(((0.0188679245283019)*(x214.value)*(((((500.0)*x208))+(((500.0)*x203))+(((500.0)*x201))+((cj0*r01*x206))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x206)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.000111644523836106)*(x215.value)*((((x204*x212))+((pz*x204*x207))+((x203*x210))+(((1000000.0)*x202*x203))+((x208*x210))+(((1000000.0)*x201*x202))+(((-1.0)*x204*x213))+(((-1.0)*x204*x211))+((x205*x213))+(((-1.0)*x205*x211))+(((-1.0)*x205*x212))+(((-1.0)*cj0*px*r02*x207))+((pz*x205*x207))+((px*r01*x209))+(((-1.0)*py*r00*x209))+(((-9188.125)*sj4))+(((-1.0)*r02*x202*x207))+(((-5618.0)*x204))+(((-5618.0)*x205)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.0188679245283019)*(x214.value)*(((((500.0)*x208))+(((500.0)*x203))+(((500.0)*x201))+((cj0*r01*x206))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x206))))))+IKsqr(((0.000111644523836106)*(x215.value)*((((x204*x212))+((pz*x204*x207))+((x203*x210))+(((1000000.0)*x202*x203))+((x208*x210))+(((1000000.0)*x201*x202))+(((-1.0)*x204*x213))+(((-1.0)*x204*x211))+((x205*x213))+(((-1.0)*x205*x211))+(((-1.0)*x205*x212))+(((-1.0)*cj0*px*r02*x207))+((pz*x205*x207))+((px*r01*x209))+(((-1.0)*py*r00*x209))+(((-9188.125)*sj4))+(((-1.0)*r02*x202*x207))+(((-5618.0)*x204))+(((-5618.0)*x205))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((0.0188679245283019)*(x214.value)*(((((500.0)*x208))+(((500.0)*x203))+(((500.0)*x201))+((cj0*r01*x206))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x206))))), ((0.000111644523836106)*(x215.value)*((((x204*x212))+((pz*x204*x207))+((x203*x210))+(((1000000.0)*x202*x203))+((x208*x210))+(((1000000.0)*x201*x202))+(((-1.0)*x204*x213))+(((-1.0)*x204*x211))+((x205*x213))+(((-1.0)*x205*x211))+(((-1.0)*x205*x212))+(((-1.0)*cj0*px*r02*x207))+((pz*x205*x207))+((px*r01*x209))+(((-1.0)*py*r00*x209))+(((-9188.125)*sj4))+(((-1.0)*r02*x202*x207))+(((-5618.0)*x204))+(((-5618.0)*x205))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x216=IKcos(j3);
IkReal x217=px*px;
IkReal x218=py*py;
IkReal x219=pz*pz;
IkReal x220=(py*r00);
IkReal x221=((2.0)*px);
IkReal x222=((0.212)*sj1);
IkReal x223=((0.212)*cj1);
IkReal x224=(r01*sj0);
IkReal x225=(cj0*py);
IkReal x226=(cj0*r00);
IkReal x227=((0.106)*cj1);
IkReal x228=(r00*sj0);
IkReal x229=(cj0*r02);
IkReal x230=(px*sj0);
IkReal x231=(cj0*r01);
IkReal x232=((0.106)*sj1);
IkReal x233=((1.0)*r02);
IkReal x234=((0.106)*cj4);
IkReal x235=((1.0)*x218);
IkReal x236=(py*r02*sj0);
IkReal x237=((0.017914)*x216);
IkReal x238=((1.0)*x217);
IkReal x239=((1.0)*x219);
evalcond[0]=((((-1.0)*px*r00))+(((-1.0)*pz*x233))+((x228*x232))+((x234*(IKsin(j3))))+(((-1.0)*x231*x232))+(((-1.0)*py*r01))+((r02*x227)));
evalcond[1]=((0.00714025)+((pz*x223))+(((-1.0)*x222*x225))+(((-1.0)*x239))+(((-1.0)*x238))+(((-1.0)*x235))+x237+((x222*x230)));
evalcond[2]=(((r02*x232))+(((-1.0)*x230*x233))+(((-1.0)*x227*x228))+((pz*x228))+(((0.0845)*cj4))+((x227*x231))+((r02*x225))+((x216*x234))+(((-1.0)*pz*x231)));
evalcond[3]=((((-1.0)*sj4*x237))+((pz*x221*x229))+(((-1.0)*x224*x239))+(((-1.0)*x224*x238))+(((-1.0)*px*x223*x229))+((px*r01*x222))+(((-0.01837625)*sj4))+(((-0.011236)*x226))+(((-0.011236)*x224))+(((-1.0)*x220*x222))+(((-1.0)*x226*x235))+(((-1.0)*x226*x239))+((r01*x221*x225))+((x218*x224))+((x217*x226))+(((-1.0)*x223*x236))+(((2.0)*pz*x236))+((sj0*x220*x221))+((pz*x223*x224))+((pz*x223*x226)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=IKsign(cj4);
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
IkReal x240=(cj3*cj4);
j2eval[0]=((((1.25443786982249)*x240))+cj4);
j2eval[1]=IKsign(((((212.0)*x240))+(((169.0)*cj4))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=sj3;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=1.0;
cj4=0;
j4=1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x241=((424000.0)*sj1);
IkReal x242=(px*sj0);
IkReal x243=(cj1*pz);
IkReal x244=(cj0*py);
IkReal x245=((338000.0)*sj3);
IkReal x246=((338000.0)*cj3);
IkReal x247=((424000.0)*cj1);
IkReal x248=(sj1*x245);
CheckValue<IkReal> x249=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x249.valid){
continue;
}
CheckValue<IkReal> x250 = IKatan2WithCheck(IkReal(((((-35828.0)*sj3))+(((-1.0)*x242*x247))+((pz*sj1*x246))+((cj1*x244*x246))+((x244*x247))+((x242*x248))+((pz*x241))+((x243*x245))+(((-1.0)*cj1*x242*x246))+(((-1.0)*x244*x248)))),IkReal(((44944.0)+(((35828.0)*cj3))+((cj1*x244*x245))+(((-1.0)*x243*x246))+((sj1*x244*x246))+(((-1.0)*sj1*x242*x246))+(((-1.0)*x241*x242))+((x241*x244))+(((-424000.0)*x243))+((pz*x248))+(((-1.0)*cj1*x242*x245)))),IKFAST_ATAN2_MAGTHRESH);
if(!x250.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x249.value)))+(x250.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x251=IKsin(j2);
IkReal x252=IKcos(j2);
IkReal x253=((1.0)*r01);
IkReal x254=(cj1*pz);
IkReal x255=(r00*sj1);
IkReal x256=(cj0*r00);
IkReal x257=(px*sj1);
IkReal x258=(cj0*r02);
IkReal x259=(cj1*py);
IkReal x260=(cj1*px);
IkReal x261=(r02*sj0);
IkReal x262=(r01*sj0);
IkReal x263=(pz*sj1);
IkReal x264=((0.106)*x251);
IkReal x265=((0.106)*x252);
IkReal x266=((0.0845)*x252);
IkReal x267=((0.0845)*x251);
IkReal x268=((1.0)*py*sj1);
IkReal x269=(sj3*x266);
IkReal x270=(cj3*x267);
IkReal x271=(sj3*x267);
IkReal x272=(cj3*x266);
IkReal x273=(x265+x272);
IkReal x274=(x264+x269+x270);
evalcond[0]=((((-1.0)*sj0*x260))+x263+x274+((cj0*x259)));
evalcond[1]=((-0.106)+((sj0*x257))+x254+x271+(((-1.0)*cj0*x268))+(((-1.0)*x273)));
evalcond[2]=(((r00*x259))+((x262*x263))+(((-1.0)*x253*x260))+(((-1.0)*x257*x258))+(((-1.0)*x261*x268))+((cj0*pz*x255))+(((-1.0)*x274)));
evalcond[3]=((((0.106)*x256))+((x258*x260))+(((-1.0)*sj0*x253*x254))+((x259*x261))+((py*x255))+(((0.106)*x262))+x271+(((-1.0)*x254*x256))+(((-1.0)*x273))+(((-1.0)*x253*x257)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x275=((424000.0)*sj1);
IkReal x276=(px*sj0);
IkReal x277=(cj1*pz);
IkReal x278=(cj0*py);
IkReal x279=((338000.0)*sj3);
IkReal x280=((338000.0)*cj3);
IkReal x281=((424000.0)*cj1);
IkReal x282=(sj1*x279);
CheckValue<IkReal> x283=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x283.valid){
continue;
}
CheckValue<IkReal> x284 = IKatan2WithCheck(IkReal(((((-35828.0)*sj3))+(((-1.0)*cj1*x276*x280))+((x278*x281))+((cj1*x278*x280))+(((-1.0)*x276*x281))+((pz*sj1*x280))+((x277*x279))+((pz*x275))+((x276*x282))+(((-1.0)*x278*x282)))),IkReal(((44944.0)+(((-1.0)*cj1*x276*x279))+(((35828.0)*cj3))+(((-1.0)*sj1*x276*x280))+(((-1.0)*x277*x280))+((x275*x278))+((sj1*x278*x280))+(((-424000.0)*x277))+(((-1.0)*x275*x276))+((cj1*x278*x279))+((pz*x282)))),IKFAST_ATAN2_MAGTHRESH);
if(!x284.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x283.value)))+(x284.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x285=IKsin(j2);
IkReal x286=IKcos(j2);
IkReal x287=((1.0)*r01);
IkReal x288=(cj1*pz);
IkReal x289=(r00*sj1);
IkReal x290=(cj0*r00);
IkReal x291=(px*sj1);
IkReal x292=(cj0*r02);
IkReal x293=(cj1*py);
IkReal x294=(cj1*px);
IkReal x295=(r02*sj0);
IkReal x296=(r01*sj0);
IkReal x297=(pz*sj1);
IkReal x298=((0.106)*x285);
IkReal x299=((0.106)*x286);
IkReal x300=((0.0845)*x286);
IkReal x301=((0.0845)*x285);
IkReal x302=((1.0)*py*sj1);
IkReal x303=(sj3*x300);
IkReal x304=(cj3*x301);
IkReal x305=(cj3*x300);
IkReal x306=(sj3*x301);
IkReal x307=(x305+x299);
IkReal x308=(x304+x303+x298);
evalcond[0]=(x308+x297+(((-1.0)*sj0*x294))+((cj0*x293)));
evalcond[1]=((-0.106)+(((-1.0)*cj0*x302))+((sj0*x291))+x306+x288+(((-1.0)*x307)));
evalcond[2]=((((-1.0)*x295*x302))+x308+((r00*x293))+((x296*x297))+((cj0*pz*x289))+(((-1.0)*x287*x294))+(((-1.0)*x291*x292)));
evalcond[3]=((((-1.0)*x288*x290))+(((-1.0)*sj0*x287*x288))+x307+(((0.106)*x296))+(((0.106)*x290))+(((-1.0)*x287*x291))+((x293*x295))+((x292*x294))+(((-1.0)*x306))+((py*x289)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x309=((5.249343832021)*sj1);
IkReal x310=(px*sj0);
IkReal x311=((5.249343832021)*cj1);
IkReal x312=(cj0*py);
if( IKabs((((x310*x311))+(((-1.0)*pz*x309))+(((-1.0)*x311*x312)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.556430446194226)+((x309*x310))+((pz*x311))+(((-1.0)*x309*x312)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x310*x311))+(((-1.0)*pz*x309))+(((-1.0)*x311*x312))))+IKsqr(((-0.556430446194226)+((x309*x310))+((pz*x311))+(((-1.0)*x309*x312))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((((x310*x311))+(((-1.0)*pz*x309))+(((-1.0)*x311*x312))), ((-0.556430446194226)+((x309*x310))+((pz*x311))+(((-1.0)*x309*x312))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x313=IKsin(j2);
IkReal x314=IKcos(j2);
IkReal x315=py*py;
IkReal x316=pz*pz;
IkReal x317=px*px;
IkReal x318=((1.0)*sj0);
IkReal x319=((0.212)*py);
IkReal x320=(px*sj0);
IkReal x321=((0.212)*r02);
IkReal x322=(cj0*r02);
IkReal x323=(r00*sj1);
IkReal x324=((2.0)*py);
IkReal x325=(r01*sj1);
IkReal x326=(cj1*r00);
IkReal x327=(cj0*pz);
IkReal x328=(pz*sj1);
IkReal x329=(r02*sj1);
IkReal x330=(cj1*pz);
IkReal x331=(cj0*px);
IkReal x332=((0.212)*r00);
IkReal x333=(pz*sj0);
IkReal x334=((1.0)*px);
IkReal x335=(cj1*py);
IkReal x336=(cj1*r02);
IkReal x337=((2.0)*r02);
IkReal x338=((1.0)*cj0);
IkReal x339=(cj1*r01);
IkReal x340=(cj1*px);
IkReal x341=((0.011236)*sj0);
IkReal x342=(r01*x330);
IkReal x343=(cj4*x314);
IkReal x344=(cj0*x339);
IkReal x345=((0.1905)*x313);
IkReal x346=((1.0)*x316);
IkReal x347=((0.1905)*x314);
IkReal x348=((2.0)*px*pz);
IkReal x349=(cj4*x313);
evalcond[0]=(x328+x345+(((-1.0)*x318*x340))+((cj0*x335)));
evalcond[1]=(x329+x344+(((-1.0)*x318*x326))+(((-1.0)*x343)));
evalcond[2]=(x336+((sj0*x323))+(((-1.0)*x325*x338))+(((-1.0)*x349)));
evalcond[3]=((-0.106)+(((-1.0)*py*sj1*x338))+x330+((sj1*x320))+(((-1.0)*x347)));
evalcond[4]=((((-1.0)*py*x318*x329))+((x323*x327))+(((-1.0)*sj1*x322*x334))+((py*x326))+(((-1.0)*sj4*x345))+((x325*x333))+(((-1.0)*x334*x339)));
evalcond[5]=((((0.106)*cj0*r00))+(((0.106)*r01*sj0))+((py*x323))+(((-1.0)*x318*x342))+(((-1.0)*sj4*x347))+((x322*x340))+(((-1.0)*x325*x334))+(((-1.0)*x326*x327))+((r02*sj0*x335)));
evalcond[6]=(((cj0*x315*x325))+(((-1.0)*x320*x328*x337))+(((-1.0)*x336*x346))+(((-0.011236)*x336))+((sj0*x316*x323))+((px*x332))+(((-1.0)*x317*x318*x323))+(((-1.0)*x324*x342))+((pz*x321))+(((-0.03629025)*x349))+(((-1.0)*x317*x325*x338))+((x323*x324*x331))+((sj0*x315*x323))+((r01*x319))+(((-1.0)*x326*x348))+((x317*x336))+((x315*x336))+(((0.011236)*cj0*x325))+(((-1.0)*x323*x341))+(((-1.0)*x316*x325*x338))+((x322*x324*x328))+(((-1.0)*x320*x324*x325)));
evalcond[7]=((((-1.0)*x322*x324*x330))+(((-1.0)*x316*x318*x326))+((x332*x333))+(((-1.0)*x324*x326*x331))+(((-0.03629025)*x343))+((x320*x324*x339))+(((-1.0)*pz*x324*x325))+(((-1.0)*x315*x318*x326))+((sj0*x317*x326))+(((-1.0)*x320*x321))+(((-1.0)*x326*x341))+((x315*x329))+((x317*x329))+(((-0.212)*r01*x327))+(((0.011236)*x344))+(((-1.0)*x323*x348))+(((-1.0)*x315*x338*x339))+(((-1.0)*x329*x346))+((x316*x344))+((x320*x330*x337))+((x317*x344))+((x319*x322))+(((0.011236)*x329)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x350=((46.5116279069767)*cj1);
IkReal x351=(cj0*py);
IkReal x352=(px*sj0);
IkReal x353=((46.5116279069767)*sj1);
if( IKabs((((x350*x352))+(((-1.0)*pz*x353))+(((-1.0)*x350*x351)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-4.93023255813953)+((x352*x353))+((pz*x350))+(((-1.0)*x351*x353)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x350*x352))+(((-1.0)*pz*x353))+(((-1.0)*x350*x351))))+IKsqr(((-4.93023255813953)+((x352*x353))+((pz*x350))+(((-1.0)*x351*x353))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((((x350*x352))+(((-1.0)*pz*x353))+(((-1.0)*x350*x351))), ((-4.93023255813953)+((x352*x353))+((pz*x350))+(((-1.0)*x351*x353))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x354=IKsin(j2);
IkReal x355=IKcos(j2);
IkReal x356=py*py;
IkReal x357=pz*pz;
IkReal x358=px*px;
IkReal x359=((0.212)*py);
IkReal x360=(px*sj0);
IkReal x361=((0.212)*r02);
IkReal x362=(cj0*r02);
IkReal x363=(py*sj1);
IkReal x364=((2.0)*r01);
IkReal x365=(cj0*r00);
IkReal x366=(pz*sj1);
IkReal x367=(cj0*r01);
IkReal x368=((0.00046225)*cj4);
IkReal x369=((2.0)*px);
IkReal x370=(r00*sj0);
IkReal x371=((0.011236)*cj1);
IkReal x372=((0.212)*pz);
IkReal x373=((1.0)*cj1);
IkReal x374=((1.0)*sj1);
IkReal x375=(cj1*py);
IkReal x376=((1.0)*r02);
IkReal x377=((2.0)*r02);
IkReal x378=(cj1*pz);
IkReal x379=(r02*sj1);
IkReal x380=(r01*sj0);
IkReal x381=((0.011236)*sj1);
IkReal x382=((0.0215)*x355);
IkReal x383=(r02*x356);
IkReal x384=(pz*x375);
IkReal x385=(cj1*x358);
IkReal x386=(sj1*x356);
IkReal x387=(cj1*x357);
IkReal x388=((0.0215)*x354);
IkReal x389=(px*x374);
IkReal x390=(x370*x373);
evalcond[0]=((((-1.0)*x390))+((cj4*x355))+x379+((cj1*x367)));
evalcond[1]=((((-1.0)*x360*x373))+x388+x366+((cj0*x375)));
evalcond[2]=(((sj1*x370))+((cj1*r02))+((cj4*x354))+(((-1.0)*x367*x374)));
evalcond[3]=((-0.106)+((sj1*x360))+x378+(((-1.0)*x382))+(((-1.0)*cj0*x363)));
evalcond[4]=(((r00*x375))+(((-1.0)*px*r01*x373))+(((-1.0)*sj0*x363*x376))+(((-1.0)*sj4*x388))+((x365*x366))+(((-1.0)*x362*x389))+((x366*x380)));
evalcond[5]=((((-1.0)*pz*x373*x380))+(((0.106)*x380))+((cj1*px*x362))+((r00*x363))+(((-1.0)*sj4*x382))+(((-1.0)*pz*x365*x373))+((r02*sj0*x375))+(((-1.0)*r01*x389))+(((0.106)*x365)));
evalcond[6]=((((-1.0)*x357*x367*x374))+(((-1.0)*r00*x369*x378))+(((-1.0)*r02*x357*x373))+((cj1*x383))+(((0.212)*px*r00))+((sj1*x357*x370))+((r01*x359))+(((-1.0)*r02*x371))+(((2.0)*pz*x362*x363))+((x370*x386))+(((-1.0)*x364*x384))+((r02*x385))+(((-1.0)*x360*x366*x377))+((x354*x368))+(((-1.0)*x358*x370*x374))+((x367*x386))+((x367*x381))+((pz*x361))+(((-1.0)*x358*x367*x374))+(((-1.0)*x360*x363*x364))+((x363*x365*x369))+(((-1.0)*x370*x381)));
evalcond[7]=(((x367*x371))+((x370*x372))+(((-2.0)*x362*x384))+(((-1.0)*r02*x357*x374))+((x358*x379))+((x360*x364*x375))+(((-1.0)*x370*x371))+(((-1.0)*x360*x361))+((x360*x377*x378))+((x370*x385))+((x355*x368))+((x356*x379))+((x359*x362))+(((-1.0)*pz*x363*x364))+(((0.011236)*x379))+(((-1.0)*x367*x372))+(((-1.0)*x356*x390))+((x367*x385))+((x367*x387))+(((-1.0)*x357*x390))+(((-1.0)*x365*x369*x375))+(((-1.0)*r00*x366*x369))+(((-1.0)*x356*x367*x373)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs(((0.797169811320755)+cj3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x391=(px*sj0);
IkReal x392=((12.4561584192523)*cj1);
IkReal x393=((9.43396229287055)*sj1);
IkReal x394=((12.4561584192523)*sj1);
IkReal x395=(cj0*py);
IkReal x396=((9.43396229287055)*cj1);
if( IKabs(((1.32035279244074)+((x394*x395))+(((-1.0)*x395*x396))+(((-1.0)*x391*x394))+((x391*x396))+(((-1.0)*pz*x392))+(((-1.0)*pz*x393)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+((pz*x396))+((x391*x393))+((x391*x392))+(((-1.0)*pz*x394))+(((-1.0)*x393*x395))+(((-1.0)*x392*x395)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((1.32035279244074)+((x394*x395))+(((-1.0)*x395*x396))+(((-1.0)*x391*x394))+((x391*x396))+(((-1.0)*pz*x392))+(((-1.0)*pz*x393))))+IKsqr(((-1.00000000304428)+((pz*x396))+((x391*x393))+((x391*x392))+(((-1.0)*pz*x394))+(((-1.0)*x393*x395))+(((-1.0)*x392*x395))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((1.32035279244074)+((x394*x395))+(((-1.0)*x395*x396))+(((-1.0)*x391*x394))+((x391*x396))+(((-1.0)*pz*x392))+(((-1.0)*pz*x393))), ((-1.00000000304428)+((pz*x396))+((x391*x393))+((x391*x392))+(((-1.0)*pz*x394))+(((-1.0)*x393*x395))+(((-1.0)*x392*x395))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x397=IKsin(j2);
IkReal x398=IKcos(j2);
IkReal x399=py*py;
IkReal x400=pz*pz;
IkReal x401=px*px;
IkReal x402=((1.0)*sj0);
IkReal x403=((0.212)*py);
IkReal x404=(px*sj0);
IkReal x405=((0.212)*r02);
IkReal x406=(cj0*r02);
IkReal x407=(r00*sj1);
IkReal x408=((2.0)*py);
IkReal x409=(r01*sj1);
IkReal x410=(cj1*r00);
IkReal x411=(cj0*pz);
IkReal x412=(cj1*r02);
IkReal x413=((0.79716981)*cj4);
IkReal x414=(r02*sj1);
IkReal x415=(cj0*px);
IkReal x416=(cj1*pz);
IkReal x417=((0.011236)*sj0);
IkReal x418=((0.0510173108376979)*sj4);
IkReal x419=((1.0)*px);
IkReal x420=(cj0*py);
IkReal x421=((2.0)*pz);
IkReal x422=((1.0)*cj0);
IkReal x423=(cj1*r01);
IkReal x424=((0.212)*r00);
IkReal x425=((0.603755157842579)*cj4);
IkReal x426=(pz*sj0);
IkReal x427=(cj1*px);
IkReal x428=(pz*sj1);
IkReal x429=(r01*x416);
IkReal x430=((0.038639151055)*x398);
IkReal x431=(cj0*x423);
IkReal x432=((1.0)*x400);
IkReal x433=((0.038639151055)*x397);
IkReal x434=(cj4*x398);
IkReal x435=(cj4*x397);
evalcond[0]=((((0.0510173108376979)*x398))+x428+x433+(((-1.0)*x402*x427))+((cj1*x420)));
evalcond[1]=((-0.106)+(((-1.0)*x430))+((sj1*x404))+(((0.0510173108376979)*x397))+(((-1.0)*sj1*x420))+x416);
evalcond[2]=((((-1.0)*x402*x410))+x414+x431+((x398*x413))+((x397*x425)));
evalcond[3]=(((sj0*x407))+(((-1.0)*x398*x425))+x412+(((-1.0)*x409*x422))+((x397*x413)));
evalcond[4]=(((py*x410))+((x407*x411))+(((-1.0)*sj1*x406*x419))+((x409*x426))+(((-1.0)*py*x402*x414))+(((-1.0)*x398*x418))+(((-1.0)*x419*x423))+(((-1.0)*sj4*x433)));
evalcond[5]=(((py*x407))+(((0.106)*cj0*r00))+(((-1.0)*x410*x411))+(((0.106)*r01*sj0))+((x406*x427))+(((-1.0)*sj4*x430))+((py*sj0*x412))+((x397*x418))+(((-1.0)*x402*x429))+(((-1.0)*x409*x419)));
evalcond[6]=(((sj0*x400*x407))+((sj0*x399*x407))+((pz*x405))+((cj0*x399*x409))+(((-1.0)*x401*x409*x422))+(((0.011236)*cj0*x409))+(((0.00247283018773374)*x434))+(((-1.0)*px*x410*x421))+(((-0.0032650082789875)*x435))+((r01*x403))+(((-0.011236)*x412))+((x406*x408*x428))+(((-1.0)*x400*x409*x422))+(((-1.0)*x408*x429))+(((-1.0)*x407*x417))+((x407*x408*x415))+((x399*x412))+((x401*x412))+(((-1.0)*x401*x402*x407))+(((-1.0)*x412*x432))+(((-1.0)*x404*x414*x421))+(((-1.0)*x404*x408*x409))+((px*x424)));
evalcond[7]=((((0.011236)*x414))+((x404*x408*x423))+((sj0*x401*x410))+((x400*x431))+((x424*x426))+(((-1.0)*x400*x402*x410))+(((-0.00247283018773374)*x435))+(((-1.0)*x399*x422*x423))+(((-0.0032650082789875)*x434))+(((-1.0)*pz*x408*x409))+(((-1.0)*x404*x405))+(((-1.0)*x408*x410*x415))+(((-1.0)*x406*x408*x416))+((x401*x431))+(((-1.0)*x399*x402*x410))+(((-1.0)*x414*x432))+(((-0.212)*r01*x411))+(((-1.0)*px*x407*x421))+(((-1.0)*x410*x417))+(((0.011236)*x431))+((x399*x414))+((x403*x406))+((x401*x414))+((x404*x412*x421)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((0.797169811320755)+cj3)))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x436=(px*sj0);
IkReal x437=((12.4561584192523)*cj1);
IkReal x438=((9.43396229287055)*sj1);
IkReal x439=((12.4561584192523)*sj1);
IkReal x440=(cj0*py);
IkReal x441=((9.43396229287055)*cj1);
if( IKabs(((-1.32035279244074)+((x436*x439))+((pz*x437))+(((-1.0)*x439*x440))+(((-1.0)*pz*x438))+(((-1.0)*x440*x441))+((x436*x441)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+((x436*x438))+(((-1.0)*x438*x440))+((pz*x439))+(((-1.0)*x436*x437))+((pz*x441))+((x437*x440)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.32035279244074)+((x436*x439))+((pz*x437))+(((-1.0)*x439*x440))+(((-1.0)*pz*x438))+(((-1.0)*x440*x441))+((x436*x441))))+IKsqr(((-1.00000000304428)+((x436*x438))+(((-1.0)*x438*x440))+((pz*x439))+(((-1.0)*x436*x437))+((pz*x441))+((x437*x440))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.32035279244074)+((x436*x439))+((pz*x437))+(((-1.0)*x439*x440))+(((-1.0)*pz*x438))+(((-1.0)*x440*x441))+((x436*x441))), ((-1.00000000304428)+((x436*x438))+(((-1.0)*x438*x440))+((pz*x439))+(((-1.0)*x436*x437))+((pz*x441))+((x437*x440))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x442=IKcos(j2);
IkReal x443=IKsin(j2);
IkReal x444=py*py;
IkReal x445=pz*pz;
IkReal x446=px*px;
IkReal x447=((1.0)*sj0);
IkReal x448=((0.212)*py);
IkReal x449=(px*sj0);
IkReal x450=((0.212)*r02);
IkReal x451=(cj0*r02);
IkReal x452=(r00*sj1);
IkReal x453=((2.0)*py);
IkReal x454=(r01*sj1);
IkReal x455=(cj1*r00);
IkReal x456=(cj0*pz);
IkReal x457=(cj1*r02);
IkReal x458=(r02*sj1);
IkReal x459=(cj0*px);
IkReal x460=(cj1*pz);
IkReal x461=((0.011236)*sj0);
IkReal x462=((0.0510173108376979)*sj4);
IkReal x463=((1.0)*px);
IkReal x464=(cj0*py);
IkReal x465=((2.0)*pz);
IkReal x466=((1.0)*cj0);
IkReal x467=(cj1*r01);
IkReal x468=((0.212)*r00);
IkReal x469=(pz*sj0);
IkReal x470=(cj1*px);
IkReal x471=(pz*sj1);
IkReal x472=(r01*x460);
IkReal x473=((0.038639151055)*x442);
IkReal x474=(cj4*x443);
IkReal x475=(cj0*x467);
IkReal x476=((1.0)*x445);
IkReal x477=((0.038639151055)*x443);
IkReal x478=(cj4*x442);
evalcond[0]=((((-1.0)*x447*x470))+((cj1*x464))+x477+x471+(((-0.0510173108376979)*x442)));
evalcond[1]=((-0.106)+((sj1*x449))+(((-1.0)*x473))+x460+(((-0.0510173108376979)*x443))+(((-1.0)*sj1*x464)));
evalcond[2]=((((-0.603755157842579)*x474))+(((-1.0)*x447*x455))+x458+x475+(((0.79716981)*x478)));
evalcond[3]=((((0.603755157842579)*x478))+(((-1.0)*x454*x466))+x457+(((0.79716981)*x474))+((sj0*x452)));
evalcond[4]=((((-1.0)*py*x447*x458))+((x454*x469))+(((-1.0)*sj4*x477))+(((-1.0)*x463*x467))+((x452*x456))+((x442*x462))+((py*x455))+(((-1.0)*sj1*x451*x463)));
evalcond[5]=((((-1.0)*sj4*x473))+((py*sj0*x457))+(((0.106)*cj0*r00))+(((-1.0)*x447*x472))+(((0.106)*r01*sj0))+(((-1.0)*x454*x463))+((x451*x470))+(((-1.0)*x455*x456))+((py*x452))+(((-1.0)*x443*x462)));
evalcond[6]=(((sj0*x444*x452))+(((-0.00247283018773374)*x478))+(((-1.0)*x446*x454*x466))+(((-1.0)*x449*x453*x454))+(((-1.0)*x445*x454*x466))+((x451*x453*x471))+(((-1.0)*x453*x472))+((x446*x457))+((cj0*x444*x454))+((r01*x448))+(((-1.0)*x452*x461))+((x452*x453*x459))+(((-0.0032650082789875)*x474))+((px*x468))+((pz*x450))+(((-1.0)*x446*x447*x452))+(((0.011236)*cj0*x454))+((x444*x457))+(((-1.0)*x449*x458*x465))+(((-0.011236)*x457))+((sj0*x445*x452))+(((-1.0)*x457*x476))+(((-1.0)*px*x455*x465)));
evalcond[7]=(((x449*x453*x467))+((x468*x469))+(((0.00247283018773374)*x474))+(((-1.0)*x453*x455*x459))+(((-1.0)*x445*x447*x455))+(((-1.0)*x451*x453*x460))+(((-1.0)*pz*x453*x454))+((x446*x475))+(((-1.0)*px*x452*x465))+(((-1.0)*x444*x466*x467))+(((0.011236)*x475))+((x446*x458))+(((-0.212)*r01*x456))+(((-1.0)*x444*x447*x455))+(((0.011236)*x458))+(((-1.0)*x455*x461))+((x448*x451))+(((-0.0032650082789875)*x478))+((sj0*x446*x455))+(((-1.0)*x458*x476))+((x449*x457*x465))+((x444*x458))+((x445*x475))+(((-1.0)*x449*x450)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x489=IKPowWithIntegerCheck(cj4,-1);
if(!x489.valid){
continue;
}
IkReal x479=x489.value;
IkReal x480=((2000.0)*cj4);
IkReal x481=(cj3*sj1);
IkReal x482=(cj1*r02);
IkReal x483=((212.0)*sj1);
IkReal x484=((-0.00471698113207547)*x479);
IkReal x485=(cj1*px*sj0);
IkReal x486=((169.0)*r00*sj0);
IkReal x487=(cj0*cj1*py);
IkReal x488=((169.0)*cj0*r01*sj1);
CheckValue<IkReal> x490=IKPowWithIntegerCheck(sj3,-1);
if(!x490.valid){
continue;
}
if( IKabs((x484*(((((-1.0)*x488))+((pz*sj1*x480))+((sj1*x486))+(((169.0)*x482))+((x480*x487))+(((-1.0)*x480*x485)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x484*(x490.value)*((((cj3*x480*x485))+((cj0*r01*x483))+(((-1.0)*r00*sj0*x483))+(((-1.0)*pz*x480*x481))+(((-1.0)*cj3*x480*x487))+(((-169.0)*cj3*x482))+(((-1.0)*x481*x486))+(((169.0)*cj0*r01*x481))+(((-212.0)*x482)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x484*(((((-1.0)*x488))+((pz*sj1*x480))+((sj1*x486))+(((169.0)*x482))+((x480*x487))+(((-1.0)*x480*x485))))))+IKsqr((x484*(x490.value)*((((cj3*x480*x485))+((cj0*r01*x483))+(((-1.0)*r00*sj0*x483))+(((-1.0)*pz*x480*x481))+(((-1.0)*cj3*x480*x487))+(((-169.0)*cj3*x482))+(((-1.0)*x481*x486))+(((169.0)*cj0*r01*x481))+(((-212.0)*x482))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x484*(((((-1.0)*x488))+((pz*sj1*x480))+((sj1*x486))+(((169.0)*x482))+((x480*x487))+(((-1.0)*x480*x485))))), (x484*(x490.value)*((((cj3*x480*x485))+((cj0*r01*x483))+(((-1.0)*r00*sj0*x483))+(((-1.0)*pz*x480*x481))+(((-1.0)*cj3*x480*x487))+(((-169.0)*cj3*x482))+(((-1.0)*x481*x486))+(((169.0)*cj0*r01*x481))+(((-212.0)*x482))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x491=IKcos(j2);
IkReal x492=IKsin(j2);
IkReal x493=py*py;
IkReal x494=pz*pz;
IkReal x495=px*px;
IkReal x496=(py*sj1);
IkReal x497=((2.0)*r01);
IkReal x498=(px*sj0);
IkReal x499=(cj0*pz);
IkReal x500=(r00*sj1);
IkReal x501=((0.212)*r01);
IkReal x502=((1.0)*sj1);
IkReal x503=(cj0*px);
IkReal x504=((1.0)*cj3);
IkReal x505=((1.0)*cj1);
IkReal x506=(px*r01);
IkReal x507=((0.212)*r00);
IkReal x508=(r01*sj0);
IkReal x509=(r00*sj0);
IkReal x510=(cj1*r02);
IkReal x511=((2.0)*pz);
IkReal x512=((1.0)*sj0);
IkReal x513=(cj1*py);
IkReal x514=((2.0)*r00);
IkReal x515=(r02*sj1);
IkReal x516=(cj0*r01);
IkReal x517=(pz*sj1);
IkReal x518=((0.212)*r02);
IkReal x519=((0.0845)*cj3);
IkReal x520=((0.01837625)*cj3);
IkReal x521=((0.00409575)*sj3);
IkReal x522=(cj4*x492);
IkReal x523=((0.0845)*x491);
IkReal x524=(cj1*x516);
IkReal x525=((0.106)*x491);
IkReal x526=(sj4*x492);
IkReal x527=(cj4*x491);
IkReal x528=(r02*x494);
IkReal x529=(x495*x516);
IkReal x530=((0.0845)*sj3*x492);
evalcond[0]=((((-1.0)*x505*x509))+(((-1.0)*x504*x527))+((sj3*x522))+x524+x515);
evalcond[1]=((((-1.0)*x502*x516))+(((-1.0)*sj3*x527))+((sj0*x500))+(((-1.0)*x504*x522))+x510);
evalcond[2]=((((0.106)*x492))+((x492*x519))+((cj0*x513))+((sj3*x523))+x517+(((-1.0)*x498*x505)));
evalcond[3]=((-0.106)+(((-1.0)*x525))+((cj1*pz))+((sj1*x498))+(((-1.0)*cj0*x496))+x530+(((-1.0)*x491*x519)));
evalcond[4]=((((-1.0)*x505*x506))+(((-1.0)*sj3*sj4*x523))+(((-0.106)*x526))+(((-1.0)*r02*x496*x512))+(((-1.0)*r02*x502*x503))+((x508*x517))+((x499*x500))+((r00*x513))+(((-1.0)*x519*x526)));
evalcond[5]=((((0.106)*cj0*r00))+(((0.0845)*sj3*x526))+((x503*x510))+(((-1.0)*x502*x506))+(((-1.0)*sj4*x525))+(((-1.0)*sj4*x491*x519))+((py*sj0*x510))+(((-1.0)*pz*x505*x508))+((r00*x496))+(((-1.0)*r00*x499*x505))+(((0.106)*x508)));
evalcond[6]=((((-1.0)*cj1*px*r00*x511))+(((-1.0)*x496*x497*x498))+(((0.011236)*sj1*x516))+(((-1.0)*x520*x522))+(((-0.011236)*x510))+(((-0.017914)*x522))+((pz*x518))+(((-1.0)*pz*x497*x513))+((sj0*x493*x500))+(((-1.0)*x502*x529))+((x521*x527))+(((-1.0)*x505*x528))+(((-1.0)*x498*x511*x515))+((sj0*x494*x500))+((px*x507))+(((-1.0)*x495*x500*x512))+((x495*x510))+((py*x501))+((sj1*x493*x516))+(((2.0)*r02*x496*x499))+((x496*x503*x514))+((x493*x510))+(((-1.0)*x494*x502*x516))+(((-0.011236)*sj0*x500)));
evalcond[7]=((((0.011236)*x524))+(((-1.0)*x499*x501))+(((-1.0)*pz*x496*x497))+(((-1.0)*x520*x527))+(((-1.0)*x521*x522))+(((-0.017914)*x527))+(((-2.0)*py*x499*x510))+(((-1.0)*x502*x528))+((x495*x524))+(((-1.0)*x503*x513*x514))+((x498*x510*x511))+(((-1.0)*x498*x518))+((cj1*x495*x509))+((x494*x524))+(((-1.0)*x494*x505*x509))+(((-1.0)*x493*x505*x509))+(((-1.0)*px*x500*x511))+(((-0.011236)*cj1*x509))+((pz*sj0*x507))+((x495*x515))+((x493*x515))+(((-1.0)*x493*x505*x516))+((cj0*py*x518))+(((0.011236)*x515))+((x497*x498*x513)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x531=(cj1*sj0);
IkReal x532=((169.0)*r00);
IkReal x533=((169.0)*r02*sj1);
IkReal x534=((2000.0)*cj4*px);
IkReal x535=((2000.0)*cj4*pz*sj1);
IkReal x536=((169.0)*cj0*cj1*r01);
IkReal x537=((2000.0)*cj0*cj1*cj4*py);
CheckValue<IkReal> x538=IKPowWithIntegerCheck(IKsign(((((169.0)*cj4))+(((212.0)*cj3*cj4)))),-1);
if(!x538.valid){
continue;
}
CheckValue<IkReal> x539 = IKatan2WithCheck(IkReal(((((-1.0)*cj3*x535))+(((-1.0)*cj3*x537))+(((-1.0)*sj3*x536))+(((-1.0)*sj3*x533))+((cj3*x531*x534))+((sj3*x531*x532)))),IkReal(((((-1.0)*sj3*x537))+(((-1.0)*sj3*x535))+(((-212.0)*r00*x531))+(((212.0)*cj0*cj1*r01))+(((-1.0)*cj3*x531*x532))+(((212.0)*r02*sj1))+((cj3*x536))+((cj3*x533))+((sj3*x531*x534)))),IKFAST_ATAN2_MAGTHRESH);
if(!x539.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x538.value)))+(x539.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x540=IKcos(j2);
IkReal x541=IKsin(j2);
IkReal x542=py*py;
IkReal x543=pz*pz;
IkReal x544=px*px;
IkReal x545=(py*sj1);
IkReal x546=((2.0)*r01);
IkReal x547=(px*sj0);
IkReal x548=(cj0*pz);
IkReal x549=(r00*sj1);
IkReal x550=((0.212)*r01);
IkReal x551=((1.0)*sj1);
IkReal x552=(cj0*px);
IkReal x553=((1.0)*cj3);
IkReal x554=((1.0)*cj1);
IkReal x555=(px*r01);
IkReal x556=((0.212)*r00);
IkReal x557=(r01*sj0);
IkReal x558=(r00*sj0);
IkReal x559=(cj1*r02);
IkReal x560=((2.0)*pz);
IkReal x561=((1.0)*sj0);
IkReal x562=(cj1*py);
IkReal x563=((2.0)*r00);
IkReal x564=(r02*sj1);
IkReal x565=(cj0*r01);
IkReal x566=(pz*sj1);
IkReal x567=((0.212)*r02);
IkReal x568=((0.0845)*cj3);
IkReal x569=((0.01837625)*cj3);
IkReal x570=((0.00409575)*sj3);
IkReal x571=(cj4*x541);
IkReal x572=((0.0845)*x540);
IkReal x573=(cj1*x565);
IkReal x574=((0.106)*x540);
IkReal x575=(sj4*x541);
IkReal x576=(cj4*x540);
IkReal x577=(r02*x543);
IkReal x578=(x544*x565);
IkReal x579=((0.0845)*sj3*x541);
evalcond[0]=((((-1.0)*x554*x558))+(((-1.0)*x553*x576))+((sj3*x571))+x573+x564);
evalcond[1]=((((-1.0)*sj3*x576))+((sj0*x549))+(((-1.0)*x553*x571))+x559+(((-1.0)*x551*x565)));
evalcond[2]=((((-1.0)*x547*x554))+(((0.106)*x541))+((cj0*x562))+((x541*x568))+((sj3*x572))+x566);
evalcond[3]=((-0.106)+((sj1*x547))+(((-1.0)*cj0*x545))+((cj1*pz))+(((-1.0)*x574))+x579+(((-1.0)*x540*x568)));
evalcond[4]=((((-1.0)*sj3*sj4*x572))+(((-0.106)*x575))+(((-1.0)*x554*x555))+((r00*x562))+(((-1.0)*r02*x545*x561))+(((-1.0)*x568*x575))+((x557*x566))+((x548*x549))+(((-1.0)*r02*x551*x552)));
evalcond[5]=((((0.106)*cj0*r00))+(((-1.0)*pz*x554*x557))+(((-1.0)*x551*x555))+((py*sj0*x559))+(((0.0845)*sj3*x575))+(((-1.0)*sj4*x540*x568))+(((0.106)*x557))+(((-1.0)*r00*x548*x554))+(((-1.0)*sj4*x574))+((x552*x559))+((r00*x545)));
evalcond[6]=((((-1.0)*x543*x551*x565))+(((-0.011236)*x559))+((x542*x559))+(((-1.0)*x569*x571))+((py*x550))+(((-0.011236)*sj0*x549))+((x545*x552*x563))+(((-1.0)*x544*x549*x561))+((sj1*x542*x565))+((x544*x559))+(((0.011236)*sj1*x565))+(((2.0)*r02*x545*x548))+((px*x556))+((sj0*x543*x549))+(((-0.017914)*x571))+(((-1.0)*cj1*px*r00*x560))+(((-1.0)*x547*x560*x564))+((pz*x567))+((sj0*x542*x549))+(((-1.0)*x554*x577))+(((-1.0)*pz*x546*x562))+(((-1.0)*x551*x578))+((x570*x576))+(((-1.0)*x545*x546*x547)));
evalcond[7]=(((pz*sj0*x556))+(((-0.011236)*cj1*x558))+(((-2.0)*py*x548*x559))+(((-1.0)*x569*x576))+(((-1.0)*px*x549*x560))+((x546*x547*x562))+(((-1.0)*x570*x571))+((cj1*x544*x558))+((x543*x573))+(((-1.0)*x548*x550))+((x542*x564))+(((-1.0)*x542*x554*x565))+(((-0.017914)*x576))+(((0.011236)*x564))+((cj0*py*x567))+(((-1.0)*x552*x562*x563))+((x547*x559*x560))+((x544*x564))+(((-1.0)*x547*x567))+(((-1.0)*pz*x545*x546))+((x544*x573))+(((0.011236)*x573))+(((-1.0)*x551*x577))+(((-1.0)*x543*x554*x558))+(((-1.0)*x542*x554*x558)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x580=(cj3*r02);
IkReal x581=((1.0)*sj1);
IkReal x582=(r02*sj3);
IkReal x583=(r00*sj0*sj3);
IkReal x584=(cj0*cj3*r01);
IkReal x585=(cj3*r00*sj0);
IkReal x586=((1.0)*cj0*r01*sj3);
CheckValue<IkReal> x587=IKPowWithIntegerCheck(IKsign(cj4),-1);
if(!x587.valid){
continue;
}
CheckValue<IkReal> x588 = IKatan2WithCheck(IkReal((((sj1*x585))+(((-1.0)*cj1*x586))+(((-1.0)*x581*x584))+(((-1.0)*x581*x582))+((cj1*x580))+((cj1*x583)))),IkReal(((((-1.0)*cj0*r01*sj3*x581))+((sj1*x583))+((sj1*x580))+(((-1.0)*cj1*x585))+((cj1*x582))+((cj1*x584)))),IKFAST_ATAN2_MAGTHRESH);
if(!x588.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x587.value)))+(x588.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x589=IKcos(j2);
IkReal x590=IKsin(j2);
IkReal x591=py*py;
IkReal x592=pz*pz;
IkReal x593=px*px;
IkReal x594=(py*sj1);
IkReal x595=((2.0)*r01);
IkReal x596=(px*sj0);
IkReal x597=(cj0*pz);
IkReal x598=(r00*sj1);
IkReal x599=((0.212)*r01);
IkReal x600=((1.0)*sj1);
IkReal x601=(cj0*px);
IkReal x602=((1.0)*cj3);
IkReal x603=((1.0)*cj1);
IkReal x604=(px*r01);
IkReal x605=((0.212)*r00);
IkReal x606=(r01*sj0);
IkReal x607=(r00*sj0);
IkReal x608=(cj1*r02);
IkReal x609=((2.0)*pz);
IkReal x610=((1.0)*sj0);
IkReal x611=(cj1*py);
IkReal x612=((2.0)*r00);
IkReal x613=(r02*sj1);
IkReal x614=(cj0*r01);
IkReal x615=(pz*sj1);
IkReal x616=((0.212)*r02);
IkReal x617=((0.0845)*cj3);
IkReal x618=((0.01837625)*cj3);
IkReal x619=((0.00409575)*sj3);
IkReal x620=(cj4*x590);
IkReal x621=((0.0845)*x589);
IkReal x622=(cj1*x614);
IkReal x623=((0.106)*x589);
IkReal x624=(sj4*x590);
IkReal x625=(cj4*x589);
IkReal x626=(r02*x592);
IkReal x627=(x593*x614);
IkReal x628=((0.0845)*sj3*x590);
evalcond[0]=((((-1.0)*x603*x607))+((sj3*x620))+(((-1.0)*x602*x625))+x613+x622);
evalcond[1]=((((-1.0)*sj3*x625))+(((-1.0)*x602*x620))+x608+((sj0*x598))+(((-1.0)*x600*x614)));
evalcond[2]=(((cj0*x611))+(((-1.0)*x596*x603))+((sj3*x621))+((x590*x617))+(((0.106)*x590))+x615);
evalcond[3]=((-0.106)+(((-1.0)*cj0*x594))+(((-1.0)*x589*x617))+(((-1.0)*x623))+((cj1*pz))+x628+((sj1*x596)));
evalcond[4]=((((-1.0)*r02*x594*x610))+((r00*x611))+(((-1.0)*x603*x604))+(((-1.0)*r02*x600*x601))+(((-1.0)*x617*x624))+((x606*x615))+(((-1.0)*sj3*sj4*x621))+((x597*x598))+(((-0.106)*x624)));
evalcond[5]=((((-1.0)*r00*x597*x603))+(((0.106)*x606))+(((0.0845)*sj3*x624))+((x601*x608))+(((0.106)*cj0*r00))+(((-1.0)*pz*x603*x606))+(((-1.0)*sj4*x589*x617))+((r00*x594))+(((-1.0)*x600*x604))+((py*sj0*x608))+(((-1.0)*sj4*x623)));
evalcond[6]=((((-1.0)*x596*x609*x613))+((py*x599))+(((-1.0)*x594*x595*x596))+((px*x605))+(((-1.0)*x600*x627))+(((2.0)*r02*x594*x597))+(((-0.017914)*x620))+((x593*x608))+((x619*x625))+(((-0.011236)*x608))+((x591*x608))+((pz*x616))+((sj0*x592*x598))+(((-1.0)*x603*x626))+(((-1.0)*cj1*px*r00*x609))+(((-1.0)*x593*x598*x610))+((sj1*x591*x614))+(((-1.0)*x618*x620))+(((-1.0)*pz*x595*x611))+(((-0.011236)*sj0*x598))+((x594*x601*x612))+(((-1.0)*x592*x600*x614))+(((0.011236)*sj1*x614))+((sj0*x591*x598)));
evalcond[7]=(((x596*x608*x609))+(((0.011236)*x622))+((pz*sj0*x605))+(((-1.0)*x597*x599))+((x591*x613))+((x593*x613))+(((-1.0)*x600*x626))+(((-0.017914)*x625))+(((-1.0)*pz*x594*x595))+(((-1.0)*x596*x616))+(((-1.0)*x601*x611*x612))+((cj1*x593*x607))+((x595*x596*x611))+(((-1.0)*px*x598*x609))+(((0.011236)*x613))+(((-1.0)*x591*x603*x614))+((x593*x622))+(((-1.0)*x619*x620))+(((-2.0)*py*x597*x608))+(((-1.0)*x618*x625))+((cj0*py*x616))+(((-1.0)*x591*x603*x607))+((x592*x622))+(((-1.0)*x592*x603*x607))+(((-0.011236)*cj1*x607)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x629=((53.0)*sj1);
IkReal x630=((11.8343195266272)*sj1);
CheckValue<IkReal> x631=IKPowWithIntegerCheck(cj4,-1);
if(!x631.valid){
continue;
}
if( IKabs(((0.0188679245283019)*(x631.value)*(((((500.0)*pz*r02))+(((500.0)*py*r01))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x629))+(((500.0)*px*r00))+((cj0*r01*x629)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.398584905660377)+(((55.8222619180529)*(px*px)))+(((55.8222619180529)*(pz*pz)))+((cj0*py*x630))+(((-11.8343195266272)*cj1*pz))+(((55.8222619180529)*(py*py)))+(((-1.0)*px*sj0*x630)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.0188679245283019)*(x631.value)*(((((500.0)*pz*r02))+(((500.0)*py*r01))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x629))+(((500.0)*px*r00))+((cj0*r01*x629))))))+IKsqr(((-0.398584905660377)+(((55.8222619180529)*(px*px)))+(((55.8222619180529)*(pz*pz)))+((cj0*py*x630))+(((-11.8343195266272)*cj1*pz))+(((55.8222619180529)*(py*py)))+(((-1.0)*px*sj0*x630))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((0.0188679245283019)*(x631.value)*(((((500.0)*pz*r02))+(((500.0)*py*r01))+(((-53.0)*cj1*r02))+(((-1.0)*r00*sj0*x629))+(((500.0)*px*r00))+((cj0*r01*x629))))), ((-0.398584905660377)+(((55.8222619180529)*(px*px)))+(((55.8222619180529)*(pz*pz)))+((cj0*py*x630))+(((-11.8343195266272)*cj1*pz))+(((55.8222619180529)*(py*py)))+(((-1.0)*px*sj0*x630))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x632=IKcos(j3);
IkReal x633=px*px;
IkReal x634=py*py;
IkReal x635=pz*pz;
IkReal x636=(py*r00);
IkReal x637=((2.0)*px);
IkReal x638=((0.212)*sj1);
IkReal x639=((0.212)*cj1);
IkReal x640=(r01*sj0);
IkReal x641=(cj0*py);
IkReal x642=(cj0*r00);
IkReal x643=((0.106)*cj1);
IkReal x644=(r00*sj0);
IkReal x645=(cj0*r02);
IkReal x646=(px*sj0);
IkReal x647=(cj0*r01);
IkReal x648=((0.106)*sj1);
IkReal x649=((1.0)*r02);
IkReal x650=((0.106)*cj4);
IkReal x651=((1.0)*x634);
IkReal x652=(py*r02*sj0);
IkReal x653=((0.017914)*x632);
IkReal x654=((1.0)*x633);
IkReal x655=((1.0)*x635);
evalcond[0]=((((-1.0)*px*r00))+((x650*(IKsin(j3))))+((x644*x648))+(((-1.0)*x647*x648))+((r02*x643))+(((-1.0)*py*r01))+(((-1.0)*pz*x649)));
evalcond[1]=((0.00714025)+((x638*x646))+((pz*x639))+(((-1.0)*x655))+(((-1.0)*x654))+(((-1.0)*x651))+x653+(((-1.0)*x638*x641)));
evalcond[2]=((((-1.0)*pz*x647))+((x643*x647))+(((-1.0)*x646*x649))+((r02*x641))+((r02*x648))+((pz*x644))+(((0.0845)*cj4))+(((-1.0)*x643*x644))+((x632*x650)));
evalcond[3]=((((-0.011236)*x640))+(((-0.011236)*x642))+(((-1.0)*sj4*x653))+(((-1.0)*x640*x655))+(((-1.0)*x640*x654))+(((-1.0)*x639*x652))+(((-1.0)*x642*x651))+(((-1.0)*x642*x655))+(((-0.01837625)*sj4))+((x634*x640))+((sj0*x636*x637))+(((-1.0)*x636*x638))+(((-1.0)*px*x639*x645))+(((2.0)*pz*x652))+((pz*x637*x645))+((x633*x642))+((r01*x637*x641))+((px*r01*x638))+((pz*x639*x642))+((pz*x639*x640)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=IKsign(cj4);
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
IkReal x656=(cj3*cj4);
j2eval[0]=(cj4+(((1.25443786982249)*x656)));
j2eval[1]=IKsign(((((212.0)*x656))+(((169.0)*cj4))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=sj3;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=1.0;
cj4=0;
j4=1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x657=((424000.0)*sj1);
IkReal x658=(px*sj0);
IkReal x659=(cj1*pz);
IkReal x660=(cj0*py);
IkReal x661=((338000.0)*sj3);
IkReal x662=((338000.0)*cj3);
IkReal x663=((424000.0)*cj1);
IkReal x664=(sj1*x661);
CheckValue<IkReal> x665=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x665.valid){
continue;
}
CheckValue<IkReal> x666 = IKatan2WithCheck(IkReal(((((-35828.0)*sj3))+(((-1.0)*cj1*x658*x662))+(((-1.0)*x660*x664))+((pz*x657))+((pz*sj1*x662))+(((-1.0)*x658*x663))+((x660*x663))+((cj1*x660*x662))+((x659*x661))+((x658*x664)))),IkReal(((44944.0)+(((35828.0)*cj3))+(((-1.0)*x657*x658))+(((-1.0)*x659*x662))+(((-1.0)*cj1*x658*x661))+((x657*x660))+((pz*x664))+((cj1*x660*x661))+(((-1.0)*sj1*x658*x662))+(((-424000.0)*x659))+((sj1*x660*x662)))),IKFAST_ATAN2_MAGTHRESH);
if(!x666.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x665.value)))+(x666.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x667=IKsin(j2);
IkReal x668=IKcos(j2);
IkReal x669=((1.0)*r01);
IkReal x670=(cj1*pz);
IkReal x671=(r00*sj1);
IkReal x672=(cj0*r00);
IkReal x673=(px*sj1);
IkReal x674=(cj0*r02);
IkReal x675=(cj1*py);
IkReal x676=(cj1*px);
IkReal x677=(r02*sj0);
IkReal x678=(r01*sj0);
IkReal x679=(pz*sj1);
IkReal x680=((0.106)*x667);
IkReal x681=((0.106)*x668);
IkReal x682=((0.0845)*x668);
IkReal x683=((0.0845)*x667);
IkReal x684=((1.0)*py*sj1);
IkReal x685=(sj3*x682);
IkReal x686=(cj3*x683);
IkReal x687=(sj3*x683);
IkReal x688=(cj3*x682);
IkReal x689=(x688+x681);
IkReal x690=(x680+x686+x685);
evalcond[0]=(((cj0*x675))+x679+x690+(((-1.0)*sj0*x676)));
evalcond[1]=((-0.106)+(((-1.0)*x689))+(((-1.0)*cj0*x684))+x670+x687+((sj0*x673)));
evalcond[2]=(((r00*x675))+((x678*x679))+(((-1.0)*x669*x676))+((cj0*pz*x671))+(((-1.0)*x690))+(((-1.0)*x673*x674))+(((-1.0)*x677*x684)));
evalcond[3]=(((py*x671))+(((-1.0)*x689))+(((-1.0)*sj0*x669*x670))+((x674*x676))+(((-1.0)*x669*x673))+(((-1.0)*x670*x672))+x687+((x675*x677))+(((0.106)*x672))+(((0.106)*x678)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x691=((424000.0)*sj1);
IkReal x692=(px*sj0);
IkReal x693=(cj1*pz);
IkReal x694=(cj0*py);
IkReal x695=((338000.0)*sj3);
IkReal x696=((338000.0)*cj3);
IkReal x697=((424000.0)*cj1);
IkReal x698=(sj1*x695);
CheckValue<IkReal> x699 = IKatan2WithCheck(IkReal((((pz*sj1*x696))+(((-35828.0)*sj3))+((x694*x697))+((pz*x691))+((cj1*x694*x696))+((x692*x698))+((x693*x695))+(((-1.0)*cj1*x692*x696))+(((-1.0)*x692*x697))+(((-1.0)*x694*x698)))),IkReal(((44944.0)+(((35828.0)*cj3))+((pz*x698))+(((-1.0)*x693*x696))+(((-1.0)*sj1*x692*x696))+((x691*x694))+(((-424000.0)*x693))+((cj1*x694*x695))+(((-1.0)*cj1*x692*x695))+(((-1.0)*x691*x692))+((sj1*x694*x696)))),IKFAST_ATAN2_MAGTHRESH);
if(!x699.valid){
continue;
}
CheckValue<IkReal> x700=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x700.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x699.value)+(((1.5707963267949)*(x700.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x701=IKsin(j2);
IkReal x702=IKcos(j2);
IkReal x703=((1.0)*r01);
IkReal x704=(cj1*pz);
IkReal x705=(r00*sj1);
IkReal x706=(cj0*r00);
IkReal x707=(px*sj1);
IkReal x708=(cj0*r02);
IkReal x709=(cj1*py);
IkReal x710=(cj1*px);
IkReal x711=(r02*sj0);
IkReal x712=(r01*sj0);
IkReal x713=(pz*sj1);
IkReal x714=((0.106)*x701);
IkReal x715=((0.106)*x702);
IkReal x716=((0.0845)*x702);
IkReal x717=((0.0845)*x701);
IkReal x718=((1.0)*py*sj1);
IkReal x719=(sj3*x716);
IkReal x720=(cj3*x717);
IkReal x721=(cj3*x716);
IkReal x722=(sj3*x717);
IkReal x723=(x715+x721);
IkReal x724=(x719+x714+x720);
evalcond[0]=((((-1.0)*sj0*x710))+((cj0*x709))+x713+x724);
evalcond[1]=((-0.106)+(((-1.0)*x723))+((sj0*x707))+x704+x722+(((-1.0)*cj0*x718)));
evalcond[2]=((((-1.0)*x711*x718))+((cj0*pz*x705))+((r00*x709))+(((-1.0)*x703*x710))+x724+(((-1.0)*x707*x708))+((x712*x713)));
evalcond[3]=((((-1.0)*x704*x706))+(((-1.0)*x703*x707))+((x709*x711))+(((0.106)*x706))+(((-1.0)*x722))+(((0.106)*x712))+(((-1.0)*sj0*x703*x704))+x723+((py*x705))+((x708*x710)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x725=((5.249343832021)*sj1);
IkReal x726=(px*sj0);
IkReal x727=((5.249343832021)*cj1);
IkReal x728=(cj0*py);
if( IKabs(((((-1.0)*x727*x728))+((x726*x727))+(((-1.0)*pz*x725)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.556430446194226)+(((-1.0)*x725*x728))+((x725*x726))+((pz*x727)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x727*x728))+((x726*x727))+(((-1.0)*pz*x725))))+IKsqr(((-0.556430446194226)+(((-1.0)*x725*x728))+((x725*x726))+((pz*x727))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*x727*x728))+((x726*x727))+(((-1.0)*pz*x725))), ((-0.556430446194226)+(((-1.0)*x725*x728))+((x725*x726))+((pz*x727))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x729=IKsin(j2);
IkReal x730=IKcos(j2);
IkReal x731=py*py;
IkReal x732=pz*pz;
IkReal x733=px*px;
IkReal x734=((1.0)*sj0);
IkReal x735=((0.212)*py);
IkReal x736=(px*sj0);
IkReal x737=((0.212)*r02);
IkReal x738=(cj0*r02);
IkReal x739=(r00*sj1);
IkReal x740=((2.0)*py);
IkReal x741=(r01*sj1);
IkReal x742=(cj1*r00);
IkReal x743=(cj0*pz);
IkReal x744=(pz*sj1);
IkReal x745=(r02*sj1);
IkReal x746=(cj1*pz);
IkReal x747=(cj0*px);
IkReal x748=((0.212)*r00);
IkReal x749=(pz*sj0);
IkReal x750=((1.0)*px);
IkReal x751=(cj1*py);
IkReal x752=(cj1*r02);
IkReal x753=((2.0)*r02);
IkReal x754=((1.0)*cj0);
IkReal x755=(cj1*r01);
IkReal x756=(cj1*px);
IkReal x757=((0.011236)*sj0);
IkReal x758=(r01*x746);
IkReal x759=(cj4*x730);
IkReal x760=(cj0*x755);
IkReal x761=((0.1905)*x729);
IkReal x762=((1.0)*x732);
IkReal x763=((0.1905)*x730);
IkReal x764=((2.0)*px*pz);
IkReal x765=(cj4*x729);
evalcond[0]=((((-1.0)*x734*x756))+((cj0*x751))+x744+x761);
evalcond[1]=((((-1.0)*x759))+(((-1.0)*x734*x742))+x745+x760);
evalcond[2]=((((-1.0)*x765))+x752+((sj0*x739))+(((-1.0)*x741*x754)));
evalcond[3]=((-0.106)+(((-1.0)*x763))+x746+(((-1.0)*py*sj1*x754))+((sj1*x736)));
evalcond[4]=(((py*x742))+(((-1.0)*sj1*x738*x750))+(((-1.0)*x750*x755))+((x739*x743))+((x741*x749))+(((-1.0)*py*x734*x745))+(((-1.0)*sj4*x761)));
evalcond[5]=((((0.106)*cj0*r00))+(((-1.0)*x742*x743))+((x738*x756))+(((0.106)*r01*sj0))+(((-1.0)*x734*x758))+((r02*sj0*x751))+((py*x739))+(((-1.0)*x741*x750))+(((-1.0)*sj4*x763)));
evalcond[6]=(((sj0*x732*x739))+(((-1.0)*x752*x762))+(((-1.0)*x736*x744*x753))+(((-0.011236)*x752))+(((-0.03629025)*x765))+((x731*x752))+((x739*x740*x747))+((px*x748))+((r01*x735))+(((-1.0)*x736*x740*x741))+(((-1.0)*x739*x757))+(((-1.0)*x742*x764))+(((-1.0)*x733*x741*x754))+(((-1.0)*x732*x741*x754))+((pz*x737))+((cj0*x731*x741))+((x733*x752))+((x738*x740*x744))+(((0.011236)*cj0*x741))+(((-1.0)*x740*x758))+(((-1.0)*x733*x734*x739))+((sj0*x731*x739)));
evalcond[7]=((((-1.0)*x742*x757))+(((-1.0)*x736*x737))+((x735*x738))+(((0.011236)*x745))+(((-1.0)*x731*x734*x742))+(((-0.212)*r01*x743))+(((-1.0)*x739*x764))+(((-1.0)*x740*x742*x747))+((x731*x745))+(((-1.0)*x731*x754*x755))+(((-0.03629025)*x759))+(((0.011236)*x760))+(((-1.0)*x745*x762))+(((-1.0)*pz*x740*x741))+((x733*x760))+(((-1.0)*x732*x734*x742))+((sj0*x733*x742))+(((-1.0)*x738*x740*x746))+((x732*x760))+((x733*x745))+((x736*x740*x755))+((x748*x749))+((x736*x746*x753)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x766=((46.5116279069767)*cj1);
IkReal x767=(cj0*py);
IkReal x768=(px*sj0);
IkReal x769=((46.5116279069767)*sj1);
if( IKabs(((((-1.0)*x766*x767))+((x766*x768))+(((-1.0)*pz*x769)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-4.93023255813953)+((x768*x769))+(((-1.0)*x767*x769))+((pz*x766)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x766*x767))+((x766*x768))+(((-1.0)*pz*x769))))+IKsqr(((-4.93023255813953)+((x768*x769))+(((-1.0)*x767*x769))+((pz*x766))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*x766*x767))+((x766*x768))+(((-1.0)*pz*x769))), ((-4.93023255813953)+((x768*x769))+(((-1.0)*x767*x769))+((pz*x766))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x770=IKsin(j2);
IkReal x771=IKcos(j2);
IkReal x772=py*py;
IkReal x773=pz*pz;
IkReal x774=px*px;
IkReal x775=((0.212)*py);
IkReal x776=(px*sj0);
IkReal x777=((0.212)*r02);
IkReal x778=(cj0*r02);
IkReal x779=(py*sj1);
IkReal x780=((2.0)*r01);
IkReal x781=(cj0*r00);
IkReal x782=(pz*sj1);
IkReal x783=(cj0*r01);
IkReal x784=((0.00046225)*cj4);
IkReal x785=((2.0)*px);
IkReal x786=(r00*sj0);
IkReal x787=((0.011236)*cj1);
IkReal x788=((0.212)*pz);
IkReal x789=((1.0)*cj1);
IkReal x790=((1.0)*sj1);
IkReal x791=(cj1*py);
IkReal x792=((1.0)*r02);
IkReal x793=((2.0)*r02);
IkReal x794=(cj1*pz);
IkReal x795=(r02*sj1);
IkReal x796=(r01*sj0);
IkReal x797=((0.011236)*sj1);
IkReal x798=((0.0215)*x771);
IkReal x799=(r02*x772);
IkReal x800=(pz*x791);
IkReal x801=(cj1*x774);
IkReal x802=(sj1*x772);
IkReal x803=(cj1*x773);
IkReal x804=((0.0215)*x770);
IkReal x805=(px*x790);
IkReal x806=(x786*x789);
evalcond[0]=(((cj1*x783))+x795+((cj4*x771))+(((-1.0)*x806)));
evalcond[1]=((((-1.0)*x776*x789))+x782+x804+((cj0*x791)));
evalcond[2]=((((-1.0)*x783*x790))+((cj1*r02))+((sj1*x786))+((cj4*x770)));
evalcond[3]=((-0.106)+(((-1.0)*cj0*x779))+(((-1.0)*x798))+((sj1*x776))+x794);
evalcond[4]=((((-1.0)*sj4*x804))+((x781*x782))+((r00*x791))+((x782*x796))+(((-1.0)*sj0*x779*x792))+(((-1.0)*px*r01*x789))+(((-1.0)*x778*x805)));
evalcond[5]=(((r02*sj0*x791))+(((-1.0)*pz*x781*x789))+(((-1.0)*r01*x805))+(((0.106)*x781))+(((0.106)*x796))+(((-1.0)*pz*x789*x796))+(((-1.0)*sj4*x798))+((r00*x779))+((cj1*px*x778)));
evalcond[6]=((((-1.0)*r00*x785*x794))+(((-1.0)*x780*x800))+((pz*x777))+((x786*x802))+(((-1.0)*r02*x773*x789))+((x770*x784))+(((-1.0)*x774*x783*x790))+(((0.212)*px*r00))+((sj1*x773*x786))+(((-1.0)*x774*x786*x790))+((cj1*x799))+(((-1.0)*x773*x783*x790))+(((-1.0)*x776*x779*x780))+((x783*x797))+(((2.0)*pz*x778*x779))+((r02*x801))+((r01*x775))+(((-1.0)*x786*x797))+((x779*x781*x785))+(((-1.0)*r02*x787))+(((-1.0)*x776*x782*x793))+((x783*x802)));
evalcond[7]=((((-1.0)*x773*x806))+((x786*x788))+(((-1.0)*pz*x779*x780))+((x786*x801))+(((-1.0)*r02*x773*x790))+((x776*x793*x794))+((x774*x795))+(((0.011236)*x795))+((x783*x787))+(((-1.0)*x781*x785*x791))+((x776*x780*x791))+(((-1.0)*x772*x806))+(((-2.0)*x778*x800))+(((-1.0)*x786*x787))+(((-1.0)*x776*x777))+(((-1.0)*x772*x783*x789))+(((-1.0)*r00*x782*x785))+((x772*x795))+((x771*x784))+((x775*x778))+(((-1.0)*x783*x788))+((x783*x803))+((x783*x801)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs(((0.797169811320755)+cj3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x807=(px*sj0);
IkReal x808=((12.4561584192523)*cj1);
IkReal x809=((9.43396229287055)*sj1);
IkReal x810=((12.4561584192523)*sj1);
IkReal x811=(cj0*py);
IkReal x812=((9.43396229287055)*cj1);
if( IKabs(((1.32035279244074)+((x810*x811))+(((-1.0)*x811*x812))+((x807*x812))+(((-1.0)*x807*x810))+(((-1.0)*pz*x808))+(((-1.0)*pz*x809)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+(((-1.0)*x808*x811))+((pz*x812))+(((-1.0)*x809*x811))+(((-1.0)*pz*x810))+((x807*x808))+((x807*x809)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((1.32035279244074)+((x810*x811))+(((-1.0)*x811*x812))+((x807*x812))+(((-1.0)*x807*x810))+(((-1.0)*pz*x808))+(((-1.0)*pz*x809))))+IKsqr(((-1.00000000304428)+(((-1.0)*x808*x811))+((pz*x812))+(((-1.0)*x809*x811))+(((-1.0)*pz*x810))+((x807*x808))+((x807*x809))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((1.32035279244074)+((x810*x811))+(((-1.0)*x811*x812))+((x807*x812))+(((-1.0)*x807*x810))+(((-1.0)*pz*x808))+(((-1.0)*pz*x809))), ((-1.00000000304428)+(((-1.0)*x808*x811))+((pz*x812))+(((-1.0)*x809*x811))+(((-1.0)*pz*x810))+((x807*x808))+((x807*x809))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x813=IKsin(j2);
IkReal x814=IKcos(j2);
IkReal x815=py*py;
IkReal x816=pz*pz;
IkReal x817=px*px;
IkReal x818=((1.0)*sj0);
IkReal x819=((0.212)*py);
IkReal x820=(px*sj0);
IkReal x821=((0.212)*r02);
IkReal x822=(cj0*r02);
IkReal x823=(r00*sj1);
IkReal x824=((2.0)*py);
IkReal x825=(r01*sj1);
IkReal x826=(cj1*r00);
IkReal x827=(cj0*pz);
IkReal x828=(cj1*r02);
IkReal x829=((0.79716981)*cj4);
IkReal x830=(r02*sj1);
IkReal x831=(cj0*px);
IkReal x832=(cj1*pz);
IkReal x833=((0.011236)*sj0);
IkReal x834=((0.0510173108376979)*sj4);
IkReal x835=((1.0)*px);
IkReal x836=(cj0*py);
IkReal x837=((2.0)*pz);
IkReal x838=((1.0)*cj0);
IkReal x839=(cj1*r01);
IkReal x840=((0.212)*r00);
IkReal x841=((0.603755157842579)*cj4);
IkReal x842=(pz*sj0);
IkReal x843=(cj1*px);
IkReal x844=(pz*sj1);
IkReal x845=(r01*x832);
IkReal x846=((0.038639151055)*x814);
IkReal x847=(cj0*x839);
IkReal x848=((1.0)*x816);
IkReal x849=((0.038639151055)*x813);
IkReal x850=(cj4*x814);
IkReal x851=(cj4*x813);
evalcond[0]=((((-1.0)*x818*x843))+x844+x849+(((0.0510173108376979)*x814))+((cj1*x836)));
evalcond[1]=((-0.106)+((sj1*x820))+(((-1.0)*x846))+x832+(((0.0510173108376979)*x813))+(((-1.0)*sj1*x836)));
evalcond[2]=((((-1.0)*x818*x826))+((x814*x829))+((x813*x841))+x830+x847);
evalcond[3]=(((sj0*x823))+((x813*x829))+(((-1.0)*x814*x841))+x828+(((-1.0)*x825*x838)));
evalcond[4]=(((py*x826))+(((-1.0)*x835*x839))+(((-1.0)*sj1*x822*x835))+(((-1.0)*x814*x834))+(((-1.0)*sj4*x849))+((x823*x827))+(((-1.0)*py*x818*x830))+((x825*x842)));
evalcond[5]=(((py*sj0*x828))+((py*x823))+(((0.106)*cj0*r00))+(((0.106)*r01*sj0))+(((-1.0)*x818*x845))+((x813*x834))+((x822*x843))+(((-1.0)*sj4*x846))+(((-1.0)*x825*x835))+(((-1.0)*x826*x827)));
evalcond[6]=((((-1.0)*x817*x825*x838))+((pz*x821))+(((-1.0)*x828*x848))+((x823*x824*x831))+((r01*x819))+(((0.011236)*cj0*x825))+(((-0.0032650082789875)*x851))+((x815*x828))+(((-1.0)*x823*x833))+((x817*x828))+(((-0.011236)*x828))+((x822*x824*x844))+(((-1.0)*x824*x845))+(((0.00247283018773374)*x850))+(((-1.0)*x817*x818*x823))+((sj0*x815*x823))+((sj0*x816*x823))+(((-1.0)*x820*x830*x837))+(((-1.0)*px*x826*x837))+((cj0*x815*x825))+(((-1.0)*x820*x824*x825))+(((-1.0)*x816*x825*x838))+((px*x840)));
evalcond[7]=((((-1.0)*x824*x826*x831))+(((-1.0)*px*x823*x837))+(((-1.0)*x816*x818*x826))+((x816*x847))+((x820*x828*x837))+((x840*x842))+(((-1.0)*x826*x833))+(((-0.0032650082789875)*x850))+(((-0.212)*r01*x827))+((x819*x822))+(((-1.0)*x830*x848))+(((-1.0)*pz*x824*x825))+(((0.011236)*x830))+(((-1.0)*x822*x824*x832))+(((-1.0)*x820*x821))+((sj0*x817*x826))+(((0.011236)*x847))+((x820*x824*x839))+((x817*x830))+(((-1.0)*x815*x818*x826))+(((-0.00247283018773374)*x851))+((x817*x847))+((x815*x830))+(((-1.0)*x815*x838*x839)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((0.797169811320755)+cj3)))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x852=(px*sj0);
IkReal x853=((12.4561584192523)*cj1);
IkReal x854=((9.43396229287055)*sj1);
IkReal x855=((12.4561584192523)*sj1);
IkReal x856=(cj0*py);
IkReal x857=((9.43396229287055)*cj1);
if( IKabs(((-1.32035279244074)+(((-1.0)*pz*x854))+((x852*x857))+((x852*x855))+(((-1.0)*x856*x857))+(((-1.0)*x855*x856))+((pz*x853)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+(((-1.0)*x852*x853))+((x852*x854))+((x853*x856))+(((-1.0)*x854*x856))+((pz*x855))+((pz*x857)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.32035279244074)+(((-1.0)*pz*x854))+((x852*x857))+((x852*x855))+(((-1.0)*x856*x857))+(((-1.0)*x855*x856))+((pz*x853))))+IKsqr(((-1.00000000304428)+(((-1.0)*x852*x853))+((x852*x854))+((x853*x856))+(((-1.0)*x854*x856))+((pz*x855))+((pz*x857))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.32035279244074)+(((-1.0)*pz*x854))+((x852*x857))+((x852*x855))+(((-1.0)*x856*x857))+(((-1.0)*x855*x856))+((pz*x853))), ((-1.00000000304428)+(((-1.0)*x852*x853))+((x852*x854))+((x853*x856))+(((-1.0)*x854*x856))+((pz*x855))+((pz*x857))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x858=IKcos(j2);
IkReal x859=IKsin(j2);
IkReal x860=py*py;
IkReal x861=pz*pz;
IkReal x862=px*px;
IkReal x863=((1.0)*sj0);
IkReal x864=((0.212)*py);
IkReal x865=(px*sj0);
IkReal x866=((0.212)*r02);
IkReal x867=(cj0*r02);
IkReal x868=(r00*sj1);
IkReal x869=((2.0)*py);
IkReal x870=(r01*sj1);
IkReal x871=(cj1*r00);
IkReal x872=(cj0*pz);
IkReal x873=(cj1*r02);
IkReal x874=(r02*sj1);
IkReal x875=(cj0*px);
IkReal x876=(cj1*pz);
IkReal x877=((0.011236)*sj0);
IkReal x878=((0.0510173108376979)*sj4);
IkReal x879=((1.0)*px);
IkReal x880=(cj0*py);
IkReal x881=((2.0)*pz);
IkReal x882=((1.0)*cj0);
IkReal x883=(cj1*r01);
IkReal x884=((0.212)*r00);
IkReal x885=(pz*sj0);
IkReal x886=(cj1*px);
IkReal x887=(pz*sj1);
IkReal x888=(r01*x876);
IkReal x889=((0.038639151055)*x858);
IkReal x890=(cj4*x859);
IkReal x891=(cj0*x883);
IkReal x892=((1.0)*x861);
IkReal x893=((0.038639151055)*x859);
IkReal x894=(cj4*x858);
evalcond[0]=((((-0.0510173108376979)*x858))+(((-1.0)*x863*x886))+((cj1*x880))+x887+x893);
evalcond[1]=((-0.106)+(((-0.0510173108376979)*x859))+(((-1.0)*x889))+((sj1*x865))+(((-1.0)*sj1*x880))+x876);
evalcond[2]=((((0.79716981)*x894))+(((-0.603755157842579)*x890))+x874+x891+(((-1.0)*x863*x871)));
evalcond[3]=((((-1.0)*x870*x882))+(((0.603755157842579)*x894))+((sj0*x868))+(((0.79716981)*x890))+x873);
evalcond[4]=((((-1.0)*x879*x883))+((x868*x872))+(((-1.0)*sj4*x893))+(((-1.0)*py*x863*x874))+((x858*x878))+((x870*x885))+((py*x871))+(((-1.0)*sj1*x867*x879)));
evalcond[5]=((((0.106)*cj0*r00))+((x867*x886))+(((0.106)*r01*sj0))+(((-1.0)*x863*x888))+(((-1.0)*x871*x872))+(((-1.0)*sj4*x889))+((py*sj0*x873))+(((-1.0)*x870*x879))+((py*x868))+(((-1.0)*x859*x878)));
evalcond[6]=(((sj0*x861*x868))+(((0.011236)*cj0*x870))+((r01*x864))+((px*x884))+(((-0.011236)*x873))+(((-1.0)*x873*x892))+((x867*x869*x887))+((cj0*x860*x870))+(((-1.0)*x868*x877))+(((-1.0)*x865*x874*x881))+(((-0.0032650082789875)*x890))+(((-0.00247283018773374)*x894))+(((-1.0)*x862*x863*x868))+((x860*x873))+((x862*x873))+(((-1.0)*x865*x869*x870))+(((-1.0)*x869*x888))+((pz*x866))+(((-1.0)*x862*x870*x882))+((x868*x869*x875))+(((-1.0)*x861*x870*x882))+(((-1.0)*px*x871*x881))+((sj0*x860*x868)));
evalcond[7]=((((-1.0)*x867*x869*x876))+(((0.011236)*x874))+(((-1.0)*x865*x866))+(((-1.0)*x861*x863*x871))+(((-1.0)*x871*x877))+((sj0*x862*x871))+(((0.00247283018773374)*x890))+((x865*x873*x881))+(((-0.0032650082789875)*x894))+((x860*x874))+((x862*x874))+(((-1.0)*x869*x871*x875))+(((-1.0)*pz*x869*x870))+(((-1.0)*x860*x882*x883))+((x865*x869*x883))+((x862*x891))+((x861*x891))+((x864*x867))+(((-1.0)*x860*x863*x871))+(((0.011236)*x891))+(((-1.0)*px*x868*x881))+(((-0.212)*r01*x872))+(((-1.0)*x874*x892))+((x884*x885)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x905=IKPowWithIntegerCheck(cj4,-1);
if(!x905.valid){
continue;
}
IkReal x895=x905.value;
IkReal x896=((2000.0)*cj4);
IkReal x897=(cj3*sj1);
IkReal x898=(cj1*r02);
IkReal x899=((212.0)*sj1);
IkReal x900=((-0.00471698113207547)*x895);
IkReal x901=(cj1*px*sj0);
IkReal x902=((169.0)*r00*sj0);
IkReal x903=(cj0*cj1*py);
IkReal x904=((169.0)*cj0*r01*sj1);
CheckValue<IkReal> x906=IKPowWithIntegerCheck(sj3,-1);
if(!x906.valid){
continue;
}
if( IKabs((x900*(((((-1.0)*x896*x901))+(((169.0)*x898))+(((-1.0)*x904))+((pz*sj1*x896))+((x896*x903))+((sj1*x902)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x900*(x906.value)*((((cj0*r01*x899))+(((-1.0)*x897*x902))+((cj3*x896*x901))+(((-212.0)*x898))+(((-1.0)*r00*sj0*x899))+(((-169.0)*cj3*x898))+(((169.0)*cj0*r01*x897))+(((-1.0)*pz*x896*x897))+(((-1.0)*cj3*x896*x903)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x900*(((((-1.0)*x896*x901))+(((169.0)*x898))+(((-1.0)*x904))+((pz*sj1*x896))+((x896*x903))+((sj1*x902))))))+IKsqr((x900*(x906.value)*((((cj0*r01*x899))+(((-1.0)*x897*x902))+((cj3*x896*x901))+(((-212.0)*x898))+(((-1.0)*r00*sj0*x899))+(((-169.0)*cj3*x898))+(((169.0)*cj0*r01*x897))+(((-1.0)*pz*x896*x897))+(((-1.0)*cj3*x896*x903))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x900*(((((-1.0)*x896*x901))+(((169.0)*x898))+(((-1.0)*x904))+((pz*sj1*x896))+((x896*x903))+((sj1*x902))))), (x900*(x906.value)*((((cj0*r01*x899))+(((-1.0)*x897*x902))+((cj3*x896*x901))+(((-212.0)*x898))+(((-1.0)*r00*sj0*x899))+(((-169.0)*cj3*x898))+(((169.0)*cj0*r01*x897))+(((-1.0)*pz*x896*x897))+(((-1.0)*cj3*x896*x903))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x907=IKcos(j2);
IkReal x908=IKsin(j2);
IkReal x909=py*py;
IkReal x910=pz*pz;
IkReal x911=px*px;
IkReal x912=(py*sj1);
IkReal x913=((2.0)*r01);
IkReal x914=(px*sj0);
IkReal x915=(cj0*pz);
IkReal x916=(r00*sj1);
IkReal x917=((0.212)*r01);
IkReal x918=((1.0)*sj1);
IkReal x919=(cj0*px);
IkReal x920=((1.0)*cj3);
IkReal x921=((1.0)*cj1);
IkReal x922=(px*r01);
IkReal x923=((0.212)*r00);
IkReal x924=(r01*sj0);
IkReal x925=(r00*sj0);
IkReal x926=(cj1*r02);
IkReal x927=((2.0)*pz);
IkReal x928=((1.0)*sj0);
IkReal x929=(cj1*py);
IkReal x930=((2.0)*r00);
IkReal x931=(r02*sj1);
IkReal x932=(cj0*r01);
IkReal x933=(pz*sj1);
IkReal x934=((0.212)*r02);
IkReal x935=((0.0845)*cj3);
IkReal x936=((0.01837625)*cj3);
IkReal x937=((0.00409575)*sj3);
IkReal x938=(cj4*x908);
IkReal x939=((0.0845)*x907);
IkReal x940=(cj1*x932);
IkReal x941=((0.106)*x907);
IkReal x942=(sj4*x908);
IkReal x943=(cj4*x907);
IkReal x944=(r02*x910);
IkReal x945=(x911*x932);
IkReal x946=((0.0845)*sj3*x908);
evalcond[0]=((((-1.0)*x921*x925))+x931+x940+((sj3*x938))+(((-1.0)*x920*x943)));
evalcond[1]=((((-1.0)*x920*x938))+(((-1.0)*sj3*x943))+(((-1.0)*x918*x932))+((sj0*x916))+x926);
evalcond[2]=(((x908*x935))+(((-1.0)*x914*x921))+((cj0*x929))+(((0.106)*x908))+x933+((sj3*x939)));
evalcond[3]=((-0.106)+(((-1.0)*cj0*x912))+(((-1.0)*x941))+((cj1*pz))+(((-1.0)*x907*x935))+x946+((sj1*x914)));
evalcond[4]=(((x924*x933))+(((-1.0)*sj3*sj4*x939))+(((-1.0)*r02*x912*x928))+(((-1.0)*r02*x918*x919))+(((-1.0)*x921*x922))+((x915*x916))+(((-0.106)*x942))+((r00*x929))+(((-1.0)*x935*x942)));
evalcond[5]=((((0.106)*x924))+((x919*x926))+(((0.106)*cj0*r00))+(((-1.0)*pz*x921*x924))+(((-1.0)*sj4*x907*x935))+(((-1.0)*sj4*x941))+(((-1.0)*x918*x922))+(((0.0845)*sj3*x942))+((py*sj0*x926))+(((-1.0)*r00*x915*x921))+((r00*x912)));
evalcond[6]=((((0.011236)*sj1*x932))+(((-0.011236)*x926))+((x911*x926))+(((-1.0)*x912*x913*x914))+(((-1.0)*x911*x916*x928))+((x937*x943))+(((-0.011236)*sj0*x916))+(((-1.0)*cj1*px*r00*x927))+(((-1.0)*x910*x918*x932))+((sj0*x910*x916))+(((-1.0)*x921*x944))+((x909*x926))+(((-1.0)*x914*x927*x931))+((x912*x919*x930))+((pz*x934))+((px*x923))+(((-1.0)*x936*x938))+((sj0*x909*x916))+((sj1*x909*x932))+(((-1.0)*x918*x945))+(((2.0)*r02*x912*x915))+(((-0.017914)*x938))+(((-1.0)*pz*x913*x929))+((py*x917)));
evalcond[7]=((((-1.0)*pz*x912*x913))+((x910*x940))+((x914*x926*x927))+((cj0*py*x934))+(((-1.0)*px*x916*x927))+((cj1*x911*x925))+(((-1.0)*x909*x921*x932))+(((-1.0)*x914*x934))+(((-1.0)*x909*x921*x925))+((x911*x931))+((x911*x940))+(((-2.0)*py*x915*x926))+(((-0.017914)*x943))+((x909*x931))+(((0.011236)*x931))+((x913*x914*x929))+(((-0.011236)*cj1*x925))+(((-1.0)*x936*x943))+(((-1.0)*x910*x921*x925))+(((-1.0)*x937*x938))+(((0.011236)*x940))+((pz*sj0*x923))+(((-1.0)*x918*x944))+(((-1.0)*x919*x929*x930))+(((-1.0)*x915*x917)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x947=(cj1*sj0);
IkReal x948=((169.0)*r00);
IkReal x949=((169.0)*r02*sj1);
IkReal x950=((2000.0)*cj4*px);
IkReal x951=((2000.0)*cj4*pz*sj1);
IkReal x952=((169.0)*cj0*cj1*r01);
IkReal x953=((2000.0)*cj0*cj1*cj4*py);
CheckValue<IkReal> x954=IKPowWithIntegerCheck(IKsign(((((169.0)*cj4))+(((212.0)*cj3*cj4)))),-1);
if(!x954.valid){
continue;
}
CheckValue<IkReal> x955 = IKatan2WithCheck(IkReal(((((-1.0)*cj3*x951))+(((-1.0)*cj3*x953))+((cj3*x947*x950))+((sj3*x947*x948))+(((-1.0)*sj3*x952))+(((-1.0)*sj3*x949)))),IkReal(((((212.0)*cj0*cj1*r01))+((sj3*x947*x950))+(((-212.0)*r00*x947))+((cj3*x949))+(((-1.0)*cj3*x947*x948))+(((212.0)*r02*sj1))+(((-1.0)*sj3*x951))+(((-1.0)*sj3*x953))+((cj3*x952)))),IKFAST_ATAN2_MAGTHRESH);
if(!x955.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x954.value)))+(x955.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x956=IKcos(j2);
IkReal x957=IKsin(j2);
IkReal x958=py*py;
IkReal x959=pz*pz;
IkReal x960=px*px;
IkReal x961=(py*sj1);
IkReal x962=((2.0)*r01);
IkReal x963=(px*sj0);
IkReal x964=(cj0*pz);
IkReal x965=(r00*sj1);
IkReal x966=((0.212)*r01);
IkReal x967=((1.0)*sj1);
IkReal x968=(cj0*px);
IkReal x969=((1.0)*cj3);
IkReal x970=((1.0)*cj1);
IkReal x971=(px*r01);
IkReal x972=((0.212)*r00);
IkReal x973=(r01*sj0);
IkReal x974=(r00*sj0);
IkReal x975=(cj1*r02);
IkReal x976=((2.0)*pz);
IkReal x977=((1.0)*sj0);
IkReal x978=(cj1*py);
IkReal x979=((2.0)*r00);
IkReal x980=(r02*sj1);
IkReal x981=(cj0*r01);
IkReal x982=(pz*sj1);
IkReal x983=((0.212)*r02);
IkReal x984=((0.0845)*cj3);
IkReal x985=((0.01837625)*cj3);
IkReal x986=((0.00409575)*sj3);
IkReal x987=(cj4*x957);
IkReal x988=((0.0845)*x956);
IkReal x989=(cj1*x981);
IkReal x990=((0.106)*x956);
IkReal x991=(sj4*x957);
IkReal x992=(cj4*x956);
IkReal x993=(r02*x959);
IkReal x994=(x960*x981);
IkReal x995=((0.0845)*sj3*x957);
evalcond[0]=((((-1.0)*x969*x992))+(((-1.0)*x970*x974))+((sj3*x987))+x989+x980);
evalcond[1]=((((-1.0)*sj3*x992))+(((-1.0)*x969*x987))+(((-1.0)*x967*x981))+((sj0*x965))+x975);
evalcond[2]=((((-1.0)*x963*x970))+(((0.106)*x957))+((x957*x984))+((sj3*x988))+x982+((cj0*x978)));
evalcond[3]=((-0.106)+(((-1.0)*cj0*x961))+((cj1*pz))+(((-1.0)*x990))+((sj1*x963))+(((-1.0)*x956*x984))+x995);
evalcond[4]=((((-1.0)*sj3*sj4*x988))+(((-0.106)*x991))+((r00*x978))+((x973*x982))+(((-1.0)*r02*x967*x968))+(((-1.0)*x984*x991))+(((-1.0)*r02*x961*x977))+((x964*x965))+(((-1.0)*x970*x971)));
evalcond[5]=((((0.106)*cj0*r00))+(((-1.0)*pz*x970*x973))+(((0.0845)*sj3*x991))+(((-1.0)*sj4*x956*x984))+((x968*x975))+(((0.106)*x973))+(((-1.0)*r00*x964*x970))+((r00*x961))+(((-1.0)*sj4*x990))+(((-1.0)*x967*x971))+((py*sj0*x975)));
evalcond[6]=((((-0.011236)*sj0*x965))+(((-0.017914)*x987))+(((-1.0)*x967*x994))+((x986*x992))+(((0.011236)*sj1*x981))+(((-1.0)*cj1*px*r00*x976))+(((-1.0)*x959*x967*x981))+((sj0*x958*x965))+((x961*x968*x979))+(((-1.0)*x960*x965*x977))+((py*x966))+(((-1.0)*x963*x976*x980))+((x960*x975))+((x958*x975))+((sj0*x959*x965))+((pz*x983))+(((-1.0)*pz*x962*x978))+(((2.0)*r02*x961*x964))+(((-1.0)*x970*x993))+(((-1.0)*x961*x962*x963))+((sj1*x958*x981))+(((-1.0)*x985*x987))+((px*x972))+(((-0.011236)*x975)));
evalcond[7]=((((-2.0)*py*x964*x975))+(((-1.0)*x963*x983))+(((-1.0)*pz*x961*x962))+(((-1.0)*x967*x993))+((x962*x963*x978))+((pz*sj0*x972))+(((-1.0)*x985*x992))+(((-1.0)*x986*x987))+(((-1.0)*x964*x966))+(((-0.011236)*cj1*x974))+(((-1.0)*x958*x970*x974))+((x959*x989))+((x960*x989))+((x960*x980))+((cj1*x960*x974))+(((-1.0)*x958*x970*x981))+((x963*x975*x976))+((x958*x980))+((cj0*py*x983))+(((-0.017914)*x992))+(((-1.0)*x959*x970*x974))+(((-1.0)*x968*x978*x979))+(((-1.0)*px*x965*x976))+(((0.011236)*x989))+(((0.011236)*x980)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x996=(cj3*r02);
IkReal x997=((1.0)*sj1);
IkReal x998=(r02*sj3);
IkReal x999=(r00*sj0*sj3);
IkReal x1000=(cj0*cj3*r01);
IkReal x1001=(cj3*r00*sj0);
IkReal x1002=((1.0)*cj0*r01*sj3);
CheckValue<IkReal> x1003 = IKatan2WithCheck(IkReal((((cj1*x996))+((cj1*x999))+((sj1*x1001))+(((-1.0)*x997*x998))+(((-1.0)*cj1*x1002))+(((-1.0)*x1000*x997)))),IkReal((((cj1*x998))+(((-1.0)*cj0*r01*sj3*x997))+(((-1.0)*cj1*x1001))+((cj1*x1000))+((sj1*x999))+((sj1*x996)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1003.valid){
continue;
}
CheckValue<IkReal> x1004=IKPowWithIntegerCheck(IKsign(cj4),-1);
if(!x1004.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x1003.value)+(((1.5707963267949)*(x1004.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1005=IKcos(j2);
IkReal x1006=IKsin(j2);
IkReal x1007=py*py;
IkReal x1008=pz*pz;
IkReal x1009=px*px;
IkReal x1010=(py*sj1);
IkReal x1011=((2.0)*r01);
IkReal x1012=(px*sj0);
IkReal x1013=(cj0*pz);
IkReal x1014=(r00*sj1);
IkReal x1015=((0.212)*r01);
IkReal x1016=((1.0)*sj1);
IkReal x1017=(cj0*px);
IkReal x1018=((1.0)*cj3);
IkReal x1019=((1.0)*cj1);
IkReal x1020=(px*r01);
IkReal x1021=((0.212)*r00);
IkReal x1022=(r01*sj0);
IkReal x1023=(r00*sj0);
IkReal x1024=(cj1*r02);
IkReal x1025=((2.0)*pz);
IkReal x1026=((1.0)*sj0);
IkReal x1027=(cj1*py);
IkReal x1028=((2.0)*r00);
IkReal x1029=(r02*sj1);
IkReal x1030=(cj0*r01);
IkReal x1031=(pz*sj1);
IkReal x1032=((0.212)*r02);
IkReal x1033=((0.0845)*cj3);
IkReal x1034=((0.01837625)*cj3);
IkReal x1035=((0.00409575)*sj3);
IkReal x1036=(cj4*x1006);
IkReal x1037=((0.0845)*x1005);
IkReal x1038=(cj1*x1030);
IkReal x1039=((0.106)*x1005);
IkReal x1040=(sj4*x1006);
IkReal x1041=(cj4*x1005);
IkReal x1042=(r02*x1008);
IkReal x1043=(x1009*x1030);
IkReal x1044=((0.0845)*sj3*x1006);
evalcond[0]=(x1038+x1029+(((-1.0)*x1019*x1023))+((sj3*x1036))+(((-1.0)*x1018*x1041)));
evalcond[1]=(x1024+((sj0*x1014))+(((-1.0)*sj3*x1041))+(((-1.0)*x1016*x1030))+(((-1.0)*x1018*x1036)));
evalcond[2]=((((-1.0)*x1012*x1019))+x1031+((sj3*x1037))+((cj0*x1027))+((x1006*x1033))+(((0.106)*x1006)));
evalcond[3]=((-0.106)+(((-1.0)*cj0*x1010))+(((-1.0)*x1039))+x1044+((sj1*x1012))+(((-1.0)*x1005*x1033))+((cj1*pz)));
evalcond[4]=((((-1.0)*x1033*x1040))+(((-1.0)*r02*x1010*x1026))+(((-1.0)*x1019*x1020))+((x1013*x1014))+(((-1.0)*r02*x1016*x1017))+((x1022*x1031))+(((-1.0)*sj3*sj4*x1037))+(((-0.106)*x1040))+((r00*x1027)));
evalcond[5]=(((x1017*x1024))+(((-1.0)*pz*x1019*x1022))+((py*sj0*x1024))+(((0.106)*cj0*r00))+(((-1.0)*r00*x1013*x1019))+(((-1.0)*sj4*x1005*x1033))+(((0.0845)*sj3*x1040))+(((-1.0)*x1016*x1020))+(((0.106)*x1022))+((r00*x1010))+(((-1.0)*sj4*x1039)));
evalcond[6]=(((x1009*x1024))+(((-1.0)*x1009*x1014*x1026))+((x1010*x1017*x1028))+(((-1.0)*pz*x1011*x1027))+((sj1*x1007*x1030))+(((-1.0)*x1016*x1043))+(((-1.0)*x1034*x1036))+((x1035*x1041))+(((-0.011236)*x1024))+(((-1.0)*x1012*x1025*x1029))+((sj0*x1008*x1014))+(((-1.0)*x1008*x1016*x1030))+(((-0.017914)*x1036))+(((-1.0)*cj1*px*r00*x1025))+(((-1.0)*x1010*x1011*x1012))+((pz*x1032))+((px*x1021))+(((-1.0)*x1019*x1042))+((py*x1015))+((x1007*x1024))+(((2.0)*r02*x1010*x1013))+(((-0.011236)*sj0*x1014))+((sj0*x1007*x1014))+(((0.011236)*sj1*x1030)));
evalcond[7]=(((x1009*x1038))+((x1009*x1029))+(((0.011236)*x1038))+(((-1.0)*x1007*x1019*x1023))+(((-1.0)*x1035*x1036))+(((-1.0)*x1016*x1042))+(((-1.0)*x1007*x1019*x1030))+(((-0.017914)*x1041))+(((-2.0)*py*x1013*x1024))+(((-0.011236)*cj1*x1023))+((cj1*x1009*x1023))+((pz*sj0*x1021))+((cj0*py*x1032))+(((-1.0)*x1017*x1027*x1028))+(((-1.0)*pz*x1010*x1011))+(((-1.0)*x1013*x1015))+((x1007*x1029))+(((-1.0)*x1008*x1019*x1023))+(((-1.0)*px*x1014*x1025))+(((-1.0)*x1034*x1041))+(((-1.0)*x1012*x1032))+((x1011*x1012*x1027))+((x1012*x1024*x1025))+(((0.011236)*x1029))+((x1008*x1038)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1045=(r00*sj0);
IkReal x1046=((53.0)*sj1);
IkReal x1047=((500.0)*pz);
IkReal x1048=(cj0*r01);
IkReal x1049=((500.0)*px);
IkReal x1050=((53.0)*cj1);
IkReal x1051=((500.0)*py);
CheckValue<IkReal> x1052=IKPowWithIntegerCheck(IKsign(cj4),-1);
if(!x1052.valid){
continue;
}
CheckValue<IkReal> x1053 = IKatan2WithCheck(IkReal((((r02*x1047))+(((-1.0)*r02*x1050))+(((-1.0)*x1045*x1046))+((r00*x1049))+((r01*x1051))+((x1046*x1048)))),IkReal((((r02*sj0*x1049))+(((-1.0)*r02*x1046))+(((-1.0)*cj0*r02*x1051))+(((-1.0)*x1045*x1047))+(((-1.0)*x1048*x1050))+((x1047*x1048))+(((-42.25)*cj4))+((x1045*x1050)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1053.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1052.value)))+(x1053.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x1054=IKcos(j3);
IkReal x1055=px*px;
IkReal x1056=py*py;
IkReal x1057=pz*pz;
IkReal x1058=(py*r00);
IkReal x1059=((2.0)*px);
IkReal x1060=((0.212)*sj1);
IkReal x1061=((0.212)*cj1);
IkReal x1062=(r01*sj0);
IkReal x1063=(cj0*py);
IkReal x1064=(cj0*r00);
IkReal x1065=((0.106)*cj1);
IkReal x1066=(r00*sj0);
IkReal x1067=(cj0*r02);
IkReal x1068=(px*sj0);
IkReal x1069=(cj0*r01);
IkReal x1070=((0.106)*sj1);
IkReal x1071=((1.0)*r02);
IkReal x1072=((0.106)*cj4);
IkReal x1073=((1.0)*x1056);
IkReal x1074=(py*r02*sj0);
IkReal x1075=((0.017914)*x1054);
IkReal x1076=((1.0)*x1055);
IkReal x1077=((1.0)*x1057);
evalcond[0]=((((-1.0)*px*r00))+((x1066*x1070))+(((-1.0)*pz*x1071))+((x1072*(IKsin(j3))))+(((-1.0)*py*r01))+(((-1.0)*x1069*x1070))+((r02*x1065)));
evalcond[1]=((0.00714025)+(((-1.0)*x1060*x1063))+x1075+((x1060*x1068))+((pz*x1061))+(((-1.0)*x1073))+(((-1.0)*x1077))+(((-1.0)*x1076)));
evalcond[2]=(((x1054*x1072))+(((-1.0)*pz*x1069))+((pz*x1066))+(((-1.0)*x1068*x1071))+(((0.0845)*cj4))+((r02*x1063))+(((-1.0)*x1065*x1066))+((r02*x1070))+((x1065*x1069)));
evalcond[3]=(((x1056*x1062))+(((-0.011236)*x1064))+(((-0.011236)*x1062))+((pz*x1059*x1067))+((x1055*x1064))+((pz*x1061*x1062))+((pz*x1061*x1064))+((r01*x1059*x1063))+(((-1.0)*x1058*x1060))+(((-0.01837625)*sj4))+(((-1.0)*px*x1061*x1067))+((sj0*x1058*x1059))+(((-1.0)*x1062*x1076))+(((-1.0)*x1062*x1077))+(((-1.0)*x1061*x1074))+(((-1.0)*sj4*x1075))+((px*r01*x1060))+(((-1.0)*x1064*x1073))+(((-1.0)*x1064*x1077))+(((2.0)*pz*x1074)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=IKsign(cj4);
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
IkReal x1078=(cj3*cj4);
j2eval[0]=(cj4+(((1.25443786982249)*x1078)));
j2eval[1]=IKsign(((((169.0)*cj4))+(((212.0)*x1078))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal j2eval[2];
j2eval[0]=cj4;
j2eval[1]=sj3;
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=1.0;
cj4=0;
j4=1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1079=((424000.0)*sj1);
IkReal x1080=(px*sj0);
IkReal x1081=(cj1*pz);
IkReal x1082=(cj0*py);
IkReal x1083=((338000.0)*sj3);
IkReal x1084=((338000.0)*cj3);
IkReal x1085=((424000.0)*cj1);
IkReal x1086=(sj1*x1083);
CheckValue<IkReal> x1087 = IKatan2WithCheck(IkReal((((x1082*x1085))+(((-35828.0)*sj3))+((x1081*x1083))+(((-1.0)*cj1*x1080*x1084))+((pz*x1079))+((pz*sj1*x1084))+(((-1.0)*x1080*x1085))+((cj1*x1082*x1084))+(((-1.0)*x1082*x1086))+((x1080*x1086)))),IkReal(((44944.0)+((x1079*x1082))+(((35828.0)*cj3))+((pz*x1086))+((sj1*x1082*x1084))+(((-1.0)*cj1*x1080*x1083))+(((-424000.0)*x1081))+(((-1.0)*x1081*x1084))+(((-1.0)*sj1*x1080*x1084))+(((-1.0)*x1079*x1080))+((cj1*x1082*x1083)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1087.valid){
continue;
}
CheckValue<IkReal> x1088=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x1088.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x1087.value)+(((1.5707963267949)*(x1088.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x1089=IKsin(j2);
IkReal x1090=IKcos(j2);
IkReal x1091=((1.0)*r01);
IkReal x1092=(cj1*pz);
IkReal x1093=(r00*sj1);
IkReal x1094=(cj0*r00);
IkReal x1095=(px*sj1);
IkReal x1096=(cj0*r02);
IkReal x1097=(cj1*py);
IkReal x1098=(cj1*px);
IkReal x1099=(r02*sj0);
IkReal x1100=(r01*sj0);
IkReal x1101=(pz*sj1);
IkReal x1102=((0.106)*x1089);
IkReal x1103=((0.106)*x1090);
IkReal x1104=((0.0845)*x1090);
IkReal x1105=((0.0845)*x1089);
IkReal x1106=((1.0)*py*sj1);
IkReal x1107=(sj3*x1104);
IkReal x1108=(cj3*x1105);
IkReal x1109=(sj3*x1105);
IkReal x1110=(cj3*x1104);
IkReal x1111=(x1103+x1110);
IkReal x1112=(x1107+x1102+x1108);
evalcond[0]=(x1101+x1112+(((-1.0)*sj0*x1098))+((cj0*x1097)));
evalcond[1]=((-0.106)+x1109+x1092+((sj0*x1095))+(((-1.0)*x1111))+(((-1.0)*cj0*x1106)));
evalcond[2]=((((-1.0)*x1091*x1098))+((r00*x1097))+((cj0*pz*x1093))+(((-1.0)*x1099*x1106))+((x1100*x1101))+(((-1.0)*x1112))+(((-1.0)*x1095*x1096)));
evalcond[3]=(x1109+(((-1.0)*x1091*x1095))+(((0.106)*x1100))+(((-1.0)*sj0*x1091*x1092))+(((-1.0)*x1092*x1094))+(((0.106)*x1094))+((py*x1093))+((x1096*x1098))+(((-1.0)*x1111))+((x1097*x1099)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2eval[2];
sj4=-1.0;
cj4=0;
j4=-1.5707963267949;
j2eval[0]=((-1.02580384057162)+(((-1.0)*cj3)));
j2eval[1]=IKsign(((-73505.0)+(((-71656.0)*cj3))));
if( IKabs(j2eval[0]) < 0.0000010000000000  || IKabs(j2eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j2]

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1113=((424000.0)*sj1);
IkReal x1114=(px*sj0);
IkReal x1115=(cj1*pz);
IkReal x1116=(cj0*py);
IkReal x1117=((338000.0)*sj3);
IkReal x1118=((338000.0)*cj3);
IkReal x1119=((424000.0)*cj1);
IkReal x1120=(sj1*x1117);
CheckValue<IkReal> x1121=IKPowWithIntegerCheck(IKsign(((-73505.0)+(((-71656.0)*cj3)))),-1);
if(!x1121.valid){
continue;
}
CheckValue<IkReal> x1122 = IKatan2WithCheck(IkReal((((x1114*x1120))+(((-1.0)*x1114*x1119))+(((-35828.0)*sj3))+((pz*sj1*x1118))+(((-1.0)*x1116*x1120))+(((-1.0)*cj1*x1114*x1118))+((cj1*x1116*x1118))+((x1116*x1119))+((pz*x1113))+((x1115*x1117)))),IkReal(((44944.0)+(((35828.0)*cj3))+((x1113*x1116))+(((-1.0)*cj1*x1114*x1117))+((cj1*x1116*x1117))+((pz*x1120))+((sj1*x1116*x1118))+(((-1.0)*x1113*x1114))+(((-424000.0)*x1115))+(((-1.0)*sj1*x1114*x1118))+(((-1.0)*x1115*x1118)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1122.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1121.value)))+(x1122.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x1123=IKsin(j2);
IkReal x1124=IKcos(j2);
IkReal x1125=((1.0)*r01);
IkReal x1126=(cj1*pz);
IkReal x1127=(r00*sj1);
IkReal x1128=(cj0*r00);
IkReal x1129=(px*sj1);
IkReal x1130=(cj0*r02);
IkReal x1131=(cj1*py);
IkReal x1132=(cj1*px);
IkReal x1133=(r02*sj0);
IkReal x1134=(r01*sj0);
IkReal x1135=(pz*sj1);
IkReal x1136=((0.106)*x1123);
IkReal x1137=((0.106)*x1124);
IkReal x1138=((0.0845)*x1124);
IkReal x1139=((0.0845)*x1123);
IkReal x1140=((1.0)*py*sj1);
IkReal x1141=(sj3*x1138);
IkReal x1142=(cj3*x1139);
IkReal x1143=(cj3*x1138);
IkReal x1144=(sj3*x1139);
IkReal x1145=(x1143+x1137);
IkReal x1146=(x1142+x1141+x1136);
evalcond[0]=(x1146+x1135+((cj0*x1131))+(((-1.0)*sj0*x1132)));
evalcond[1]=((-0.106)+x1144+x1126+((sj0*x1129))+(((-1.0)*x1145))+(((-1.0)*cj0*x1140)));
evalcond[2]=((((-1.0)*x1129*x1130))+x1146+((r00*x1131))+((x1134*x1135))+(((-1.0)*x1133*x1140))+(((-1.0)*x1125*x1132))+((cj0*pz*x1127)));
evalcond[3]=(x1145+((x1130*x1132))+((x1131*x1133))+(((-1.0)*x1144))+(((0.106)*x1128))+((py*x1127))+(((-1.0)*x1126*x1128))+(((0.106)*x1134))+(((-1.0)*sj0*x1125*x1126))+(((-1.0)*x1125*x1129)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1147=((5.249343832021)*sj1);
IkReal x1148=(px*sj0);
IkReal x1149=((5.249343832021)*cj1);
IkReal x1150=(cj0*py);
if( IKabs(((((-1.0)*x1149*x1150))+((x1148*x1149))+(((-1.0)*pz*x1147)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.556430446194226)+((pz*x1149))+(((-1.0)*x1147*x1150))+((x1147*x1148)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x1149*x1150))+((x1148*x1149))+(((-1.0)*pz*x1147))))+IKsqr(((-0.556430446194226)+((pz*x1149))+(((-1.0)*x1147*x1150))+((x1147*x1148))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*x1149*x1150))+((x1148*x1149))+(((-1.0)*pz*x1147))), ((-0.556430446194226)+((pz*x1149))+(((-1.0)*x1147*x1150))+((x1147*x1148))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1151=IKsin(j2);
IkReal x1152=IKcos(j2);
IkReal x1153=py*py;
IkReal x1154=pz*pz;
IkReal x1155=px*px;
IkReal x1156=((1.0)*sj0);
IkReal x1157=((0.212)*py);
IkReal x1158=(px*sj0);
IkReal x1159=((0.212)*r02);
IkReal x1160=(cj0*r02);
IkReal x1161=(r00*sj1);
IkReal x1162=((2.0)*py);
IkReal x1163=(r01*sj1);
IkReal x1164=(cj1*r00);
IkReal x1165=(cj0*pz);
IkReal x1166=(pz*sj1);
IkReal x1167=(r02*sj1);
IkReal x1168=(cj1*pz);
IkReal x1169=(cj0*px);
IkReal x1170=((0.212)*r00);
IkReal x1171=(pz*sj0);
IkReal x1172=((1.0)*px);
IkReal x1173=(cj1*py);
IkReal x1174=(cj1*r02);
IkReal x1175=((2.0)*r02);
IkReal x1176=((1.0)*cj0);
IkReal x1177=(cj1*r01);
IkReal x1178=(cj1*px);
IkReal x1179=((0.011236)*sj0);
IkReal x1180=(r01*x1168);
IkReal x1181=(cj4*x1152);
IkReal x1182=(cj0*x1177);
IkReal x1183=((0.1905)*x1151);
IkReal x1184=((1.0)*x1154);
IkReal x1185=((0.1905)*x1152);
IkReal x1186=((2.0)*px*pz);
IkReal x1187=(cj4*x1151);
evalcond[0]=(x1183+x1166+((cj0*x1173))+(((-1.0)*x1156*x1178)));
evalcond[1]=((((-1.0)*x1156*x1164))+x1182+x1167+(((-1.0)*x1181)));
evalcond[2]=(x1174+((sj0*x1161))+(((-1.0)*x1163*x1176))+(((-1.0)*x1187)));
evalcond[3]=((-0.106)+x1168+(((-1.0)*x1185))+((sj1*x1158))+(((-1.0)*py*sj1*x1176)));
evalcond[4]=(((x1163*x1171))+(((-1.0)*x1172*x1177))+(((-1.0)*sj4*x1183))+((py*x1164))+(((-1.0)*sj1*x1160*x1172))+(((-1.0)*py*x1156*x1167))+((x1161*x1165)));
evalcond[5]=((((0.106)*cj0*r00))+(((-1.0)*x1156*x1180))+(((-1.0)*x1163*x1172))+(((0.106)*r01*sj0))+((r02*sj0*x1173))+(((-1.0)*sj4*x1185))+(((-1.0)*x1164*x1165))+((py*x1161))+((x1160*x1178)));
evalcond[6]=(((pz*x1159))+((x1153*x1174))+(((0.011236)*cj0*x1163))+((px*x1170))+((x1155*x1174))+(((-1.0)*x1158*x1166*x1175))+((x1161*x1162*x1169))+(((-1.0)*x1158*x1162*x1163))+(((-0.03629025)*x1187))+((sj0*x1154*x1161))+((cj0*x1153*x1163))+((x1160*x1162*x1166))+(((-1.0)*x1162*x1180))+(((-1.0)*x1161*x1179))+((sj0*x1153*x1161))+(((-1.0)*x1154*x1163*x1176))+(((-1.0)*x1164*x1186))+(((-1.0)*x1155*x1156*x1161))+(((-1.0)*x1174*x1184))+(((-0.011236)*x1174))+((r01*x1157))+(((-1.0)*x1155*x1163*x1176)));
evalcond[7]=(((x1153*x1167))+(((-1.0)*pz*x1162*x1163))+((x1155*x1167))+((x1158*x1168*x1175))+(((-1.0)*x1158*x1159))+((x1157*x1160))+((sj0*x1155*x1164))+(((-0.03629025)*x1181))+((x1154*x1182))+(((-1.0)*x1153*x1156*x1164))+(((0.011236)*x1167))+(((0.011236)*x1182))+(((-1.0)*x1164*x1179))+(((-1.0)*x1162*x1164*x1169))+((x1155*x1182))+(((-1.0)*x1160*x1162*x1168))+(((-1.0)*x1154*x1156*x1164))+(((-0.212)*r01*x1165))+(((-1.0)*x1161*x1186))+(((-1.0)*x1153*x1176*x1177))+((x1170*x1171))+((x1158*x1162*x1177))+(((-1.0)*x1167*x1184)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1188=((46.5116279069767)*cj1);
IkReal x1189=(cj0*py);
IkReal x1190=(px*sj0);
IkReal x1191=((46.5116279069767)*sj1);
if( IKabs(((((-1.0)*x1188*x1189))+((x1188*x1190))+(((-1.0)*pz*x1191)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-4.93023255813953)+(((-1.0)*x1189*x1191))+((pz*x1188))+((x1190*x1191)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x1188*x1189))+((x1188*x1190))+(((-1.0)*pz*x1191))))+IKsqr(((-4.93023255813953)+(((-1.0)*x1189*x1191))+((pz*x1188))+((x1190*x1191))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((-1.0)*x1188*x1189))+((x1188*x1190))+(((-1.0)*pz*x1191))), ((-4.93023255813953)+(((-1.0)*x1189*x1191))+((pz*x1188))+((x1190*x1191))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1192=IKsin(j2);
IkReal x1193=IKcos(j2);
IkReal x1194=py*py;
IkReal x1195=pz*pz;
IkReal x1196=px*px;
IkReal x1197=((0.212)*py);
IkReal x1198=(px*sj0);
IkReal x1199=((0.212)*r02);
IkReal x1200=(cj0*r02);
IkReal x1201=(py*sj1);
IkReal x1202=((2.0)*r01);
IkReal x1203=(cj0*r00);
IkReal x1204=(pz*sj1);
IkReal x1205=(cj0*r01);
IkReal x1206=((0.00046225)*cj4);
IkReal x1207=((2.0)*px);
IkReal x1208=(r00*sj0);
IkReal x1209=((0.011236)*cj1);
IkReal x1210=((0.212)*pz);
IkReal x1211=((1.0)*cj1);
IkReal x1212=((1.0)*sj1);
IkReal x1213=(cj1*py);
IkReal x1214=((1.0)*r02);
IkReal x1215=((2.0)*r02);
IkReal x1216=(cj1*pz);
IkReal x1217=(r02*sj1);
IkReal x1218=(r01*sj0);
IkReal x1219=((0.011236)*sj1);
IkReal x1220=((0.0215)*x1193);
IkReal x1221=(r02*x1194);
IkReal x1222=(pz*x1213);
IkReal x1223=(cj1*x1196);
IkReal x1224=(sj1*x1194);
IkReal x1225=(cj1*x1195);
IkReal x1226=((0.0215)*x1192);
IkReal x1227=(px*x1212);
IkReal x1228=(x1208*x1211);
evalcond[0]=(x1217+(((-1.0)*x1228))+((cj1*x1205))+((cj4*x1193)));
evalcond[1]=(x1204+x1226+((cj0*x1213))+(((-1.0)*x1198*x1211)));
evalcond[2]=(((cj1*r02))+((cj4*x1192))+(((-1.0)*x1205*x1212))+((sj1*x1208)));
evalcond[3]=((-0.106)+x1216+(((-1.0)*x1220))+((sj1*x1198))+(((-1.0)*cj0*x1201)));
evalcond[4]=((((-1.0)*sj0*x1201*x1214))+(((-1.0)*x1200*x1227))+((x1204*x1218))+((r00*x1213))+((x1203*x1204))+(((-1.0)*sj4*x1226))+(((-1.0)*px*r01*x1211)));
evalcond[5]=((((-1.0)*r01*x1227))+((r02*sj0*x1213))+(((-1.0)*pz*x1211*x1218))+((cj1*px*x1200))+(((0.106)*x1203))+(((-1.0)*pz*x1203*x1211))+((r00*x1201))+(((-1.0)*sj4*x1220))+(((0.106)*x1218)));
evalcond[6]=((((-1.0)*x1198*x1201*x1202))+(((-1.0)*r02*x1195*x1211))+(((-1.0)*x1202*x1222))+((x1205*x1224))+(((-1.0)*x1196*x1208*x1212))+(((-1.0)*x1208*x1219))+(((-1.0)*x1198*x1204*x1215))+(((0.212)*px*r00))+((r01*x1197))+((x1192*x1206))+((pz*x1199))+(((-1.0)*r02*x1209))+((r02*x1223))+((x1201*x1203*x1207))+((sj1*x1195*x1208))+(((-1.0)*x1196*x1205*x1212))+(((2.0)*pz*x1200*x1201))+(((-1.0)*r00*x1207*x1216))+((x1205*x1219))+(((-1.0)*x1195*x1205*x1212))+((x1208*x1224))+((cj1*x1221)));
evalcond[7]=((((-1.0)*r02*x1195*x1212))+((x1205*x1223))+((x1205*x1225))+(((-1.0)*x1198*x1199))+(((-1.0)*pz*x1201*x1202))+(((-1.0)*r00*x1204*x1207))+((x1193*x1206))+(((-1.0)*x1194*x1228))+(((-1.0)*x1195*x1228))+(((-1.0)*x1205*x1210))+((x1197*x1200))+((x1196*x1217))+((x1205*x1209))+(((-2.0)*x1200*x1222))+((x1208*x1210))+((x1198*x1215*x1216))+(((-1.0)*x1194*x1205*x1211))+(((-1.0)*x1203*x1207*x1213))+((x1208*x1223))+((x1198*x1202*x1213))+(((-1.0)*x1208*x1209))+(((0.011236)*x1217))+((x1194*x1217)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs(((0.797169811320755)+cj3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1229=(px*sj0);
IkReal x1230=((12.4561584192523)*cj1);
IkReal x1231=((9.43396229287055)*sj1);
IkReal x1232=((12.4561584192523)*sj1);
IkReal x1233=(cj0*py);
IkReal x1234=((9.43396229287055)*cj1);
if( IKabs(((1.32035279244074)+(((-1.0)*pz*x1231))+(((-1.0)*pz*x1230))+(((-1.0)*x1229*x1232))+(((-1.0)*x1233*x1234))+((x1232*x1233))+((x1229*x1234)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+((pz*x1234))+(((-1.0)*x1230*x1233))+(((-1.0)*pz*x1232))+(((-1.0)*x1231*x1233))+((x1229*x1230))+((x1229*x1231)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((1.32035279244074)+(((-1.0)*pz*x1231))+(((-1.0)*pz*x1230))+(((-1.0)*x1229*x1232))+(((-1.0)*x1233*x1234))+((x1232*x1233))+((x1229*x1234))))+IKsqr(((-1.00000000304428)+((pz*x1234))+(((-1.0)*x1230*x1233))+(((-1.0)*pz*x1232))+(((-1.0)*x1231*x1233))+((x1229*x1230))+((x1229*x1231))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((1.32035279244074)+(((-1.0)*pz*x1231))+(((-1.0)*pz*x1230))+(((-1.0)*x1229*x1232))+(((-1.0)*x1233*x1234))+((x1232*x1233))+((x1229*x1234))), ((-1.00000000304428)+((pz*x1234))+(((-1.0)*x1230*x1233))+(((-1.0)*pz*x1232))+(((-1.0)*x1231*x1233))+((x1229*x1230))+((x1229*x1231))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1235=IKsin(j2);
IkReal x1236=IKcos(j2);
IkReal x1237=py*py;
IkReal x1238=pz*pz;
IkReal x1239=px*px;
IkReal x1240=((1.0)*sj0);
IkReal x1241=((0.212)*py);
IkReal x1242=(px*sj0);
IkReal x1243=((0.212)*r02);
IkReal x1244=(cj0*r02);
IkReal x1245=(r00*sj1);
IkReal x1246=((2.0)*py);
IkReal x1247=(r01*sj1);
IkReal x1248=(cj1*r00);
IkReal x1249=(cj0*pz);
IkReal x1250=(cj1*r02);
IkReal x1251=((0.79716981)*cj4);
IkReal x1252=(r02*sj1);
IkReal x1253=(cj0*px);
IkReal x1254=(cj1*pz);
IkReal x1255=((0.011236)*sj0);
IkReal x1256=((0.0510173108376979)*sj4);
IkReal x1257=((1.0)*px);
IkReal x1258=(cj0*py);
IkReal x1259=((2.0)*pz);
IkReal x1260=((1.0)*cj0);
IkReal x1261=(cj1*r01);
IkReal x1262=((0.212)*r00);
IkReal x1263=((0.603755157842579)*cj4);
IkReal x1264=(pz*sj0);
IkReal x1265=(cj1*px);
IkReal x1266=(pz*sj1);
IkReal x1267=(r01*x1254);
IkReal x1268=((0.038639151055)*x1236);
IkReal x1269=(cj0*x1261);
IkReal x1270=((1.0)*x1238);
IkReal x1271=((0.038639151055)*x1235);
IkReal x1272=(cj4*x1236);
IkReal x1273=(cj4*x1235);
evalcond[0]=(x1271+x1266+(((0.0510173108376979)*x1236))+((cj1*x1258))+(((-1.0)*x1240*x1265)));
evalcond[1]=((-0.106)+x1254+(((0.0510173108376979)*x1235))+(((-1.0)*sj1*x1258))+((sj1*x1242))+(((-1.0)*x1268)));
evalcond[2]=(x1269+x1252+((x1235*x1263))+((x1236*x1251))+(((-1.0)*x1240*x1248)));
evalcond[3]=(x1250+(((-1.0)*x1247*x1260))+((x1235*x1251))+((sj0*x1245))+(((-1.0)*x1236*x1263)));
evalcond[4]=(((x1247*x1264))+(((-1.0)*py*x1240*x1252))+(((-1.0)*sj1*x1244*x1257))+((py*x1248))+(((-1.0)*x1257*x1261))+((x1245*x1249))+(((-1.0)*sj4*x1271))+(((-1.0)*x1236*x1256)));
evalcond[5]=(((x1244*x1265))+(((0.106)*cj0*r00))+(((0.106)*r01*sj0))+((py*x1245))+(((-1.0)*x1247*x1257))+((x1235*x1256))+(((-1.0)*sj4*x1268))+(((-1.0)*x1248*x1249))+(((-1.0)*x1240*x1267))+((py*sj0*x1250)));
evalcond[6]=(((x1244*x1246*x1266))+((x1245*x1246*x1253))+(((-0.0032650082789875)*x1273))+((cj0*x1237*x1247))+(((-1.0)*x1239*x1247*x1260))+((pz*x1243))+(((-1.0)*x1246*x1267))+((r01*x1241))+((x1237*x1250))+(((-1.0)*x1245*x1255))+(((-1.0)*x1250*x1270))+((x1239*x1250))+(((0.00247283018773374)*x1272))+(((-1.0)*x1238*x1247*x1260))+(((-1.0)*x1242*x1252*x1259))+((sj0*x1238*x1245))+(((-1.0)*px*x1248*x1259))+(((-1.0)*x1239*x1240*x1245))+(((0.011236)*cj0*x1247))+((sj0*x1237*x1245))+((px*x1262))+(((-1.0)*x1242*x1246*x1247))+(((-0.011236)*x1250)));
evalcond[7]=((((0.011236)*x1269))+(((-1.0)*x1237*x1260*x1261))+(((-1.0)*x1244*x1246*x1254))+(((0.011236)*x1252))+(((-0.0032650082789875)*x1272))+(((-1.0)*px*x1245*x1259))+(((-1.0)*x1238*x1240*x1248))+(((-0.00247283018773374)*x1273))+(((-1.0)*x1252*x1270))+((x1242*x1250*x1259))+((x1238*x1269))+(((-1.0)*x1248*x1255))+((x1237*x1252))+(((-0.212)*r01*x1249))+(((-1.0)*x1246*x1248*x1253))+(((-1.0)*x1242*x1243))+(((-1.0)*x1237*x1240*x1248))+(((-1.0)*pz*x1246*x1247))+((x1262*x1264))+((x1239*x1252))+((x1239*x1269))+((x1241*x1244))+((x1242*x1246*x1261))+((sj0*x1239*x1248)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((0.797169811320755)+cj3)))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1274=(px*sj0);
IkReal x1275=((12.4561584192523)*cj1);
IkReal x1276=((9.43396229287055)*sj1);
IkReal x1277=((12.4561584192523)*sj1);
IkReal x1278=(cj0*py);
IkReal x1279=((9.43396229287055)*cj1);
if( IKabs(((-1.32035279244074)+((pz*x1275))+((x1274*x1279))+((x1274*x1277))+(((-1.0)*x1277*x1278))+(((-1.0)*x1278*x1279))+(((-1.0)*pz*x1276)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00000000304428)+((pz*x1279))+((pz*x1277))+((x1275*x1278))+((x1274*x1276))+(((-1.0)*x1276*x1278))+(((-1.0)*x1274*x1275)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.32035279244074)+((pz*x1275))+((x1274*x1279))+((x1274*x1277))+(((-1.0)*x1277*x1278))+(((-1.0)*x1278*x1279))+(((-1.0)*pz*x1276))))+IKsqr(((-1.00000000304428)+((pz*x1279))+((pz*x1277))+((x1275*x1278))+((x1274*x1276))+(((-1.0)*x1276*x1278))+(((-1.0)*x1274*x1275))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((-1.32035279244074)+((pz*x1275))+((x1274*x1279))+((x1274*x1277))+(((-1.0)*x1277*x1278))+(((-1.0)*x1278*x1279))+(((-1.0)*pz*x1276))), ((-1.00000000304428)+((pz*x1279))+((pz*x1277))+((x1275*x1278))+((x1274*x1276))+(((-1.0)*x1276*x1278))+(((-1.0)*x1274*x1275))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1280=IKcos(j2);
IkReal x1281=IKsin(j2);
IkReal x1282=py*py;
IkReal x1283=pz*pz;
IkReal x1284=px*px;
IkReal x1285=((1.0)*sj0);
IkReal x1286=((0.212)*py);
IkReal x1287=(px*sj0);
IkReal x1288=((0.212)*r02);
IkReal x1289=(cj0*r02);
IkReal x1290=(r00*sj1);
IkReal x1291=((2.0)*py);
IkReal x1292=(r01*sj1);
IkReal x1293=(cj1*r00);
IkReal x1294=(cj0*pz);
IkReal x1295=(cj1*r02);
IkReal x1296=(r02*sj1);
IkReal x1297=(cj0*px);
IkReal x1298=(cj1*pz);
IkReal x1299=((0.011236)*sj0);
IkReal x1300=((0.0510173108376979)*sj4);
IkReal x1301=((1.0)*px);
IkReal x1302=(cj0*py);
IkReal x1303=((2.0)*pz);
IkReal x1304=((1.0)*cj0);
IkReal x1305=(cj1*r01);
IkReal x1306=((0.212)*r00);
IkReal x1307=(pz*sj0);
IkReal x1308=(cj1*px);
IkReal x1309=(pz*sj1);
IkReal x1310=(r01*x1298);
IkReal x1311=((0.038639151055)*x1280);
IkReal x1312=(cj4*x1281);
IkReal x1313=(cj0*x1305);
IkReal x1314=((1.0)*x1283);
IkReal x1315=((0.038639151055)*x1281);
IkReal x1316=(cj4*x1280);
evalcond[0]=(x1309+x1315+(((-0.0510173108376979)*x1280))+((cj1*x1302))+(((-1.0)*x1285*x1308)));
evalcond[1]=((-0.106)+x1298+(((-0.0510173108376979)*x1281))+(((-1.0)*x1311))+(((-1.0)*sj1*x1302))+((sj1*x1287)));
evalcond[2]=(x1313+x1296+(((0.79716981)*x1316))+(((-1.0)*x1285*x1293))+(((-0.603755157842579)*x1312)));
evalcond[3]=(x1295+((sj0*x1290))+(((0.603755157842579)*x1316))+(((0.79716981)*x1312))+(((-1.0)*x1292*x1304)));
evalcond[4]=(((x1292*x1307))+((x1290*x1294))+((py*x1293))+(((-1.0)*sj1*x1289*x1301))+(((-1.0)*sj4*x1315))+((x1280*x1300))+(((-1.0)*py*x1285*x1296))+(((-1.0)*x1301*x1305)));
evalcond[5]=((((0.106)*cj0*r00))+(((-1.0)*x1285*x1310))+((py*sj0*x1295))+(((0.106)*r01*sj0))+((py*x1290))+((x1289*x1308))+(((-1.0)*sj4*x1311))+(((-1.0)*x1292*x1301))+(((-1.0)*x1293*x1294))+(((-1.0)*x1281*x1300)));
evalcond[6]=(((cj0*x1282*x1292))+((sj0*x1283*x1290))+((x1290*x1291*x1297))+((px*x1306))+(((0.011236)*cj0*x1292))+((x1282*x1295))+(((-1.0)*px*x1293*x1303))+((r01*x1286))+((x1289*x1291*x1309))+(((-1.0)*x1284*x1292*x1304))+(((-1.0)*x1291*x1310))+(((-0.00247283018773374)*x1316))+(((-1.0)*x1287*x1296*x1303))+(((-1.0)*x1290*x1299))+(((-1.0)*x1287*x1291*x1292))+((x1284*x1295))+((sj0*x1282*x1290))+(((-1.0)*x1284*x1285*x1290))+(((-1.0)*x1295*x1314))+((pz*x1288))+(((-1.0)*x1283*x1292*x1304))+(((-0.0032650082789875)*x1312))+(((-0.011236)*x1295)));
evalcond[7]=((((-1.0)*x1282*x1304*x1305))+((x1284*x1313))+(((-1.0)*x1289*x1291*x1298))+((sj0*x1284*x1293))+((x1306*x1307))+(((-1.0)*x1282*x1285*x1293))+(((0.00247283018773374)*x1312))+((x1283*x1313))+((x1282*x1296))+(((-1.0)*x1293*x1299))+(((-1.0)*x1296*x1314))+(((-1.0)*x1291*x1293*x1297))+(((0.011236)*x1296))+(((-1.0)*px*x1290*x1303))+((x1287*x1295*x1303))+((x1286*x1289))+((x1284*x1296))+(((-1.0)*x1283*x1285*x1293))+(((-1.0)*x1287*x1288))+(((-0.212)*r01*x1294))+((x1287*x1291*x1305))+(((-1.0)*pz*x1291*x1292))+(((0.011236)*x1313))+(((-0.0032650082789875)*x1316)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j2]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
CheckValue<IkReal> x1327=IKPowWithIntegerCheck(cj4,-1);
if(!x1327.valid){
continue;
}
IkReal x1317=x1327.value;
IkReal x1318=((2000.0)*cj4);
IkReal x1319=(cj3*sj1);
IkReal x1320=(cj1*r02);
IkReal x1321=((212.0)*sj1);
IkReal x1322=((-0.00471698113207547)*x1317);
IkReal x1323=(cj1*px*sj0);
IkReal x1324=((169.0)*r00*sj0);
IkReal x1325=(cj0*cj1*py);
IkReal x1326=((169.0)*cj0*r01*sj1);
CheckValue<IkReal> x1328=IKPowWithIntegerCheck(sj3,-1);
if(!x1328.valid){
continue;
}
if( IKabs((x1322*((((pz*sj1*x1318))+(((-1.0)*x1326))+(((169.0)*x1320))+((x1318*x1325))+((sj1*x1324))+(((-1.0)*x1318*x1323)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1322*(x1328.value)*(((((-212.0)*x1320))+(((-1.0)*x1319*x1324))+(((-169.0)*cj3*x1320))+((cj3*x1318*x1323))+((cj0*r01*x1321))+(((-1.0)*cj3*x1318*x1325))+(((-1.0)*r00*sj0*x1321))+(((169.0)*cj0*r01*x1319))+(((-1.0)*pz*x1318*x1319)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1322*((((pz*sj1*x1318))+(((-1.0)*x1326))+(((169.0)*x1320))+((x1318*x1325))+((sj1*x1324))+(((-1.0)*x1318*x1323))))))+IKsqr((x1322*(x1328.value)*(((((-212.0)*x1320))+(((-1.0)*x1319*x1324))+(((-169.0)*cj3*x1320))+((cj3*x1318*x1323))+((cj0*r01*x1321))+(((-1.0)*cj3*x1318*x1325))+(((-1.0)*r00*sj0*x1321))+(((169.0)*cj0*r01*x1319))+(((-1.0)*pz*x1318*x1319))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2((x1322*((((pz*sj1*x1318))+(((-1.0)*x1326))+(((169.0)*x1320))+((x1318*x1325))+((sj1*x1324))+(((-1.0)*x1318*x1323))))), (x1322*(x1328.value)*(((((-212.0)*x1320))+(((-1.0)*x1319*x1324))+(((-169.0)*cj3*x1320))+((cj3*x1318*x1323))+((cj0*r01*x1321))+(((-1.0)*cj3*x1318*x1325))+(((-1.0)*r00*sj0*x1321))+(((169.0)*cj0*r01*x1319))+(((-1.0)*pz*x1318*x1319))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1329=IKcos(j2);
IkReal x1330=IKsin(j2);
IkReal x1331=py*py;
IkReal x1332=pz*pz;
IkReal x1333=px*px;
IkReal x1334=(py*sj1);
IkReal x1335=((2.0)*r01);
IkReal x1336=(px*sj0);
IkReal x1337=(cj0*pz);
IkReal x1338=(r00*sj1);
IkReal x1339=((0.212)*r01);
IkReal x1340=((1.0)*sj1);
IkReal x1341=(cj0*px);
IkReal x1342=((1.0)*cj3);
IkReal x1343=((1.0)*cj1);
IkReal x1344=(px*r01);
IkReal x1345=((0.212)*r00);
IkReal x1346=(r01*sj0);
IkReal x1347=(r00*sj0);
IkReal x1348=(cj1*r02);
IkReal x1349=((2.0)*pz);
IkReal x1350=((1.0)*sj0);
IkReal x1351=(cj1*py);
IkReal x1352=((2.0)*r00);
IkReal x1353=(r02*sj1);
IkReal x1354=(cj0*r01);
IkReal x1355=(pz*sj1);
IkReal x1356=((0.212)*r02);
IkReal x1357=((0.0845)*cj3);
IkReal x1358=((0.01837625)*cj3);
IkReal x1359=((0.00409575)*sj3);
IkReal x1360=(cj4*x1330);
IkReal x1361=((0.0845)*x1329);
IkReal x1362=(cj1*x1354);
IkReal x1363=((0.106)*x1329);
IkReal x1364=(sj4*x1330);
IkReal x1365=(cj4*x1329);
IkReal x1366=(r02*x1332);
IkReal x1367=(x1333*x1354);
IkReal x1368=((0.0845)*sj3*x1330);
evalcond[0]=(x1353+x1362+(((-1.0)*x1343*x1347))+((sj3*x1360))+(((-1.0)*x1342*x1365)));
evalcond[1]=(x1348+(((-1.0)*sj3*x1365))+((sj0*x1338))+(((-1.0)*x1342*x1360))+(((-1.0)*x1340*x1354)));
evalcond[2]=(x1355+(((-1.0)*x1336*x1343))+((x1330*x1357))+((cj0*x1351))+((sj3*x1361))+(((0.106)*x1330)));
evalcond[3]=((-0.106)+(((-1.0)*x1329*x1357))+x1368+((cj1*pz))+((sj1*x1336))+(((-1.0)*cj0*x1334))+(((-1.0)*x1363)));
evalcond[4]=(((x1337*x1338))+(((-1.0)*sj3*sj4*x1361))+(((-0.106)*x1364))+((x1346*x1355))+((r00*x1351))+(((-1.0)*x1357*x1364))+(((-1.0)*x1343*x1344))+(((-1.0)*r02*x1334*x1350))+(((-1.0)*r02*x1340*x1341)));
evalcond[5]=((((-1.0)*x1340*x1344))+(((-1.0)*sj4*x1363))+(((0.106)*cj0*r00))+((r00*x1334))+(((-1.0)*sj4*x1329*x1357))+((x1341*x1348))+(((-1.0)*pz*x1343*x1346))+((py*sj0*x1348))+(((0.106)*x1346))+(((0.0845)*sj3*x1364))+(((-1.0)*r00*x1337*x1343)));
evalcond[6]=((((-1.0)*x1340*x1367))+(((-1.0)*pz*x1335*x1351))+((x1333*x1348))+((sj0*x1332*x1338))+(((-0.011236)*x1348))+((x1359*x1365))+((py*x1339))+((px*x1345))+(((-0.017914)*x1360))+(((-1.0)*x1333*x1338*x1350))+((x1334*x1341*x1352))+(((-0.011236)*sj0*x1338))+((x1331*x1348))+((pz*x1356))+(((-1.0)*x1343*x1366))+((sj1*x1331*x1354))+(((-1.0)*x1332*x1340*x1354))+(((-1.0)*cj1*px*r00*x1349))+(((2.0)*r02*x1334*x1337))+(((-1.0)*x1334*x1335*x1336))+(((-1.0)*x1336*x1349*x1353))+((sj0*x1331*x1338))+(((-1.0)*x1358*x1360))+(((0.011236)*sj1*x1354)));
evalcond[7]=((((-1.0)*x1340*x1366))+(((-1.0)*x1336*x1356))+(((0.011236)*x1353))+(((-0.011236)*cj1*x1347))+((cj1*x1333*x1347))+(((0.011236)*x1362))+((x1332*x1362))+(((-1.0)*px*x1338*x1349))+((x1333*x1362))+(((-1.0)*x1337*x1339))+(((-1.0)*x1332*x1343*x1347))+((x1333*x1353))+(((-1.0)*x1331*x1343*x1354))+(((-1.0)*x1359*x1360))+(((-1.0)*pz*x1334*x1335))+(((-1.0)*x1341*x1351*x1352))+(((-1.0)*x1331*x1343*x1347))+((x1331*x1353))+(((-0.017914)*x1365))+((cj0*py*x1356))+((pz*sj0*x1345))+((x1335*x1336*x1351))+((x1336*x1348*x1349))+(((-2.0)*py*x1337*x1348))+(((-1.0)*x1358*x1365)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1369=(cj1*sj0);
IkReal x1370=((169.0)*r00);
IkReal x1371=((169.0)*r02*sj1);
IkReal x1372=((2000.0)*cj4*px);
IkReal x1373=((2000.0)*cj4*pz*sj1);
IkReal x1374=((169.0)*cj0*cj1*r01);
IkReal x1375=((2000.0)*cj0*cj1*cj4*py);
CheckValue<IkReal> x1376=IKPowWithIntegerCheck(IKsign(((((169.0)*cj4))+(((212.0)*cj3*cj4)))),-1);
if(!x1376.valid){
continue;
}
CheckValue<IkReal> x1377 = IKatan2WithCheck(IkReal(((((-1.0)*cj3*x1373))+(((-1.0)*cj3*x1375))+((sj3*x1369*x1370))+((cj3*x1369*x1372))+(((-1.0)*sj3*x1374))+(((-1.0)*sj3*x1371)))),IkReal(((((212.0)*cj0*cj1*r01))+(((-212.0)*r00*x1369))+((sj3*x1369*x1372))+(((-1.0)*sj3*x1375))+(((-1.0)*sj3*x1373))+(((212.0)*r02*sj1))+((cj3*x1371))+((cj3*x1374))+(((-1.0)*cj3*x1369*x1370)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1377.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1376.value)))+(x1377.value));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1378=IKcos(j2);
IkReal x1379=IKsin(j2);
IkReal x1380=py*py;
IkReal x1381=pz*pz;
IkReal x1382=px*px;
IkReal x1383=(py*sj1);
IkReal x1384=((2.0)*r01);
IkReal x1385=(px*sj0);
IkReal x1386=(cj0*pz);
IkReal x1387=(r00*sj1);
IkReal x1388=((0.212)*r01);
IkReal x1389=((1.0)*sj1);
IkReal x1390=(cj0*px);
IkReal x1391=((1.0)*cj3);
IkReal x1392=((1.0)*cj1);
IkReal x1393=(px*r01);
IkReal x1394=((0.212)*r00);
IkReal x1395=(r01*sj0);
IkReal x1396=(r00*sj0);
IkReal x1397=(cj1*r02);
IkReal x1398=((2.0)*pz);
IkReal x1399=((1.0)*sj0);
IkReal x1400=(cj1*py);
IkReal x1401=((2.0)*r00);
IkReal x1402=(r02*sj1);
IkReal x1403=(cj0*r01);
IkReal x1404=(pz*sj1);
IkReal x1405=((0.212)*r02);
IkReal x1406=((0.0845)*cj3);
IkReal x1407=((0.01837625)*cj3);
IkReal x1408=((0.00409575)*sj3);
IkReal x1409=(cj4*x1379);
IkReal x1410=((0.0845)*x1378);
IkReal x1411=(cj1*x1403);
IkReal x1412=((0.106)*x1378);
IkReal x1413=(sj4*x1379);
IkReal x1414=(cj4*x1378);
IkReal x1415=(r02*x1381);
IkReal x1416=(x1382*x1403);
IkReal x1417=((0.0845)*sj3*x1379);
evalcond[0]=((((-1.0)*x1392*x1396))+((sj3*x1409))+(((-1.0)*x1391*x1414))+x1411+x1402);
evalcond[1]=(x1397+(((-1.0)*x1389*x1403))+(((-1.0)*sj3*x1414))+((sj0*x1387))+(((-1.0)*x1391*x1409)));
evalcond[2]=((((-1.0)*x1385*x1392))+((x1379*x1406))+(((0.106)*x1379))+((cj0*x1400))+x1404+((sj3*x1410)));
evalcond[3]=((-0.106)+(((-1.0)*x1412))+(((-1.0)*cj0*x1383))+(((-1.0)*x1378*x1406))+((cj1*pz))+((sj1*x1385))+x1417);
evalcond[4]=((((-1.0)*x1392*x1393))+(((-1.0)*r02*x1389*x1390))+(((-1.0)*sj3*sj4*x1410))+((x1395*x1404))+((r00*x1400))+(((-0.106)*x1413))+(((-1.0)*x1406*x1413))+((x1386*x1387))+(((-1.0)*r02*x1383*x1399)));
evalcond[5]=((((-1.0)*pz*x1392*x1395))+(((-1.0)*x1389*x1393))+(((0.106)*cj0*r00))+(((-1.0)*r00*x1386*x1392))+((x1390*x1397))+(((-1.0)*sj4*x1378*x1406))+(((0.106)*x1395))+((py*sj0*x1397))+(((0.0845)*sj3*x1413))+((r00*x1383))+(((-1.0)*sj4*x1412)));
evalcond[6]=(((x1382*x1397))+((px*x1394))+((sj0*x1380*x1387))+((sj0*x1381*x1387))+(((-1.0)*x1382*x1387*x1399))+(((2.0)*r02*x1383*x1386))+(((-1.0)*x1389*x1416))+(((0.011236)*sj1*x1403))+(((-0.011236)*x1397))+((x1383*x1390*x1401))+(((-1.0)*x1381*x1389*x1403))+(((-0.017914)*x1409))+((pz*x1405))+((py*x1388))+(((-1.0)*cj1*px*r00*x1398))+(((-1.0)*pz*x1384*x1400))+(((-1.0)*x1383*x1384*x1385))+(((-1.0)*x1392*x1415))+(((-1.0)*x1407*x1409))+((sj1*x1380*x1403))+(((-1.0)*x1385*x1398*x1402))+(((-0.011236)*sj0*x1387))+((x1408*x1414))+((x1380*x1397)));
evalcond[7]=((((-1.0)*pz*x1383*x1384))+(((-1.0)*x1381*x1392*x1396))+(((0.011236)*x1402))+(((-1.0)*x1380*x1392*x1403))+(((0.011236)*x1411))+((x1384*x1385*x1400))+(((-1.0)*x1389*x1415))+((x1385*x1397*x1398))+(((-1.0)*x1380*x1392*x1396))+(((-1.0)*x1407*x1414))+(((-1.0)*px*x1387*x1398))+(((-2.0)*py*x1386*x1397))+((cj1*x1382*x1396))+(((-0.011236)*cj1*x1396))+((pz*sj0*x1394))+(((-1.0)*x1385*x1405))+(((-1.0)*x1390*x1400*x1401))+((x1382*x1411))+((cj0*py*x1405))+((x1382*x1402))+(((-1.0)*x1386*x1388))+((x1380*x1402))+((x1381*x1411))+(((-0.017914)*x1414))+(((-1.0)*x1408*x1409)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1418=(cj3*r02);
IkReal x1419=((1.0)*sj1);
IkReal x1420=(r02*sj3);
IkReal x1421=(r00*sj0*sj3);
IkReal x1422=(cj0*cj3*r01);
IkReal x1423=(cj3*r00*sj0);
IkReal x1424=((1.0)*cj0*r01*sj3);
CheckValue<IkReal> x1425 = IKatan2WithCheck(IkReal((((sj1*x1423))+((cj1*x1421))+(((-1.0)*x1419*x1420))+(((-1.0)*x1419*x1422))+((cj1*x1418))+(((-1.0)*cj1*x1424)))),IkReal((((sj1*x1421))+((cj1*x1420))+((cj1*x1422))+(((-1.0)*cj0*r01*sj3*x1419))+(((-1.0)*cj1*x1423))+((sj1*x1418)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1425.valid){
continue;
}
CheckValue<IkReal> x1426=IKPowWithIntegerCheck(IKsign(cj4),-1);
if(!x1426.valid){
continue;
}
j2array[0]=((-1.5707963267949)+(x1425.value)+(((1.5707963267949)*(x1426.value))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1427=IKcos(j2);
IkReal x1428=IKsin(j2);
IkReal x1429=py*py;
IkReal x1430=pz*pz;
IkReal x1431=px*px;
IkReal x1432=(py*sj1);
IkReal x1433=((2.0)*r01);
IkReal x1434=(px*sj0);
IkReal x1435=(cj0*pz);
IkReal x1436=(r00*sj1);
IkReal x1437=((0.212)*r01);
IkReal x1438=((1.0)*sj1);
IkReal x1439=(cj0*px);
IkReal x1440=((1.0)*cj3);
IkReal x1441=((1.0)*cj1);
IkReal x1442=(px*r01);
IkReal x1443=((0.212)*r00);
IkReal x1444=(r01*sj0);
IkReal x1445=(r00*sj0);
IkReal x1446=(cj1*r02);
IkReal x1447=((2.0)*pz);
IkReal x1448=((1.0)*sj0);
IkReal x1449=(cj1*py);
IkReal x1450=((2.0)*r00);
IkReal x1451=(r02*sj1);
IkReal x1452=(cj0*r01);
IkReal x1453=(pz*sj1);
IkReal x1454=((0.212)*r02);
IkReal x1455=((0.0845)*cj3);
IkReal x1456=((0.01837625)*cj3);
IkReal x1457=((0.00409575)*sj3);
IkReal x1458=(cj4*x1428);
IkReal x1459=((0.0845)*x1427);
IkReal x1460=(cj1*x1452);
IkReal x1461=((0.106)*x1427);
IkReal x1462=(sj4*x1428);
IkReal x1463=(cj4*x1427);
IkReal x1464=(r02*x1430);
IkReal x1465=(x1431*x1452);
IkReal x1466=((0.0845)*sj3*x1428);
evalcond[0]=(((sj3*x1458))+(((-1.0)*x1441*x1445))+(((-1.0)*x1440*x1463))+x1460+x1451);
evalcond[1]=((((-1.0)*sj3*x1463))+(((-1.0)*x1440*x1458))+((sj0*x1436))+x1446+(((-1.0)*x1438*x1452)));
evalcond[2]=(((x1428*x1455))+((sj3*x1459))+(((0.106)*x1428))+(((-1.0)*x1434*x1441))+x1453+((cj0*x1449)));
evalcond[3]=((-0.106)+(((-1.0)*x1461))+((cj1*pz))+(((-1.0)*cj0*x1432))+((sj1*x1434))+x1466+(((-1.0)*x1427*x1455)));
evalcond[4]=(((x1435*x1436))+(((-1.0)*sj3*sj4*x1459))+(((-1.0)*x1441*x1442))+(((-1.0)*r02*x1438*x1439))+(((-0.106)*x1462))+(((-1.0)*x1455*x1462))+(((-1.0)*r02*x1432*x1448))+((r00*x1449))+((x1444*x1453)));
evalcond[5]=((((-1.0)*sj4*x1427*x1455))+(((-1.0)*sj4*x1461))+((py*sj0*x1446))+((x1439*x1446))+(((0.106)*cj0*r00))+(((-1.0)*x1438*x1442))+((r00*x1432))+(((0.0845)*sj3*x1462))+(((0.106)*x1444))+(((-1.0)*pz*x1441*x1444))+(((-1.0)*r00*x1435*x1441)));
evalcond[6]=(((sj1*x1429*x1452))+(((-1.0)*pz*x1433*x1449))+((sj0*x1430*x1436))+(((-0.017914)*x1458))+(((-1.0)*cj1*px*r00*x1447))+((sj0*x1429*x1436))+(((2.0)*r02*x1432*x1435))+((pz*x1454))+(((0.011236)*sj1*x1452))+((py*x1437))+((x1431*x1446))+(((-1.0)*x1430*x1438*x1452))+(((-0.011236)*sj0*x1436))+(((-1.0)*x1434*x1447*x1451))+(((-1.0)*x1431*x1436*x1448))+((x1457*x1463))+(((-1.0)*x1441*x1464))+(((-1.0)*x1438*x1465))+((x1429*x1446))+((px*x1443))+(((-1.0)*x1456*x1458))+(((-1.0)*x1432*x1433*x1434))+(((-0.011236)*x1446))+((x1432*x1439*x1450)));
evalcond[7]=((((-0.011236)*cj1*x1445))+(((-0.017914)*x1463))+(((-1.0)*x1457*x1458))+(((-2.0)*py*x1435*x1446))+(((-1.0)*x1434*x1454))+(((0.011236)*x1451))+((pz*sj0*x1443))+((x1431*x1451))+(((-1.0)*x1430*x1441*x1445))+(((-1.0)*x1435*x1437))+((x1431*x1460))+(((-1.0)*x1456*x1463))+(((-1.0)*px*x1436*x1447))+(((-1.0)*pz*x1432*x1433))+(((0.011236)*x1460))+(((-1.0)*x1429*x1441*x1445))+((x1434*x1446*x1447))+(((-1.0)*x1439*x1449*x1450))+((x1433*x1434*x1449))+((cj0*py*x1454))+(((-1.0)*x1438*x1464))+(((-1.0)*x1429*x1441*x1452))+((x1429*x1451))+((x1430*x1460))+((cj1*x1431*x1445)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
    }
}
}

}

}
}
return solutions.GetNumSolutions()>0;
}
static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "fa5d9f43e181a6d419c0930835cf5fba"; }

IKFAST_API const char* GetIkFastVersion() { return "0x10000049"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
