// rokubimini
#include <rokubimini_ethercat/setup/RokubiminiEthercat.hpp>

namespace rokubimini
{
namespace ethercat
{
namespace setup
{
void RokubiminiEthercat::fromFile(const YAML::Node& yamlNode, const std::string& setupFile)
{
  Rokubimini::fromFile(yamlNode, setupFile);
  if (yamlNode["ethercat_bus"])
  {
    ethercatBus_ = yamlNode["ethercat_bus"].as<std::string>();
  }
  if (yamlNode["ethercat_address"])
  {
    const auto ethercat_address = yamlNode["ethercat_address"].as<uint32_t>();
    if (ethercat_address == 0)
    {
      throw ros::Exception("The EtherCAT address is 0.");
    }
    ethercatAddress_ = ethercat_address;
  }
}

}  // namespace setup
}  // namespace ethercat
}  // namespace rokubimini
