/*
Copyright (c) 2010-2016, Mathieu Labbe - IntRoLab - Universite de Sherbrooke
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Universite de Sherbrooke nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef RTABMAP_POSTPROCESSINGDIALOG_H_
#define RTABMAP_POSTPROCESSINGDIALOG_H_

#include "rtabmap/gui/RtabmapGuiExp.h" // DLL export/import defines

#include <QDialog>
#include <QtCore/QSettings>

#include <rtabmap/core/Optimizer.h>

class Ui_PostProcessingDialog;
class QAbstractButton;

namespace rtabmap {

class RTABMAPGUI_EXP PostProcessingDialog : public QDialog
{
	Q_OBJECT

public:
	PostProcessingDialog(QWidget * parent = 0);

	virtual ~PostProcessingDialog();

	void saveSettings(QSettings & settings, const QString & group = "") const;
	void loadSettings(QSettings & settings, const QString & group = "");

	//getters
	bool isDetectMoreLoopClosures() const;
	double clusterRadius() const;
	double clusterAngle() const;
	int iterations() const;
	bool intraSession() const;
	bool interSession() const;
	bool isRefineNeighborLinks() const;
	bool isRefineLoopClosureLinks() const;
	bool isSBA() const;
	int sbaIterations() const;
	double sbaVariance() const;
	Optimizer::Type sbaType() const;
	bool sbaRematchFeatures() const;

	//setters
	void setDetectMoreLoopClosures(bool on);
	void setClusterRadius(double radius);
	void setClusterAngle(double angle);
	void setIterations(int iterations);
	void setIntraSession(bool enabled);
	void setInterSession(bool enabled);
	void setRefineNeighborLinks(bool on);
	void setRefineLoopClosureLinks(bool on);
	void setSBA(bool on);
	void setSBAIterations(int iterations);
	void setSBAVariance(double variance);
	void setSBAType(Optimizer::Type type);
	void setSBARematchFeatures(bool value);

Q_SIGNALS:
	void configChanged();

public Q_SLOTS:
	void closeDialog ( QAbstractButton * button );
	void restoreDefaults();

private Q_SLOTS:
	void updateVisibility();
	void updateButtonBox();

private:
	bool validateForm();

private:
	Ui_PostProcessingDialog * _ui;
};

}

#endif /* POSTPROCESSINGDIALOG_H_ */
