/*
 * Copyright (c) 2008, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Willow Garage, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef OGRE_TOOLS_STL_LOADER_H
#define OGRE_TOOLS_STL_LOADER_H

#include <OgreVector3.h>
#include <OgreMesh.h>

#include <vector>
#include <stdint.h>

namespace ogre_tools
{
// TODO: remove in noetic
// Please use assimp or rviz::loadMeshFromResource directly
class [[deprecated]] STLLoader
{
public:
  STLLoader();
  ~STLLoader();

  bool load(const std::string& path);
  bool load(uint8_t * buffer, const size_t num_bytes, const std::string& origin);

  Ogre::MeshPtr toMesh(const std::string& name);

  struct Triangle
  {
    Ogre::Vector3 vertices_[3];
    Ogre::Vector3 normal_;
  };

  typedef std::vector<Triangle> V_Triangle;
  V_Triangle triangles_;

protected:
  //! Load a binary STL file
  bool load_binary(uint8_t * buffer);
};

} // namespace ogre_tools

#endif // OGRE_TOOLS_STL_LOADER_H
