    std::map<std::string, sick_scan::SickLocColaTelegramMsg> emulator_responses = { // emulator responses to driver requests
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000afb9afbdb3b0291eb3b041d2000008000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b0287000202780002027e000200020002000200020002028902950002029d000202a9000202de02ca029f029702a102b202bf02b402a302c302b102aa028502ca02b802ff031103b70462049f048704ab04a804a10493049a049c0496045c043b040903f2040303dc03d403c90399036f037903840385038503a503cb03f40431048104b304b304520444044504b7049c043003da03c003ae03b503c603ff0411041f047f04890485049504e604ee04f904d504cf04e604de04d904cc04dc04d804e904c004ce04ca04d704d104c004b20429035602d602d702bb02c002b302d202c002c602d102c002c202cc02ab02c102a602d802c702d102d502d102cf02ca02d402e702e602d002d602d902dc02ef02e602e502e002ef02e902ed02fc02ef02f5030802f302f202f302fe02fe030f02f8030d030403070307031603070326030e0312032a0320031b0322031f0314033a032d032b03200330033d033e03440343035b0344033d034b03520341034c034b035a03440353034f0363035f039a043c04fe05110521051b051f0520053005470542052805340542055c053c056205480555055b055b0566056c05620566056e057a05880574057a059205a40583059c059b05b805ab05a005b905d005ce05c505c505d605d205d605db05f305fc0602060d061b05f806270625063406300633064e0655065f06580661066c067a067d06870687069e069c06a506ae06b306c206c106dc06ea06f806e006e606eb06d006bb06a406b706a9069d069f06830681066c066f066e066b065a066606490663063b0641061106230627061805f606220602060b060c061f060405ff05e905f805ea05e605d305d505dc05cf05ce05bc05bf05aa05b505b305b305ab059a058b05b00595057e058c057205920587057a0582057f05690574055e055e0567055b055d056d055b05570552055c054c0565055805490549055505280549052b05420522035a02f4028701370129012a0128011c0134011e011a012d010701270116011301060102011200ff00fa01190104012600fe0103010300f3011600ee00fc00fe010c010b00fe01180108011101000110014001e6025502c7023604e2050705000511050c051404f00503051c05150502051e051005080513051405260511050f050c0502051f05180515051c0521052d051c051d0524052105360528050c05370537051f0530053105410528055105390544054c0544054305300553053a053304ba03fd036b02fb02bd02cb032c03dd0451051a0548055b0566055d050e047c040503d903c403ed042404a904e504eb04ba03d3033503180339032503a803de038e0342030e031402f8030102f703100300026a02620266026b0297028e02ab02ab02c502da02db02ca02c702d102d702d202e402e602f4032a03b2049a0672067c06870694068e068a06bd06b606c006d7076c07ff07ef073406dc07260842084b0849085807f2075b07540817089408a008b5085507ba079f08870901090508dd083507ef08010930096f09540891083c089309c209c208ef0899087b08b809d10943090608d908e909f909880947092f097d09f109d109a009a50a4e0a1f09fb0a130aa70a760a5b0abf0aff0acb0ae00b4e0b4b0002040103fa03f803f203f303ee03e103f103e503ea03f203f403ee03e903da03e403be03d203d503c903cd03e803bb03c003c203c703be03ba03b603c703ad03b803bf03b003b303aa03b103a103a603a9039a03ab03ac03a203b403b4036e03b203bb03af03a603ae03a903a903b003b20397039c038e036f038f0387037d037f038103890396038a0394039103950397039103940387037e037e036f036f038e037a038803830378038403890389038d038b038e0380038f0392038803870393038e039a037b038a038a038f037e03980393038d038a035e03ad039d03cc03fd03fb03660314030a036e02ca01e30190018401a101f802a202d602ba02c502c302bc0286028c026a02780269025d0256024b024d02440240022e021e022b0226021f020e01e101de0228025102380239023902430241023e023a023f023a0238023d02330238025802500250024d025a02580256024b02610257024a0249024002440253023702590216021301dc01d9019d01c201e401c501ea01e801d8019101a001bf022a0237021401b40197018b019101aa0236022c01ff0198017901850167013c011000ed00d500a8009f00aa00a200a1008f008b008f52535349313f80000000000000fff922300d05032b1e4100001d7700001ebc0000000000000000000000001d471db200001cfc00001cf3000024512bee323c333d32a732f7323932fd33d73219331e33583571320c32fe3017386b3b5335f5329c33cf31cc31ea324232f63299329432272f2b276926e526e624c224c724f723b2257c2a14295b2863290f2ee9351239633cd83e453ba239473aa440473eb63ee037db397e3a0b2e622244222922ca28e02cdb2fb233ab3354345c33d93628341833a5332734ed358e3429345634a0351c34463447336c360b34d735043413345d35ce36af3f4c3f9131673154347a3476350d33f0348f346b33cc352834d3348f36c634fa36d6335c346d3474347e34cf357235353529344d3480363f3664367e360b34d235aa35d636363563358935773491359a351e347735e8360735dd356935743470364d34e0352d354b353b345e359a33c7352a358933f734de356e34be34e23664345034d435ba360435e93513353a35093512341d359f35e8357134dd368f357d35a134e535e7352d357a341533e337223f89373735e434c63548357c35b5349033cc341d35c234e8343b32d83528339534b7341433e734153378334b3401341833c8339e334a3496345c334e32de3497338533f0328c335f343032c431be321532bb330132993359331b32f0321931d531f5316f2d252e173150321231753202325d30f130f4306c312c30d3312d30df311f311231553050307f303b307f30e630fa31232fea2fa8301c302a2cdd2a982b952c162d312c202c472cfd2c9d2da12d1f2da62d842d612d4c2dc12d1d2e422c7b2d5a2d3e2f712e202df02ea8305f2dfa2f762f372eae2d212e702e5c2f092e212e802ee02fe72fc62ee62ea12eda2f562f6130122f502fab2f9a2fbd30b131372f32303b3140308b31cd301530f43175311e30fc324531463267321331ba32073214315b322d3230323c31db32ed318a324d32a4326d31be339531e3332030ef31aa51cd531b4d762abc26432774291a292728142ac52c692c292e552c8c2dc72dd52ed62ede2e802f8d300c2ee92fcb2e7230bc3099316b33893195323a30b9303a2fa42efd2f7b2d9c2e122d4f2dd72c9e37fe455a4e164f3499013215327d3391338633e4336634f233c3327f32e933fe3256332733d73344339332ef33ef33f93400346332f0332a33b132c8329a326332f532f8330a33ad32673293337f316c3126328631bf320530dc32823093320531e331da32a7324a3270308f31d232383a4947a948e942a73c213f6946674a8943f434b03227310c30d4319735943df13d173a18386d3a573f973d8039a038f43aaa3e7b36202e1a29f933723683374b35f930a02e322a712920269527382630279e26182f21315d2c3d25c327c525d626952bff30213131323c330833093315336f32f2331b33dc389a443a461e2d8f2c6a2b142b012bb42c722a062ae32acc2f0430842d492ebc319530e9346a2cdf2d882caf2e1430052ff0311230662c912be02b9930a03286355a2f892aa92a9f2d532fad2b1231de2ba72a382ac22f8c2dd8328428d828f12dfa27992ad931e228a12b2126b328bb31ae2c6a29b4270d29fe329f2da026ad273f2ed72b6c26a527722daa2892264129212c6a255f26da2e2c27ba29df00001d042d6b34fb36053549353e367c34b73547347d34553428341c346034d5343a369734c834c735b933fa291e250d242822db235e241c22ab2a223356362a356d34c135e835693621356334bb2abd2455255224d52473251b259a2f042cfc8afc8cb98c6e8c4a8c868c448c398c79892033fd2847271427b0263b264a273727372a8335333680374436a6366c35f8365b36dc366135722edf283728d428c32763283f279a27cf2a7c334b36a336b636473662362c3748364436023671366235a13619355337bb36b836b63626376a355c35ce366e36da2aef8672770b389c36a833e535a22ae92a1226112c913445305d28b82ca832062d6e2d572f022daa2d582cf52ecf2ddf2efe2e3a2ef62ee62eec2f6b2ed82ebc2e8f2fc530c43437363d367931f42cc42b7033be33ce35dc35bf3600354935083592364135e0366a36b63666375b3776354a359435b9361035b33529356935dc34263478354235cf36553530329831db2ede2f3d2b992b8f29ed29c62ab32c7131fc339935b833b730762dff33e63a753bf839b131822d3827602a3135a137f83866338732e4318d2f2a3397350632be30082936246f23cc2509273425b1262c26ca26720000000000000000000107b2010100320e000a35480000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000afc5afc9b3bc5e2db3bc76d3000008000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b026800020002028700020002027c000200020002000200020002000202b102c90002000202dc02b002a702da02ba02a20298029b02c1027f02a6029b028f029202b902f4032103bc047d04ab04ae0496049204ae04900496048a049f0471043104200408040203d703d703d00392034d038d03780393038503a403c203fa044a048804ac04c9046a0442045504b80494042103ae03c103aa03b403da04170422043d048004b4047a049304dc04e604e004e504da04d104de04e204d304d304b904da04c504db04ce04d104ce04c204ad0420036802d402c402c502cf02b502a702bd02b202b902bd02c002c402a402b402c002c002cd02ce02cc02d002c402e402db02d402e002e102da02dc02e302eb02e202d602fc02e502f002ee02e902f70306030502fe02f302f602fb030003040322030202f70311030c030d032603240310031e031a031003210333032c0330031f032a031b032a031f033a0337033e03390344033f034e034c03380352035d03520349035d0360036d035c03650391044104fe05100530051a0533053305240530054005450541053a0551053605490549055d055d056005820561056b055905620589058d05740596057e0590059705a305a305b105a705b005b305b4059f05c305cb05c205d505de05f105fa060706050608060a061706210625063606430640064406510653066a06580675067e0658067106850697069106ac06b106ca06be06d006cc06e306e406e506db06d106c806bb06ba06af06a206ad068a067a068b067f067d066e0668065c0650063f06510623063a065106250634061a061f061b061106030623060f060205f905f605d805e305de05d705d005c605c905c505cf05bf05c505b005ae05b3059e058a05a905a40597058e0583059b05850582057405750585057f057a05720569055a0560056105560557055e054d056f05480559054a0551053f054b0524054105250549053f054f052e052b051f051104e2032e02c8022b010e0108011c0130012e011301160116011e01180106011200f70122011b011e0103011d010d010901050116011a010a010b0115011d010501080102011201080102012301c8022f0284031204d904f7050805030511050205090512050a050b051905010507052504f9050b0509050a051d050a05230529051e05100525051c0521051a0538052b0529051b05290535052d0527053f05360547054d053a0544054a054e05490545053c053b052e04ca04050367030902bf02c8033b03ee04a005150556055f0561055105190486041503e003c603ea0431049b04dc04f304cb03c5032f0311033f033203a903df039c033803330315030c02f4030302ff02f802770257025e025602a302ab02b102d002b502c402b302d702d202c802e702e402e502e302db033003bf049b066e0670068006880690068e06aa06be06ce06c70763080807ed073106e40735083d083a0855087807ef076f073c080008a208a608b7085a07bf07b5087308fb090d08e7082707e707e909320961095a08800840089009bf09a408e9089e087b08ce09d6092f090708dc08e40a16098c0949094d09a70a0409ba09ae09a70a5b0a1e09fe0a060aa40a710a5a0acd0af20aca0adf0b380b2c0002040903fb03ee040303f103f503ea03f403ea03f303f103dc03dd03d403e703d603d303cb03e003d903e103c803c503d403b903c803ae03c003a603d403b503ae03b603a503b303b103c703ae03a003ac03b203a703b1039103980398036603b403b303a703b4039f03a903a903a403a8039303a70385038b03970396038203680379038103990398038403a003920397039403a003810384038b0387038d038503930385037d037e037e0385038a03860386038903880390038e038a038a038e03910391038b0388038603970383038c03940396038a035603a7039603d203fc03fa0381030e033f036402cf01d601720192019d01ff025c02e602d802bf02a202bd029c02710282027c02700284024f0259023f0234023e022902200233022d0220020401c601cb0223022802340233023c02420242022c0239023b023a0247023f02520262024c023f0263025c024d024c0256025d025e023e024f02680244025902420257023d0237022e01d801c1018a01cc01ea01ea01e601e001e701a501a301c20219023f021801b70194018c01a001d60217023601d5019501790164016e0134011900c300e300ac00a7009d00aa00a500b600b0009052535349313f80000000000000fff922300d05032b1cb6000000001d57000000001d9900000000000000000000000000001d9c1d2e0000000024202d0b31d9302431993354343c3430326f35d43378342134ee350532ef30a936be3b3e33a93240321c33073306319b335b32de339c31a32e9627e3257a256b252424e0240b249c261f2ba7285f28eb283a2eac34b33a883c313cb93b383a44381b3e8b3edf3d3037fc3a813b4c30ac2381229f239d28d52bd32f03328933263207349e36ce34b53449347c342d3497357b345333f8350534a2366a343b358d3413349f348834a9357336c73f9a3e0b31af31e3338233ae3507368234c5357d34f0350a3516351d3700362b350d34c23439346c345234863555340334cf355a34c93531364135ff359b355235b936ec347f35b43542355935ee3530345f347a34ee35b4359a357f35833562337a35c6369034c43570351233e9340f357734be3544362834db33ef348c347735e1352636f335df36e634ec35e5358f364835bf35e834b1351236c83520346a351735e0347f347233ba345933a337ac3ede377e3615343035da343b3443358834b9344033f4344034ca33a8354e348a34a133ac339833ea322033cd3392350e34903309330a34b233363471340c33dd331633b332df338e3375335833aa34e7331b32f33378331132a431b631e43160322032072df22cbe31a331dc318c312c316a3177312231003058317730c130e932f731ed316430b6313d2ff2302f2fe7308c306f307b302030c52fc02d452bd72c3a2c072c332c752cb12bf82da52de92c992d152c8d2d592d852dbd2e152e912d0f2e592dc22c7a2e202d372e902e7e2e632efc2f2b2d5d2dd42e802ecf2e912ff92ede2f002fe130292ff92ec22f382e822f152ee72fda2fd22fa8305c314c2fa52fd8306d308f30f12fc630a53118318a317330d8312931093108315831f4321731d23289325a321c32a630f732bb325b32ef324a32f6324c3418329d33cd324732b631b73377336a334a32fc34a053ed504a466d27be293728d028232aa02d0a2d592d1b2d1e2dca2e902e712fe62e382f1b2f2d30a02f9930a430e2312330c2308e30d5308a2f612f012fad2f242f2a2e892e7f2e742ef141fe4a944f6e4d3631e73347331833fe3358341b3395330033c8338932bd342333f63277353e343034a133c8332533cd3283325d32ea33c532af332b33023336324e32c132ed32ae31fd318c3207328b312931b3312430f8319c31d3321c321e31cf320f320d31dd325838d74701492241243c103fcd4585492b3da9350231ae311e3108321c34b33cde3ba538e538a53aec3de23efd3a5b381239a63fc736262e60298032c135773745357431d92d2e2a9d285c278a25ee26c2244f25902fe331cc2d49250b2636257e24b92c3e31533356321a32c8338c320232a632c93366351a38cc433c46772dbe2d162bc52bb62ba12c102b202a872a5c2f8631872cec2ee731fc2fdf340b2d102e5a2c1e2c68304d2efb328731d22b992b9b2bd630453235344430602afd2a492cd230532b7c32f92b862a7a2a8430222d4132a7291e2a9b2e1f27be2b05315627f62c2e26a028e131c72b0b29b4271928fd311a2ca8276a26ae2efa2a5c266127962eae28c4266829812c13259e272b2df028382be900001dcd2d83355a34af353834d935db34b034f534063425358535063542345d353934e935ec341d346732b52a9a240f2272247622a624b0233a2b2d32b7357935f0355c3674358c35cb341633fb2ac024a123c823fc23c625dc2744306329768b468ca18c388ca78bfb8c558c428bf68856336f27c7270c264725db25cd270628a62b8a354e3619364337b13599367a36753683353f35a82eb427d5279a2725283f2706277627fc2a9b33b636b436af36f1371636bd3716362435f2367a369e362e3646361436763656370b3566372336a2360d361736c5297d865075d637e5368033ee33b92b2627a0265e2c5e34eb31ff28452cb3321830d32cc72dcf2e462ec32cc02da62efd2dd62e062e452ce12f612e6c2f662faa2eb52fe130383395362436b2328a2e202c703411365636523631365a3577355336f236863691363b357a367f351e3459356036f6346a353b368e3686359534d3343636343539340d364233cf339f30202feb2d9d2b2a2c2e2b1b2acb28d52bb3300a33d1360b32862fde2db134613bdb3b45395131892d14276629a032d23ab337ed360f32ca314130c0331035ea3322320c283b22f423eb25ba2663262a24c32499267a0000000000000000000107b2010100320f000728080000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000afd9afddb3d0b6e1b3d0cf70000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b026d02660002026f0002027b0002028b00020002000202af02b002b80002000202c9000202d002cb02c002b402d902cc02c902ab029e029f02b0029b02ad02d0029f02ce033003cb0479048f04a004a1049904a004aa049e04a20494046604350423041303ef03e103c803b60354036d038a0379039d03a803a703bf03f6043d048204c004bd046c0443045704a4049d041b03da03b703b903ab03da042504080428047004a8045d049104d904e304ca04d904dc04e904d904de04d104d004d404d704d804c604d404c104c504c404c20405036902e702ca02be02c302c102cb02c202d402b102bf02ad02be02c502b302c102bd02c302cc02d702cf02e302d502d802dc02d302d902dd02e002de02ee02e702e102ea02ec02e502f302eb02ef02fe02f402f702ec030602f602f302f80304030302fa03150322031b0316030f030e0315032a03200321032703240329032c033b032d0333033603440342033e03460342033f034c034f0331034c035e034e03510362035a03500355035c039d044004f705100515051d05240534052a054c0538053b053d05480550053b0541055405570551056e056b055a0576057c058605720571058a0598059d057b05a0059b05b205b505b405b605af05c905c405d305ce05e105e205df05df05fd05f90602061605fa0618061c06340639063a062c0629063f0652066d0666068406690685069f06950691069e06ac06b006b406b906cd06da06c406f306d806ed06d406d906b606a706b406b50692068506950683066b0681068006760672066606550653063106310633063a062a062c06140614061c05fb060105fa060105ff05fa05de05e105f605e105c705c605c005b905be05c105af05bc05b7059c05a4059e057a059c05a30595058305a005890577058b056c0592058605630554055a0568055805520551055e055c057605640565055a052f053b05490551054d054805330535053705340535053005320520052b05290529052605270521051c050e04f504f5035302f6027f0153012a012a012a012f01260132012801310123010e011b011c01340116011f0124011b0126010d012801150120011f0117011e011e0129011f012f01cc02290287032904cb04f6051104fb051705030518051005260506051b051305010512051e04ff053504ff051a052d0530053205300520052a0529053805390529051b053b054005350533053a052605420543052d052d0544053c0535051104b003f50369030202a602dd033903fa048104eb054d05610553055005140483041703e603c103ed041804ab04df050804c503bb032203210343037303a003d2038b031f033c031e031a02de02e9030a02f4029c0254024d027302ab0284029602d402ad02b902cf02d502ab02cd02e302e302d502f602f8033803b10490066b0678068c068f068b069d06a506b706c106d6074c07e30801072a06ed0720083d0839084a087507ef075e076c082d089e08b308b0085407bc07ab08ab08e5091608ce081507de0802094709660960087d0847086b09b8099908ed0895088e08cf09c50937090308d308fb09fa096e09570937099f09f409ca099309ab0a4f0a1f09ff0a0f0a980a660a680ad50ae40abb0aec0b410b4f000203ff040303fa03fc03fb03f603ec03e703ed03df03ea03e603db03ee03ef03d903e003cf03e203cb03c303be03c503c003c103c403c103af03c903b003ad03ba03b603bd03a903b703ab03a303a403a203af03b403a503ad039f0395037f03bc03b603b503ab03a903a803ac03a903ab037e03a30386037703880387036a039303830397038f038c039b038d0398038b039803880392039303970396039b0398036c0387037e037a0380038c038e038d038d0395038b0381038a03910397039b037a03910390038c0388039b037903910384038c0383036303a6038e03dd03fb04050383031c0345034702df01e501a3019701c101f102b302da02e202a302c002a702ae029902930277027b028302570266024a023d02350226023202270229022b01f501bf01e50211023e022d023a023a023202340234024b023c023d02400244024d02490250024e024d02420255024d025d0256024a0244025f024d0251025a023d0235022c021801f401fa01bb01aa01d001ca01d9020e01e301c201c1017e01ba0225022b02070195019c0177018d01ea0230022f01fb01a8017901890158013700fe00e100d500a900a900ab00b900a4009c00a4009652535349313f80000000000000fff922300d05032b1d171cf400001fb100001de500001cde0000000000001e651e5c1e6d000000001cea000025062c4d3103328c310e31e23214339c34a03452338a34c733fa320634ae32ca362d3aa3346b33be32b1329232f232a732113297327a32a92f15275d2595250e258d245b25162558296b29d628ea2923282e2d6935633af53d573dd83c08385439a33e323ef33d6a398a399d3be52e5823902279225b28642aee30b63384348f32b536e3378534bd3499361534af34bf341434c13468351c350734b0345a34993585346735ab3536352d35ac421e3e09316831df341b34c13497344c34eb3412362a352636f1357e34f7366b3514354934e434b2347a3483343b34dc3518354535ac35a535b735e235f834d535b6363d35b835a93613351b361735f434f835c5354136f434ef364d366d361d351835c33696346e33f6347e34dc359d3595358d342e34aa352734d2352a351d357c34c5358e3513358434f535563592353b35cf35dc355434ef379c35b0349b356534f0347534a73583350a342237123f9337d9367735b935aa34e4344b35493392349b346b348b34343407357234e634423408348d3328338734333359333133163435348533d7330a333b3535335c33cc330032bb330a32d23387325c32e8327632973219324a32c3335a3229324b322b31cb2ef02c9d3232315431e931e3328832f431d931722fe6311630623207313e300c30ff311f3081309530d5310e31303089302031e930aa30f22c972c8f2bc32ccf2d1a2c912c1f2d832dd32cee2d662e572cf42cd52d482d1a2d822e1d2dd32ea12e1f2de52d562e312e232f1a2f322eb62fee2f582f632ebb2eaa2e7f2fb92f842ea02f9a30dd2fff2fa22fd52f7b2f4630322f5f2f9130e6304630ba325c30603007306431132fb530fb31cc30ce322d305c30e732893303328e31db327f32b932c13251324930a331b331d2322f347d334c32c7322d325a324433453367337a335c334b338433b93468338c3336334d33c7337933a333e2341435073422522e52c54c092bc6281e2a602b482bc82c8e2c852d092cde2e782ff72fb02fdd2ee030ee306b302e30a230683146303630fa3079302830602fd32fb72e8a2d072d5940934a3f4dd14bd23282330132c8341e331033ee3358337c32ad352933c333ec348533a8333c3470320434973378328832363227327333e03375336431ac31a8329232e8317f317a31df328e32363365325b328f33c633ad31d031c2329b34903b9e48af497642953ed83ea745d2494040763892324c3123325a3221359a3dc43c2038f339813b7440363e2f3ab737053af44128381c2dcc29d62fe036a5381937a032b12b1229c3274827f92741263324a22472301d32e42bec2575285e26e9249b2d0731de31e331ea34c833ae32ad32cf33ec331b3467388f44cc47b92e2c2ce62bc42bad2c402bb42b592af62b032f5f332d2ee72e6f3207301c35bb2d6e2eef2cb62ce4304f2f5c307730032c162ba72c7e30cb31fe356e2de52c6529f42e3e30e42c35328b2af82a602a8430562db8348a298c2b402dff283d2a95318929262b48274f297c31862c732b3b26a62a6031732d0a264728232f342b11267627692e22298e26c928ff2ba726df28612d6e27f72a1b00001cd82daf3513351835243537358b35f534d435e434cb34e735aa345f33e934e3347e358f3429355c344b2b05246b24bb23b023c623dc24d129893472368a34b2352234fe3695350c35ec34702a7b251823d9231024e524b7268530b828318ba58c958cc78c598c488c428c2f8c3d887534d32828275d27a726a82689287926832b1434cd36f6371335df372b35e7379f367e373d348f2e0c278027382748270629462807285d2afc33af36713697368d36b435b93697375336ab36103586352437c7361b360c36a936e4359837f03662378836ee379a26e4868b75713739369633fc338b2a42275a28562b8433dd2f9d27e02af132dd2c7f2d9e2d4d2fc62dc32eaf2d832d6c2d822e682dff2da72f462e3d2f1a2fc02fd02fe52fdf347c364e35da33582ec62c1b357334be36e8360635c63672366936743533365c362335d935d93550365c35643645366c3769362e3674357b353b35a735d9349a356f357433f133be3229314e2fa02da52a5f2b9629dc29fe2e0831103204368c34992ebd2fa9356e3bc83d753aaa33082ce228892a7232893996380a33b0321b30df2f3734c436303445304228b2235d23e025272627259c2633258926080000000000000000000107b20101003210000c3cd00000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000afe1afe5b3d8da48b3d8f289000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b027102610002027c00020002028800020002000200020002000200020002000202ad029b02e102ca02b302ab02cd02ac02a802c702a002bf029802be02ae02ad028e0293032a03930475049f04a704ab048e04a204980493049704a3048a043b040603e503f903ed03d703c60397037b03850382038f0379039703d603f70439047904b204bc045f0444045704af0492042e03c903b503a503a503c903ec040104210470049d0470048604cf04db04d404e604da04d204ea04d904d904eb04d404e204d604ca04e704c304bb04c604c30411036002db02d302d302cf02d102c102bf02c602c402b502b602d302d102bf02c002d402b202c102d902d702d502d302cd02d302d702dd02e602fb02d802ff030402fc02e402ff02ee02ed0307030b030102fc030f02fd02fd030e0307031b030c031a030f02ef02ff031a0335031f031b03110312032f032203300323033c031c032003340328033d033603350337033c03450348033603550352034b03490351035703470349035c035303670395043504f605160520052105250533052a05210546053b0532053d053f054c054405400551055a0559056005720565056705720576057c0569058a05940585058905b405ae05a005a605bc05b805bf05d105da05dd05eb05db05e105f905fc061005fc060d06160609062206140609062f0646062a0654065b0660066b0670068a0677067b067a069806b006bc06a306c106c406d806cd06df06ed06ef06c306d306ca06c006c306ac06a2069d06890689068a0683067c066706750666066406550654063c0638062006250628061c06270626060f061105ff05f6060405ed05ef05f305f905ea05cc05d805c505c605bc05b005ad05b805b005a605a605bd05a805ab0595059305800567057905890570057c057b056c058b056e056b056e0572055f0560056305560548054b055605570567054405400534053e0548053e053f05450537054f053c05350533053e05340520052e052f052605220516051c051905080506051b050004ea033b02d9023e01460117013c01360138011f0135012c011d0124011c012b012801240128012801290127011d011a01230136012a012301180133011f013401700211026202df04d004ed04f6050004f4050e050f0511050e0507050f0515051a051c0514051b05120514050e052a0513051e0533051205190514052405180537052a052c0543051305260555054c054f053a05340545053a052a04b204150374030402b302c2033403f1045304fc052d053e055f055005130494040603da03c303f3042d04a304d204f304a003c1033b031e03330349038f03d3038e0334031d0327030c02e402fe032003160275025d0264025d02a302b402b102db02c702b802c602d402da02cb02ce02ef02e202ee02e4031d03ba04a2064f0678068c0689069d06b206b306ab06c206c8074907f107f3073106ea073108370847084d086a07ce07670736082808b308b508ac086107ae07be087908eb090d08dd082c07e007f4091209750969088f084808a509bc099908dd089b087808c709d6094708f808d108f609d70994094f0930096f09f009ba09aa09b90a520a1b0a0f0a0c0a7d0a6e0a5a0abe0b030ad60aff0b4f0b42000203e403f103fb03f7040403ef03f503f803e503e803e903e103e703db03d103da03cb03d103d303e703b703c903d103c103bb03c603c403ba03c303c603ae03a603b103b503b503b303a703a9038903b203b003a6039803a003a10399037b03ab03b503aa03af03a203ab03a303ae03b2039f03a6039903a1038e03870373038f037e0387038b038a03930389037e039a039a03960370037e03700383037c037f0384039a0373039603840388039a0384037d038e0390038a0394038c038e0392038c03930382038603800386039a038f0386039c038e035603ab038703db03f703ea036102f90318036802bc01d6019b018901a301e4027902cc02c602c302aa02a0029b02850297028a02660266025d024e02520229024e02130218022a022b022c020a01cf01ea02180227023c023c0237023f023c0234023c024502480243024a024602510266023b0245024c025d024602560252025102500259025e0255025b02500236023a0230022301e201a301af01a401fd01ef01da01e801bf01bb01a501ac02310232022301a3019c01a4019e01b1021b023601f201bc017601760150013000fd00f800bb00a900a600b500a4009a00a600ac008c52535349313f80000000000000fff922300d05032b1df81efb00001cb2000000001ced0000000000000000000000000000000000001ccb1d0a240f2c7431f332c431ac335a33bc324d345032cf34b132b133bd33ca3594360036933ea734a932be324c320233b432993309331632b131932d462755272a276925a623c7242e2510261e29702957289f29132ff33649392f3d2e3e603cd93a1a3a213f7b3eff3e0638c83a9a3ae42f2d241a234c2497286c2e0631163401343b337535c5381f355a35293555342034cb350a33f2348c34af338734cc33ac346b353e335e35d23618356235a4416b3f533163318c333f33e233e534c9353634b034d535d836c6344c342935cc3507341b363335333445342734e63529360035cb359735aa3579342a364233f5340c345136363457358c356e343d343e3494354c34623543355e34a63514342f34b9343634b5377135db34ad337434ab34aa35b6356a34143540345835783444364b366535133656351b3568362c35bf35a0351635a3371d3517353c35c1359635c234bc360835dd3495354f33f637f3405537f9358134f1359035713446354835cb33d0344c3587349734a5349234cc3522343a3412344e33ba3309349233ea341a3443340a359933f13382346d343932883315341233e93301335b3319322c3211323831e032b932ab31ee3203316f327b32432df62d8a319132e233f33285319d3308312530dc30fb30a83110307931cc3210324130fa2f9a2fa9316a30bb314e3059313e308830c22fa32e762c9a2c4e2bf12bdf2d1f2d232d062df22d8f2d3a2d232d472e1a2d5b2dcd2d9a2de52d8e2dc42dcf2ed22e922e392ed42e342e092f552ef42f322f682eba2f8c2f262ef12e672ee830b4304c30582f70300c304230452fd03028302c30692f10304c2fc730bd3082315132c531e030e8322c318e3176321f30e531e231bb314731573229320b31e132933388330231fc326e31b1331c333c33a83322327432b83301326e3350321332fb333d337932d73320340b3389334333a033c434ab340a3422357434bc337f342734ab540d53af481a29482a7629fd2b2e2b872d7f2c9a2d382eaf2ef82fe82f7f2fcb305430353065304d30c83167314330b82f963031300830932ea92d7a2b7d3aa446904cff4ed9317e3316346533f334e533f033eb3410344334ff346833e0338e333d336b335f33f0341a33b93285343c33c0331f347c331933c332ad332a31ef32563284318833f4332f314b3245324e32c3328731f0325633553b75461f486642b93d0840a8460149424499377433ca333e317b325d35833cad3d6d3a90396a3aa13f0c3ea43bab38e53dae40bc35a12df42a59323f371737ce371a31a42da529a328002810265c25fa26c025f22fe531b22d402539260d25b3249e2b8c323d326f3210327c33c9337a324f333c33e7355d3a8c438846312f742d052b822ba82b7e2ae12ace2bd12aed302e33212e292e9931f12ff8348d2da62e2a2cc72d7832172f5e330530392b8b2b472c892ff032e63414307f2c112a712dee2fe72bf932cb2d5e29c82a0f2f962d8f321229972b102ec927e22b87322828402b0f27db29ce31ab2e27292e26e82abe343b2d40277d26e82e402b0926e3268e2f052a97267629d22ce7252526b02cc727882b0f00001c022e5e3489359e34a3360334c53491361c35af34d23501349f34f735ce35093543355334e433a035492af7230523c7248922e5232c24b229e03375366c36c635d23580353c3538363d34342c6f23d8248025042589252a26d8307f29028b068cae8c418c848c098c6c8c298c6088e7331d28372647256b266626e0279c267b2b3034df3758375a368a374e381235fd354235c536b12ee7294627a2282e287727f626d928fd29a8338a36ae3504372a3785363835ee36b635b536b336ae365e36a035b1370f373937ea36e6359736353760358036d0287586ca759e37a7375334fd357a2c9f299126872d7b34e82fe229432cac331a2f6e2e262e5b2e312edb2ef42e612e792d332d972f2c2ed92f4a2f252ee130912e793147316c3434365c359332ba2e2d2b493508368f35c135c835f5355d362736bf3640357d355b35c7353735ee3569342737963695367f356d36ed356a353f356a351b34e334c734e333c733583253304d2e6a2b432bf32c4f2a532a5d2b5b302e34d9362a35612e9d2dcc35f73ad43cc638c032722d282630297335553b28381534753126318a2fe7351d35f0344b2f762aa723132465247a27192634253824f9267e0000000000000000000107b20101003211000520800000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000afe8afecb3dff847b3e01365000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b0280000200020002000200020002027302a20002000202a002ab000200020002000202c502c502c502b602a8029f029d02d702b602a502a102cf02b102c702ee02a102ea031303c50491048404a604af049f049104ab04a0049404920478042203df040a03fd03d503be03c20395037903720378038503a203a803cf04070441047b04c604c50460043e045204bf0493042803d503c203ab03ad03d204160412041f0462047b0480049004d104fd04d304c904d704df04e704d804c804d704e804ca04df04cc04cd04cf04d704d104970417036b02d902d202c002bf02d102c502d502b602ae02bc02c302d002c702ce02b902c302cd02bf02d202da02d702de02ce02d502d202d802dd02ef02dd02ee02e902e502f902e202ee02ec02ea02f802ed02fb02f802f302f5030e030d0305030f030403040311030c0320030e031903110328030f03250332032a0322031d033c032803310343032e0335032e0345033d03410349034203440347034003500348034b03500350036f036403670399043b04f10529051f051805210534052e051c053f052c0524054605500548053c055005550560054d05640571057a056b056b057a058a0576059a058305b2058c05a5059805bf05ba05b105c005b905cb05c405e105cf05d205d505f005ef060e0601060505e506010622062b061a062f062d064b064f0628066f065c0663067a0680068b0693069106a106bc06b306c906c506db06d906d506f806ed06d706d606ca06bc06b406b4068c06b006860687067606780675065906530653065d064d064b063806380635064506300614061d061f06040611060d0607060e060005eb05e805f405d805d605d205db05c105bf05b705b405a605ad05a5059f05a00596057905a205950587058f056a05860572057305820577058005670557056c056f055a05630566056a056505440553056f055505590546053f054a054305500543053f0535054e054805310543053c053c0537050c05350522053b0526052305260522051c051b052705110508051104e3035102e402620148013001310139013c0131012801230118012d0123011501250118012201170132010b012201210131010801240121013601260129014701f2024b02d004ba050a05060508051c050f050d0526050f04f80514051b0518051005210521051d05360519051b0530052d0524051c053b050d05360541053e053a05480546054b05510539052f053a0540052f052204a70407036302fe02b302c8033803eb046c04ff054505510561055e050a047f040803e203b903f4041e04b204dc04fa04a003ca0340033d0326037903a503e1038d033a033b0321031602f50301030502f10269025e026902600286029f02a602da02b402ca02bd02d602d102d302e702cf02e6030302e3033003ba04a6066b066f0688068206a106a906b806c206c306cf076208020801073206f40736084108450869086507ed0766075f0820088508ae08b2084707a807ab087f0904090208ca081207db07e00923096f09600892084a089309af09b108db0887087408c509cc0936090208ec08ef0a040988094f093c09a809f909b5098609b30a500a2309e60a0b0aa10a770a680ad50b050ad50af80b3a0b3b0002041b03f10410040403fb03ee03ed040003f003e603dc03dc03e403ed03de03e403ba03d803ce03cb03be03bb03cc03c703c203c503c803bd03c103ac03b203bf03a903b103ac03a303ad03a103bd03b003b5039603ac03ae039f03ab037903ac03ad03b203ad03b003b403a803a103b40396039703900393038a0385039a038d0392037e039003840393038e038c0386038d038a03980388038e039b03810388038003870387038503760394039a038c03960392038b0395038c03a3038803950388039e038f03940392039a0392038e0396038f038f037503ad039103d303de03ef035a030e0318035d02c901f301970179019f01fb02a902cf02bc02c102c202a0029d028a0279025b0275025f02400257025f025002420224021e0234022e021e020b01cd01d9020f0237022b0236023202300238022d0256022c02490239023f0249023b024502480244024902450253025d024c0245025b025a025902480255024d023402300235022a01ef01c101cc01c401b401ed01f601f301e301b201a201db02220251021101be0190019a018b01ca0217022401fa019b018e016f017c013b00fd00e500cb00a700a700b200ab009f00a800aa00b152535349313f80000000000000fff922300d05032b1eac0000000000000000000000001d801cdc000000001d561d8000000000000000001d2a25b72c0e3129328a334a338430f03290338333ac316f3311325b30673430315e380c3a8c336c3435321431ea3297335a31e0322d32b9321e2d90288528d825bc256224f725d6252d25db296b29b22935292f2df734ed39df3c0f3d483c253810392a3f043f3f3dea370939f23ae52e33231e2210236a29082c25300033fa34a73541345e3715350d3313357e35a8348e344333d534a535a1347833b734f4342334f834d53494344a344d38cd40963e6f316531383422347233b0345333ab3545363635ad34bd343034a7348d3558350b3435356e3446344734d834a5361e35c3365935be35923491357634ba3509358334733606355535a8363334f135bf3527352a365d35fd34593480351b349335cc359634ce359e345734e5349d3555341f35da34983404344935ba357533ee34ed34c83460359a353a36bd34dc35aa3564352835f435ab35b5364b353f361b35a9357f355233b7342533bf376a3fb73813343c351f35d83513347834aa35f13413351135d8341b33cc34ac3527342e340d339834a033a7333c32ca343b344833c53344347b32c433a9321f33fe32f233f1324a32c6337a32e9330232a5333f31f132c3331c3377322c32de311f321232442fa92df831a031c332de323b32703119311a331b2ff930f03158311830e93099309e30ed304f2f2430122ffa30a32fab300130b92fff2f8c2d7c2b7b2bf32c212c8c2c3a2dd02bee2dc82d962d9e2d3e2d302eaf2ed42e6a2d662e202dd12df62dd42d962c932d692eac2e352e802f6f2e982e7b2e902e152eb32f5e2eff2e402fcb2f7a2f922ea92f132f0e2fb22faa303e2ff930313065308f310132383009304c30d7305f3249309b319331f730e531aa314731b5324e31753167321731a4319431853195332e3263314a326831f032c432f23212325631a13245328b32dd3226323c3330328332bb328b32713481328f33b531e13349335133d1339533f933d0331c341b343332ff3457519352c44bbf2f0028ca2a072a512ad22c292d062da42f742ead2fd43085305330fe310430f12ff831f7309d30c82fc331c43044300f2db62ccb2c0e384844f34ca64e6131c63131331933af32ed33c0349332d233f534ad335632d3335a3389333b32eb32eb3190338933d632c6320e3274326e313a336f31ad3105319931a63109312e316331ef33033319321a317032d633423bcf46b9492e41f63cc340494603498442a636a0327931a9313b318a358a3d683c6738b139e33a403f8d3d7d39cc37783d363e5b352b2c4e2ae6300736fc361f365c31eb2c2e2a39278f2780260f270f23b826d02f7d31172c3e26c126cc25ff23e72ca430d8328a31ee32ab32ec324233d732f2320034c039c3440f45f52dda2cd82b1a2bda2aba2af42a572a662ad52f4d31f32d342e1131ed2f7133d02d2d2df22b2d2d2930042f2530f5303e2d232b9f2c0330be32c334c62fc02ad42ae02e6130a82c6533d32c8829a22a4a2f312cf132802a03299e2e6928e62b5e31fe289c2b9f2775282b31f92bd2293d26b229c930ad2ce2277e284b2e4f2ae1264728942e4b289225ce28802bec248026162d0128862b8700001bcd2e4b33ae3474353535923507343134f3350d35ae352b34bc340834d2343b370634c03567356834522aee227e23b9242223932308239129e234e3362c34e5368335b73581368e35d534cb295f241323e125a5241a24b126fc2f5728ec8b2d8c618c9b8c6f8c9f8c908c338bc588a1332c28ac26a426322712272125fb26c32941350b36d13778366836bf373a370f36d736e1345d2df227f22652277f279527c327a627d429ef33dc35b9355a36c1358435a236af356f3663349c3690363136b534e83643357c3678352435cc363635973629367d27e2865a757a37bf38f4348e35982aac297426d92c7133aa2fd129aa2bef32452d0d2dc32efb2def2d482e002d842dfb2e4c2fc52e522ef330442ea92e122e0e2ed22fac308733f2360036fb327d2dac2c5f3520358336b935cd35f436623603375c345f37e0351a36eb369935ac37203635367d363c3635370d35a135a335dd35cc346a347f34bc35a4343432f8322730b62da22ab82ac12b9928162a302ecd303732d134a7332d2f2d2dc333223b1f3a01397230f42cfc26f22a6d33bb3ac93917339b32aa301a305532b934c833f330562998234923be24b4265025e02583252124f30000000000000000000107b20101003211000c3cd00000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000aff6affab3ee35a0b3ee4dde000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b027b027a027f0273029102890002000200020002000200020002000200020002000202b202b902cc02aa02a602cf02b102ae02bc02af02de027e02ac02d002e902b902f9032603c3046504a604a704930498049b049d048b0498048b0475044603fb040003ea03d903e103a8037b036003710389038a0382039303cc03ff0444048d04bb04bc04600446045704ac04a6040603d603bb03ad03b603ec03ff03ff042704620496046f048404d704e004d904ee04d804e604db04d004ca04d704f504d504cd04ce04d704ce04e104c504b20412035a02cf02d902b502c402ca02bf02be02bb02cd02be02cd02c302cb02c202be02b902bb02ca02d002d702c802e302de02d002d502f302e802e402e102e502f302ef02e602ea02f1030202f802e602ff02ef02f102fe02f402fd0300030003050302030d0301031b03020334030f0313031f031a032e032e03250336033c031f033703380330033b0336033f0337034103400348033d0335034e034b034c034c0344033a034e0377036c0360038d044104f10514051e0527051b052c052e053a052f0531054b054d054c05580552054c0561055e055a0547055e0566055e05730588057705820594057e05830597059f058305bc05a605ab05ba05c605c605b205c805df05e105e405ff05f505f50605060905ff06090615063106370642064c062e06560660064d0646067f067a0686067b069c06970696069806bd06cd06b406c906e006f006e306e506e006d806d606c206a506c0069e068c06a2068006750677066b06780666066e065c06470634063e062e063e0632061f061d0625062405f8061b061305fa05f705fb05ed05cd05e605d605d605c405bd05bc05b805a405bb05b505bb05ba05af05b005a405ac0598059505a0059905790585058b05710581056f0572056b0577056c0564055f056605700557054c055c055d055205510539053d05450520053405440536054c052005330538053b0533052e053005080522052a0514052a0534052c051a05290525050a0523051b05210500051a051405120518050804eb04e3036002f902760171014c013001330134013f0124012e01400131012a0126013c01170129012401250124012f012b0123012b012c012001290135019b02250271032a04f10508050605030515051205190512051d050d052f0514052b052b051f052d052c052d0522052c0527053b054205380541053d0536052305480549053905350550053f052b04c503ec0363030302af02d3033803ff045e052d0565054d055a05370519047903fe03da03bc03ed0424049b04d204f7048303c2032e031c033c0357039f03ed039b0337031503180305030302e7031c02d7026e026a02640263029b02af029d02cf02c902c902d802ad02ca02d902ca02ea02ed02f202ef032103b904be06450674068006880689069c06a506b606cb06e5076007f707e5073506e507320845084f0845085407d60746076407ff08a208a308ab084b07b107b008a5090a090008de082807e507fe0935096609620891082c088e09b009bb08ee0891088708ab09de094e090008e1090109fa097f0934092409970a1809b0099a098e0a4b0a290a060a0d0a8b0a6d0a710adb0af80ad20ae40b4e0b370002040003fa03fb03f903f503f703f003f103d903e003e203e503e803d503e903e003c703d803e303c603dc03be03c503c503c003bd03b903bd03c503a103ac03bb03bd03ae03b603a403a803a303b203b103ac03a8038f03ab038b0397037803b103ac03ab03aa03b203ac03a203a103a9039203890397039e0398038a038a0388038e03980392038f03a2039e03990383038e038d039503900367038603600384038a0374036c0379037c038b0393039503910386039703970394038e038f0396039503840383038c0390038803730385038e03940398034903a5038903e303f503ef036003130331037002af01df018b018301a701fe02a302ca02d402d102a3029c02a1029d02710289026d0268025d02450258024c0238022202140219022c0221020801d201e0021e022e023502300233023202440233023f0249024102500244023f024302490244023b02520258024b025d023d026c02600254025d024f025202510257022a0219020701ca01af019f01ad01d801c201d701dd01d101a1018b01c8022b0221021d01a7018c017f01a501dd022b022e01fd018e018c0184015a0136010d00e700dd00a400a500b500af00ab00a70097008f52535349313f80000000000000fff922300d05032b1cef1d161fab1d821ce81d01000000000000000000000000000000000000000000001d3e260c2b9d318032ab30f732863345326d3360309735b6337b31c730a132d2306b36413ad6359e3232323c335932b8328832aa333832b132e42e38263227862666261724c2230a262b27b12a7629d9288528ea2f2c367239ac3c513ce93abd389d398d3efb3eb73d1138b638f33d982f2023d0221a211227772cdf30d23379349e334b35a037a334e9347a34c533c034cf33e4345734cc356634ca3318342434dc34bf3454348d340e353d365b41543fde3181315134da34553412349b34b034ea348134e1345e34e53493357f34f83598358f34ac34343454351f3427343235443570341034ec35a835b335e834d534c735e83575351d342834cf363a34ad367b360c3542363a356d351735a3352d356c34bb35e2343535fa3350350d3509345134fc342833ea3526342633ea354134853451359d34ec3594351635d0354635c535743622372a35733599356b35cd3646373034fd332a33cb33d8379b3eff382e35da352f34b235bc351f34ad342c34f2352733d833d833fa338b33ed3477339f33ae340c34f3345333fc345933943345342833d7333f34ba348433af3366355d32b633e233db331b3297330233c9333232453256325e312931ed327531d631eb2e972d763235313e3172311430eb327c310e306131b4325f2fc730c530a231d2306c30aa30b1310c2f9b2fd1316e30792f882f8c30f02fa62cb02c0a2b542bea2cf02bc62d0f2d892c522dac2db02d472dcd2d312db32cf32da12e732eaa2d842e402ce72dd42e592e662dc92e252ff22e422e982f392ed92e882efd30642ed82f692fc630b8302b2f522fa930c92f202f742efe2f222fae2f8f30772fdf304130402fa62ff7313130c9307131c93121320b31af31b73122313631c231f6314831233227329b31c531b9325a326333b5337432883478330a31de333d32543443334a32d532ef336c3391332034cb3307330a33c2330632a432cb33c333393371349c331a341133c134d1336233a53380332b33a73506349851b753f54dd7333e26ba291a2a282b6c2bc22dd02df02e402fbb3016308e2fb231a530f1314b3144314f30bb309330fa30442ef02e192ddb2d573be248494e544bd7323832e0338f3468337d3371335d337d333e33c831ee337e3271329d337e333132533241324331bd322f3181311331ba30e43198320633b731fb32773279326430bf31c432f6396e490e494541c43ce23f4245c3485f439f33b430c5321631403359349a3daf3d0739d139583af73f0c3f2b3b4038333ee13fc135b72dab2a483120369a366b367f31b22d3f2a33291626f02781256222ea264c2ef931602c6d257c2632265c24fa2b8430bb315933db32db3287338e3246329a32ac343d3a1e43f144302fa62cc22b862b8b2c332b5e2b0c2aea2a662e3431dc2dbe2f4b316c306534562cb52d592cf92dff310a30d130ee31fb2b8b2c0c2c4030c53295348a2e252a7a2b2c2d6b2fe32ba7327f2b702a332a372f472e7332a929c029492dc628372aba330927b42a4c273e285630b92cc72a1428302b0f31f22b2f27ec27ae304e2b7125f826d02e8a2a12267128ca2b5a25c926a32e5527982b4500001d722dc834d03540355034b33554350f36643558358734963445358d344f347c35be35223457356b32a32aa823192361240723b9243223e429bd3542367034e034cd35b534ee369435ef346929be236024a7246f25ec241a27cc30bb28aa8b348c648c4a8c468c7a8c6d8bff8bdc886933272920261025792584268126ae26972a5d33cb367236f8359f359c364a377936ad36a534652d5a28f4275f29b727a7278328bf29552a9233d63658360435993621372f358135c135f8368b361c35f835b7372f3754368a366c36cd384c36b43617364335e82932863c7545369c36fb34cb35df2aad286126722de834673114298c2bc932222d6c2db92def2d782eff2e3c2d8e2d1b2ed82d3e2e682e742ea02f9d2e5a2e952ef1302930d23579363336ab32162d862ba534ad35ae365d3636367636bb355436a936183534361634ed35df361235f035e1366937043568356636c6354836d733a5345434a3347434e9345e32c83058310b2f362cc22c8c2c1729be2b802ccf32223496365b34142fd32eac34463a7e3db63890323f2d8f283b293332c238ce37db33633357303c2f2d347035e833d0302728d0243e2436249a26952569256925e026780000000000000000000107b20101003212000b37180000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000aff8affcb3f03e60b3f057cc000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b029a028a0002000200020002028a000200020002000200020002000202ba02a10002000202bf02b4028b028002bd02c902b602c102c1028c02c302a402a3029d02e102f4032503bd0487049404a7049204a804a804a4048b04a9049104840434040b03df040603d803cd03c3038803820378038103820385039703db03fa044f048304b404bb045f043c045504a80495042803b903bc03ad03b403ed04120402041d047b0495046f049104d904e704d804d704d404e904e904e004dc04d004c604c804d504c104c504cb04c204c1049f0408036802d702cb02b502c402c802c502ce02b702ce02cc02c802b602b902bd02e002c502c202c802db02d602e202dd02d302cd02d302d702dc02de02e702e602e702e202f302fc02ea030502ff02ed02ef02fe02f702fa03040301030403120315030202ff030a02fe030b032a030b0323030c0320031c0333031a0318033c0334032f033203280332033d032e0337034903440344034903540346034e035b034e03490356035103630369035d038e044e04f80510051a0515053d05200525052d052e05340530052d053a053d055f0556055e0562055e055a0553056405710561057e058705880586059805a605a405a705a905a405b305b805c805c505c305c505c705c605e505db05d005f3060c060905f3060a0603061b062d0626062b06260640063b066a0654065f0655066e06770687068c069a069d06af06bf06d506cd06ca06d606df06f206ec06d406da06c906b906bb06ac069d068b0697067f068f067a067706720656066f065f064e063606300644063f0630061b06210620061c060d060f05fd0604061605f505f005f005d405f805dd05ca05c305bc05a705b905b605bd05bb05b405ad05af05b6059405960574058f059e0585057e0588057705780574056a057b056505660562056b0554054f056e056a055a054e056205490550054e0543053d054f054905460546053605450535053d0534051605260530050c05380529052c052305260527051e052105250514051405140515050c050e04ff051b05080509050604e6035c02e7026b0153012601450135014c0127012d012c011c0132013401210138011e013a0122013601270131011b012401250131013f0138014d01e0024002b8047c04e9050605050506052f0512050b05120530052705210524052c052a0526051905290537051c052e051e052d053b053705400543053d053f0541053005320545053c0522049b03fa035b030102c902ce033b03f304710524053105660556054f0514048a03fc03db03cc03f1042a04a404da04fe04a903c8033e031c0354035a039303e3039103400346031703280308030302e602fa0273025c02680261029702a5029f02d102b902d302e202ba02e202d302c902db02e002ea02e6032e03be04ab06830685066b068906a2069d06ab06b706ca06d6076f07fa07f0073d06f3073508470840083e084a07c5075f0747080c089b08ab08ba084407ad079f089f090c090408cc082b07e307ec092f0973095c08950849088209aa09a208f10897088208d109d9094708fe08d708f009f509730952094709a80a0309c2099609a40a4f0a1f09d90a050a930a720a650ad60af10ac90b000b5f0b270c2a040903f103fc03fa040603ec03ef03f003ef03d703ee03d603e503db03dc03d603de03de03d303d703c003d403d303cc03ca03b903c703ba03c203be039e03b603b303b603a503b003a303b903c003ae039a03ac039d03b0039f039f036f03ba03b003ae03af03a503a403a003b103b00384037d038f038f037b038b03a40382039403840390038d039e0388038d03950393038b038803800380036f0381037a039103600385037703950386038203910381037a03850371038e0386038c0394038d03830387038d038503880383039403830399038c032e03a1039d03c203f40402037a031d0362037002df01d6019a018001b0020b02af02d502b102c8029402c002ab02a702770285027b025b02580230025302360235023f0231021a022a022201ff01bf01ee021e0242022d024002320241024c0231023a024a024002360247023e024302460247025002530262024a0256025f0246025902560256025f0251023f024e022a0243020f01fc01aa019c01cf01ba01f701f001f801ca01c0018901be021c02560204017e0190018b01a901e3023f023401e901a801810184015b0140010200e700d100a5009f00a0009f009800a600af00a752535349313f80000000000000fff922300d05032b1d4a1e9500000000000000001d1100000000000000000000000000001e1f1cdc0000000026582cf7338434b231eb31b032d23255327e34e231f033f833d933ff316830ca37363ba633b4336a324c3305321231ff321533503186325d2ce92723271128132492245724c8247a26a4290f295c28d629442f36362338ab3cd53c853bc339c439503f723f493dfd395c3a163a562f5623d1225622a5283e2c073082342d3372338c35be36ac34e8343034b4355834d033b033cb344c347234f0357434ef346335b23558349835aa352c383241523d30315e3240348e34483405346133e435683433341d344d35b535303609333a347934d03497341933d533ca344a34c335f8363935d435bb35a5354c355335c5361534cf347b35823410349235a535ea34fe35ba353b3520350e350f3497345535c336133557365a353733af35c43422358a34b634cd341b3561363434363498352f34bd360f352d34ef3674361134dd357635b7353e3495358f3574349635a235d434ea3595343833f2342c37d13edc37aa35e83534365c339d3609358e34e734dd3553354535a735083553333e33dd339333aa33e93451348e33d833a2342b335732bc33c833bb32e232a7331932e9335a336932d532d2324732dc32d7331a330b3393321f32c333d432223120318a32c32df42dbd31f131823257328b330a31b932142fce318d311832823155315f3102313930c3306b2ff72fac2f6230093049304d307830492f452d5c2be92c1b2c722c302c8c2d1e2d992d162dbf2ca62d392d662d3c2e492d1c2d842e0d2e752e3b2ce72d262de52e732ea02e612e3f2f0e2ec02f0d2e7a2d642ec62f142e7b2fcf2e4f2f3d303f30102fb7308f2f762fd82f852f292f6a2ff92f9d2f9d30f130af3206308b2fe5310a312530d8318431a63145322f312931e131cb31c931a8323732d5315f315c31dc3287317b334032cb32b1329632e031e83220320d32383328327932f732bd3384346533b532f2347a327d330832f433583393336c33ae33823394346b3425342f33e1345333c3343f334034003406338f3420512b53054a743013289528152a2c2a852ce92d932eb1300c2fd52fd4310b2fe231c830083138304431073086316330ee30142db42d662cf22ed5415d49174e2a350e33403328342533f13205336233d43340322532a8329932773257331e337c339332b7313e32f531ce32a632403178318d31d1317d325e328632f0332b327f315931c333583d3147a74a1041b53aa33fb3450a489042273484336630d831d6324634e23cc53d6b398138253a783edb3e7f3acc37b13c5f3e8434f02da7290230f1377e37123593304e2b3c2a782713268326a2274f23e0264d2fb030f92c8f257526ef26a125002c4a30723127332c31a63324339c32f3333133493489394a43c245682cd92bd62c952bce2af52b312af12ae12a732f2330bb2db22ec031432fd4340c2c8b2e182d182edc31e02f84320131272bf72bd42b2e313b32e835722e492a432aa52e9c2fa12c0f33822ba529872a6b2ed02cc8336629e92a4f2db728042ac7316c27d22ae82755296231982c8b2ac026d3297030a42c9b26c427bc2f782b1e265529632edf29b0262428ab2b962652273b2c6326a72c1f29041cd42e3534a5356133f736093591353134ea3620345335f0346035393528350c3456344e35173470349729df23b62277238a24bc229023b829e733ad3749354a359f35c5366235703659339329762482252c246b24f123ed26402fcb29998b688c948c808c7b8c1d8c308bee8c6d88c0342e2a082721265f26fe2638252c26ec299f354d36e636f235b537d437153662366236b435ae2ebd28052882281d285e273f2991277a2a96329536c537a435f6379c37b236e83845363236f5365f360836943711370a363736e33672376235923745359b36ef2ce9863575d6393536c6334f342d2a70260525d32bca34be303729a12b7131772d1d2d2a2f732dcc2f7a2cb32d132cde2e882d7d2dcf2f472f0630e22e812f782f6b2ebf2fd7354f35d136f732b62e3e2a97344e34803643354936b035b634c036613607354635eb370635813678363235da3681359035c034dc36ee35c434a6359e347a34ce354d343e345933c430fc30f42d1e2c352a2c2cf9299529842e572f3d32ff34a433fb2eb52ebd33f33b25398d3b1d34912dee27442879320d37b437ed34b231d9308f2eef340935673431308d294d238224ab256a271c262825b624e325040000000000000000000107b20101003212000d42880000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000affaaffeb3f247ddb3f26089000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b00020289027a026e000200020002000200020002029d0002000202a202b3000202ac000202cf029e02c402a702b102cb02be02c8029d02c5028c02ce02b002a802c602f6032f03a8047c04ad04ad04a404ab049e04b604a004a4047f046e041f0412041603f903e303db03c503840379036f037d038f03a603a303c303f70442048304c004cb045504460450049b04a2042803e003c303a303b403d8040a03ec0428045404ae0464047e04d504d404ef04d904e304dd04dc04e404df04d504c704da04bb04cf04db04c804e704cb04ae040c036902eb02c202bd02ca02b702bd02b202bc02b602c802bb02c902ca02c402c502ba02be02b402d002dd02ba02d302db02de02d102d002e202db02e902dd02e102ed02f102ee02f602f102f002f60300030602f702fd02f7030f030702ff030603070308031302ff030803080311032e0307031b031e03140320031e0326032303290320032d032c033b032c033b033d033703600349034f034b0340034c0347034603600363036e03480368039e043c04e9051d05130518051e0539052e053505340545052a053a0555053c053a054b055d056a05640565057e0587056d0573057d0576059f05810587059e059805a5059505b005bd05b305c405d105c405cd05d405e605d305d805f705ec060705fd060205fb060a061e0635061c06320641064406440654064c065b067a067a0681067806850693069c06af06bf06cf06c006cb06df06e906e306ea06cf06cc06cb06ae06b706c206a306860694067a067b066f06650658066f06680652065506510640064c062506440618062e061d060c05ff0601060205eb060105f005e805ee05d405df05cd05d205c105c605c705b905bd05b705c5059d05b305a105ab05a1059d059f058c05a50592057905710574057d0585056f057f056105720564055f055205610561055c056a054f055c05570556056105480545052305400536052f0548053b0549051c0536052d051a051e052005280529053305370510052c0517053d052c05250520050c050c0512050f05100515051705130513050204f7034102eb024b015101430137013b0133013d012e012d0128013b013c0131012c0122012601300128012c011a012a012301360133013c013d014d01f1026302e104d804f3050b0508052d051a051a0512051c052b05260524051a051f052b051f0522051f05270543053a05240533053c053305430546053b0548053b054505340546050b04aa03e9035f02fb02b302d3033903e80473050f0550054b054e054d051f0477040b03d803c603e7042e04b004ea04e0049403b5033402f40350036a03a903de039e0347030e0327030e02f1030902d802b502750278023d028b02a402ae02b702d602c202c502cd02cb02d802f402da02ee02db02e802f4032d03ba04d006830669068206850691068c06aa06bf06ba06e0076007dd0809073006f00740083e08470851084a07cc073c075a0832089f089b08b1085507c007ac08b30900090008db081d07e307e209490974095f0880083308a309cc09b408f50894086908db09bb094a090608f508f209c8098a0948094c09a80a0009c3099c09b00a540a1209fd0a130aad0a750a700ade0af00ac10af90b350b4a0002040003fe03fe03eb03fe03f403f803f903e303de03e803d803f103ea03e303ef03ee03e503d303d103e403ce03a803be03be03b703bc03c0039e03ae03ba03c303bb03b803aa03b303ac03ac03b6039e039a03ac039803b2038903a1037203b903af03b003ab03b003b103a903a403ac0385039003b103840390037b036b0390038d037c039403900398038e03840388037b037603870385039703780385038403920382036f037c0376038c038e0397038f03890396038f0396038e038d038403890382038b038d038f0392038e038b038e0392038c035003a0039003d703e803fc036f030b0326035202a401c80188018601980213028a02cd02c502b202c102ae0296028f0283027f025c026c02640244025f0246023c022b022e0220022d0223020901d201ef0219023902340234023a02320244023e02420240023f023902390245024e023d025302520262025e025c0240024602560269025c0257025202500257022d0245023001ed020601a401ad01bd01d501cf01f301ed01df01a2019301bf02450242022301a5017e0183018e01c1022502160205019b016f018d01660138010700c900c400ac00a900b000b800be009d00a300a152535349313f80000000000000fff922300d05032b00001da71d9d1cbe0000000000000000000000001deb000000001d201cc300001e78000025dd2dbe301032f432683162328431b1344a321d34a231d0335d33e8326c308035f03ca9344831df3202323331e2329b316b322531f333432dcb2878266925182592245223c524da26c02964297328c828922dba355b3aac3d123d273b48385638693f8a3ecd3dde3a1438d33a8f2ddf226b2487232028e42c7f31b433a635c5323736d53878348f350033e934c6344d347b34673420345634a8353d343f364934a03420352f337d34f836f641723dbb309a3257343433fe34cd34cd36173513355334793575348d34e534a734cf3515355135e234a4340336c234f33489347b364a360b35af35e335383631365b350b34f1351034a5352f35a2350a3480348b35ce35713606347534c235433510350b353834c435fe35ba35e0350d33b3363c34ab34c835d03504357c357c35c9353b363e360b360435773695359135d335f433c534ed352f35b336593570361735d63454343a339f35bd33a137933fe9392e350035da3618357333f63487348734be33c935af34ed339a35693506344833e03320338633a2326e323b3406334f335f344432653403341232f7338632ee3422330f326f3379327d323232f832a6329331df332a32e031b1324631c8324332312e852d7931da312f32dc31fb31a0319031bd30f831c13122306030b130e531c5319130dd309c30172fc42f95307830442fa72fe330d12f7a2dac2c712bff2d0e2c6a2b972d052dcb2d3d2e112d3b2ddf2e212e9b2d522d8c2df62d752d412d7e2c9f2e7b2c9c2ed92daf2e622ef32f9c2f622eb02f8f2e992f002f262ecc2fc82f4130182fdb300a2f362eef2f932f332f492ea530952f8630922fbd306f30082fbc308f2f4c30443184320031ae312c30f331bf30f931f23110317f31d132af320531a431e4311c32a931a2322832553152327f326833b9327332fe339d323532fd3242345133093389342833c03362337d337032913286346b32f53420324b32c3336633bf3482344d33d9340633a43378337333cf337033733383535d51d04b042b45271728a82a392bd42c092e0c2f052fe92f992f8c304e30ca3195315230df3132311c314430e330c12ee12e222de52c9e35e145054c4c504931c0335a331e33bb3242335c32e9331e3343327032b2326f334c336433263378326f3263323a311a315932da31d831d93222311231ca32de325b329b31af329031b3348f3be3490048ff420d3cd7401445d54a3a418b352531d132503211323a348b3df03be03993391c3baa3ebc3db2399839573d763f9c35a92f6729bf311635fa37e135d2306c2e09292827f32811260f28b31fa126252ecf333b2a2024d4261124d924962c0230e131fe328b3264313732ff3234337b331b33f039d444c043072caf2d472ba92c3d2ba72c622b1b2a682b3d2efa31e02f1e2dba31732f8533e82d282df12c852eac317330d631e42f2c2c212bd82be13033315434e92d5b2afe2b002d522fed2c3c345e2a8a29832a5b2fa42e623247287b29952d0227fe2c2c316129cc2a4b27142843327c2e9529092736294931962bd426c7279e2f242a5b26e327612eaa27f0260c28d62b3f259e27a92da428742ada0000207c2e703488366e34b1352634c034893592356434f835a734433446349633c333a533c534bd34d3327c29ad25d0248f242b2360247824922bb034bf356a34b23543356f3612352835ae33c228eb24be256a235325a723fd280b308624e18b9a8c6b8c7a8c538c8c8c968c538be78826334f28d624f3268f2624278627d826de2ad335c736d836ce364e36c33789377b3827387b35032e0f27102855283d27eb275a279c29502b0334a0366f367e35c0362f36e535e036803555368c3642370336ab375136b3363736ab35fa368036c0363436453717254085ef735d371537a1339f33d22ade28f927912e5c360b305328a72da531522ed52e1d2ea82ea62d862d392e5b2db02de62e132f4f2e392e5b2fa62df12ec82f1b2f7f2fd3352635b4366732162cad2b76351f35b9365a3620360d3633350935d0355635ee35e736b4372835de3554370b353a355334ae354b35bc37513618347833653497349234ea3464323e32662f922d992dae297d2c7c29a32af62d6931b9334a355b331c2f862eaf3516391e3b70376731d42de928092af13579398c39be32b3326231ca2eed341635d8335b31b3291d233c246725262648240f2572255825c20000000000000000000107b20101003213000007d00000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000b03eb042b43774afb4378d7e000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b026b0293026f000200020002000200020002000200020295029a0002000202a40002000202d302d102be02af02ca02a502ad02c3029102950293029d02f802ac02e102e6032603bb04610493049604a804a50485049504a804a40490046f044903f50407040403e603d903ce038f0376038003850383038f039e03c803f50443048104af04c10463043f044904a50492041703cf03c803a403b003f6040a03f6041d04610499046e049404dd04dd04e704d504c704df04dc04d104d404c804dc04e104c104cc04c104c804cb04bd04af0432036502d702d802b102d602b402c402bc02bd02c102c102cf02cf02b202ce02c902c702bd02da02cb02d102cd02cb02e102d002d902e002db02df02e002e402e602f002ea02e402ed02e802f802f102ef031302f502ff02fd02fd030303100304030302fd031d0302031a031d030903130312032a03220323032d0333032a03280332033903340339033a032f0332033f033e034403400344034303450347034e03510355034f035c035b03600389043204fb050d0519052e0524052005230541052e0535054b0548054c054f055d056305440566056b05600554055a0578056a05800576057f057f0597058105a305aa05a205b305bc05bd05cc05ba05cb05d005c405c905e505de05df05de0607061a0605060b06200613061f063a062f0645063f064606410650066b0671066d0695067e06920693069206a406b806b206c806d006ed06df06fb06e806cc06a206c806c006c006b606940697069a069a0678068206780676066e067c0660064a0663063b063c06470627062c061f062d05f0061005ee0600060e061a060805e505f005f105c805d805d105c305bc05ba05c505c605b105ba05cb05be05a7059d0588058c05a2059a058d05740589055b058d0568058a05750569056905740576055e05620561056305660569055c0559053d0547054f0554054c053a0550054d05320539053a0529052a053c053f052105350527053f05230522052d051b05250528052605170534051e0529050f050b050f05170504050b05100521051d050f05100515050f0519050304f704fc04f8050705120506051c05060510050d051205170516051a05190507051a0510050f0512051d050504ef04fc04fd04d8032802ec026201530142014e013a012c014601230138012c013c013f01430139012d013b014e013a0133013b0145013c012d013d01520241029c030304fe052d05380548051504d00407036102f602be02e3034203f00471050e053c056a05550541052c0484040703dd03d003f1041804a504cf04eb049e03c1033e031703430371039a03da0398034b032d03040308030602f202f702f90276024f0266028202a402c902a202ce02bd02d202cd02da02d702e002d602dd02e302e902e7032a03c2047b0668067406820688069e0697069f06b206c206d5077507fb07eb073e06f60736082e08490840085407f107640756080c089408aa08b7087807c307aa087e0912090608d3082d07d007e70924096d0962086c083f088409be09a908e00898088708c209e40934091808da08f009fb0981094a0946099b0a1409bd099909a70a650a1b0a010a130a980a710a4d0ad80ad90ac70afa0b4f0b3200020402040503e903ef03fb03eb03f803fb03da03e303f003eb03e303dd03e803d203e203c403cc03cd03ce03b603c803c203c503c003b603ad03b803ad03b103ae03b203b003a703b003b103aa03b403af039503b103ae0399039b0396036003b803ab03ac03b103b003a703af039d03a5038403830395039c0388038e0389038a038f03770383038c03a0039a03910393038a0384039803890377038f036103740381038f03960385036f0389038a039a037a038b038c0388038403860392038503880392038a038e0394038d0387038b038d03930389036e03ad039403e403f203e2036c031d033e036302d501ba0184018501a00203027702d402c202cb02b302ad028f0277028902770278024a0250024b023f02410230021302340231021a022001ff01b901e602100229023b02210232023d0245023a024a023c023f023b0246025c024102520242024a024a0253025b0252025e0262023c0261026a02450261025b024902330229024701f801be01b201da01d101d301ea01f801da01c8018e01c6021f0237021201aa01910181019c01b6022a021a020201c1016d018c0166013d00fe00d500d200a000a500af00ab008e009e00a3009d52535349313f80000000000000fff922300d05032b1dc41d201ccb000000000000000000000000000000001d891dd5000000001d110000000024552b2430a5325e30ea332a32f43211345d3437343c3449300a339b313a318d36573ae23612336e32f7325a322933ab3344321f325c329b2e862657280a26462508238c23b324472657294028e5286828dc2e7b356e39b63cdb3cd43b8839dd39563efb3f593e8539213a133c542efa226b22b823ac26e52c41316e341934ba33743513366334a634613442351f356a347d3473350734a4358b343e33db35e0356c3568353a34de35f636b13e953e45317d31503493335e34dc3490354e351834f7350f343834003609349334553471357833e53496349534b4356b346735df35b2351735fd35ee35d0355f35cb352f3548359c355035f734d6359d361133b5364034d8352e354134da349d3596355335f8344e35fd344a348e359a35473570342034ad34eb341b3424352234e13523348334a534b934f636653638353b356a35ab35f335c6360d35fc35cb352b350c34cf35d53494349b340537be403f373f35fb3546346d34ca3592359533df34d534e133dc341d3413342e3363335834f8336c331c33e9351534d23357343a335533d233d733f5331d3466332532de339c32c132a932993229336b329432a533513340324e32e432e8333831a330e732412e052c69326a32553114323b313d31e6317432363196307530fc31a5301b317630c330e23101308c2ff430dc305230062ed22ff22f992ff02ddd2e752c0c2bcb2bf52c162d552d342cf92c642dd12d092d392d412d742c432d8d2dff2c302def2d8c2ce72e3d2dcd2e882d9430722efb306e2f322e312d7e2e302f632ef92e70306f2ef32fa82f892fe72fae2ece2eb92fa02f1e2e692f162fe6307c318430ec2f662fd3307231ab30823327308831ee306c31c03200319d30d630c631d731b031a3318f3175315f31b231e133c03304326e31f8321332a431b531cf3338333832e933f233853345329533fe3293333e31ee33833389330933c633543376332e33e732eb33c2333a345b343e338f3378340c33fe340d32f532fc33d633da334033e8334834a7350e349f34323381334333ad327133c033a43395336a33393379339d338233ce32ea3377336333173283341e34f3344433d534ce551d531f4b562ed82ab22c222f1a30202f563160307b318131f630d5304d310c318d309a2f9b3024305e2f072d822c482bdf294c2b8e46644ec64f052f3330363133315133c737f746de4a0442fa3bb43e21442248e341ce359232ef30e831c732e633bb3d573cbd397e37c43a4c3fca3e483bbc39263d4d3ff235a62e6729c72ffc36ab380235f62ff82cad2bba2895275c26de2749235b265c302531492b1325a6249c265b24cd2b9b3084320731bc326f324d330f32d932f232e334a838b3429349202dd62cc82b812bb72b052ba52b4c2b312afe2f2d30dd2d852f00315a2fd5340f2dd12dbc2cf82e3530522f87311f310c2c282b682bd22f23324634f9301a2a192a9e2dc230132cc933202bf22a2b2a1330e02d263360291a2a1b2ebf27c42a8c324527bb2bd925dd290231682c1b2a5e2733294d31592bbd273e27d12ee92a6c26a527922de6294a263629d12be2271427532cee277a2b2b00001b872d163592361c352b35bf34d8341036603633344e34f534803499348d34ff345c35a2355d351433672b54235523a4227a23b924a725672a4034533602362235e63656366e359e3570341e29eb23b4258623c023fb257e26ac309b2bad8b4c8c3a8c628ca28c838c388c768bb0886734a129b8264e258426f9265126a626af29d1358e37a93708360735e236a4367336ed3748345f2dfa28d12701296b28ba283f271926d129a1345c368a36bb355637f93668365136cf372b36e836023725370435d9364a363f35bd36a2369336a6367635c736ba29168692757b369636cc350034ec2a1d27b926722c3f371130a029542d1a31862f252dc32eca2d8b2e1b2e072e6e2ef22dc42e402e37300b2f402f572f672f0e2f82304a2f7d33fc3776368a33062ee72b8b351d362535b73793366235b2356335c3352d3665361e368f35f334723666353b369b361f362d35ab351835ec34833449367e347c340b35ec339a32af30f730902e2b29712a722b18290b28c82d8d314533853496336a2e0e2e8133a93b443c1f3a2e32062d6827b129b934ab38d3397a334930b731bd2ea7338a35ee341c3111290e23aa2413257c2699271d2590255425a40000000000000000000107b2010100321700082dc00000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000b040b044b4397d61b4399613000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b026b00020002000200020002027e00020002029b029602a30002000202b602b5000202c902c402c902ca02b602b402dd02c102c002a102af02bc02b302c102ed02ec02f6032503c6047004a304a4049e049004a20490049c049d048f0460043703ff041003f503de03ce03bf036e0371036d038803a80389039b03cb03f20447049104c304ae04530437044e04b50479042303d503bd03ae03af03f403f704120428046404a3046e048d04f404cd04db04cb04c704d904d404cd04d004ce04d704c904d404bd04c504d504b704bb04b20415034b02d802c902c802d502c702c002ca02c102bf02c402cb02d302a502da02d402dc02c002c402c002df02bf02e502d202d602e402e202ec02e302db02ec02ff02e502e402eb02f602e902fe02f902f902ef030b02f002ff030902f902fb0302031f030a03090323031702fb03180313031e031f0310032d0316032e030f033c0320032d032d032f032903410330033a0342033b034b0342034b034d034b034703520357035b036e0356036f0395044104fe051d051b0534052c0524052a052605450541053b0554054a055d0540055a05610551055e055605640560056a0580058d0565058505860583059b0597059505b405a605b505be05a205b105bd05eb05c605ca05cf05d605fe05ef05f805fb061305f2060b06180634063006310640062e0641065b065c067206640678066e068b06a8068b069f06b106cd06cb06c506dd06d806e006e106d606e206dc06b406c406b706ad06b606b1067e069006700674066c06820653065c066706600652064506310643061e062b062f0619061b0607061c05fb05ff05f605ef05e405dd05fe05e605eb05b805cd05c205bc05be05be05c005bf05a605b505ad05b105890572059705920586058c059c058605820582056605650570056205750556055a055a054405540548055d0551055b055a05510541054605450548054f051c053f05430537053e053405400522052f052f053d051b052b051c05300520052f05230515051f051b05180523051b050a05040521050a05070520050e050e051105140524050d05170512051904fd0512050f04ed05010512050d05080512051605260518050b050204fe04fa05130509050304ff051804fe04f404f804ef0431033d02c30225014601480137013f014f0139013e0137013b0139013c0134012c01390147013e01420128014d0147014a01460152015b024b02ac030c051905280531053104d403f3036402ff02a902d803400403045d0512053705590555054f053a0466040503ca03c203e9042a04a004df04d3049803bb032f0318032e0330038d03e40388035303180308030802e8030a030e02d2027d025d025b0267029e029502ab02c302c102d602c802d702c502e102de02e802e802e102ea033203c104e6066c0669067c068d06a0069b06a406b606c106e0076607f907f6071b06ea0739083c084f0859086907ee074407570839088808c308c6084507ba07ab08bc0915091b08d2082307e307f00953094e094f087b083e08a309a1097108cf08b2087b08e209c10938090508e4090509e5098b095c0931099f0a0409ac098e09a40a450a200a010a210a8e0a6d0a5d0ae00ada0adf0b0c0b4c0b3c000203fe03ff03ff040603f503f803ec03ef03e503ee03f003ec03ea03e303e603ef03d303e503c503d203cd03d903cc03c403c303c003be03c703c703bb03ad03af03a903bb03b103a903a4039f03c303b203b3038803a7039303a0039d035503b103b003b403a703ab03b203b003b203b8038b039403860396038a039103920378037a039003980394039103950398039f03940387038103980367036d03820389037d038c038b037c0384039c037a039c038f03800387038f03790398038a03880385038f03880394038a0392038103920394038e0390034903a6039503cd03f7040a036703140344035c027f01ee0191017201af021302b902c502d602ce029a0285028d02880275028802700275025a025c024f023a022f0239022a0224022b0231021201d801ee0223022a0238022f024902360244023a0237024b024b0249024d023e024902490256026402570255025702520246024a025102620249024c02530256024d024e024c021501c3019a019c01b301de01e801d601ed01fa01be018e01c3021d0243020e01a50196018d019901f5021c022e01fa019f015d01840169013500f600f900cb00a700a900b700ba00a900ac00a9008c52535349313f80000000000000fff922300d05032b1d5d000000000000000000001d3c000000001cee1e2f1e05000000001d511d1e00001dfc25df2c4530203230324330953262326b342c330b32b232d332a1308130aa30d237923b5934b9328a327c32703328324032d832a0324332302e70269d276b25e225e423f124cf258e283329bf29db285d27ad2f7f364839af3d8a3c993aa2381d3ada3fbf3fda3dbf381c3c593a962dfe22182200237327332d50301933cb34f632fb35cb3767336635c334ab3566360334b434c9352f34ba34f9348134f934a43649354c34733637361c364440a03ef5311f321b33c63369341f34e2344834ca352734e73493343d37483398339533ab34dd34b8350733cf367634133537359d348934d93503353a3638351433ed35ac35dc358534a735dd34b7357435093607344d360e35513492358235f3357133c6351734cd33c1348436ff34ca354734c634a03615346a3643347b36b9343236673536359e360d365f352936ad35d635c0365e353f362d35d0351c361235c834df34ec34e533a034dd331a385c4001377c34f134fd33e634a5354a3529353933c03481348c33733444337834dc33a93391347a33fd3479340e34a7343e333132e6352d33c633ec3465339333dd33c73284338d32f132c9345e33b13369311d32ee3338331e32e1318132583262328231172ea62da1320b30f331753236318032ab31e830a031153051318630ff31ee30ea2fd7319d305330062eee2faf309c2f732fc13054310c30172c902b5d2ce72be72c792c832bd62c082e172d292e0b2d742d952c7c2e912d822d082d112d7b2cee2e0d2d0b2e922de52d852e992e782f6f2e152f412f022edb2f582f5c2fa42dee2ee02e8631152f7f2faf2f792f272f1d2f272efe30462f432f9e2f9c31633254302e304c311030d62f8a30b8313d312632603221318e322230b9329f3253324c3389326433153221326c31f432613264334532563287326631b1349d3286325533233261332b32b43425333f3301321233f4330a33be32a433b232c733d9341033ac33d933d0338933cb33f53427330a3408345b32d133e2339033aa338032d9340f33a233be33343434334e339b351133db32c933a8340d332c331b323e333b344a3454348434793375334833da344f332a342a3486346a346a41885340529b45642c2a2b212e0e2efa2eb53029303730753156324830f9310d31c731342fda30522f7630612dd32c972b272a7b27f82e7247ef4d554d022dde30e731e2325237c0480e48fa41ce3dc13f6b45f347c1436135ad331d3170318f324c33333f443ca73aa5390f3b7e3f923ea53a563b093ddd3f3c35a72dd12b2133a037933747366d2f682d7f2ae4285427f9262d2780233426372fe631572b362568276225bd25c32be9305e324c31d0336a322632a3325432b0340534bb3a0e446241602df22d422bf82b972abb2b652b542ac32b062f6c31952dcd2e4b3287300b34ca2d642d512c022d442f9d306832632f482cdc2aaa2b33316031fc35cd2d432a1629cf2de62fd42b8833792a6d2b632b0c2f392d81324e2a742cc52e0f260b2bcd319329402afe2683291931a92ce7294826142aeb32542ba827c828a12fd72b49263827402e8c2929265929e52b5126f926732c5927522bf300001cb42ea0346434583533352a355234fd354b34d334a83478342734873432339b35a0342035db348a33872918225623bf233f2418237a22c12a1b344e35ec364f366334b335ca360436c13469286c23ef23f9266924ca25a5272030d522668b6d8c5a8cab8c578c498c8b8c838c668832329928ce2736265326812636263f27572bba347a36aa369c36b1365a3604357a36313771357a2c7a28f228c027d727fa2874275027ba2ab333d334f937853544362037a836cc365438313583366836e036c6367336a435c636fd35f03708360135e836ae36ae2454864272b838af36b7330f34c0298e27c826fb2fa13387304a29fd2d4531682c902e472dbc2d652f0b2f602e122e0b2e9c2d632e4c2df12ec62e6d2e9e2f2c2f7a2ebf2fe935083685350931b52cdb2b86348f36293596365834bd35ec352b360d366034d23551352434e236ba35e0363635553426357435b9366c35f7367b35b434d43417360935863423327930e42f2f2c5b2bb52ca92d9e2a452cb02c5430ac34ae355f31b22e002eb635303bec3ad6392d31e42c6a27812a9332b33a97370a3350324732562f5034893554343c2ecc28852296233224b92612256e25242516266c0000000000000000000107b20101003217000a35480000"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"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"})},
      {"LMDscandata", sick_scan::ColaParser::createColaTelegram(sick_scan::ColaParser::convertSopasCommand("sSN"), "LMDscandata", {"000100010119fd060000b043b047b43c8a5ab43ca2fe000009000000000005dc000000a20000000244495354313f80000000000000fff922300d05032b026a028f00020002027e0002026e000200020288000202b102ad02c4000200020002000202ce02a3029202c702a802be02cb028702930296028102a502e702b802d302fe032e03c90485048f04a2048a04ab04a204a5049f048d049d0465043f040003f3040603d103c803b1037e0380036f0391039d038903b203cd0403043a048304af04c704670449045b04aa049a042103d203c403a603b703e5041e0422041f046f04910471049804ed04ea04e504e504ca04e104db04d404cb04c804da04d304e104dd04d404d204c804b504b6041c036602eb02d202d702ab02c002b702ca02be02c702bd02c802c902c202b902d602b902cd02c702c002d702ca02d702ef02cc02d402e502e802e402e102e902f002e002ed02ea02eb02fc02f802f502e902ef030102ff02fa0308030602f90304031a031203140303030803130317030e032603200329032a032b03290331032f03330323032b0331033d0334033c0346034d03420348034a03410352034903490368035c035c036d036f037803a3044704fc051a0524051c0525052605240534052f053305360555054705530551054a0555054505640560056805560564056f055f056405800589058e058a059705a6059e059d05b3059c05c205a205bf05d205e005ce05e005e105df05f505f105fa06030604060b0619061e0620063b0644063706470667066e06460672067a068b067806940691069306b606b906c106d806d606ef06e406e906e806d506d106cf06bd06ba06bd06940698068e068c0680066d067a067806480660066106590632065206350638061e063306290610060906020604060b05f9060105de05f005e505ed05dc05d405da05b905ba05c705d205a505af05b305c105ac05ab05aa059305a0057c059a057e05820582058b0580057b0588056d057a05520563055a0569056d05530563055e055a0554056405490545053b054d054b053a05590543053e0536054a054b053c053b0525052f051a0533053a0521051c05290526052c051a051c05180532051d050b051a050f050c0504050e0511050b05190526051405110521050e051a0506051404fd0