# toposens_driver

This package enables serial communication with a TS3 sensor.

It was developed and tested for ROS Melodic on Ubuntu 18.04 (Bionic) and ROS Kinetic on Ubuntu 16.04 (Xenial) using Toposens TS3 ultrasonic sensor.

## Overview

* Parses the serial datastream and converts it to `TsScan` messages
* Publishes the data on the topic `/ts_scans`
* Passes firmware commands to the sensor. These commands are meant to let a user change specific signal processing parameters
* Lets the user change these firmware parameters through a *dynamic reconfiguration server*

## Usage

### Build

Find information on how to build the package in the README of the `toposens` metapackage.

### Enable Serial Port Permissions

Add yourself to the “dialout” group:

```bash
sudo adduser $USER dialout
```

Trigger updated group permissions to take effect:

```bash
newgrp dialout
```

Re-login or reboot for the updated group permissions to take effect permanently.

### Run

Connect the TS3 sensor via the FTDI or USB cable.

The `ts_driver_node` translates the sensor data into custom `toposens_msgs/TsScan` messages.

Launch the driver node and start accruing data from a TS3 sensor. Set the corresponding serial port as launch argument (here: `/dev/ttyUSB0`):

```bash
roslaunch toposens_driver toposens_driver.launch port:=/dev/ttyUSB0
```

The sensor data is published to the the topic `/ts_scans`. View the incoming scans with:

```bash
rostopic echo /ts_scans
```

### Configuration

The following firmware parameters can be set through the *dynamic reconfiguration server*:

| Parameter Name | Description |
| --- | --- |
| `num_pulses` | This is the only parameter that has an effect on the emitted ultrasonic signal. It defines the number of electrical pulses that the piezo transmitter is stimulated with in every transmission cycle. The higher the number, the louder and longer the emitted signal will be. As a result, increasing the value will detect objects that are further away, decreasing it will increase the sensor's precision in short range. |
| `echo_rejection_threshold` | This parameter defines the minimum amplitude, i.e. the signal strength, that a received echo signal needs to have in order to be utilized for further processing. Signals that are below this threshold are discarded. As a result, increasing the value will ignore more points of smaller intensity and only allow strong reflectors to be detected. |
| `peak_detection_window` | This parameter defines the kernel size for a peak detection filter that is applied on the received ADC signals in order to find the peaks that link to the echoes of the detected objects. When it is set too high, objects that are close to each other might merge to one bigger object. Decreasing it might separate these objects but might also destabilize the resulting signal. |
| `noise_indicator_threshold` | This parameter has no effect on the visualization of the pointcloud or the markers. It is solely used to mark individual scans with a noise flag. This is done by calculating an overall noise level for the raw ADC signal of one frame. If this noise level lies above the noise_indicator_threshold, the noise flag for this scan is set. This might indicate that there are sources of ultrasonic disturbances in the scene. However the scans will be shown regardless of the noise flag. |
| `external_temperature` | This parameter defines the temperature that is used for calculating the speed to sound. Its accuracy has an effect on the correct calculation of the distance of objects. The value is only used if `use_external_temperature` is checked. |
| `use_external_temperature` | The TS3 also has an on-board temperature sensor. If `use_external_temperature` is not checked, the TS3 will use its on-board temperature sensor for speed-of-sound calculation. If it is checked, it will use the `external_temperature`. |

To manipulate sensor parameters live in realtime, run in an additional terminal window:

```bash
rosrun rqt_reconfigure rqt_reconfigure
```

#### Additional Configuration

Additional configuration (to the firmware parameters) is done via launch file parameters.

| Parameter Name | Description |
| --- | --- |
| `port` | The serial port ID that represents the sensor |
| `frame_id` | The frame ID in which the data is published |
