#ifndef TOPOSENS_ECHO_DRIVER_ECHO_DRIVER_H
#define TOPOSENS_ECHO_DRIVER_ECHO_DRIVER_H

#include <memory>
#include <vector>

#include <boost/thread/recursive_mutex.hpp>

#include <dynamic_reconfigure/server.h>
#include <ros/ros.h>
#include <tf2_ros/static_transform_broadcaster.h>

#include <toposens/sensor_lib.h>

#include "toposens_echo_driver/EchoOneDriverConfig.h"
#include "toposens_echo_driver/ros_utils.h"

namespace toposens_echo_driver
{
using EchoOneDriverConfigServer = dynamic_reconfigure::Server<EchoOneDriverConfig>;

class EchoOneDriver
{
public:
  EchoOneDriver(ros::NodeHandle nh, RosParameters parameters);
  ~EchoOneDriver();

  /**
   * @brief Triggers single-shot measurement from sensor and publishes TsScan ROS message with
   * result
   */
  void measure();

  /**
   * @brief Publish static TFs between sensor coordinate frames
   */
  void publishStaticTransforms();

private:
  void initialize();
  void configureDynamicReconfigureServer();
  void reconfigure(const EchoOneDriverConfig& config, uint32_t level);

  ros::NodeHandle nh_;
  ros::Publisher point_cloud_publisher_, ts_scan_publisher_;
  ros::ServiceServer adc_dump_service_;
  tf2_ros::StaticTransformBroadcaster static_tf_broadcaster_;
  RosParameters parameters_;

  std::unique_ptr<EchoOneDriverConfigServer> dynamic_reconfigure_server_;
  boost::recursive_mutex dynamic_reconfigure_server_mutex_;
};

}  // namespace toposens_echo_driver

#endif  // TOPOSENS_ECHO_DRIVER_ECHO_DRIVER_H
