#ifndef TOPOSENS_ECHO_DRIVER_ROS_UTILS_H
#define TOPOSENS_ECHO_DRIVER_ROS_UTILS_H

#include <sstream>
#include <string>

#include <geometry_msgs/TransformStamped.h>
#include <ros/ros.h>
#include <tf/tf.h>

#include <toposens/sensor_lib.h>

#include "toposens_msgs/TsScan.h"

namespace toposens_echo_driver
{
class RosParameters
{
public:
  RosParameters() = default;
  explicit RosParameters(ros::NodeHandle private_nh);

  [[nodiscard]] auto to_string() const -> std::string;

  std::string com_interface{}, can_device{}, uart_device{}, scans_topic{}, sensor_mode{},
      frame_id{}, target_frame{};
  double loop_rate_hz{}, temperature{};
  int transducer_volume{}, transducer_num_pulses{};

  const std::string transducer_volume_str{"transducer_volume"};
  const std::string transducer_num_pulses_str{"transducer_num_pulses"};
  const std::string temperature_str{"temperature"};

private:
  void load(ros::NodeHandle private_nh);
};

/**
 * @brief Converts all points availabble in @p session_data to ROS message
 * @details Based on coordinate frame defintion from here (Toposens)
 * https://teamtoposens.atlassian.net/wiki/spaces/EN/pages/467697939/Standardized+Coordinate+System
 * and here (ROS) https://www.ros.org/reps/rep-0103.html#axis-orientation.
 */
auto to_TsScan(const Sensor_Session_t* session_data, const RosParameters& params)
    -> toposens_msgs::TsScan;

/**
 * @brief Returns geometry_msgs::TransformStamped to be published by TF broadcaster
 * @details Take transformation arguments (translation/rotation) and the corresponding frame ids and
 * create the TF message to be published.
 */
auto getStaticTransformMsg(const ros::Time& t, const std::vector<float>& trans,
                           const tf::Quaternion& q, const std::string& from, const std::string& to)
    -> geometry_msgs::TransformStamped;
}  // namespace toposens_echo_driver

#endif  // TOPOSENS_ECHO_DRIVER_ROS_UTILS_H
