#include <ros/ros.h>

#include "toposens_echo_driver/RequestAdcDump.h"

auto main(int argc, char** argv) -> int
{
  ros::init(argc, argv, "toposens_request_adc_dump_node");
  if (argc != 3)
  {
    ROS_ERROR("usage: toposens_request_adc_dump_node <SENSOR_ID> <DUMP_FILE_PATH>");
    return 1;
  }

  const auto* const srv_name = "request_adc_dump";

  ros::NodeHandle nh;
  ros::ServiceClient client = nh.serviceClient<toposens_echo_driver::RequestAdcDump>(srv_name);

  toposens_echo_driver::RequestAdcDump srv;
  srv.request.sensor_id = atoll(argv[1]);
  srv.request.file_path = argv[2];

  if (client.call(srv))
  {
    ROS_INFO("Response: [success=%d]", srv.response.success);
  }
  else
  {
    ROS_ERROR("Failed to call service %s. [success=%d]", srv_name, srv.response.success);
    return 1;
  }

  return 0;
}