/** **************************************************************************************
 * @file       sensor_lib_config.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      This file contains all library configurations
 ******************************************************************************************/

#ifndef TOPOSENS_CONFIG_SENSOR_LIB_CONFIG_H /* include control, avoid multiple includes of header \
                                             file */
#define TOPOSENS_CONFIG_SENSOR_LIB_CONFIG_H

/*---- <system includes> --------------------------------------------------------------*/
#include <stdio.h>
/*---- "library includes" -------------------------------------------------------------*/

/*---- "project includes" -------------------------------------------------------------*/

/*---- public macros and constants ----------------------------------------------------*/
/** **************************************************************************************
  @brief      If this define is set, the library will use the linux socket interface
******************************************************************************************/
#ifdef __linux__
/** **************************************************************************************
  @brief      CAN-Bus support is integrated for Linux
******************************************************************************************/
#define CAN_AVAILABLE
/** **************************************************************************************
  @brief      UART support is integrated for Linux
******************************************************************************************/
#define UART_AVAILABLE
#endif
/** **************************************************************************************
  @brief      Upper Limit of suppored Sensors on Bus. This value influences static array sizes
******************************************************************************************/
#define MAX_NUMBER_OF_SENSORS_ON_BUS 10
/** **************************************************************************************
  @brief      Upper Limit of suppored POINT Data per Point Data Session. 3D OR 2D. A maximum of 2x
as much point data can be received in one session: 1x for 1D and 1x for 3D
******************************************************************************************/
#define MAX_NUMBER_OF_POINTS_PER_SESSION 50

/** **************************************************************************************
  @brief      Used to select currently used print-functions. Implemented atm are REGULAR_MPRINTF
******************************************************************************************/
// #define REGULAR_PRINTF 1

#ifdef EMBEDDED
#define MPRINTF(f_, ...) otherprintf((f_), __VA_ARGS__)
#elif REGULAR_PRINTF
#define MPRINTF(f_, ...) printf((f_), ##__VA_ARGS__)
#else
#define NOREALPRINTF 1
#define MPRINTF(f_, ...)                \
  do                                    \
  {                                     \
    if (0) printf((f_), ##__VA_ARGS__); \
  } while (0)  // To also allow no print output
#endif
#define DEVICE_NAME_LEN 100
/*---- public types -------------------------------------------------------------------*/

/*---- public variables prototypes ----------------------------------------------------*/

/*---- public functions prototypes ----------------------------------------------------*/

/*---- public inline functions --------------------------------------------------------*/

#endif  // TOPOSENS_CONFIG_SENSOR_LIB_CONFIG_H
