/** **************************************************************************************
 * @file       socketinterface.h
 * @ingroup    Socket-Interface
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      This file contains the linux-can-socket interface prototypes
 ******************************************************************************************/

#ifndef TOPOSENS_LINUX_SOCKETINTERFACE_H /* include control, avoid multiple includes of header \
                                          * file                                               \
                                          */
#define TOPOSENS_LINUX_SOCKETINTERFACE_H

/*---- "project includes" -------------------------------------------------------------*/
#include "toposens/sensor_lib.h"
#ifdef CAN_AVAILABLE
/*---- <system includes> --------------------------------------------------------------*/
#include <linux/can.h>
#include <stdint.h>
/*---- "library includes" -------------------------------------------------------------*/

/*---- public macros and constants ----------------------------------------------------*/

/*---- public types -------------------------------------------------------------------*/

/*---- public variables prototypes ----------------------------------------------------*/

/*---- public functions prototypes ----------------------------------------------------*/

/** ******************************************************************************
  @ingroup      Socket-Interface
  @brief        Called to send messages to can socket
  @param[in]    *frame pointer to can-frame that should be send
  @return       int 0 if the writing was successful
                int 1 in case of an error
*******************************************************************************/
int WriteFrame(struct can_frame* frame);

/** ******************************************************************************
  @ingroup      Socket-Interface
  @brief        Called from the can-library, this function will take care of all linux-related
socket-setup, socket configuration and starting of the receiver thread.
  @param[in]    *InterfaceName_cp interface-name that shall be configured
  @param[in]    InterfaceBitrate_u32 Bitrate the interface should be working with
  @return       int 0 if setup was successful
                int 1 in case of an error
*******************************************************************************/
int SetupSocket(char* InterfaceName_cp, uint32_t InterfaceBitrate_u32);

/** ******************************************************************************
  @ingroup      Socket-Interface
  @brief        Called from the can-library, this function will close the socket and take care of
ReceiverThread termination
  @return       int 0 if deinit was successful
                int 1 in case of an error
*******************************************************************************/
int DeinitSocket();

/** ******************************************************************************
  @ingroup      Socket-Interface
  @brief        This function is called by the library to set a callback function for incoming
can-traffic.
  @param[in]    (*Callback)   Function Pointer to function that shall be called-back if a can-frame
was revived
*******************************************************************************/
void RegisterReadCallback(void (*Callback)(struct can_frame* frame));
/*---- public inline functions --------------------------------------------------------*/

#endif  /* end of include control */
#endif  // TOPOSENS_LINUX_SOCKETINTERFACE_H
