# Toposens Sensor Library

[[_TOC_]]

## Introduction

The purpose of this README is to document how to use the library and the provided examples.

## Communication Protocol

More information about the communication protocol can be found in the [*communication_protocol*](communication_protocol/protocol_documentation.md) subdirectory.

## Setting up the Sensor & CAN Interface

- Connect the D-Sub-15 cable from the sensor to the power/data D-Sub-15 cable.
- Connect the D-Sub-9 to the peak CAN adapter and the peak CAN adapter USB to the host device.
- Install the required kernel modules:

  ```none
  sudo modprobe peak_usb
  sudo modprobe peak_pci
  sudo apt-get update
  sudo apt-get install can-utils
  ```

- Then either every time the sensor is connected run the following command or set up an automatic way to configure the interface as described below:

```none
sudo ip link set can0 up type can bitrate 1000000
```

### Automatic Setup with /etc/network/interfaces

In the */etc/network/interfaces* file, add the following:

```none
allow-hotplug can0
iface can0 can static
     bitrate 1000000
     up ip link set $IFACE txqueuelen 100
```

### Automatic Setup with systemd

If you are on Ubuntu 20.04 you can use *systemd* since */etc/network/interfaces* is deprecated.
Navigate to `/etc/systemd/network/` and create a file `80-can.network` with the following content:

```none
[Match]
Name=can*

[CAN]
BitRate=1000000
```

Then run the following commands to enable the automatic configuration via systemd:

```none
sudo systemctl enable systemd-networkd
sudo systemctl start systemd-networkd
```

### Test the Interface

- Run the command:

```none
candump can0
```

- In a new terminal, send one of the example commands from the [communication protocol](communication_protocol/protocol_documentation.md). If the corresponding response comes back then everything is working and connected correctly.

## Compiling and Installing the Sensor Library and example applications

```none
mkdir build
cd build
cmake ..
make
sudo make install
```

or simply run the install.sh

## Running the Examples

After compiling the library, go to the folder `build/examples`. Run the example of choice.

```none
cd build/examples
./n_frames_single_shot_example
```
