/** **************************************************************************************
 * @file       example_common.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      Library containing common functions that are used in the various
 *examples
 ******************************************************************************************/

#ifndef EXAMPLE_COMMON_H_
#define EXAMPLE_COMMON_H_

#include <stdint.h>
#include "toposens/sensor_lib.h"

void
GetSettings();
void
PrintVersion(Version_t Version_t);
void
GetVersions();
void
PrintSessionData(Sensor_Session_t* Session);
void
PrintADCBlobData(ADCDump_t* ADCDump);
void
SaveADCBlobData(ADCDump_t* ADCDump, const char* filepath);
void
PrintLogMessage(uint16_t SenderId_u16, const uint8_t* ReceivedPayload_pu8);
void
PrintSensorsOnBus();

#endif  // EXAMPLE_COMMON_H_
