/** **************************************************************************************
 * @file       custom_structs_internal.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 ******************************************************************************************/

#ifndef TOPOSENS_CUSTOM_STRUCTS_INTERNAL_H
#define TOPOSENS_CUSTOM_STRUCTS_INTERNAL_H

#include <stdbool.h>
#include <stdint.h>

#ifdef UART
#define APP_PACKET_DATA_LEN 128
#else
#define APP_PACKET_DATA_LEN 47
#endif

#define APP_UPDATE_SIGNATURE_LENGTH                20
#define BOOTLOADER_APP_DATA_SIGNING_KEY_LENGTH     16
#define BOOTLOADER_APP_DATA_AES_KEY_LENGTH         32
#define BOOTLOADER_APP_DATA_AES_INIT_VECTOR_LENGTH 16

typedef struct AppUpdateInfo_t
{
    uint8_t signature[APP_UPDATE_SIGNATURE_LENGTH];
    Version_t app_version;
    Version_t min_supported_hw_version;
    Version_t max_supported_hw_version;
    uint8_t sensor_model;
    uint32_t size;
    uint32_t crc;
    uint16_t number_of_packets;
} AppUpdateInfo_t;

typedef struct AppPacketHeader_t
{
    uint16_t packet_number;
    uint8_t byte_count;
    uint32_t address;
    uint8_t record_type;
} AppPacketHeader_t;

typedef struct BootloaderData_t
{
    AppUpdateInfo_t app_update_info;
    AppPacketHeader_t last_app_packet_header;
    uint8_t last_app_packet_data[APP_PACKET_DATA_LEN];
    bool start_application;

    uint8_t* new_app_buffer;
    uint32_t copy_offset;
    uint8_t app_offset_valid;
    uint32_t new_crc;

} BootloaderData_t;

typedef struct BootloaderAppData_t
{
    Version_t app_version;
    uint32_t app_crc;
    uint32_t app_size;
    uint8_t signing_key[BOOTLOADER_APP_DATA_SIGNING_KEY_LENGTH];
    uint8_t aes_key[BOOTLOADER_APP_DATA_AES_KEY_LENGTH];
    uint8_t iv[BOOTLOADER_APP_DATA_AES_INIT_VECTOR_LENGTH];
} BootloaderAppData_t;

#endif  // TOPOSENS_CUSTOM_STRUCTS_INTERNAL_H
