/** **************************************************************************************
 * @file       custom_types.h
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 *
 ******************************************************************************************/

#ifndef TOPOSENS_CUSTOM_TYPES_H
#define TOPOSENS_CUSTOM_TYPES_H

typedef enum CommsInterfaceType_t
{
    IF_NONE = 0b00000000,
    IF_CAN  = 0b00000001,
    IF_UART = 0b00000010,
    IF_USB  = 0b00000100,
} CommsInterfaceType_t;

typedef enum CANSpeed_t
{
    CAN_SPEED_1000KBIT,
    CAN_SPEED_500KBIT,
    CAN_SPEED_250KBIT,
    CAN_SPEED_125KBIT
} CANSpeed_t;

typedef enum SensorState_t
{
    // Bootloader states
    STATE_BL_WAIT_FOR_INIT,
    STATE_BL_RX_APP,
    STATE_BL_PROCESSING_APP,
    STATE_BL_FLASH_APP,
    STATE_BL_RDY_TO_LAUNCH,
    STATE_BL_LAUNCHING_APP,

    // App states
    STATE_APP_IDLE,
    STATE_APP_NOISE_SAMPLE,
    STATE_APP_WAIT_FOR_NOISE_SAMPLING,
    STATE_APP_TRANSDUCE_AND_SAMPLE,
    STATE_APP_TRANSMIT,
    STATE_APP_SAMPLE,
    STATE_APP_WAIT_FOR_SAMPLING,
    STATE_APP_SIG_PRO_CALIB_TRANSDUCER,
    STATE_APP_CALCULATE_POINTS,
    STATE_APP_OUTPUT_POINTS,
    STATE_APP_WAITING_FOR_POINT_SESSION_END,
    STATE_APP_OUTPUT_ADC_SIGNALS,
    STATE_APP_WAITING_FOR_ADC_DUMP_SESSION_END,
    STATE_APP_PROCESS_LONG_SELF_CHECK,
    STATE_APP_SIG_PRO_CALIB_NEARFIELD,
    STATE_APP_NOISE_SAMPLING_DONE,
    STATE_APP_SAMPLING_DONE,
    STATE_APP_POINT_SESSION_END,
    STATE_APP_ADC_DUMP_SESSION_END,
    STATE_APP_INITIAL,
    STATE_APP_UPDATE_SETTINGS
} SensorState_t;

typedef enum SensorMode_t
{
    SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN,
    SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN,
    SENSOR_MODE_SINGLE_SHOT_TRANSMIT,
    SENSOR_MODE_SINGLE_SHOT_LISTEN,
    SENSOR_MODE_IDLE,
    SENSOR_MODE_SIG_PRO_CALIB_TRANSDUCER,
    SENSOR_MODE_SELF_CHECK,
    SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN_FIXED,
    SENSOR_MODE_SIG_PRO_CALIB_NEARFIELD,
    SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN_SILENT_FRAME,
    SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN_SILENT_FRAME,
    SENSOR_MODE_MAX
} SensorMode_t;

typedef enum ResetReason_t
{
    RESET_REASON_UNKNOWN,
    RESET_REASON_LOW_POWER_RESET,
    RESET_REASON_WINDOW_WATCHDOG_RESET,
    RESET_REASON_INDEPENDENT_WATCHDOG_RESET,
    RESET_REASON_SOFTWARE_RESET,
    RESET_REASON_POWER_ON_POWER_DOWN_RESET,
    RESET_REASON_EXTERNAL_RESET_PIN_RESET,
    RESET_REASON_BROWNOUT_RESET,
    RESET_REASON_END
} ResetReason_t;

typedef enum LogLevel_t
{
    LOG_LEVEL_DEBUG,
    LOG_LEVEL_INFO,
    LOG_LEVEL_WARN,
    LOG_LEVEL_ERROR
} LogLevel_t;

typedef enum LogCategoryByte_t
{
    LOG_CAT_RESET_REASON,
    LOG_CAT_BOOTLOADER,
    LOG_CAT_COMMUNICATION,
    LOG_CAT_PERIPHERAL,
    LOG_CAT_USER,
    LOG_CAT_SELF_CHECK,
    LOG_CAT_SIGNAL_PROCESSING,
    LOG_CAT_SOFTWARE,
    LOG_CAT_STRING,
    LOG_CAT_CALIB_TRANSDUCER,
    LOG_CAT_FRAMERATE,
    LOG_CAT_CALIB_NEARFIELD
} LogCategoryByte_t;

typedef enum SelfCheckError_t
{
    SC_STATUS_SENSOR_OK,
    SC_STATUS_MIC_MALFUNCTION,
    SC_STATUS_TRANSDUCER_MALFUNCTION,
    SC_STATUS_PGA_OK,
    SC_STATUS_PGA_MALFUNCTION,
    SC_STATUS_PGA_CANNOT_CHECK
} SelfCheckError_t;

typedef enum SoftwareIssueByte_t
{
    SW_ISSUE_MALLOC_FAILED,
    SW_ISSUE_REBOOT_REQUIRED,
    SW_ISSUE_LOAD_FROM_FLASH_FAILED,
    SW_ISSUE_SAVE_FROM_FLASH_FAILED,
    SW_ISSUE_STORING_FACTORY_DEFAULTS_IN_FLASH
} SoftwareIssueByte_t;

/** Issue bytes for logging category #LOG_CAT_CALIB_TRANSDUCER. */
typedef enum CalibTransducerIssueByte_t
{
    CALIB_TRANSDUCER_ISSUE_NOT_CALIBRATED,
    CALIB_TRANSDUCER_ISSUE_CALIBRATION_STARTED,
    CALIB_TRANSDUCER_ISSUE_CALIBRATION_FINISHED,
    CALIB_TRANSDUCER_ISSUE_INIT_ERROR,
    CALIB_TRANSDUCER_ISSUE_BAD_FRAME,
    CALIB_TRANSDUCER_ISSUE_CALIBRATION_FAILED,
    CALIB_TRANSDUCER_ISSUE_MAX
} CalibTransducerIssueByte_t;

typedef enum CalibNearfieldIssueByte_t
{
    CALIB_NEARFIELD_ISSUE_INIT_FAILED,
    CALIB_NEARFIELD_ISSUE_NOT_CALIBRATED,
    CALIB_NEARFIELD_ISSUE_NOT_ENABLED,
    CALIB_NEARFIELD_ISSUE_CALIBRATION_STARTED,
    CALIB_NEARFIELD_ISSUE_CALIBRATION_FINISHED,
    CALIB_NEARFIELD_ISSUE_CALIBRATION_FAILED,
} CalibNearfieldIssueByte_t;

typedef enum SignalProcessingIssueByte_t
{
    SIG_PRO_ISSUE_INIT_ERROR,
    SIG_PRO_ISSUE_VSOUND_CAL_ERROR,
    SIG_PRO_ISSUE_NO_ECHOES_FOUND,
    SIG_PRO_ISSUE_CLIPPING,
    SIG_PRO_ISSUE_NO_VALID_POINTS_FOUND,
    SIG_PRO_ISSUE_TRACKING_ERROR,
    SIG_PRO_ISSUE_KALMAN_ERROR,
    SIG_PRO_ISSUE_POINT_BUFFER_FULL,
    SIG_PRO_ISSUE_TIMER_ERROR
} SignalProcessingIssueByte_t;

typedef enum BootloaderStatus_t
{
    BL_STATUS_APP_VERSION_ERROR,
    BL_STATUS_SIZE_ERROR,
    BL_STATUS_CRC_ERROR,
    BL_STATUS_SIGNATURE_ERROR,
    BL_STATUS_INIT_ERROR,
    BL_STATUS_EXPECTED_PACKET,
    BL_STATUS_HW_VERSION_ERROR,
    BL_STATUS_MODEL_ERROR,
    BL_STATUS_MULTI_INIT_ERROR,
    BL_STATUS_NOT_RDY_TO_LAUNCH,
    BL_STATUS_NEXT_STATE,
    BL_STATUS_FLASH_INCOMPLETE_ERROR
} BootloaderStatus_t;

typedef enum SensorModel_t
{
    MODEL_BRAVO_DEV_PLATFORM,
    MODEL_BRAVO_DEV_KIT
} SensorModel_t;

typedef enum RecordType_t
{
    RECORD_DATA,
    RECORD_EOF,
    RECORD_EXTEN_SEG_ADD,
    RECORD_START_SEG_ADD,
    RECORD_EXTEN_LIN_ADD,
    RECORD_START_LIN_ADD
} RecordType_t;

#ifdef __linux__
extern const char* const kLogLevelStrings[];
extern const char* const kSensorModelStrings[];
extern const char* const kRecordTypeStrings[];
extern const char* const kSensorModeStrings[];
extern const char* const kSensorStateStrings[];
extern const char* const kCommsInterfaceStrings[];
extern const char* const kResetReasonStrings[];
#endif /* __linux__ */

#endif  // TOPOSENS_CUSTOM_TYPES_H
