/** **************************************************************************************
 * @file       uartinterface.h
 * @ingroup    UART-Interface
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      This file contains the linux-uart interface prototypes
 ******************************************************************************************/

#ifndef TOPOSENS_LINUX_UARTINTERFACE_H
#define TOPOSENS_LINUX_UARTINTERFACE_H

/*---- <system includes> --------------------------------------------------------------*/
/*---- "library includes" -------------------------------------------------------------*/

/*---- "project includes" -------------------------------------------------------------*/
#include "toposens/sensor_lib.h"
/*---- public macros and constants ----------------------------------------------------*/

/*---- public types -------------------------------------------------------------------*/

/*---- public variables prototypes ----------------------------------------------------*/

/*---- public functions prototypes ----------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif

    /** ******************************************************************************
      @ingroup      Uart-Interface
      @brief        Called to send messages to can socket
      @param[in]    *Payload_pu8 pointer to payload that should be send
      @param[in]    Length_u8
      @param[in]    InterfaceId_u8
      @return       int 0 if the writing was successful
                    int 1 in case of an error
    *******************************************************************************/
    int
    WriteUARTPayload(uint8_t* Payload_pu8, uint8_t Length_u8, uint8_t InterfaceId_u8);

    /** ******************************************************************************
      @ingroup      Uart-Interface
      @brief        Called from the library, this function will take care of all linux-related
    uart-setup, socket configuration and starting of the receiver thread.
      @param[in]    *InterfaceName_cp interface-name that shall be configured
      @param[in]    InterfaceBitrate_u32 Bitrate the interface should be working with
      @param[in]    InterfaceId_u8
      @return       int 0 if setup was successful
                    int 1 in case of an error
    *******************************************************************************/
    int
    SetupUARTPort(const char* InterfaceName_cp, uint32_t InterfaceBitrate_u32, uint8_t InterfaceId_u8);

    /** ******************************************************************************
      @ingroup      Uart-Interface
      @brief        Called from the can-library, this function will close the socket and take care of
    ReceiverThread termination
      @return       int 0 if deinit was successful
                    int 1 in case of an error
    *******************************************************************************/
    int
    DeinitUARTPort();

    /** ******************************************************************************
      @ingroup      Uart-Interface
      @brief        This function is called by the library to set a callback function for incoming
    can-traffic.
      @param[in]    (*Callback)   Function Pointer to function that shall be called-back if a can-frame
    was revived
    *******************************************************************************/
    void
    RegisterUARTReadCallback(void (*Callback)(uint8_t* UARTMsg_pu8, uint16_t UARTMsgSize_u16, uint8_t InterfaceId_u8));
    /*---- public inline functions --------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif  // TOPOSENS_LINUX_UARTINTERFACE_H
