#!/usr/bin/env python3

import toposens
import signal
import sys

def sigint_handler(sig, frame):
    print('You pressed Ctrl+C, de-initializing interface and exiting')
    toposens.deinit_uart("/dev/ttyUSB0")
    sys.exit(0)

if __name__ == "__main__":
    signal.signal(signal.SIGINT, sigint_handler)
    toposens.init_uart(interface="/dev/ttyUSB0")
    toposens.prepare_single_shot()
    while True:
        print("measuring")
        result = toposens.measure()
        print(result.points_3d_list)
